/*
 * Decompiled with CFR 0.152.
 */
package com.mouseviator.spelling.alphabet.trainer;

import com.mouseviator.spelling.alphabet.trainer.ListItem;
import com.mouseviator.spelling.alphabet.trainer.SpellTableModel;
import com.mouseviator.utils.internatialization.LanguageFile;
import com.mouseviator.utils.internatialization.Translator;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.TableColumn;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.MaskFormatter;

public class SpellingAlphabetTrainer
extends JFrame {
    private List<ListItem> spell_tables = new ArrayList<ListItem>();
    private Properties activeSpellTable = new Properties();
    private List<String> usedKeys = new ArrayList<String>();
    private List<String> keysToChooseFrom = new ArrayList<String>();
    private ListItem lastSpellTable;
    private Properties appSettings = new Properties();
    private Random randomGenerator = new Random();
    private boolean answerCorrect = false;
    private Timer answerResultTimer;
    private int correct_answers = 0;
    private int incorrect_answers = 0;
    private int table_rotations = 0;
    private static final String SPELL_TABLES_FOLDER = "." + File.separator + "tables" + File.separator;
    private static final String SPELL_TABLES_PATTERN = "^(.*?)(.properties)$";
    private static final String LANG_FOLDER = "." + File.separator + "lang" + File.separator;
    private static final String LANG_KEY_PATTERN = "^(.*?)(_)([\\w]{2})(_)([\\w]{2})$";
    private static final String FILE_NAME_PATTERN = "^(.*)(\\.)(.*)$";
    private static final byte UPDATE_VARIABLE_TO_FORM = 1;
    private static final byte UPDATE_FORM_TO_VARIABLE = 2;
    private static final String SETTINGS_FILE = "settings.properties";
    private static final String DOCS_FOLDER = "docs" + File.separator;
    private static final String LICENSE_FILE = "license.pdf";
    private static final String HELP_FILE = "help.pdf";
    private JCheckBox chkShowWarningBeforeSTDelete;
    private JButton cmdAboutOk;
    private JButton cmdCheck;
    private JButton cmdClose;
    private JButton cmdSettingsOk;
    private JButton cmdTEAddRow;
    private JButton cmdTEClose;
    private JButton cmdTEDelete;
    private JButton cmdTEDeleteRow;
    private JButton cmdTELoad;
    private JButton cmdTENew;
    private JButton cmdTESave;
    private JDialog frmAbout;
    private JDialog frmSettings;
    private JDialog frmTableEditor;
    private JMenu helpMenu;
    private JScrollPane jScrollPane1;
    private JLabel lblActiveSpellTable;
    private JLabel lblAppTitle;
    private JLabel lblAuthor;
    private JLabel lblAuthorDesc;
    private JLabel lblCheckResult;
    private JLabel lblCorrectAnswerHighlight;
    private JLabel lblCorrectAnswerHighlightDesc;
    private JLabel lblCurrentChar;
    private JLabel lblCurrentCharDesc;
    private JLabel lblGNUGPLv3Image;
    private JLabel lblHighlightTime;
    private JLabel lblIncorrectAnswerHighlight;
    private JLabel lblIncorrectAnswerHighlightDesc;
    private JLabel lblLanguage;
    private JLabel lblLicensed;
    private JLabel lblNotes;
    private JLabel lblNotesDesc;
    private JLabel lblSATImage;
    private JLabel lblStatistics;
    private JLabel lblTESpellTable;
    private JLabel lblVersion;
    private JLabel lblVersionDesc;
    private JLabel lblWebsite;
    private JLabel lblWebsiteDesc;
    private JComboBox<ListItem> lstActiveSpellTable;
    private JComboBox<ListItem> lstLanguage;
    private JComboBox<ListItem> lstTESpellTable;
    private JMenu mainMenu;
    private JMenuBar mainMenuBar;
    private JMenuItem menuAbout;
    private JMenuItem menuClose;
    private JMenuItem menuHelp;
    private JMenuItem menuLicense;
    private JMenuItem menuSettings;
    private JMenuItem menuTableEditor;
    private JPanel pnlTableEdit;
    private JPanel pnlTableSelection;
    private JSpinner sprHighlightTime;
    private JTable tblSpellTable;
    private JTextField txtSpelledCharacter;

    private void TEDeleteRow() {
        int[] selected_rows = this.tblSpellTable.getSelectedRows();
        SpellTableModel model = (SpellTableModel)this.tblSpellTable.getModel();
        model.deleteRows(selected_rows);
    }

    private void TEAddRow() {
        SpellTableModel model = (SpellTableModel)this.tblSpellTable.getModel();
        model.addRow(new String[]{"", "new"});
        this.tblSpellTable.setRowSelectionInterval(this.tblSpellTable.getRowCount() - 1, this.tblSpellTable.getRowCount() - 1);
    }

    private void TESaveTable() {
        int result;
        SpellTableModel model = (SpellTableModel)this.tblSpellTable.getModel();
        int invalid_rows = 0;
        int num_rows = model.getRowCount();
        if (num_rows == 0) {
            JOptionPane.showMessageDialog(this, Translator.getString("error.editor.save.empty_table_msg"), Translator.getString("error.editor.save.empty_table_dt"), 0);
            return;
        }
        for (String[] row : model.getData()) {
            if (!row[0].trim().isEmpty() && !row[1].trim().isEmpty()) continue;
            ++invalid_rows;
        }
        if (invalid_rows == num_rows) {
            JOptionPane.showMessageDialog(this, Translator.getString("error.editor.save.no_valid_rows_msg"), Translator.getString("error.editor.save.no_valid_rows_dt"), 0);
            return;
        }
        if (invalid_rows > 0 && (result = JOptionPane.showConfirmDialog(this, Translator.getString("error.editor.save.invalid_rows_msg"), Translator.getString("error.editor.save.invalid_rows_dt"), 0)) == 1) {
            return;
        }
        ListItem edited_table = (ListItem)this.lstTESpellTable.getSelectedItem();
        if (model.savePropertiesFile(model.getPropertiesFile())) {
            boolean isPresent = false;
            for (int i = 0; i < this.lstActiveSpellTable.getItemCount(); ++i) {
                ListItem loaded_item = this.lstActiveSpellTable.getItemAt(i);
                if (!loaded_item.equals(edited_table)) continue;
                isPresent = true;
            }
            if (!isPresent) {
                this.lstActiveSpellTable.addItem(edited_table);
                this.spell_tables.add(edited_table);
            }
            ListItem tested_table = (ListItem)this.lstActiveSpellTable.getSelectedItem();
            if (((String)edited_table.getItemData()).equals((String)tested_table.getItemData())) {
                this.loadSelectedSpellTable();
            }
            JOptionPane.showMessageDialog(this.frmTableEditor, Translator.getString("table_editor.save.success"), Translator.getString("table_editor.save.DT"), 1);
        } else {
            JOptionPane.showMessageDialog(this.frmTableEditor, Translator.getString("table_editor.save.failed"), Translator.getString("table_editor.save.DT"), 0);
        }
    }

    public SpellingAlphabetTrainer() {
        this.initComponents();
        WindowListener wl = new WindowListener(){

            @Override
            public void windowOpened(WindowEvent e) {
            }

            @Override
            public void windowClosing(WindowEvent e) {
                SpellingAlphabetTrainer.this.close();
            }

            @Override
            public void windowClosed(WindowEvent e) {
            }

            @Override
            public void windowIconified(WindowEvent e) {
            }

            @Override
            public void windowDeiconified(WindowEvent e) {
            }

            @Override
            public void windowActivated(WindowEvent e) {
            }

            @Override
            public void windowDeactivated(WindowEvent e) {
            }
        };
        this.addWindowListener(wl);
        Image image = Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("resources/SAT_icon_64.png"));
        this.setIconImage(image);
        this.frmAbout.setIconImage(image);
        this.frmSettings.setIconImage(image);
        this.frmTableEditor.setIconImage(image);
        this.txtSpelledCharacter.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                SpellingAlphabetTrainer.this.enableCheckButton(true);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                SpellingAlphabetTrainer.this.enableCheckButton(true);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                SpellingAlphabetTrainer.this.enableCheckButton(true);
            }
        });
        this.setLocationRelativeTo(null);
        this.frmAbout.setLocationRelativeTo(null);
        this.frmSettings.setLocationRelativeTo(null);
        this.frmTableEditor.setLocationRelativeTo(null);
        this.appInit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void appInit() {
        try {
            Translator.setLanguageFolder(LANG_FOLDER);
        }
        catch (IOException ex) {
            Logger.getLogger(SpellingAlphabetTrainer.class.getName()).log(Level.SEVERE, null, ex);
        }
        if (Translator.getLanguages().isEmpty()) {
            JOptionPane.showMessageDialog(this, "Nebyl nalazen \u017e\u00e1dn\u00fd jazykov\u00fd soubor pro p\u0159eklad u\u017eivatelsk\u00e9ho rozhran\u00ed! Bude pou\u017eit v\u00fdchoz\u00ed jazyk!\nNo language file for translating GUI has been found! Default language will be used!", "Chyba\\Error", 0);
            this.lstLanguage.setEnabled(false);
        } else {
            Map<String, LanguageFile> languages = Translator.getLanguages();
            for (String lang_key : languages.keySet()) {
                LanguageFile lf = languages.get(lang_key);
                Locale lang_loc = lf.getLocale();
                ListItem<String> lang_item = new ListItem<String>(lang_loc.getDisplayName(), lang_key);
                this.lstLanguage.addItem(lang_item);
            }
        }
        File f = new File(SETTINGS_FILE);
        FileInputStream fis = null;
        InputStreamReader reader = null;
        if (f.exists()) {
            try {
                fis = new FileInputStream(f);
                reader = new InputStreamReader((InputStream)fis, Charset.forName("UTF-8"));
                this.appSettings.load(reader);
                this.updateSettings((byte)1);
            }
            catch (Exception ex) {
                Logger.getLogger(SpellingAlphabetTrainer.class.getName()).log(Level.SEVERE, null, ex);
                this.updateSettings((byte)2);
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException ex) {
                        Logger.getLogger(SpellingAlphabetTrainer.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException ex) {
                        Logger.getLogger(SpellingAlphabetTrainer.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
            }
        } else {
            this.setDefaultLanguage();
            this.updateSettings((byte)2);
        }
        this.loadSelectedLanguage();
        this.setupAnswerTimer();
        this.loadSpellTables();
        if (this.spell_tables.isEmpty()) {
            try {
                JOptionPane.showMessageDialog(this, Translator.getString("error.no_spell_tables_msg"), Translator.getString("error.no_spell_tables_dt"), 0);
            }
            catch (Exception ex) {
                Logger.getLogger(SpellingAlphabetTrainer.class.getName()).log(Level.SEVERE, null, ex);
            }
            finally {
                this.dispose();
                System.exit(0);
            }
        }
        for (ListItem item : this.spell_tables) {
            this.lstActiveSpellTable.addItem(item);
            this.lstTESpellTable.addItem(item);
        }
        this.loadSelectedSpellTable();
        this.setQuestion();
    }

    private void setupAnswerTimer() {
        int time = ((SpinnerNumberModel)this.sprHighlightTime.getModel()).getNumber().intValue();
        this.answerResultTimer = new Timer(time, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SpellingAlphabetTrainer.this.lblCheckResult.setText("");
                SpellingAlphabetTrainer.this.lblCheckResult.setBackground(null);
                SpellingAlphabetTrainer.this.lblCheckResult.setForeground(Color.black);
                SpellingAlphabetTrainer.this.txtSpelledCharacter.setBackground(Color.white);
                SpellingAlphabetTrainer.this.txtSpelledCharacter.setForeground(Color.black);
                SpellingAlphabetTrainer.this.txtSpelledCharacter.setText("");
                SpellingAlphabetTrainer.this.updateStatistics();
                SpellingAlphabetTrainer.this.setQuestion();
            }
        });
        this.answerResultTimer.setRepeats(false);
    }

    private void initComponents() {
        this.frmSettings = new JDialog();
        this.lblLanguage = new JLabel();
        this.lstLanguage = new JComboBox();
        this.lblCorrectAnswerHighlightDesc = new JLabel();
        this.lblIncorrectAnswerHighlightDesc = new JLabel();
        this.lblCorrectAnswerHighlight = new JLabel();
        this.lblIncorrectAnswerHighlight = new JLabel();
        this.lblHighlightTime = new JLabel();
        this.sprHighlightTime = new JSpinner();
        this.cmdSettingsOk = new JButton();
        this.chkShowWarningBeforeSTDelete = new JCheckBox();
        this.frmTableEditor = new JDialog();
        this.cmdTEClose = new JButton();
        this.cmdTESave = new JButton();
        this.pnlTableSelection = new JPanel();
        this.lblTESpellTable = new JLabel();
        this.cmdTELoad = new JButton();
        this.lstTESpellTable = new JComboBox();
        this.cmdTENew = new JButton();
        this.cmdTEDelete = new JButton();
        this.pnlTableEdit = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.tblSpellTable = new JTable();
        this.cmdTEAddRow = new JButton();
        this.cmdTEDeleteRow = new JButton();
        this.frmAbout = new JDialog();
        this.lblAppTitle = new JLabel();
        this.lblAuthorDesc = new JLabel();
        this.lblVersionDesc = new JLabel();
        this.lblWebsiteDesc = new JLabel();
        this.lblAuthor = new JLabel();
        this.lblVersion = new JLabel();
        this.lblWebsite = new JLabel();
        this.cmdAboutOk = new JButton();
        this.lblNotesDesc = new JLabel();
        this.lblNotes = new JLabel();
        this.lblLicensed = new JLabel();
        this.lblGNUGPLv3Image = new JLabel();
        this.lblSATImage = new JLabel();
        this.lblActiveSpellTable = new JLabel();
        this.lstActiveSpellTable = new JComboBox();
        this.lblCurrentCharDesc = new JLabel();
        this.lblCurrentChar = new JLabel();
        this.txtSpelledCharacter = new JTextField();
        this.cmdCheck = new JButton();
        this.lblCheckResult = new JLabel();
        this.lblStatistics = new JLabel();
        this.cmdClose = new JButton();
        this.mainMenuBar = new JMenuBar();
        this.mainMenu = new JMenu();
        this.menuSettings = new JMenuItem();
        this.menuTableEditor = new JMenuItem();
        this.menuClose = new JMenuItem();
        this.helpMenu = new JMenu();
        this.menuAbout = new JMenuItem();
        this.menuLicense = new JMenuItem();
        this.menuHelp = new JMenuItem();
        this.frmSettings.setTitle("Settings");
        this.frmSettings.setModal(true);
        this.lblLanguage.setText("Language:");
        this.lstLanguage.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                SpellingAlphabetTrainer.this.lstLanguageItemStateChanged(evt);
            }
        });
        this.lstLanguage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SpellingAlphabetTrainer.this.lstLanguageActionPerformed(evt);
            }
        });
        this.lblCorrectAnswerHighlightDesc.setText("Correct answer highlight:");
        this.lblIncorrectAnswerHighlightDesc.setText("Incorrect answer highlight:");
        this.lblCorrectAnswerHighlight.setBackground(new Color(0, 255, 0));
        this.lblCorrectAnswerHighlight.setHorizontalAlignment(0);
        this.lblCorrectAnswerHighlight.setText("Correct");
        this.lblCorrectAnswerHighlight.setToolTipText("Left click to set background color, right click to set foreground color.");
        this.lblCorrectAnswerHighlight.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.lblCorrectAnswerHighlight.setOpaque(true);
        this.lblCorrectAnswerHighlight.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                SpellingAlphabetTrainer.this.lblCorrectAnswerHighlightMouseClicked(evt);
            }
        });
        this.lblIncorrectAnswerHighlight.setBackground(new Color(255, 0, 0));
        this.lblIncorrectAnswerHighlight.setForeground(new Color(255, 255, 255));
        this.lblIncorrectAnswerHighlight.setHorizontalAlignment(0);
        this.lblIncorrectAnswerHighlight.setText("Incorrect");
        this.lblIncorrectAnswerHighlight.setToolTipText("Left click to set background color, right click to set foreground color.");
        this.lblIncorrectAnswerHighlight.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.lblIncorrectAnswerHighlight.setOpaque(true);
        this.lblIncorrectAnswerHighlight.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                SpellingAlphabetTrainer.this.lblIncorrectAnswerHighlightMouseClicked(evt);
            }
        });
        this.lblHighlightTime.setText("Highlight time (Miliseconds):");
        this.sprHighlightTime.setModel(new SpinnerNumberModel(1250, 250, 10000, 10));
        this.sprHighlightTime.setToolTipText("This sets how long the correct/incorrect result will be highlighted.");
        this.cmdSettingsOk.setText("Ok");
        this.cmdSettingsOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SpellingAlphabetTrainer.this.cmdSettingsOkActionPerformed(evt);
            }
        });
        this.chkShowWarningBeforeSTDelete.setSelected(true);
        this.chkShowWarningBeforeSTDelete.setText("Show waring before deleting spell table:");
        GroupLayout frmSettingsLayout = new GroupLayout(this.frmSettings.getContentPane());
        this.frmSettings.getContentPane().setLayout(frmSettingsLayout);
        frmSettingsLayout.setHorizontalGroup(frmSettingsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(frmSettingsLayout.createSequentialGroup().addContainerGap().addGroup(frmSettingsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(frmSettingsLayout.createSequentialGroup().addComponent(this.lblLanguage, -2, 96, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.lstLanguage, 0, -1, Short.MAX_VALUE)).addGroup(frmSettingsLayout.createSequentialGroup().addGroup(frmSettingsLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.lblIncorrectAnswerHighlightDesc, -1, 169, Short.MAX_VALUE).addComponent(this.lblCorrectAnswerHighlightDesc, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(frmSettingsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblCorrectAnswerHighlight, -1, -1, Short.MAX_VALUE).addComponent(this.lblIncorrectAnswerHighlight, -1, -1, Short.MAX_VALUE))).addGroup(GroupLayout.Alignment.TRAILING, frmSettingsLayout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.cmdSettingsOk)).addGroup(frmSettingsLayout.createSequentialGroup().addComponent(this.lblHighlightTime).addGap(18, 18, 18).addComponent(this.sprHighlightTime, -2, 101, -2).addGap(0, 95, Short.MAX_VALUE)).addComponent(this.chkShowWarningBeforeSTDelete, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        frmSettingsLayout.setVerticalGroup(frmSettingsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(frmSettingsLayout.createSequentialGroup().addContainerGap().addGroup(frmSettingsLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblLanguage).addComponent(this.lstLanguage, -2, -1, -2)).addGap(18, 18, 18).addGroup(frmSettingsLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblCorrectAnswerHighlightDesc).addComponent(this.lblCorrectAnswerHighlight)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(frmSettingsLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblIncorrectAnswerHighlightDesc).addComponent(this.lblIncorrectAnswerHighlight)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(frmSettingsLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.lblHighlightTime).addComponent(this.sprHighlightTime, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.chkShowWarningBeforeSTDelete).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 15, Short.MAX_VALUE).addComponent(this.cmdSettingsOk).addContainerGap()));
        this.frmTableEditor.setTitle("Spell Table Editor");
        this.frmTableEditor.setModal(true);
        this.cmdTEClose.setIcon(new ImageIcon(this.getClass().getResource("/com/mouseviator/spelling/alphabet/trainer/resources/Cancel_16x16.png")));
        this.cmdTEClose.setText("Close");
        this.cmdTEClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SpellingAlphabetTrainer.this.cmdTECloseActionPerformed(evt);
            }
        });
        this.cmdTESave.setIcon(new ImageIcon(this.getClass().getResource("/com/mouseviator/spelling/alphabet/trainer/resources/table-save-icon.png")));
        this.cmdTESave.setText("Save");
        this.cmdTESave.setEnabled(false);
        this.cmdTESave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SpellingAlphabetTrainer.this.cmdTESaveActionPerformed(evt);
            }
        });
        this.pnlTableSelection.setBorder(BorderFactory.createTitledBorder("Select table:"));
        this.lblTESpellTable.setText("Spell table:");
        this.cmdTELoad.setIcon(new ImageIcon(this.getClass().getResource("/com/mouseviator/spelling/alphabet/trainer/resources/Button-Load-icon16.png")));
        this.cmdTELoad.setText("Load");
        this.cmdTELoad.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SpellingAlphabetTrainer.this.cmdTELoadActionPerformed(evt);
            }
        });
        this.cmdTENew.setIcon(new ImageIcon(this.getClass().getResource("/com/mouseviator/spelling/alphabet/trainer/resources/table-add-icon.png")));
        this.cmdTENew.setText("New");
        this.cmdTENew.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SpellingAlphabetTrainer.this.cmdTENewActionPerformed(evt);
            }
        });
        this.cmdTEDelete.setIcon(new ImageIcon(this.getClass().getResource("/com/mouseviator/spelling/alphabet/trainer/resources/table-delete-icon.png")));
        this.cmdTEDelete.setText("Delete");
        this.cmdTEDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SpellingAlphabetTrainer.this.cmdTEDeleteActionPerformed(evt);
            }
        });
        GroupLayout pnlTableSelectionLayout = new GroupLayout(this.pnlTableSelection);
        this.pnlTableSelection.setLayout(pnlTableSelectionLayout);
        pnlTableSelectionLayout.setHorizontalGroup(pnlTableSelectionLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, pnlTableSelectionLayout.createSequentialGroup().addContainerGap().addComponent(this.lblTESpellTable, -1, 107, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pnlTableSelectionLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlTableSelectionLayout.createSequentialGroup().addComponent(this.cmdTENew, -2, 74, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cmdTEDelete)).addGroup(pnlTableSelectionLayout.createSequentialGroup().addComponent(this.lstTESpellTable, -2, 220, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cmdTELoad, -2, 74, -2))).addContainerGap()));
        pnlTableSelectionLayout.linkSize(0, this.cmdTEDelete, this.cmdTELoad, this.cmdTENew);
        pnlTableSelectionLayout.setVerticalGroup(pnlTableSelectionLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlTableSelectionLayout.createSequentialGroup().addContainerGap().addGroup(pnlTableSelectionLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblTESpellTable).addComponent(this.lstTESpellTable, -2, -1, -2).addComponent(this.cmdTELoad)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(pnlTableSelectionLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cmdTENew).addComponent(this.cmdTEDelete)).addContainerGap()));
        pnlTableSelectionLayout.linkSize(1, this.cmdTEDelete, this.cmdTELoad, this.cmdTENew);
        this.pnlTableEdit.setBorder(BorderFactory.createTitledBorder("Edit table:"));
        this.tblSpellTable.setModel(new SpellTableModel());
        this.tblSpellTable.setCellSelectionEnabled(true);
        this.tblSpellTable.setRowHeight(20);
        this.tblSpellTable.getColumnModel().getColumn(0).setCellEditor(new CharacterEditor());
        this.jScrollPane1.setViewportView(this.tblSpellTable);
        this.cmdTEAddRow.setIcon(new ImageIcon(this.getClass().getResource("/com/mouseviator/spelling/alphabet/trainer/resources/table-row-insert-icon.png")));
        this.cmdTEAddRow.setText("Add");
        this.cmdTEAddRow.setEnabled(false);
        this.cmdTEAddRow.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SpellingAlphabetTrainer.this.cmdTEAddRowActionPerformed(evt);
            }
        });
        this.cmdTEDeleteRow.setIcon(new ImageIcon(this.getClass().getResource("/com/mouseviator/spelling/alphabet/trainer/resources/table-row-delete-icon.png")));
        this.cmdTEDeleteRow.setText("Delete");
        this.cmdTEDeleteRow.setEnabled(false);
        this.cmdTEDeleteRow.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SpellingAlphabetTrainer.this.cmdTEDeleteRowActionPerformed(evt);
            }
        });
        GroupLayout pnlTableEditLayout = new GroupLayout(this.pnlTableEdit);
        this.pnlTableEdit.setLayout(pnlTableEditLayout);
        pnlTableEditLayout.setHorizontalGroup(pnlTableEditLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlTableEditLayout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -2, 0, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pnlTableEditLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.cmdTEAddRow, GroupLayout.Alignment.TRAILING, -2, 69, -2).addComponent(this.cmdTEDeleteRow, GroupLayout.Alignment.TRAILING)).addContainerGap()));
        pnlTableEditLayout.linkSize(0, this.cmdTEAddRow, this.cmdTEDeleteRow);
        pnlTableEditLayout.setVerticalGroup(pnlTableEditLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlTableEditLayout.createSequentialGroup().addContainerGap().addGroup(pnlTableEditLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlTableEditLayout.createSequentialGroup().addComponent(this.cmdTEAddRow).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cmdTEDeleteRow)).addComponent(this.jScrollPane1, -2, 275, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        pnlTableEditLayout.linkSize(1, this.cmdTEAddRow, this.cmdTEDeleteRow);
        GroupLayout frmTableEditorLayout = new GroupLayout(this.frmTableEditor.getContentPane());
        this.frmTableEditor.getContentPane().setLayout(frmTableEditorLayout);
        frmTableEditorLayout.setHorizontalGroup(frmTableEditorLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(frmTableEditorLayout.createSequentialGroup().addContainerGap().addGroup(frmTableEditorLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(frmTableEditorLayout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.cmdTESave).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cmdTEClose)).addComponent(this.pnlTableEdit, -1, -1, Short.MAX_VALUE).addComponent(this.pnlTableSelection, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        frmTableEditorLayout.linkSize(0, this.cmdTEClose, this.cmdTESave);
        frmTableEditorLayout.setVerticalGroup(frmTableEditorLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, frmTableEditorLayout.createSequentialGroup().addContainerGap().addComponent(this.pnlTableSelection, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pnlTableEdit, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(frmTableEditorLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cmdTESave).addComponent(this.cmdTEClose)).addContainerGap(-1, Short.MAX_VALUE)));
        frmTableEditorLayout.linkSize(1, this.cmdTEClose, this.cmdTESave);
        this.frmAbout.setTitle("About");
        this.frmAbout.setModal(true);
        this.lblAppTitle.setFont(new Font("Tahoma", 1, 20));
        this.lblAppTitle.setHorizontalAlignment(0);
        this.lblAppTitle.setText("Spelling Alphabet Trainer");
        this.lblAuthorDesc.setText("Author:");
        this.lblVersionDesc.setText("Version:");
        this.lblWebsiteDesc.setText("Website:");
        this.lblAuthor.setFont(new Font("Tahoma", 1, 13));
        this.lblAuthor.setText("Radek Henys");
        this.lblVersion.setFont(new Font("Tahoma", 1, 13));
        this.lblVersion.setText("1.0");
        this.lblWebsite.setFont(new Font("Tahoma", 1, 13));
        this.lblWebsite.setForeground(new Color(51, 51, 255));
        this.lblWebsite.setText("web");
        this.cmdAboutOk.setText("OK");
        this.cmdAboutOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SpellingAlphabetTrainer.this.cmdAboutOkActionPerformed(evt);
            }
        });
        this.lblNotesDesc.setText("Notes:");
        this.lblNotes.setFont(new Font("Tahoma", 2, 13));
        this.lblNotes.setText("web");
        this.lblNotes.setVerticalAlignment(1);
        this.lblLicensed.setText("Licensed under GNU GPL v3");
        this.lblGNUGPLv3Image.setIcon(new ImageIcon(this.getClass().getResource("/com/mouseviator/spelling/alphabet/trainer/resources/gplv3-127x51.png")));
        this.lblSATImage.setIcon(new ImageIcon(this.getClass().getResource("/com/mouseviator/spelling/alphabet/trainer/resources/SAT_icon_128.png")));
        GroupLayout frmAboutLayout = new GroupLayout(this.frmAbout.getContentPane());
        this.frmAbout.getContentPane().setLayout(frmAboutLayout);
        frmAboutLayout.setHorizontalGroup(frmAboutLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, frmAboutLayout.createSequentialGroup().addContainerGap().addGroup(frmAboutLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(frmAboutLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.lblNotesDesc, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.lblAuthorDesc, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.lblVersionDesc, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.lblWebsiteDesc, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.lblGNUGPLv3Image, -1, -1, Short.MAX_VALUE)).addComponent(this.lblSATImage)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(frmAboutLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(frmAboutLayout.createSequentialGroup().addComponent(this.lblLicensed, -1, -1, Short.MAX_VALUE).addGap(18, 18, 18).addComponent(this.cmdAboutOk)).addComponent(this.lblVersion, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.lblWebsite, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.lblNotes, -1, -1, Short.MAX_VALUE).addComponent(this.lblAuthor, -1, -1, Short.MAX_VALUE).addComponent(this.lblAppTitle, GroupLayout.Alignment.LEADING, -1, 300, Short.MAX_VALUE)).addContainerGap()));
        frmAboutLayout.setVerticalGroup(frmAboutLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(frmAboutLayout.createSequentialGroup().addContainerGap().addGroup(frmAboutLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblSATImage, -1, -1, Short.MAX_VALUE).addComponent(this.lblAppTitle, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(frmAboutLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblAuthorDesc).addComponent(this.lblAuthor)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(frmAboutLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblVersionDesc).addComponent(this.lblVersion)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(frmAboutLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblWebsiteDesc).addComponent(this.lblWebsite)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(frmAboutLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(frmAboutLayout.createSequentialGroup().addComponent(this.lblNotes, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(frmAboutLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cmdAboutOk).addComponent(this.lblLicensed))).addGroup(frmAboutLayout.createSequentialGroup().addComponent(this.lblNotesDesc).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblGNUGPLv3Image, -1, -1, Short.MAX_VALUE))).addContainerGap()));
        this.setDefaultCloseOperation(0);
        this.setTitle("Spelling Alphabet Trainer");
        this.lblActiveSpellTable.setText("Active spell table:");
        this.lstActiveSpellTable.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SpellingAlphabetTrainer.this.lstActiveSpellTableActionPerformed(evt);
            }
        });
        this.lblCurrentCharDesc.setText("How do you spell this character:");
        this.lblCurrentChar.setFont(new Font("Tahoma", 1, 36));
        this.lblCurrentChar.setHorizontalAlignment(0);
        this.lblCurrentChar.setText("A");
        this.txtSpelledCharacter.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                SpellingAlphabetTrainer.this.txtSpelledCharacterKeyPressed(evt);
            }
        });
        this.cmdCheck.setIcon(new ImageIcon(this.getClass().getResource("/com/mouseviator/spelling/alphabet/trainer/resources/Check_16x16.png")));
        this.cmdCheck.setText("Check");
        this.cmdCheck.setEnabled(false);
        this.cmdCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SpellingAlphabetTrainer.this.cmdCheckActionPerformed(evt);
            }
        });
        this.lblCheckResult.setText(" ");
        this.lblCheckResult.setOpaque(true);
        this.lblStatistics.setText(" ");
        this.cmdClose.setIcon(new ImageIcon(this.getClass().getResource("/com/mouseviator/spelling/alphabet/trainer/resources/Shutdown_button_T16x16.png")));
        this.cmdClose.setText("Close");
        this.cmdClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SpellingAlphabetTrainer.this.cmdCloseActionPerformed(evt);
            }
        });
        this.mainMenu.setText("Menu");
        this.menuSettings.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        this.menuSettings.setIcon(new ImageIcon(this.getClass().getResource("/com/mouseviator/spelling/alphabet/trainer/resources/Settings_16x16.png")));
        this.menuSettings.setText("Settings...");
        this.menuSettings.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SpellingAlphabetTrainer.this.menuSettingsActionPerformed(evt);
            }
        });
        this.mainMenu.add(this.menuSettings);
        this.menuTableEditor.setAccelerator(KeyStroke.getKeyStroke(69, 2));
        this.menuTableEditor.setIcon(new ImageIcon(this.getClass().getResource("/com/mouseviator/spelling/alphabet/trainer/resources/table-edit-icon.png")));
        this.menuTableEditor.setText("Table Editor...");
        this.menuTableEditor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SpellingAlphabetTrainer.this.menuTableEditorActionPerformed(evt);
            }
        });
        this.mainMenu.add(this.menuTableEditor);
        this.menuClose.setAccelerator(KeyStroke.getKeyStroke(115, 8));
        this.menuClose.setIcon(new ImageIcon(this.getClass().getResource("/com/mouseviator/spelling/alphabet/trainer/resources/Shutdown_button_T16x16.png")));
        this.menuClose.setText("Close");
        this.menuClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SpellingAlphabetTrainer.this.menuCloseActionPerformed(evt);
            }
        });
        this.mainMenu.add(this.menuClose);
        this.mainMenuBar.add(this.mainMenu);
        this.helpMenu.setText("Help");
        this.menuAbout.setAccelerator(KeyStroke.getKeyStroke(112, 2));
        this.menuAbout.setIcon(new ImageIcon(this.getClass().getResource("/com/mouseviator/spelling/alphabet/trainer/resources/Information_16x16.png")));
        this.menuAbout.setText("About...");
        this.menuAbout.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SpellingAlphabetTrainer.this.menuAboutActionPerformed(evt);
            }
        });
        this.helpMenu.add(this.menuAbout);
        this.menuLicense.setAccelerator(KeyStroke.getKeyStroke(113, 2));
        this.menuLicense.setIcon(new ImageIcon(this.getClass().getResource("/com/mouseviator/spelling/alphabet/trainer/resources/Text Document_16x16.png")));
        this.menuLicense.setText("License...");
        this.menuLicense.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SpellingAlphabetTrainer.this.menuLicenseActionPerformed(evt);
            }
        });
        this.helpMenu.add(this.menuLicense);
        this.menuHelp.setAccelerator(KeyStroke.getKeyStroke(112, 0));
        this.menuHelp.setIcon(new ImageIcon(this.getClass().getResource("/com/mouseviator/spelling/alphabet/trainer/resources/Actions-help-contents-icon.png")));
        this.menuHelp.setText("Help...");
        this.menuHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SpellingAlphabetTrainer.this.menuHelpActionPerformed(evt);
            }
        });
        this.helpMenu.add(this.menuHelp);
        this.mainMenuBar.add(this.helpMenu);
        this.setJMenuBar(this.mainMenuBar);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.lblActiveSpellTable).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.lstActiveSpellTable, 0, -1, Short.MAX_VALUE)).addComponent(this.lblCheckResult, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.lblCurrentCharDesc).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblCurrentChar, -2, 103, -2)).addComponent(this.txtSpelledCharacter)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cmdCheck)).addComponent(this.lblStatistics, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.cmdClose))).addContainerGap()));
        layout.linkSize(0, this.cmdCheck, this.cmdClose);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblActiveSpellTable).addComponent(this.lstActiveSpellTable, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.lblCurrentChar, -1, -1, Short.MAX_VALUE).addComponent(this.lblCurrentCharDesc, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.txtSpelledCharacter, -2, -1, -2).addComponent(this.cmdCheck)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblCheckResult).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.lblStatistics, -1, 43, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cmdClose).addGap(7, 7, 7)));
        layout.linkSize(1, this.cmdCheck, this.cmdClose);
        this.pack();
    }

    private void cmdCloseActionPerformed(ActionEvent evt) {
        this.close();
    }

    private void lstActiveSpellTableActionPerformed(ActionEvent evt) {
        this.loadSelectedSpellTable();
        this.setQuestion();
    }

    private void cmdCheckActionPerformed(ActionEvent evt) {
        this.checkAnswer();
    }

    private void txtSpelledCharacterKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10 && this.cmdCheck.isEnabled()) {
            this.checkAnswer();
        }
    }

    private void menuCloseActionPerformed(ActionEvent evt) {
        this.close();
    }

    private void cmdSettingsOkActionPerformed(ActionEvent evt) {
        this.setupAnswerTimer();
        this.frmSettings.setVisible(false);
    }

    private void menuSettingsActionPerformed(ActionEvent evt) {
        this.frmSettings.pack();
        this.frmSettings.revalidate();
        this.frmSettings.setLocationRelativeTo(this);
        this.frmSettings.setVisible(true);
        this.frmSettings.toFront();
    }

    private void lblCorrectAnswerHighlightMouseClicked(MouseEvent evt) {
        Color newColor;
        if (evt.getButton() == 1) {
            Color newColor2 = JColorChooser.showDialog(this, Translator.getString("lblCorrectAnswerHighlight.ch.bg.title"), this.lblCorrectAnswerHighlight.getBackground());
            if (newColor2 != null) {
                this.lblCorrectAnswerHighlight.setBackground(newColor2);
            }
        } else if (evt.getButton() == 3 && (newColor = JColorChooser.showDialog(this, Translator.getString("lblCorrectAnswerHighlight.ch.fg.title"), this.lblCorrectAnswerHighlight.getForeground())) != null) {
            this.lblCorrectAnswerHighlight.setForeground(newColor);
        }
    }

    private void lblIncorrectAnswerHighlightMouseClicked(MouseEvent evt) {
        Color newColor;
        if (evt.getButton() == 1) {
            Color newColor2 = JColorChooser.showDialog(this, Translator.getString("lblIncorrectAnswerHighlight.ch.bg.title"), this.lblIncorrectAnswerHighlight.getBackground());
            if (newColor2 != null) {
                this.lblIncorrectAnswerHighlight.setBackground(newColor2);
            }
        } else if (evt.getButton() == 3 && (newColor = JColorChooser.showDialog(this, Translator.getString("lblIncorrectAnswerHighlight.ch.fg.title"), this.lblIncorrectAnswerHighlight.getForeground())) != null) {
            this.lblIncorrectAnswerHighlight.setForeground(newColor);
        }
    }

    private void lstLanguageItemStateChanged(ItemEvent evt) {
        this.loadSelectedLanguage();
    }

    private void cmdTECloseActionPerformed(ActionEvent evt) {
        this.frmTableEditor.setVisible(false);
    }

    private void menuTableEditorActionPerformed(ActionEvent evt) {
        this.frmTableEditor.pack();
        this.frmTableEditor.revalidate();
        this.frmTableEditor.setLocationRelativeTo(this);
        this.frmTableEditor.setVisible(true);
        this.frmTableEditor.toFront();
    }

    private void cmdTELoadActionPerformed(ActionEvent evt) {
        this.enableControls(false);
        this.loadSpellTableIntoEditor();
        this.enableControls(true);
    }

    private void cmdTEAddRowActionPerformed(ActionEvent evt) {
        this.enableControls(false);
        this.TEAddRow();
        this.enableControls(true);
    }

    private void cmdTEDeleteRowActionPerformed(ActionEvent evt) {
        this.enableControls(false);
        this.TEDeleteRow();
        this.enableControls(true);
    }

    private void cmdTESaveActionPerformed(ActionEvent evt) {
        this.enableControls(false);
        this.TESaveTable();
        this.enableControls(true);
    }

    private void cmdAboutOkActionPerformed(ActionEvent evt) {
        this.frmAbout.setVisible(false);
    }

    private void menuAboutActionPerformed(ActionEvent evt) {
        this.frmAbout.setTitle(Translator.getString("frmAbout.title"));
        this.frmAbout.pack();
        this.frmAbout.revalidate();
        this.frmAbout.setLocationRelativeTo(this);
        this.frmAbout.setVisible(true);
        this.frmAbout.toFront();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cmdTENewActionPerformed(ActionEvent evt) {
        this.enableControls(false);
        try {
            boolean validInput;
            String tableName = "";
            do {
                validInput = true;
                tableName = JOptionPane.showInputDialog(this.frmTableEditor, (Object)Translator.getString("table_editor.new.id.text"));
                if (tableName == null) {
                    return;
                }
                for (ListItem item : this.spell_tables) {
                    if (!item.getTitle().equals(tableName)) continue;
                    validInput = false;
                    break;
                }
                if (validInput) continue;
                JOptionPane.showMessageDialog(this.frmTableEditor, MessageFormat.format(Translator.getString("table_editor.new.name.error_msg"), tableName), Translator.getString("table_editor.new.name.error_dt"), 1);
            } while (!validInput);
            ListItem<String> new_table = new ListItem<String>(tableName, SPELL_TABLES_FOLDER + File.separator + tableName + ".properties");
            this.lstTESpellTable.addItem(new_table);
            this.lstTESpellTable.setSelectedItem(new_table);
            SpellTableModel model = (SpellTableModel)this.tblSpellTable.getModel();
            model.setPropertiesFile(new_table.getItemData());
            this.TEAddRow();
        }
        finally {
            this.enableControls(true);
        }
    }

    private void cmdTEDeleteActionPerformed(ActionEvent evt) {
        this.enableControls(false);
        ListItem selected_table = (ListItem)this.lstTESpellTable.getSelectedItem();
        if (this.chkShowWarningBeforeSTDelete.isSelected() && JOptionPane.showConfirmDialog(this.frmTableEditor, MessageFormat.format(Translator.getString("table_editor.del_tbl.confirm_msg"), selected_table.getTitle(), selected_table.getItemData()), Translator.getString("table_editor.del_tbl.confirm_dt"), 0) == 1) {
            this.enableControls(true);
            return;
        }
        ListItem active_table = (ListItem)this.lstActiveSpellTable.getSelectedItem();
        this.lstActiveSpellTable.removeItem(selected_table);
        if (selected_table.equals(active_table) && this.lstActiveSpellTable.getItemCount() > 0) {
            this.lstActiveSpellTable.setSelectedIndex(0);
        }
        this.spell_tables.remove(selected_table);
        this.lstTESpellTable.removeItem(selected_table);
        if (this.lstTESpellTable.getItemCount() > 0) {
            this.lstTESpellTable.setSelectedIndex(0);
            this.loadSpellTableIntoEditor();
        } else {
            ((SpellTableModel)this.tblSpellTable.getModel()).deleteAll();
        }
        try {
            File f = new File((String)selected_table.getItemData());
            f.delete();
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this.frmTableEditor, MessageFormat.format(Translator.getString("table_editor.del_tbl.failed_msg"), selected_table.getTitle()), Translator.getString("table_editor.del_tbl.failed_dt"), 0);
            Logger.getLogger(SpellingAlphabetTrainer.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.enableControls(true);
    }

    private void lstLanguageActionPerformed(ActionEvent evt) {
    }

    private void menuLicenseActionPerformed(ActionEvent evt) {
        String file_name = DOCS_FOLDER + LICENSE_FILE;
        String lang_key = (String)((ListItem)this.lstLanguage.getSelectedItem()).getItemData();
        this.openFile(this.getLocalizedFile(file_name, lang_key, true), true);
    }

    private void menuHelpActionPerformed(ActionEvent evt) {
        String file_name = DOCS_FOLDER + HELP_FILE;
        String lang_key = (String)((ListItem)this.lstLanguage.getSelectedItem()).getItemData();
        this.openFile(this.getLocalizedFile(file_name, lang_key, true), true);
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException ex) {
            Logger.getLogger(SpellingAlphabetTrainer.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new SpellingAlphabetTrainer().setVisible(true);
            }
        });
    }

    private void loadSpellTables() {
        File folder = new File(SPELL_TABLES_FOLDER);
        final Pattern pattern = Pattern.compile(SPELL_TABLES_PATTERN, 2);
        File[] files = folder.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                Matcher matcher = pattern.matcher(pathname.getPath());
                return matcher.matches();
            }
        });
        if (files != null && files.length > 0) {
            for (File f : files) {
                Matcher matcher = pattern.matcher(f.getName());
                matcher.matches();
                String fileName = matcher.group(1);
                ListItem<String> item = new ListItem<String>(fileName, f.getPath());
                this.spell_tables.add(item);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean loadSelectedSpellTable() {
        ListItem item = (ListItem)this.lstActiveSpellTable.getSelectedItem();
        FileInputStream fis = null;
        InputStreamReader reader = null;
        try {
            Properties props = new Properties();
            fis = new FileInputStream((String)item.getItemData());
            reader = new InputStreamReader((InputStream)fis, Charset.forName("UTF-8"));
            props.load(reader);
            if (props.size() > 0) {
                this.activeSpellTable.clear();
                this.activeSpellTable = props;
                this.keysToChooseFrom.clear();
                this.usedKeys.clear();
                Enumeration<Object> e = this.activeSpellTable.keys();
                while (e.hasMoreElements()) {
                    String key = (String)e.nextElement();
                    this.keysToChooseFrom.add(key);
                }
                this.setTitle(MessageFormat.format(Translator.getString("app.stl.title"), Translator.getString("app.title"), item.getTitle()));
                this.resetStatistics();
                this.lastSpellTable = item;
                System.gc();
            }
            JOptionPane.showMessageDialog(this, MessageFormat.format(Translator.getString("error.empty_table_msg"), item.getTitle()), Translator.getString("error.empty_table_dt"), 0);
            if (this.lastSpellTable != null) {
                this.lstActiveSpellTable.setSelectedItem(this.lastSpellTable);
            }
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(SpellingAlphabetTrainer.class.getName()).log(Level.SEVERE, null, ex);
            JOptionPane.showMessageDialog(this, MessageFormat.format(Translator.getString("error.table_fnf_msg"), item.getTitle(), item.getItemData()), Translator.getString("error.table_fnf_dt"), 0);
            if (this.lastSpellTable != null) {
                this.lstActiveSpellTable.setSelectedItem(this.lastSpellTable);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException ex) {
                    Logger.getLogger(SpellingAlphabetTrainer.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException ex) {
                    Logger.getLogger(SpellingAlphabetTrainer.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            return true;
        }
    }

    private void setQuestion() {
        if (this.keysToChooseFrom.isEmpty()) {
            List<String> tmp_arr = this.keysToChooseFrom;
            this.keysToChooseFrom = this.usedKeys;
            this.usedKeys = tmp_arr;
            ++this.table_rotations;
        }
        String key = this.keysToChooseFrom.get(this.randomGenerator.nextInt(this.keysToChooseFrom.size()));
        this.lblCurrentChar.setText(key);
    }

    private void checkAnswer() {
        if (this.cmdCheck.isEnabled()) {
            this.enableCheckButton(false);
            if (this.txtSpelledCharacter.getText().isEmpty()) {
                JOptionPane.showMessageDialog(this, MessageFormat.format(Translator.getString("msg.type_answer"), this.lblCurrentChar.getText()));
                this.enableCheckButton(true);
                return;
            }
            String correct_answer = this.activeSpellTable.getProperty(this.lblCurrentChar.getText());
            this.answerCorrect = this.txtSpelledCharacter.getText().trim().toLowerCase().equals(correct_answer.toLowerCase());
            if (this.answerCorrect) {
                this.lblCheckResult.setText(Translator.getString("answer.correct"));
                this.lblCheckResult.setBackground(this.lblCorrectAnswerHighlight.getBackground());
                this.lblCheckResult.setForeground(this.lblCorrectAnswerHighlight.getForeground());
                this.txtSpelledCharacter.setBackground(this.lblCorrectAnswerHighlight.getBackground());
                this.txtSpelledCharacter.setForeground(this.lblCorrectAnswerHighlight.getForeground());
                this.keysToChooseFrom.remove(this.lblCurrentChar.getText());
                this.usedKeys.add(this.lblCurrentChar.getText());
                ++this.correct_answers;
            } else {
                this.lblCheckResult.setText(MessageFormat.format(Translator.getString("answer.incorrect"), this.lblCurrentChar.getText(), correct_answer));
                this.lblCheckResult.setBackground(this.lblIncorrectAnswerHighlight.getBackground());
                this.lblCheckResult.setForeground(this.lblIncorrectAnswerHighlight.getForeground());
                this.txtSpelledCharacter.setBackground(this.lblIncorrectAnswerHighlight.getBackground());
                this.txtSpelledCharacter.setForeground(this.lblIncorrectAnswerHighlight.getForeground());
                ++this.incorrect_answers;
            }
            this.answerResultTimer.restart();
        }
    }

    private void selectLanguage(String lang_key) {
        Map<String, LanguageFile> languages = Translator.getLanguages();
        LanguageFile lf = languages.get(lang_key);
        Locale lang_loc = lf.getLocale();
        ListItem<String> lang_item = new ListItem<String>(lang_loc.getDisplayName(), lang_key);
        this.lstLanguage.setSelectedItem(lang_item);
    }

    private void resetStatistics() {
        this.correct_answers = 0;
        this.incorrect_answers = 0;
        this.table_rotations = 0;
    }

    private void updateStatistics() {
        float percent = 1.0f / (float)(this.correct_answers + this.incorrect_answers) * (float)this.correct_answers;
        this.lblStatistics.setText(MessageFormat.format(Translator.getString("statistics"), this.correct_answers, this.incorrect_answers, Float.valueOf(percent), this.table_rotations));
    }

    private void close() {
        this.saveSettings();
        this.dispose();
        System.exit(0);
    }

    private void updateSettings(byte direction) {
        if (direction == 2) {
            if (this.lstLanguage.getItemCount() > 0) {
                ListItem item = (ListItem)this.lstLanguage.getSelectedItem();
                String lang_key = (String)item.getItemData();
                this.appSettings.setProperty("language", lang_key);
            }
            int iValue = ((SpinnerNumberModel)this.sprHighlightTime.getModel()).getNumber().intValue();
            this.appSettings.setProperty("highlight.time", String.valueOf(iValue));
            iValue = this.lblCorrectAnswerHighlight.getBackground().getRGB();
            this.appSettings.setProperty("correct.highlight.background", String.valueOf(iValue));
            iValue = this.lblIncorrectAnswerHighlight.getBackground().getRGB();
            this.appSettings.setProperty("incorrect.highlight.background", String.valueOf(iValue));
            iValue = this.lblCorrectAnswerHighlight.getForeground().getRGB();
            this.appSettings.setProperty("correct.highlight.foreground", String.valueOf(iValue));
            iValue = this.lblIncorrectAnswerHighlight.getForeground().getRGB();
            this.appSettings.setProperty("incorrect.highlight.foreground", String.valueOf(iValue));
            iValue = this.chkShowWarningBeforeSTDelete.isSelected() ? 1 : 0;
            this.appSettings.setProperty("editor.tbl.delete.warning", String.valueOf(iValue));
        } else if (direction == 1) {
            if (this.lstLanguage.getItemCount() > 0) {
                String sValue = this.appSettings.getProperty("language").trim();
                this.selectLanguage(sValue);
            }
            int iValue = Integer.valueOf(this.appSettings.getProperty("highlight.time"));
            if (((SpinnerNumberModel)this.sprHighlightTime.getModel()).getMinimum().compareTo(iValue) <= 0 && ((SpinnerNumberModel)this.sprHighlightTime.getModel()).getMaximum().compareTo(iValue) >= 0) {
                this.sprHighlightTime.setValue(iValue);
            }
            iValue = Integer.valueOf(this.appSettings.getProperty("correct.highlight.background"));
            this.lblCorrectAnswerHighlight.setBackground(new Color(iValue));
            iValue = Integer.valueOf(this.appSettings.getProperty("incorrect.highlight.background"));
            this.lblIncorrectAnswerHighlight.setBackground(new Color(iValue));
            iValue = Integer.valueOf(this.appSettings.getProperty("correct.highlight.foreground"));
            this.lblCorrectAnswerHighlight.setForeground(new Color(iValue));
            iValue = Integer.valueOf(this.appSettings.getProperty("incorrect.highlight.foreground"));
            this.lblIncorrectAnswerHighlight.setForeground(new Color(iValue));
            iValue = Integer.valueOf(this.appSettings.getProperty("editor.tbl.delete.warning"));
            this.chkShowWarningBeforeSTDelete.setSelected(iValue == 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveSettings() {
        FileOutputStream fos = null;
        OutputStreamWriter writer = null;
        try {
            this.updateSettings((byte)2);
            File f = new File(SETTINGS_FILE);
            if (!f.canWrite()) {
                f.setWritable(true);
            }
            fos = new FileOutputStream(f);
            writer = new OutputStreamWriter((OutputStream)fos, Charset.forName("UTF-8"));
            this.appSettings.store(writer, "Spell Table Trainer Settings");
            f.setReadOnly();
        }
        catch (IOException ioe) {
            Logger.getLogger(SpellingAlphabetTrainer.class.getName()).log(Level.SEVERE, null, ioe);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException ex) {
                    Logger.getLogger(SpellingAlphabetTrainer.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException ex) {
                    Logger.getLogger(SpellingAlphabetTrainer.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
    }

    private void setDefaultLanguage() {
        Map<String, LanguageFile> languages = Translator.getLanguages();
        if (languages.size() <= 0 || this.lstLanguage.getItemCount() <= 0) {
            return;
        }
        Locale loc = Locale.getDefault();
        String english_key = "";
        String local_key = "";
        for (String key : languages.keySet()) {
            LanguageFile lf = languages.get(key);
            if (loc.equals(lf.getLocale())) {
                local_key = key;
                break;
            }
            if (!loc.equals(new Locale("en", "US"))) continue;
            english_key = key;
        }
        if (!local_key.isEmpty()) {
            this.selectLanguage(local_key);
        } else if (!english_key.isEmpty()) {
            this.selectLanguage(english_key);
        } else {
            this.lstLanguage.setSelectedIndex(0);
        }
    }

    private void loadSelectedLanguage() {
        ListItem lang_item = (ListItem)this.lstLanguage.getSelectedItem();
        if (lang_item != null) {
            Translator.setLanguage((String)lang_item.getItemData());
        }
        Translator.setBundleName("com.mouseviator.spelling.alphabet.trainer.resources.Translation");
        this.cmdCheck.setText(Translator.getString("cmdCheck.text"));
        this.cmdCheck.setToolTipText(Translator.getString("cmdCheck.tooltip"));
        this.cmdClose.setText(Translator.getString("cmdClose.text"));
        this.cmdClose.setToolTipText(Translator.getString("cmdClose.tooltip"));
        this.cmdSettingsOk.setText(Translator.getString("cmdSettingsOk.text"));
        this.frmSettings.setTitle(Translator.getString("frmSettings.title"));
        this.lblActiveSpellTable.setText(Translator.getString("lblActiveSpellTable.text"));
        this.lstActiveSpellTable.setToolTipText(Translator.getString("lstActiveSpellTable.tooltip"));
        this.txtSpelledCharacter.setToolTipText(Translator.getString("txtSpelledCharacter.tooltip"));
        this.lblCheckResult.setText(Translator.getString("lblCheckResult.text"));
        this.lblCorrectAnswerHighlight.setText(Translator.getString("lblCorrectAnswerHighlight.text"));
        this.lblCorrectAnswerHighlight.setToolTipText(Translator.getString("lblCorrectAnswerHighlight.tooltip"));
        this.lblCorrectAnswerHighlightDesc.setText(Translator.getString("lblCorrectAnswerHighlightDesc.text"));
        this.lblCurrentCharDesc.setText(Translator.getString("lblCurrentCharDesc.text"));
        this.lblHighlightTime.setText(Translator.getString("lblHighlightTime.text"));
        this.lblIncorrectAnswerHighlight.setText(Translator.getString("lblIncorrectAnswerHighlight.text"));
        this.lblIncorrectAnswerHighlight.setToolTipText(Translator.getString("lblIncorrectAnswerHighlight.tooltip"));
        this.lblIncorrectAnswerHighlightDesc.setText(Translator.getString("lblIncorrectAnswerHighlightDesc.text"));
        this.lblLanguage.setText(Translator.getString("lblLanguage.text"));
        this.lblStatistics.setText(Translator.getString("lblStatistics.text"));
        this.mainMenu.setText(Translator.getString("mainMenu.text"));
        this.menuClose.setText(Translator.getString("menuClose.text"));
        this.menuSettings.setText(Translator.getString("menuSettings.text"));
        this.menuTableEditor.setText(Translator.getString("menuTableEditor.text"));
        ((TitledBorder)this.pnlTableSelection.getBorder()).setTitle(Translator.getString("pnlTableSelection.title"));
        ((TitledBorder)this.pnlTableEdit.getBorder()).setTitle(Translator.getString("pnlTableEdit.title"));
        this.lblTESpellTable.setText(Translator.getString("lblTESpellTable.text"));
        this.cmdTELoad.setText(Translator.getString("cmdTELoad.text"));
        this.cmdTEAddRow.setText(Translator.getString("cmdTEAddRow.text"));
        this.cmdTEDeleteRow.setText(Translator.getString("cmdTEDeleteRow.text"));
        this.cmdTESave.setText(Translator.getString("cmdTESave.text"));
        this.cmdTEClose.setText(Translator.getString("cmdTEClose.text"));
        this.cmdTENew.setText(Translator.getString("cmdTENew.text"));
        this.cmdTEDelete.setText(Translator.getString("cmdTEDelete.text"));
        this.frmTableEditor.setTitle(Translator.getString("frmTableEditor.title"));
        int column_index = this.tableColumnIndexToViewIndex(this.tblSpellTable, 0);
        this.tblSpellTable.getColumnModel().getColumn(column_index).setHeaderValue(Translator.getString("table_editor.column0"));
        column_index = this.tableColumnIndexToViewIndex(this.tblSpellTable, 1);
        this.tblSpellTable.getColumnModel().getColumn(column_index).setHeaderValue(Translator.getString("table_editor.column1"));
        this.sprHighlightTime.setToolTipText(Translator.getString("sprHighlightTime.tooltip"));
        this.lblAuthorDesc.setText(Translator.getString("lblAuthorDesc.text"));
        this.lblVersionDesc.setText(Translator.getString("lblVersionDesc.text"));
        this.lblWebsiteDesc.setText(Translator.getString("lblWebsiteDesc.text"));
        this.lblWebsite.setText(Translator.getString("lblWebsite.text"));
        this.cmdAboutOk.setText(Translator.getString("cmdAboutOk.text"));
        this.helpMenu.setText(Translator.getString("helpMenu.text"));
        this.menuAbout.setText(Translator.getString("menuAbout.text"));
        this.menuLicense.setText(Translator.getString("menuLicense.text"));
        this.menuHelp.setText(Translator.getString("menuHelp.text"));
        this.lblAppTitle.setText(Translator.getString("app.title"));
        this.chkShowWarningBeforeSTDelete.setText(Translator.getString("chkShowWarningBeforeSTDelete.text"));
        this.lblNotesDesc.setText(Translator.getString("lblNotesDesc.text"));
        this.lblNotes.setText(Translator.getString("lblNotes.text"));
        this.lblLicensed.setText(Translator.getString("lblLicensed.text"));
        ListItem item = (ListItem)this.lstActiveSpellTable.getSelectedItem();
        if (item != null) {
            this.setTitle(MessageFormat.format(Translator.getString("app.stl.title"), Translator.getString("app.title"), item.getTitle()));
        }
    }

    private void loadSpellTableIntoEditor() {
        SpellTableModel model = (SpellTableModel)this.tblSpellTable.getModel();
        ListItem item = (ListItem)this.lstTESpellTable.getSelectedItem();
        model.loadPropertiesFile((String)item.getItemData());
    }

    private void enableControls(boolean bEnable) {
        boolean hasItems = ((SpellTableModel)this.tblSpellTable.getModel()).getRowCount() > 0;
        boolean isTables = this.lstTESpellTable.getItemCount() > 0;
        this.cmdTEAddRow.setEnabled(bEnable && isTables);
        this.cmdTEDeleteRow.setEnabled(bEnable && hasItems && isTables);
        this.lstTESpellTable.setEnabled(bEnable && isTables);
        this.cmdTELoad.setEnabled(bEnable && isTables);
        this.cmdTESave.setEnabled(bEnable && hasItems && isTables);
        this.cmdTEClose.setEnabled(bEnable);
        this.cmdTENew.setEnabled(bEnable);
        this.cmdTEDelete.setEnabled(bEnable && isTables);
        this.lstActiveSpellTable.setEnabled(bEnable && isTables);
        this.txtSpelledCharacter.setEnabled(bEnable && isTables);
        this.enableCheckButton(bEnable && isTables);
    }

    private void enableCheckButton(boolean enable) {
        boolean isEmpty = "".equals(this.txtSpelledCharacter.getText().trim());
        this.cmdCheck.setEnabled(enable && !isEmpty);
    }

    private int tableColumnIndexToViewIndex(JTable table, int mColIndex) {
        for (int c = 0; c < table.getColumnCount(); ++c) {
            TableColumn col = table.getColumnModel().getColumn(c);
            if (col.getModelIndex() != mColIndex) continue;
            return c;
        }
        return -1;
    }

    private boolean openFile(File file) {
        return this.openFile(file, false);
    }

    private boolean openFile(File file, boolean askOpenContainingFolder) {
        boolean bRet = false;
        boolean bDesktopSupported = true;
        Desktop desktop = null;
        if (file == null) {
            return bRet;
        }
        if (!file.exists()) {
            String file_name = file.getPath();
            String folder_name = file.getAbsolutePath();
            int last_pos = folder_name.lastIndexOf(File.separator);
            if (last_pos != -1) {
                folder_name = folder_name.substring(0, last_pos);
            }
            if ((file = new File(folder_name)).exists() && askOpenContainingFolder) {
                int result = JOptionPane.showConfirmDialog(this, MessageFormat.format(Translator.getString("error.file_not_exist_folder_open_msg"), file_name), Translator.getString("error.file_not_exist_folder_open_dt"), 0);
                if (result == 1) {
                    return bRet;
                }
            } else {
                JOptionPane.showMessageDialog(this, MessageFormat.format(Translator.getString("error.file_not_exist_msg"), file_name), Translator.getString("error.file_not_exist_dt"), 0);
                return bRet;
            }
        }
        if (bDesktopSupported = Desktop.isDesktopSupported()) {
            desktop = Desktop.getDesktop();
            bDesktopSupported = desktop.isSupported(Desktop.Action.OPEN);
        }
        if (bDesktopSupported) {
            try {
                desktop.open(file);
                bRet = true;
            }
            catch (Exception ex) {
                Logger.getLogger(SpellingAlphabetTrainer.class.getName()).log(Level.SEVERE, "Failed top open folder/file: " + file.getPath() + " using Desktop class.", ex);
                JOptionPane.showMessageDialog(this, MessageFormat.format(Translator.getString("error.file_open_failed_msg"), file.getPath()), Translator.getString("error.file_open_failed_dt"), 0);
            }
        } else {
            JOptionPane.showMessageDialog(this, MessageFormat.format(Translator.getString("error.desktop_api_notsupported"), file.getPath()), Translator.getString("error.desktop_api_notsupported_dt"), 0);
            return bRet;
        }
        return bRet;
    }

    private File getLocalizedFile(String file_name, String lang_key, boolean ret_original) {
        File file = null;
        Pattern loc_pattern = Pattern.compile(LANG_KEY_PATTERN, 2);
        Matcher loc_matcher = loc_pattern.matcher(lang_key);
        if (loc_matcher.matches()) {
            String new_file_name;
            File new_file;
            String locale = loc_matcher.group(2) + loc_matcher.group(3) + loc_matcher.group(4) + loc_matcher.group(5);
            Pattern fn_pattern = Pattern.compile(FILE_NAME_PATTERN, 2);
            Matcher fn_matcher = fn_pattern.matcher(file_name);
            if (fn_matcher.matches() && (new_file = new File(new_file_name = fn_matcher.group(1) + locale + fn_matcher.group(2) + fn_matcher.group(3))).exists()) {
                file = new_file;
            }
        }
        if (file == null && ret_original) {
            file = new File(file_name);
        }
        return file;
    }

    protected class CharacterEditor
    extends DefaultCellEditor {
        JFormattedTextField ftf;
        MaskFormatter mf;
        private boolean DEBUG;

        public CharacterEditor() {
            super(new JFormattedTextField());
            this.DEBUG = false;
            try {
                this.ftf = (JFormattedTextField)this.getComponent();
                this.mf = new MaskFormatter("**");
                this.ftf.setFormatterFactory(new DefaultFormatterFactory(this.mf));
                this.ftf.setHorizontalAlignment(10);
                this.ftf.setFocusLostBehavior(3);
                this.ftf.getInputMap().put(KeyStroke.getKeyStroke(10, 0), "check");
                this.ftf.getActionMap().put("check", new AbstractAction(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (!CharacterEditor.this.ftf.isEditValid()) {
                            if (CharacterEditor.this.userSaysRevert()) {
                                CharacterEditor.this.ftf.postActionEvent();
                            }
                        } else {
                            try {
                                CharacterEditor.this.ftf.setText(CharacterEditor.this.ftf.getText().trim().toUpperCase());
                                CharacterEditor.this.ftf.commitEdit();
                                CharacterEditor.this.ftf.postActionEvent();
                            }
                            catch (ParseException parseException) {
                                // empty catch block
                            }
                        }
                    }
                });
            }
            catch (ParseException ex) {
                Logger.getLogger(CharacterEditor.class.getName()).log(Level.SEVERE, null, ex);
            }
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            JFormattedTextField ftf = (JFormattedTextField)super.getTableCellEditorComponent(table, value, isSelected, row, column);
            ftf.setValue(value);
            return ftf;
        }

        @Override
        public Object getCellEditorValue() {
            JFormattedTextField ftf = (JFormattedTextField)this.getComponent();
            Object o = ftf.getValue();
            if (o instanceof String) {
                return o;
            }
            if (this.DEBUG) {
                System.out.println("getCellEditorValue: o isn't a String");
            }
            return String.valueOf(o);
        }

        @Override
        public boolean stopCellEditing() {
            JFormattedTextField ftf = (JFormattedTextField)this.getComponent();
            if (ftf.isEditValid()) {
                try {
                    ftf.commitEdit();
                }
                catch (ParseException parseException) {}
            } else if (!this.userSaysRevert()) {
                return false;
            }
            return super.stopCellEditing();
        }

        protected boolean userSaysRevert() {
            Toolkit.getDefaultToolkit().beep();
            this.ftf.selectAll();
            Object[] options = new Object[]{Translator.getString("table_editor.char_edit_opt_edit"), Translator.getString("table_editor.char_edit_opt_revert")};
            int answer = JOptionPane.showOptionDialog(SwingUtilities.getWindowAncestor(this.ftf), Translator.getString("table_editor.invalid_text_character_msg"), Translator.getString("table_editor.invalid_text_character_dt"), 0, 0, null, options, options[1]);
            if (answer == 1) {
                this.ftf.setValue(this.ftf.getValue());
                return true;
            }
            return false;
        }
    }
}

