/*
 * Decompiled with CFR 0.152.
 */
package com.mouseviator.utils.internatialization;

import java.io.File;
import java.io.IOException;
import java.security.InvalidParameterException;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LanguageFile {
    private String filePath;
    public static final String FILENAME_PATTERN = "^(.*?)(_)([\\w]{2})(_)([\\w]{2})(.properties)$";
    private Pattern pattern = Pattern.compile("^(.*?)(_)([\\w]{2})(_)([\\w]{2})(.properties)$", 2);

    public LanguageFile(String filePath) throws IOException, InvalidParameterException, NullPointerException {
        this.checkFilePath(filePath);
        this.filePath = filePath;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public void setFilePath(String fileName) throws IOException, InvalidParameterException, NullPointerException {
        this.checkFilePath(this.filePath);
        this.filePath = fileName;
    }

    public String getFolderPath() {
        return this.getFolderPath(this.filePath);
    }

    private String getFolderPath(String filePath) {
        int lastPos = -1;
        int charPos = filePath.lastIndexOf("\\");
        lastPos = Math.max(lastPos, charPos);
        charPos = filePath.lastIndexOf("/");
        if ((lastPos = Math.max(lastPos, charPos)) != -1) {
            return filePath.substring(0, lastPos);
        }
        return filePath;
    }

    public String getFileName() {
        return this.getFileName(this.filePath);
    }

    private String getFileName(String filePath) {
        int lastPos = -1;
        int charPos = filePath.lastIndexOf("\\");
        lastPos = Math.max(lastPos, charPos);
        charPos = filePath.lastIndexOf("/");
        if ((lastPos = Math.max(lastPos, charPos)) != -1) {
            return filePath.substring(lastPos + 1);
        }
        return filePath;
    }

    public String getNameWithLocale() {
        return this.getNameWithLocale(this.filePath);
    }

    private String getNameWithLocale(String filePath) {
        String fileName = this.getFileName(filePath);
        Matcher matcher = this.pattern.matcher(fileName);
        if (matcher.matches()) {
            return matcher.group(1) + matcher.group(2) + matcher.group(3) + matcher.group(4) + matcher.group(5);
        }
        throw new InvalidParameterException(MessageFormat.format(ResourceBundle.getBundle("murdock/utils/internatialization/Translation").getString("LanguageFile.getNameWithLocale.regex_exception"), filePath, FILENAME_PATTERN));
    }

    public String getName() {
        return this.getName(this.filePath);
    }

    private String getName(String filePath) {
        String fileName = this.getFileName(filePath);
        Matcher matcher = this.pattern.matcher(fileName);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        throw new InvalidParameterException(MessageFormat.format(ResourceBundle.getBundle("murdock/utils/internatialization/Translation").getString("LanguageFile.getName.regex_exception"), filePath, FILENAME_PATTERN));
    }

    public Locale getLocale() {
        Matcher matcher = this.pattern.matcher(this.getFileName(this.filePath));
        if (matcher.matches()) {
            return new Locale(matcher.group(3), matcher.group(5));
        }
        return null;
    }

    private void checkFilePath(String filePath) throws IOException, InvalidParameterException, NullPointerException {
        if (filePath == null) {
            throw new NullPointerException(ResourceBundle.getBundle("murdock/utils/internatialization/Translation").getString("LanguageFile.checkFilePath.null_exception"));
        }
        Matcher matcher = this.pattern.matcher(this.getFileName(filePath));
        if (!matcher.matches()) {
            throw new InvalidParameterException(MessageFormat.format(ResourceBundle.getBundle("murdock/utils/internatialization/Translation").getString("LanguageFile.checkFilePath.regex_exception"), filePath, FILENAME_PATTERN));
        }
        File f = new File(filePath);
        if (!f.exists() || !f.isFile()) {
            throw new IOException(MessageFormat.format(ResourceBundle.getBundle("murdock/utils/internatialization/Translation").getString("LanguageFile.checkFilePath.io_exception"), filePath));
        }
    }
}

