/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws;

import com.sun.deploy.config.Platform;
import com.sun.deploy.trace.Trace;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Properties;

public class HtmlOptions {
    private static final String DOCBASE_KEY = "docbase";
    private static final String JNLPHREF_KEY = "jnlphref";
    private static final String EMBEDDED_KEY = "embedded";
    private static final String APPARG_KEY = "apparg";
    private static final String VMARG_KEY = "vmarg";
    private static final String PNAME_KEY = "name";
    private static final String PVALUE_KEY = "value";
    private String _embedded_jnlp = null;
    private String[] _htmlApplicationArgs = null;
    private String[] _htmlVmArgs = null;
    private Properties _htmlParameters;
    private URL _docbase = null;
    private String _jnlphref = null;
    private Properties rawProperties = null;
    static HtmlOptions theInstance = null;

    private HtmlOptions() {
    }

    private HtmlOptions(InputStream inputStream) throws MalformedURLException, IOException {
        this.importProperties(inputStream);
    }

    public static synchronized HtmlOptions get() {
        return theInstance;
    }

    public static synchronized HtmlOptions create(InputStream inputStream) throws MalformedURLException, IOException {
        theInstance = new HtmlOptions(inputStream);
        return theInstance;
    }

    public void export(OutputStream outputStream) throws IOException {
        if (this.rawProperties != null) {
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream);
            this.rawProperties.store(outputStreamWriter, null);
            outputStreamWriter.close();
        }
    }

    public synchronized void init(String string) {
        theInstance = new HtmlOptions();
    }

    private byte[] readFully(InputStream inputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n = 0;
        byte[] byArray = new byte[16384];
        while ((n = inputStream.read(byArray)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        inputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    private void importProperties(InputStream inputStream) throws MalformedURLException, IOException {
        byte[] byArray = this.readFully(inputStream);
        this.rawProperties = this.load(byArray, Platform.get().getPlatformNativeEncoding());
        if (this.rawProperties.getProperty(DOCBASE_KEY) == null) {
            this.rawProperties = this.load(byArray, "UTF-8");
        }
        String string = this.rawProperties.getProperty(DOCBASE_KEY);
        this._jnlphref = this.rawProperties.getProperty(JNLPHREF_KEY);
        String string2 = this.rawProperties.getProperty(EMBEDDED_KEY);
        this._htmlApplicationArgs = this.extractList(APPARG_KEY);
        this._htmlVmArgs = this.extractList(VMARG_KEY);
        this._htmlParameters = this.extractParameters();
        if (string != null && string.length() > 0) {
            this._docbase = new URL(string);
        }
        if (string2 != null && string2.length() > 0) {
            this._embedded_jnlp = string2;
        }
    }

    private Properties extractParameters() {
        String string;
        Properties properties = new Properties();
        int n = 0;
        while (this.rawProperties.containsKey(string = "name." + n)) {
            String string2 = "value." + n;
            properties.setProperty(this.rawProperties.getProperty(string), this.rawProperties.getProperty(string2));
            ++n;
        }
        return properties.isEmpty() ? null : properties;
    }

    private String[] extractList(String string) {
        String string2;
        String string3;
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        while ((string3 = this.rawProperties.getProperty(string2 = string + "." + n)) != null) {
            arrayList.add(string3);
            ++n;
        }
        return arrayList.toArray(new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties load(byte[] byArray, String string) {
        ByteArrayInputStream byteArrayInputStream = null;
        InputStreamReader inputStreamReader = null;
        try {
            byteArrayInputStream = new ByteArrayInputStream(byArray);
            inputStreamReader = new InputStreamReader((InputStream)byteArrayInputStream, string);
            Properties properties = new Properties();
            properties.load(inputStreamReader);
            Properties properties2 = properties;
            return properties2;
        }
        catch (Exception exception) {
            Properties properties = new Properties();
            return properties;
        }
        finally {
            if (inputStreamReader != null) {
                try {
                    inputStreamReader.close();
                }
                catch (IOException iOException) {
                    Trace.ignoredException((Exception)iOException);
                }
            } else if (byteArrayInputStream != null) {
                try {
                    ((InputStream)byteArrayInputStream).close();
                }
                catch (IOException iOException) {
                    Trace.ignoredException((Exception)iOException);
                }
            }
        }
    }

    public String getEmbedded() {
        return this._embedded_jnlp;
    }

    public String[] getHtmlApplicationArgs() {
        return this._htmlApplicationArgs;
    }

    public String[] getHtmlVmArgs() {
        return this._htmlVmArgs;
    }

    public Properties getParameters() {
        return this._htmlParameters;
    }

    public String getAbsoluteHref(URL uRL) throws MalformedURLException {
        block3: {
            if (this._jnlphref != null && this._jnlphref.length() > 0) {
                try {
                    return new URL(this._jnlphref).toString();
                }
                catch (MalformedURLException malformedURLException) {
                    if (uRL == null) break block3;
                    return new URL(uRL.toString() + "/" + this._jnlphref).toString();
                }
            }
        }
        return null;
    }

    public URL getDocBase() {
        return this._docbase;
    }
}

