/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.policy.sourcemodel;

import com.sun.xml.internal.ws.policy.AssertionSet;
import com.sun.xml.internal.ws.policy.Policy;
import com.sun.xml.internal.ws.policy.PolicyAssertion;
import com.sun.xml.internal.ws.policy.PolicyException;
import com.sun.xml.internal.ws.policy.privateutil.LocalizationMessages;
import com.sun.xml.internal.ws.policy.privateutil.PolicyLogger;
import com.sun.xml.internal.ws.policy.privateutil.PolicyUtils;
import com.sun.xml.internal.ws.policy.sourcemodel.AssertionData;
import com.sun.xml.internal.ws.policy.sourcemodel.DefaultPolicyAssertionCreator;
import com.sun.xml.internal.ws.policy.sourcemodel.ModelNode;
import com.sun.xml.internal.ws.policy.sourcemodel.PolicyReferenceData;
import com.sun.xml.internal.ws.policy.sourcemodel.PolicySourceModel;
import com.sun.xml.internal.ws.policy.spi.AssertionCreationException;
import com.sun.xml.internal.ws.policy.spi.PolicyAssertionCreator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class PolicyModelTranslator {
    private static final PolicyLogger LOGGER = PolicyLogger.getLogger(PolicyModelTranslator.class);
    private static final PolicyAssertionCreator defaultCreator = new DefaultPolicyAssertionCreator();
    private final Map<String, PolicyAssertionCreator> assertionCreators;

    private PolicyModelTranslator() throws PolicyException {
        this(null);
    }

    /*
     * WARNING - void declaration
     */
    protected PolicyModelTranslator(Collection<PolicyAssertionCreator> collection) throws PolicyException {
        void policyAssertionCreator;
        LOGGER.entering(collection);
        LinkedList<PolicyAssertionCreator> linkedList = new LinkedList<PolicyAssertionCreator>();
        PolicyAssertionCreator[] policyAssertionCreatorArray = PolicyUtils.ServiceProvider.load(PolicyAssertionCreator.class);
        Object hashMap = policyAssertionCreatorArray;
        int n = ((PolicyAssertionCreator[])hashMap).length;
        boolean bl = false;
        while (policyAssertionCreator < n) {
            PolicyAssertionCreator policyAssertionCreator2 = hashMap[policyAssertionCreator];
            linkedList.add(policyAssertionCreator2);
            ++policyAssertionCreator;
        }
        if (collection != null) {
            for (PolicyAssertionCreator policyAssertionCreator3 : collection) {
                linkedList.add(policyAssertionCreator3);
            }
        }
        hashMap = new HashMap();
        for (PolicyAssertionCreator policyAssertionCreator4 : linkedList) {
            String[] stringArray = policyAssertionCreator4.getSupportedDomainNamespaceURIs();
            String string = policyAssertionCreator4.getClass().getName();
            if (stringArray == null || stringArray.length == 0) {
                LOGGER.warning(LocalizationMessages.WSP_0077_ASSERTION_CREATOR_DOES_NOT_SUPPORT_ANY_URI(string));
                continue;
            }
            for (String string2 : stringArray) {
                LOGGER.config(LocalizationMessages.WSP_0078_ASSERTION_CREATOR_DISCOVERED(string, string2));
                if (string2 == null || string2.length() == 0) {
                    throw LOGGER.logSevereException(new PolicyException(LocalizationMessages.WSP_0070_ERROR_REGISTERING_ASSERTION_CREATOR(string)));
                }
                PolicyAssertionCreator policyAssertionCreator5 = hashMap.put(string2, policyAssertionCreator4);
                if (policyAssertionCreator5 == null) continue;
                throw LOGGER.logSevereException(new PolicyException(LocalizationMessages.WSP_0071_ERROR_MULTIPLE_ASSERTION_CREATORS_FOR_NAMESPACE(string2, policyAssertionCreator5.getClass().getName(), policyAssertionCreator4.getClass().getName())));
            }
        }
        this.assertionCreators = Collections.unmodifiableMap(hashMap);
        LOGGER.exiting();
    }

    public static PolicyModelTranslator getTranslator() throws PolicyException {
        return new PolicyModelTranslator();
    }

    public Policy translate(PolicySourceModel policySourceModel) throws PolicyException {
        PolicySourceModel policySourceModel2;
        LOGGER.entering(policySourceModel);
        if (policySourceModel == null) {
            throw LOGGER.logSevereException(new PolicyException(LocalizationMessages.WSP_0043_POLICY_MODEL_TRANSLATION_ERROR_INPUT_PARAM_NULL()));
        }
        try {
            policySourceModel2 = policySourceModel.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw LOGGER.logSevereException(new PolicyException(LocalizationMessages.WSP_0016_UNABLE_TO_CLONE_POLICY_SOURCE_MODEL(), cloneNotSupportedException));
        }
        String string = policySourceModel2.getPolicyId();
        String string2 = policySourceModel2.getPolicyName();
        Collection<AssertionSet> collection = this.createPolicyAlternatives(policySourceModel2);
        LOGGER.finest(LocalizationMessages.WSP_0052_NUMBER_OF_ALTERNATIVE_COMBINATIONS_CREATED(collection.size()));
        Policy policy = null;
        if (collection.size() == 0) {
            policy = Policy.createNullPolicy(policySourceModel.getNamespaceVersion(), string2, string);
            LOGGER.finest(LocalizationMessages.WSP_0055_NO_ALTERNATIVE_COMBINATIONS_CREATED());
        } else if (collection.size() == 1 && collection.iterator().next().isEmpty()) {
            policy = Policy.createEmptyPolicy(policySourceModel.getNamespaceVersion(), string2, string);
            LOGGER.finest(LocalizationMessages.WSP_0026_SINGLE_EMPTY_ALTERNATIVE_COMBINATION_CREATED());
        } else {
            policy = Policy.createPolicy(policySourceModel.getNamespaceVersion(), string2, string, collection);
            LOGGER.finest(LocalizationMessages.WSP_0057_N_ALTERNATIVE_COMBINATIONS_M_POLICY_ALTERNATIVES_CREATED(collection.size(), policy.getNumberOfAssertionSets()));
        }
        LOGGER.exiting(policy);
        return policy;
    }

    private Collection<AssertionSet> createPolicyAlternatives(PolicySourceModel policySourceModel) throws PolicyException {
        LinkedList<AssertionSet> linkedList;
        RawPolicy rawPolicy;
        ContentDecomposition contentDecomposition = new ContentDecomposition();
        LinkedList<RawPolicy> linkedList2 = new LinkedList<RawPolicy>();
        LinkedList<RawAlternative> linkedList3 = new LinkedList<RawAlternative>();
        RawPolicy rawPolicy2 = rawPolicy = new RawPolicy(policySourceModel.getRootNode(), new LinkedList<RawAlternative>());
        do {
            linkedList = rawPolicy2.originalContent;
            do {
                Object object;
                this.decompose(linkedList, contentDecomposition);
                if (contentDecomposition.exactlyOneContents.isEmpty()) {
                    object = new RawAlternative(contentDecomposition.assertions);
                    rawPolicy2.alternatives.add((RawAlternative)object);
                    if (((RawAlternative)object).allNestedPolicies.isEmpty()) continue;
                    linkedList2.addAll(((RawAlternative)object).allNestedPolicies);
                    continue;
                }
                object = PolicyUtils.Collections.combine(contentDecomposition.assertions, contentDecomposition.exactlyOneContents, false);
                if (object == null || object.isEmpty()) continue;
                linkedList3.addAll((Collection<RawAlternative>)object);
            } while ((linkedList = (LinkedList<AssertionSet>)linkedList3.poll()) != null);
        } while ((rawPolicy2 = (RawPolicy)linkedList2.poll()) != null);
        linkedList = new LinkedList<AssertionSet>();
        for (RawAlternative rawAlternative : rawPolicy.alternatives) {
            List<AssertionSet> list = this.normalizeRawAlternative(rawAlternative);
            linkedList.addAll(list);
        }
        return linkedList;
    }

    private void decompose(Collection<ModelNode> collection, ContentDecomposition contentDecomposition) throws PolicyException {
        ModelNode modelNode;
        contentDecomposition.reset();
        LinkedList<ModelNode> linkedList = new LinkedList<ModelNode>(collection);
        block6: while ((modelNode = (ModelNode)linkedList.poll()) != null) {
            switch (modelNode.getType()) {
                case POLICY: 
                case ALL: {
                    linkedList.addAll(modelNode.getChildren());
                    continue block6;
                }
                case POLICY_REFERENCE: {
                    linkedList.addAll(PolicyModelTranslator.getReferencedModelRootNode(modelNode).getChildren());
                    continue block6;
                }
                case EXACTLY_ONE: {
                    contentDecomposition.exactlyOneContents.add(this.expandsExactlyOneContent(modelNode.getChildren()));
                    continue block6;
                }
                case ASSERTION: {
                    contentDecomposition.assertions.add(modelNode);
                    continue block6;
                }
            }
            throw LOGGER.logSevereException(new PolicyException(LocalizationMessages.WSP_0007_UNEXPECTED_MODEL_NODE_TYPE_FOUND((Object)modelNode.getType())));
        }
    }

    private static ModelNode getReferencedModelRootNode(ModelNode modelNode) throws PolicyException {
        PolicySourceModel policySourceModel = modelNode.getReferencedModel();
        if (policySourceModel == null) {
            PolicyReferenceData policyReferenceData = modelNode.getPolicyReferenceData();
            if (policyReferenceData == null) {
                throw LOGGER.logSevereException(new PolicyException(LocalizationMessages.WSP_0041_POLICY_REFERENCE_NODE_FOUND_WITH_NO_POLICY_REFERENCE_IN_IT()));
            }
            throw LOGGER.logSevereException(new PolicyException(LocalizationMessages.WSP_0010_UNEXPANDED_POLICY_REFERENCE_NODE_FOUND_REFERENCING(policyReferenceData.getReferencedModelUri())));
        }
        return policySourceModel.getRootNode();
    }

    private Collection<ModelNode> expandsExactlyOneContent(Collection<ModelNode> collection) throws PolicyException {
        ModelNode modelNode;
        LinkedList<ModelNode> linkedList = new LinkedList<ModelNode>();
        LinkedList<ModelNode> linkedList2 = new LinkedList<ModelNode>(collection);
        block5: while ((modelNode = (ModelNode)linkedList2.poll()) != null) {
            switch (modelNode.getType()) {
                case POLICY: 
                case ALL: 
                case ASSERTION: {
                    linkedList.add(modelNode);
                    continue block5;
                }
                case POLICY_REFERENCE: {
                    linkedList.add(PolicyModelTranslator.getReferencedModelRootNode(modelNode));
                    continue block5;
                }
                case EXACTLY_ONE: {
                    linkedList2.addAll(modelNode.getChildren());
                    continue block5;
                }
            }
            throw LOGGER.logSevereException(new PolicyException(LocalizationMessages.WSP_0001_UNSUPPORTED_MODEL_NODE_TYPE((Object)modelNode.getType())));
        }
        return linkedList;
    }

    private List<AssertionSet> normalizeRawAlternative(RawAlternative rawAlternative) throws AssertionCreationException, PolicyException {
        List<PolicyAssertion> list;
        Object object;
        LinkedList<Object> linkedList;
        LinkedList linkedList2 = new LinkedList();
        LinkedList<Object> linkedList3 = new LinkedList<Object>();
        if (!rawAlternative.nestedAssertions.isEmpty()) {
            linkedList = new LinkedList<RawAssertion>(rawAlternative.nestedAssertions);
            while ((object = (RawAssertion)linkedList.poll()) != null) {
                list = this.normalizeRawAssertion((RawAssertion)object);
                if (list.size() == 1) {
                    linkedList2.addAll(list);
                    continue;
                }
                linkedList3.add(list);
            }
        }
        linkedList = new LinkedList();
        if (linkedList3.isEmpty()) {
            linkedList.add(AssertionSet.createAssertionSet(linkedList2));
        } else {
            object = PolicyUtils.Collections.combine(linkedList2, linkedList3, true);
            list = object.iterator();
            while (list.hasNext()) {
                Collection collection = (Collection)list.next();
                linkedList.add(AssertionSet.createAssertionSet(collection));
            }
        }
        return linkedList;
    }

    private List<PolicyAssertion> normalizeRawAssertion(RawAssertion rawAssertion) throws AssertionCreationException, PolicyException {
        boolean bl;
        ArrayList<PolicyAssertion> arrayList;
        if (rawAssertion.parameters.isEmpty()) {
            arrayList = null;
        } else {
            arrayList = new ArrayList<PolicyAssertion>(rawAssertion.parameters.size());
            for (ModelNode cloneable2 : rawAssertion.parameters) {
                arrayList.add(this.createPolicyAssertionParameter(cloneable2));
            }
        }
        LinkedList linkedList = new LinkedList();
        if (rawAssertion.nestedAlternatives != null && !rawAssertion.nestedAlternatives.isEmpty()) {
            RawAlternative rawAlternative;
            LinkedList<RawAlternative> linkedList2 = new LinkedList<RawAlternative>(rawAssertion.nestedAlternatives);
            while ((rawAlternative = (RawAlternative)linkedList2.poll()) != null) {
                linkedList.addAll(this.normalizeRawAlternative(rawAlternative));
            }
        }
        LinkedList<PolicyAssertion> linkedList3 = new LinkedList<PolicyAssertion>();
        boolean bl2 = bl = !linkedList.isEmpty();
        if (bl) {
            Iterator iterator = linkedList.iterator();
            while (iterator.hasNext()) {
                AssertionSet assertionSet = (AssertionSet)iterator.next();
                linkedList3.add(this.createPolicyAssertion(rawAssertion.originalNode.getNodeData(), arrayList, assertionSet));
            }
        } else {
            linkedList3.add(this.createPolicyAssertion(rawAssertion.originalNode.getNodeData(), arrayList, null));
        }
        return linkedList3;
    }

    private PolicyAssertion createPolicyAssertionParameter(ModelNode modelNode) throws AssertionCreationException, PolicyException {
        if (modelNode.getType() != ModelNode.Type.ASSERTION_PARAMETER_NODE) {
            throw LOGGER.logSevereException(new PolicyException(LocalizationMessages.WSP_0065_INCONSISTENCY_IN_POLICY_SOURCE_MODEL((Object)modelNode.getType())));
        }
        ArrayList<PolicyAssertion> arrayList = null;
        if (modelNode.hasChildren()) {
            arrayList = new ArrayList<PolicyAssertion>(modelNode.childrenSize());
            for (ModelNode modelNode2 : modelNode) {
                arrayList.add(this.createPolicyAssertionParameter(modelNode2));
            }
        }
        return this.createPolicyAssertion(modelNode.getNodeData(), arrayList, null);
    }

    private PolicyAssertion createPolicyAssertion(AssertionData assertionData, Collection<PolicyAssertion> collection, AssertionSet assertionSet) throws AssertionCreationException {
        String string = assertionData.getName().getNamespaceURI();
        PolicyAssertionCreator policyAssertionCreator = this.assertionCreators.get(string);
        if (policyAssertionCreator == null) {
            return defaultCreator.createAssertion(assertionData, collection, assertionSet, null);
        }
        return policyAssertionCreator.createAssertion(assertionData, collection, assertionSet, defaultCreator);
    }

    private static final class ContentDecomposition {
        final List<Collection<ModelNode>> exactlyOneContents = new LinkedList<Collection<ModelNode>>();
        final List<ModelNode> assertions = new LinkedList<ModelNode>();

        private ContentDecomposition() {
        }

        void reset() {
            this.exactlyOneContents.clear();
            this.assertions.clear();
        }
    }

    private static final class RawAlternative {
        private static final PolicyLogger LOGGER = PolicyLogger.getLogger(RawAlternative.class);
        final List<RawPolicy> allNestedPolicies = new LinkedList<RawPolicy>();
        final Collection<RawAssertion> nestedAssertions = new LinkedList<RawAssertion>();

        RawAlternative(Collection<ModelNode> collection) throws PolicyException {
            for (ModelNode modelNode : collection) {
                RawAssertion rawAssertion = new RawAssertion(modelNode, new LinkedList<ModelNode>());
                this.nestedAssertions.add(rawAssertion);
                block5: for (ModelNode modelNode2 : rawAssertion.originalNode.getChildren()) {
                    switch (modelNode2.getType()) {
                        case ASSERTION_PARAMETER_NODE: {
                            rawAssertion.parameters.add(modelNode2);
                            continue block5;
                        }
                        case POLICY: 
                        case POLICY_REFERENCE: {
                            if (rawAssertion.nestedAlternatives == null) {
                                rawAssertion.nestedAlternatives = new LinkedList<RawAlternative>();
                                RawPolicy rawPolicy = modelNode2.getType() == ModelNode.Type.POLICY ? new RawPolicy(modelNode2, rawAssertion.nestedAlternatives) : new RawPolicy(PolicyModelTranslator.getReferencedModelRootNode(modelNode2), rawAssertion.nestedAlternatives);
                                this.allNestedPolicies.add(rawPolicy);
                                continue block5;
                            }
                            throw LOGGER.logSevereException(new PolicyException(LocalizationMessages.WSP_0006_UNEXPECTED_MULTIPLE_POLICY_NODES()));
                        }
                    }
                    throw LOGGER.logSevereException(new PolicyException(LocalizationMessages.WSP_0008_UNEXPECTED_CHILD_MODEL_TYPE((Object)modelNode2.getType())));
                }
            }
        }
    }

    private static final class RawAssertion {
        ModelNode originalNode;
        Collection<RawAlternative> nestedAlternatives = null;
        final Collection<ModelNode> parameters;

        RawAssertion(ModelNode modelNode, Collection<ModelNode> collection) {
            this.parameters = collection;
            this.originalNode = modelNode;
        }
    }

    private static final class RawPolicy {
        final Collection<ModelNode> originalContent;
        final Collection<RawAlternative> alternatives;

        RawPolicy(ModelNode modelNode, Collection<RawAlternative> collection) {
            this.originalContent = modelNode.getChildren();
            this.alternatives = collection;
        }
    }
}

