/*
 * Decompiled with CFR 0.152.
 */
package sun.management.snmp.jvminstr;

import com.sun.jmx.mbeanserver.Util;
import com.sun.jmx.snmp.SnmpStatusException;
import com.sun.jmx.snmp.agent.SnmpMib;
import java.io.File;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.Map;
import javax.management.MBeanServer;
import sun.management.snmp.jvminstr.JVM_MANAGEMENT_MIB_IMPL;
import sun.management.snmp.jvmmib.EnumJvmRTBootClassPathSupport;
import sun.management.snmp.jvmmib.JvmRuntimeMBean;
import sun.management.snmp.util.JvmContextFactory;

public class JvmRuntimeImpl
implements JvmRuntimeMBean {
    static final EnumJvmRTBootClassPathSupport JvmRTBootClassPathSupportSupported = new EnumJvmRTBootClassPathSupport("supported");
    static final EnumJvmRTBootClassPathSupport JvmRTBootClassPathSupportUnSupported = new EnumJvmRTBootClassPathSupport("unsupported");

    public JvmRuntimeImpl(SnmpMib snmpMib) {
    }

    public JvmRuntimeImpl(SnmpMib snmpMib, MBeanServer mBeanServer) {
    }

    static RuntimeMXBean getRuntimeMXBean() {
        return ManagementFactory.getRuntimeMXBean();
    }

    private static String validDisplayStringTC(String string) {
        return JVM_MANAGEMENT_MIB_IMPL.validDisplayStringTC(string);
    }

    private static String validPathElementTC(String string) {
        return JVM_MANAGEMENT_MIB_IMPL.validPathElementTC(string);
    }

    private static String validJavaObjectNameTC(String string) {
        return JVM_MANAGEMENT_MIB_IMPL.validJavaObjectNameTC(string);
    }

    static String[] splitPath(String string) {
        String[] stringArray = string.split(File.pathSeparator);
        return stringArray;
    }

    static String[] getClassPath(Object object) {
        String[] stringArray;
        Map map = (Map)Util.cast(object instanceof Map ? object : null);
        if (map != null && (stringArray = (String[])map.get("JvmRuntime.getClassPath")) != null) {
            return stringArray;
        }
        stringArray = JvmRuntimeImpl.splitPath(JvmRuntimeImpl.getRuntimeMXBean().getClassPath());
        if (map != null) {
            map.put("JvmRuntime.getClassPath", stringArray);
        }
        return stringArray;
    }

    static String[] getBootClassPath(Object object) {
        String[] stringArray;
        if (!JvmRuntimeImpl.getRuntimeMXBean().isBootClassPathSupported()) {
            return new String[0];
        }
        Map map = (Map)Util.cast(object instanceof Map ? object : null);
        if (map != null && (stringArray = (String[])map.get("JvmRuntime.getBootClassPath")) != null) {
            return stringArray;
        }
        stringArray = JvmRuntimeImpl.splitPath(JvmRuntimeImpl.getRuntimeMXBean().getBootClassPath());
        if (map != null) {
            map.put("JvmRuntime.getBootClassPath", stringArray);
        }
        return stringArray;
    }

    static String[] getLibraryPath(Object object) {
        String[] stringArray;
        Map map = (Map)Util.cast(object instanceof Map ? object : null);
        if (map != null && (stringArray = (String[])map.get("JvmRuntime.getLibraryPath")) != null) {
            return stringArray;
        }
        stringArray = JvmRuntimeImpl.splitPath(JvmRuntimeImpl.getRuntimeMXBean().getLibraryPath());
        if (map != null) {
            map.put("JvmRuntime.getLibraryPath", stringArray);
        }
        return stringArray;
    }

    static String[] getInputArguments(Object object) {
        String[] stringArray;
        Map map = (Map)Util.cast(object instanceof Map ? object : null);
        if (map != null && (stringArray = (String[])map.get("JvmRuntime.getInputArguments")) != null) {
            return stringArray;
        }
        stringArray = JvmRuntimeImpl.getRuntimeMXBean().getInputArguments();
        String[] stringArray2 = stringArray.toArray(new String[0]);
        if (map != null) {
            map.put("JvmRuntime.getInputArguments", stringArray2);
        }
        return stringArray2;
    }

    @Override
    public String getJvmRTSpecVendor() throws SnmpStatusException {
        return JvmRuntimeImpl.validDisplayStringTC(JvmRuntimeImpl.getRuntimeMXBean().getSpecVendor());
    }

    @Override
    public String getJvmRTSpecName() throws SnmpStatusException {
        return JvmRuntimeImpl.validDisplayStringTC(JvmRuntimeImpl.getRuntimeMXBean().getSpecName());
    }

    @Override
    public String getJvmRTVMVersion() throws SnmpStatusException {
        return JvmRuntimeImpl.validDisplayStringTC(JvmRuntimeImpl.getRuntimeMXBean().getVmVersion());
    }

    @Override
    public String getJvmRTVMVendor() throws SnmpStatusException {
        return JvmRuntimeImpl.validDisplayStringTC(JvmRuntimeImpl.getRuntimeMXBean().getVmVendor());
    }

    @Override
    public String getJvmRTManagementSpecVersion() throws SnmpStatusException {
        return JvmRuntimeImpl.validDisplayStringTC(JvmRuntimeImpl.getRuntimeMXBean().getManagementSpecVersion());
    }

    @Override
    public String getJvmRTVMName() throws SnmpStatusException {
        return JvmRuntimeImpl.validJavaObjectNameTC(JvmRuntimeImpl.getRuntimeMXBean().getVmName());
    }

    @Override
    public Integer getJvmRTInputArgsCount() throws SnmpStatusException {
        String[] stringArray = JvmRuntimeImpl.getInputArguments(JvmContextFactory.getUserData());
        return new Integer(stringArray.length);
    }

    @Override
    public EnumJvmRTBootClassPathSupport getJvmRTBootClassPathSupport() throws SnmpStatusException {
        if (JvmRuntimeImpl.getRuntimeMXBean().isBootClassPathSupported()) {
            return JvmRTBootClassPathSupportSupported;
        }
        return JvmRTBootClassPathSupportUnSupported;
    }

    @Override
    public Long getJvmRTUptimeMs() throws SnmpStatusException {
        return new Long(JvmRuntimeImpl.getRuntimeMXBean().getUptime());
    }

    @Override
    public Long getJvmRTStartTimeMs() throws SnmpStatusException {
        return new Long(JvmRuntimeImpl.getRuntimeMXBean().getStartTime());
    }

    @Override
    public String getJvmRTSpecVersion() throws SnmpStatusException {
        return JvmRuntimeImpl.validDisplayStringTC(JvmRuntimeImpl.getRuntimeMXBean().getSpecVersion());
    }

    @Override
    public String getJvmRTName() throws SnmpStatusException {
        return JvmRuntimeImpl.validDisplayStringTC(JvmRuntimeImpl.getRuntimeMXBean().getName());
    }
}

