/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.Closeable;
import java.io.FileDescriptor;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketImpl;
import java.net.SocketImplFactory;
import java.net.SocksSocketImpl;
import java.nio.channels.ServerSocketChannel;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;

public class ServerSocket
implements Closeable {
    private boolean created = false;
    private boolean bound = false;
    private boolean closed = false;
    private Object closeLock = new Object();
    private SocketImpl impl;
    private boolean oldImpl = false;
    private static SocketImplFactory factory = null;

    ServerSocket(SocketImpl socketImpl) {
        this.impl = socketImpl;
        socketImpl.setServerSocket(this);
    }

    public ServerSocket() throws IOException {
        this.setImpl();
    }

    public ServerSocket(int n) throws IOException {
        this(n, 50, null);
    }

    public ServerSocket(int n, int n2) throws IOException {
        this(n, n2, null);
    }

    public ServerSocket(int n, int n2, InetAddress inetAddress) throws IOException {
        this.setImpl();
        if (n < 0 || n > 65535) {
            throw new IllegalArgumentException("Port value out of range: " + n);
        }
        if (n2 < 1) {
            n2 = 50;
        }
        try {
            this.bind(new InetSocketAddress(inetAddress, n), n2);
        }
        catch (SecurityException securityException) {
            this.close();
            throw securityException;
        }
        catch (IOException iOException) {
            this.close();
            throw iOException;
        }
    }

    SocketImpl getImpl() throws SocketException {
        if (!this.created) {
            this.createImpl();
        }
        return this.impl;
    }

    private void checkOldImpl() {
        if (this.impl == null) {
            return;
        }
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws NoSuchMethodException {
                    Class[] classArray = new Class[]{SocketAddress.class, Integer.TYPE};
                    ServerSocket.this.impl.getClass().getDeclaredMethod("connect", classArray);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            this.oldImpl = true;
        }
    }

    private void setImpl() {
        if (factory != null) {
            this.impl = factory.createSocketImpl();
            this.checkOldImpl();
        } else {
            this.impl = new SocksSocketImpl();
        }
        if (this.impl != null) {
            this.impl.setServerSocket(this);
        }
    }

    void createImpl() throws SocketException {
        if (this.impl == null) {
            this.setImpl();
        }
        try {
            this.impl.create(true);
            this.created = true;
        }
        catch (IOException iOException) {
            throw new SocketException(iOException.getMessage());
        }
    }

    public void bind(SocketAddress socketAddress) throws IOException {
        this.bind(socketAddress, 50);
    }

    public void bind(SocketAddress socketAddress, int n) throws IOException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        if (!this.oldImpl && this.isBound()) {
            throw new SocketException("Already bound");
        }
        if (socketAddress == null) {
            socketAddress = new InetSocketAddress(0);
        }
        if (!(socketAddress instanceof InetSocketAddress)) {
            throw new IllegalArgumentException("Unsupported address type");
        }
        InetSocketAddress inetSocketAddress = (InetSocketAddress)socketAddress;
        if (inetSocketAddress.isUnresolved()) {
            throw new SocketException("Unresolved address");
        }
        if (n < 1) {
            n = 50;
        }
        try {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                securityManager.checkListen(inetSocketAddress.getPort());
            }
            this.getImpl().bind(inetSocketAddress.getAddress(), inetSocketAddress.getPort());
            this.getImpl().listen(n);
            this.bound = true;
        }
        catch (SecurityException securityException) {
            this.bound = false;
            throw securityException;
        }
        catch (IOException iOException) {
            this.bound = false;
            throw iOException;
        }
    }

    public InetAddress getInetAddress() {
        if (!this.isBound()) {
            return null;
        }
        try {
            return this.getImpl().getInetAddress();
        }
        catch (SocketException socketException) {
            return null;
        }
    }

    public int getLocalPort() {
        if (!this.isBound()) {
            return -1;
        }
        try {
            return this.getImpl().getLocalPort();
        }
        catch (SocketException socketException) {
            return -1;
        }
    }

    public SocketAddress getLocalSocketAddress() {
        if (!this.isBound()) {
            return null;
        }
        return new InetSocketAddress(this.getInetAddress(), this.getLocalPort());
    }

    public Socket accept() throws IOException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        if (!this.isBound()) {
            throw new SocketException("Socket is not bound yet");
        }
        Socket socket = new Socket((SocketImpl)null);
        this.implAccept(socket);
        return socket;
    }

    protected final void implAccept(Socket socket) throws IOException {
        SocketImpl socketImpl = null;
        try {
            if (socket.impl == null) {
                socket.setImpl();
            } else {
                socket.impl.reset();
            }
            socketImpl = socket.impl;
            socket.impl = null;
            socketImpl.address = new InetAddress();
            socketImpl.fd = new FileDescriptor();
            this.getImpl().accept(socketImpl);
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                securityManager.checkAccept(socketImpl.getInetAddress().getHostAddress(), socketImpl.getPort());
            }
        }
        catch (IOException iOException) {
            if (socketImpl != null) {
                socketImpl.reset();
            }
            socket.impl = socketImpl;
            throw iOException;
        }
        catch (SecurityException securityException) {
            if (socketImpl != null) {
                socketImpl.reset();
            }
            socket.impl = socketImpl;
            throw securityException;
        }
        socket.impl = socketImpl;
        socket.postAccept();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object object = this.closeLock;
        synchronized (object) {
            if (this.isClosed()) {
                return;
            }
            if (this.created) {
                this.impl.close();
            }
            this.closed = true;
        }
    }

    public ServerSocketChannel getChannel() {
        return null;
    }

    public boolean isBound() {
        return this.bound || this.oldImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isClosed() {
        Object object = this.closeLock;
        synchronized (object) {
            return this.closed;
        }
    }

    public synchronized void setSoTimeout(int n) throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        this.getImpl().setOption(4102, new Integer(n));
    }

    public synchronized int getSoTimeout() throws IOException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        Object object = this.getImpl().getOption(4102);
        if (object instanceof Integer) {
            return (Integer)object;
        }
        return 0;
    }

    public void setReuseAddress(boolean bl) throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        this.getImpl().setOption(4, bl);
    }

    public boolean getReuseAddress() throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        return (Boolean)this.getImpl().getOption(4);
    }

    public String toString() {
        if (!this.isBound()) {
            return "ServerSocket[unbound]";
        }
        return "ServerSocket[addr=" + this.impl.getInetAddress() + ",port=" + this.impl.getPort() + ",localport=" + this.impl.getLocalPort() + "]";
    }

    void setBound() {
        this.bound = true;
    }

    void setCreated() {
        this.created = true;
    }

    public static synchronized void setSocketFactory(SocketImplFactory socketImplFactory) throws IOException {
        if (factory != null) {
            throw new SocketException("factory already defined");
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkSetFactory();
        }
        factory = socketImplFactory;
    }

    public synchronized void setReceiveBufferSize(int n) throws SocketException {
        if (n <= 0) {
            throw new IllegalArgumentException("negative receive size");
        }
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        this.getImpl().setOption(4098, new Integer(n));
    }

    public synchronized int getReceiveBufferSize() throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        int n = 0;
        Object object = this.getImpl().getOption(4098);
        if (object instanceof Integer) {
            n = (Integer)object;
        }
        return n;
    }

    public void setPerformancePreferences(int n, int n2, int n3) {
    }
}

