/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.DLSInfo;
import com.sun.media.sound.DLSModulator;
import com.sun.media.sound.DLSRegion;
import com.sun.media.sound.DLSSample;
import com.sun.media.sound.DLSSampleLoop;
import com.sun.media.sound.DLSSampleOptions;
import com.sun.media.sound.DLSSoundbank;
import com.sun.media.sound.ModelByteBuffer;
import com.sun.media.sound.ModelByteBufferWavetable;
import com.sun.media.sound.ModelConnectionBlock;
import com.sun.media.sound.ModelDestination;
import com.sun.media.sound.ModelIdentifier;
import com.sun.media.sound.ModelInstrument;
import com.sun.media.sound.ModelPatch;
import com.sun.media.sound.ModelPerformer;
import com.sun.media.sound.ModelSource;
import com.sun.media.sound.ModelStandardTransform;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.sound.midi.Patch;

public class DLSInstrument
extends ModelInstrument {
    protected int preset = 0;
    protected int bank = 0;
    protected boolean druminstrument = false;
    protected byte[] guid = null;
    protected DLSInfo info = new DLSInfo();
    protected List<DLSRegion> regions = new ArrayList<DLSRegion>();
    protected List<DLSModulator> modulators = new ArrayList<DLSModulator>();

    public DLSInstrument() {
        super(null, null, null, null);
    }

    public DLSInstrument(DLSSoundbank dLSSoundbank) {
        super(dLSSoundbank, null, null, null);
    }

    public DLSInfo getInfo() {
        return this.info;
    }

    @Override
    public String getName() {
        return this.info.name;
    }

    public void setName(String string) {
        this.info.name = string;
    }

    @Override
    public ModelPatch getPatch() {
        return new ModelPatch(this.bank, this.preset, this.druminstrument);
    }

    public void setPatch(Patch patch) {
        if (patch instanceof ModelPatch && ((ModelPatch)patch).isPercussion()) {
            this.druminstrument = true;
            this.bank = patch.getBank();
            this.preset = patch.getProgram();
        } else {
            this.druminstrument = false;
            this.bank = patch.getBank();
            this.preset = patch.getProgram();
        }
    }

    @Override
    public Object getData() {
        return null;
    }

    public List<DLSRegion> getRegions() {
        return this.regions;
    }

    public List<DLSModulator> getModulators() {
        return this.modulators;
    }

    public String toString() {
        if (this.druminstrument) {
            return "Drumkit: " + this.info.name + " bank #" + this.bank + " preset #" + this.preset;
        }
        return "Instrument: " + this.info.name + " bank #" + this.bank + " preset #" + this.preset;
    }

    private ModelIdentifier convertToModelDest(int n) {
        if (n == 0) {
            return null;
        }
        if (n == 1) {
            return ModelDestination.DESTINATION_GAIN;
        }
        if (n == 3) {
            return ModelDestination.DESTINATION_PITCH;
        }
        if (n == 4) {
            return ModelDestination.DESTINATION_PAN;
        }
        if (n == 260) {
            return ModelDestination.DESTINATION_LFO1_FREQ;
        }
        if (n == 261) {
            return ModelDestination.DESTINATION_LFO1_DELAY;
        }
        if (n == 518) {
            return ModelDestination.DESTINATION_EG1_ATTACK;
        }
        if (n == 519) {
            return ModelDestination.DESTINATION_EG1_DECAY;
        }
        if (n == 521) {
            return ModelDestination.DESTINATION_EG1_RELEASE;
        }
        if (n == 522) {
            return ModelDestination.DESTINATION_EG1_SUSTAIN;
        }
        if (n == 778) {
            return ModelDestination.DESTINATION_EG2_ATTACK;
        }
        if (n == 779) {
            return ModelDestination.DESTINATION_EG2_DECAY;
        }
        if (n == 781) {
            return ModelDestination.DESTINATION_EG2_RELEASE;
        }
        if (n == 782) {
            return ModelDestination.DESTINATION_EG2_SUSTAIN;
        }
        if (n == 5) {
            return ModelDestination.DESTINATION_KEYNUMBER;
        }
        if (n == 128) {
            return ModelDestination.DESTINATION_CHORUS;
        }
        if (n == 129) {
            return ModelDestination.DESTINATION_REVERB;
        }
        if (n == 276) {
            return ModelDestination.DESTINATION_LFO2_FREQ;
        }
        if (n == 277) {
            return ModelDestination.DESTINATION_LFO2_DELAY;
        }
        if (n == 523) {
            return ModelDestination.DESTINATION_EG1_DELAY;
        }
        if (n == 524) {
            return ModelDestination.DESTINATION_EG1_HOLD;
        }
        if (n == 525) {
            return ModelDestination.DESTINATION_EG1_SHUTDOWN;
        }
        if (n == 783) {
            return ModelDestination.DESTINATION_EG2_DELAY;
        }
        if (n == 784) {
            return ModelDestination.DESTINATION_EG2_HOLD;
        }
        if (n == 1280) {
            return ModelDestination.DESTINATION_FILTER_FREQ;
        }
        if (n == 1281) {
            return ModelDestination.DESTINATION_FILTER_Q;
        }
        return null;
    }

    private ModelIdentifier convertToModelSrc(int n) {
        if (n == 0) {
            return null;
        }
        if (n == 1) {
            return ModelSource.SOURCE_LFO1;
        }
        if (n == 2) {
            return ModelSource.SOURCE_NOTEON_VELOCITY;
        }
        if (n == 3) {
            return ModelSource.SOURCE_NOTEON_KEYNUMBER;
        }
        if (n == 4) {
            return ModelSource.SOURCE_EG1;
        }
        if (n == 5) {
            return ModelSource.SOURCE_EG2;
        }
        if (n == 6) {
            return ModelSource.SOURCE_MIDI_PITCH;
        }
        if (n == 129) {
            return new ModelIdentifier("midi_cc", "1", 0);
        }
        if (n == 135) {
            return new ModelIdentifier("midi_cc", "7", 0);
        }
        if (n == 138) {
            return new ModelIdentifier("midi_cc", "10", 0);
        }
        if (n == 139) {
            return new ModelIdentifier("midi_cc", "11", 0);
        }
        if (n == 256) {
            return new ModelIdentifier("midi_rpn", "0", 0);
        }
        if (n == 257) {
            return new ModelIdentifier("midi_rpn", "1", 0);
        }
        if (n == 7) {
            return ModelSource.SOURCE_MIDI_POLY_PRESSURE;
        }
        if (n == 8) {
            return ModelSource.SOURCE_MIDI_CHANNEL_PRESSURE;
        }
        if (n == 9) {
            return ModelSource.SOURCE_LFO2;
        }
        if (n == 10) {
            return ModelSource.SOURCE_MIDI_CHANNEL_PRESSURE;
        }
        if (n == 219) {
            return new ModelIdentifier("midi_cc", "91", 0);
        }
        if (n == 221) {
            return new ModelIdentifier("midi_cc", "93", 0);
        }
        return null;
    }

    private ModelConnectionBlock convertToModel(DLSModulator dLSModulator) {
        ModelIdentifier modelIdentifier = this.convertToModelSrc(dLSModulator.getSource());
        ModelIdentifier modelIdentifier2 = this.convertToModelSrc(dLSModulator.getControl());
        ModelIdentifier modelIdentifier3 = this.convertToModelDest(dLSModulator.getDestination());
        int n = dLSModulator.getScale();
        double d = n == Integer.MIN_VALUE ? Double.NEGATIVE_INFINITY : (double)n / 65536.0;
        if (modelIdentifier3 != null) {
            Object object;
            Object object2 = null;
            Object object3 = null;
            ModelConnectionBlock modelConnectionBlock = new ModelConnectionBlock();
            if (modelIdentifier2 != null) {
                object = new ModelSource();
                if (modelIdentifier2 == ModelSource.SOURCE_MIDI_PITCH) {
                    ((ModelStandardTransform)((ModelSource)object).getTransform()).setPolarity(true);
                } else if (modelIdentifier2 == ModelSource.SOURCE_LFO1 || modelIdentifier2 == ModelSource.SOURCE_LFO2) {
                    ((ModelStandardTransform)((ModelSource)object).getTransform()).setPolarity(true);
                }
                ((ModelSource)object).setIdentifier(modelIdentifier2);
                modelConnectionBlock.addSource((ModelSource)object);
                object3 = object;
            }
            if (modelIdentifier != null) {
                object = new ModelSource();
                if (modelIdentifier == ModelSource.SOURCE_MIDI_PITCH) {
                    ((ModelStandardTransform)((ModelSource)object).getTransform()).setPolarity(true);
                } else if (modelIdentifier == ModelSource.SOURCE_LFO1 || modelIdentifier == ModelSource.SOURCE_LFO2) {
                    ((ModelStandardTransform)((ModelSource)object).getTransform()).setPolarity(true);
                }
                ((ModelSource)object).setIdentifier(modelIdentifier);
                modelConnectionBlock.addSource((ModelSource)object);
                object2 = object;
            }
            object = new ModelDestination();
            ((ModelDestination)object).setIdentifier(modelIdentifier3);
            modelConnectionBlock.setDestination((ModelDestination)object);
            if (dLSModulator.getVersion() == 1) {
                if (dLSModulator.getTransform() == 1) {
                    if (object2 != null) {
                        ((ModelStandardTransform)((ModelSource)object2).getTransform()).setTransform(1);
                        ((ModelStandardTransform)((ModelSource)object2).getTransform()).setDirection(true);
                    }
                    if (object3 != null) {
                        ((ModelStandardTransform)((ModelSource)object3).getTransform()).setTransform(1);
                        ((ModelStandardTransform)((ModelSource)object3).getTransform()).setDirection(true);
                    }
                }
            } else if (dLSModulator.getVersion() == 2) {
                int n2;
                int n3 = dLSModulator.getTransform();
                int n4 = n3 >> 15 & 1;
                int n5 = n3 >> 14 & 1;
                int n6 = n3 >> 10 & 8;
                int n7 = n3 >> 9 & 1;
                int n8 = n3 >> 8 & 1;
                int n9 = n3 >> 4 & 8;
                if (object2 != null) {
                    n2 = 0;
                    if (n6 == 3) {
                        n2 = 3;
                    }
                    if (n6 == 1) {
                        n2 = 1;
                    }
                    if (n6 == 2) {
                        n2 = 2;
                    }
                    ((ModelStandardTransform)((ModelSource)object2).getTransform()).setTransform(n2);
                    ((ModelStandardTransform)((ModelSource)object2).getTransform()).setPolarity(n5 == 1);
                    ((ModelStandardTransform)((ModelSource)object2).getTransform()).setDirection(n4 == 1);
                }
                if (object3 != null) {
                    n2 = 0;
                    if (n9 == 3) {
                        n2 = 3;
                    }
                    if (n9 == 1) {
                        n2 = 1;
                    }
                    if (n9 == 2) {
                        n2 = 2;
                    }
                    ((ModelStandardTransform)((ModelSource)object3).getTransform()).setTransform(n2);
                    ((ModelStandardTransform)((ModelSource)object3).getTransform()).setPolarity(n8 == 1);
                    ((ModelStandardTransform)((ModelSource)object3).getTransform()).setDirection(n7 == 1);
                }
            }
            modelConnectionBlock.setScale(d);
            return modelConnectionBlock;
        }
        return null;
    }

    @Override
    public ModelPerformer[] getPerformers() {
        ArrayList<ModelPerformer> arrayList = new ArrayList<ModelPerformer>();
        HashMap<String, DLSModulator> hashMap = new HashMap<String, DLSModulator>();
        for (DLSModulator object : this.getModulators()) {
            hashMap.put(object.getSource() + "x" + object.getControl() + "=" + object.getDestination(), object);
        }
        HashMap hashMap2 = new HashMap();
        for (DLSRegion dLSRegion : this.regions) {
            Object object;
            Object object22;
            ModelPerformer modelPerformer = new ModelPerformer();
            modelPerformer.setName(dLSRegion.getSample().getName());
            modelPerformer.setSelfNonExclusive((dLSRegion.getFusoptions() & 1) != 0);
            modelPerformer.setExclusiveClass(dLSRegion.getExclusiveClass());
            modelPerformer.setKeyFrom(dLSRegion.getKeyfrom());
            modelPerformer.setKeyTo(dLSRegion.getKeyto());
            modelPerformer.setVelFrom(dLSRegion.getVelfrom());
            modelPerformer.setVelTo(dLSRegion.getVelto());
            hashMap2.clear();
            hashMap2.putAll(hashMap);
            for (DLSModulator dLSModulator : dLSRegion.getModulators()) {
                hashMap2.put(dLSModulator.getSource() + "x" + dLSModulator.getControl() + "=" + dLSModulator.getDestination(), dLSModulator);
            }
            List<ModelConnectionBlock> list = modelPerformer.getConnectionBlocks();
            for (Object object22 : hashMap2.values()) {
                object = this.convertToModel((DLSModulator)object22);
                if (object == null) continue;
                list.add((ModelConnectionBlock)object);
            }
            DLSSample dLSSample = dLSRegion.getSample();
            object22 = dLSRegion.getSampleoptions();
            if (object22 == null) {
                object22 = dLSSample.getSampleoptions();
            }
            object = dLSSample.getDataBuffer();
            float f = -((DLSSampleOptions)object22).unitynote * 100 + ((DLSSampleOptions)object22).finetune;
            ModelByteBufferWavetable modelByteBufferWavetable = new ModelByteBufferWavetable((ModelByteBuffer)object, dLSSample.getFormat(), f);
            modelByteBufferWavetable.setAttenuation(modelByteBufferWavetable.getAttenuation() / 65536.0f);
            if (((DLSSampleOptions)object22).getLoops().size() != 0) {
                DLSSampleLoop dLSSampleLoop = ((DLSSampleOptions)object22).getLoops().get(0);
                modelByteBufferWavetable.setLoopStart((int)dLSSampleLoop.getStart());
                modelByteBufferWavetable.setLoopLength((int)dLSSampleLoop.getLength());
                if (dLSSampleLoop.getType() == 0L) {
                    modelByteBufferWavetable.setLoopType(1);
                }
                if (dLSSampleLoop.getType() == 1L) {
                    modelByteBufferWavetable.setLoopType(2);
                } else {
                    modelByteBufferWavetable.setLoopType(1);
                }
            }
            modelPerformer.getConnectionBlocks().add(new ModelConnectionBlock(1.0, new ModelDestination(new ModelIdentifier("filter", "type", 1))));
            modelPerformer.getOscillators().add(modelByteBufferWavetable);
            arrayList.add(modelPerformer);
        }
        return arrayList.toArray(new ModelPerformer[arrayList.size()]);
    }

    public byte[] getGuid() {
        return this.guid == null ? null : Arrays.copyOf(this.guid, this.guid.length);
    }

    public void setGuid(byte[] byArray) {
        this.guid = byArray == null ? null : Arrays.copyOf(byArray, byArray.length);
    }
}

