/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.chart;

import com.sun.javafx.charts.Legend;
import com.sun.javafx.css.StyleConverter;
import com.sun.javafx.css.StyleManager;
import com.sun.javafx.css.StyleableDoubleProperty;
import com.sun.javafx.css.StyleableProperty;
import com.sun.javafx.css.converters.SizeConverter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.animation.Animation;
import javafx.animation.FadeTransition;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.ParallelTransition;
import javafx.animation.Timeline;
import javafx.beans.property.DoubleProperty;
import javafx.beans.value.WritableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.chart.Axis;
import javafx.scene.chart.CategoryAxis;
import javafx.scene.chart.ValueAxis;
import javafx.scene.chart.XYChart;
import javafx.scene.layout.StackPane;
import javafx.util.Duration;

public class BarChart<X, Y>
extends XYChart<X, Y> {
    private Map<XYChart.Series, Map<String, XYChart.Data<X, Y>>> seriesCategoryMap = new HashMap<XYChart.Series, Map<String, XYChart.Data<X, Y>>>();
    private Legend legend = new Legend();
    private boolean seriesRemove = false;
    private final Orientation orientation;
    private CategoryAxis categoryAxis;
    private ValueAxis valueAxis;
    private Timeline dataRemoveTimeline;
    private XYChart.Data<X, Y> dataItemBeingRemoved = null;
    private XYChart.Series<X, Y> seriesOfDataRemoved = null;
    private double bottomPos = 0.0;
    private DoubleProperty barGap = new StyleableDoubleProperty(4.0){

        @Override
        protected void invalidated() {
            this.get();
            BarChart.this.requestChartLayout();
        }

        @Override
        public Object getBean() {
            return BarChart.this;
        }

        @Override
        public String getName() {
            return "barGap";
        }

        @Override
        public StyleableProperty getStyleableProperty() {
            return StyleableProperties.BAR_GAP;
        }
    };
    private DoubleProperty categoryGap = new StyleableDoubleProperty(10.0){

        @Override
        protected void invalidated() {
            this.get();
            BarChart.this.requestChartLayout();
        }

        @Override
        public Object getBean() {
            return BarChart.this;
        }

        @Override
        public String getName() {
            return "categoryGap";
        }

        @Override
        public StyleableProperty getStyleableProperty() {
            return StyleableProperties.CATEGORY_GAP;
        }
    };
    private static final String PSEUDO_CLASS_VERTICAL = "vertical";
    private static final String PSEUDO_CLASS_HORIZONTAL = "horizontal";
    private static final long VERTICAL_PSEUDOCLASS_STATE = StyleManager.getInstance().getPseudoclassMask("vertical");
    private static final long HORIZONTAL_PSEUDOCLASS_STATE = StyleManager.getInstance().getPseudoclassMask("horizontal");

    public final double getBarGap() {
        return this.barGap.getValue();
    }

    public final void setBarGap(double d) {
        this.barGap.setValue(d);
    }

    public final DoubleProperty barGapProperty() {
        return this.barGap;
    }

    public final double getCategoryGap() {
        return this.categoryGap.getValue();
    }

    public final void setCategoryGap(double d) {
        this.categoryGap.setValue(d);
    }

    public final DoubleProperty categoryGapProperty() {
        return this.categoryGap;
    }

    public BarChart(Axis<X> axis, Axis<Y> axis2) {
        this(axis, axis2, FXCollections.observableArrayList());
    }

    public BarChart(Axis<X> axis, Axis<Y> axis2, ObservableList<XYChart.Series<X, Y>> observableList) {
        super(axis, axis2);
        this.getStyleClass().add("bar-chart");
        this.setLegend(this.legend);
        if (!(axis instanceof ValueAxis && axis2 instanceof CategoryAxis || axis2 instanceof ValueAxis && axis instanceof CategoryAxis)) {
            throw new IllegalArgumentException("Axis type incorrect, one of X,Y should be CategoryAxis and the other NumberAxis");
        }
        if (axis instanceof CategoryAxis) {
            this.categoryAxis = (CategoryAxis)axis;
            this.valueAxis = (ValueAxis)axis2;
            this.orientation = Orientation.VERTICAL;
        } else {
            this.categoryAxis = (CategoryAxis)axis2;
            this.valueAxis = (ValueAxis)axis;
            this.orientation = Orientation.HORIZONTAL;
        }
        this.impl_pseudoClassStateChanged(PSEUDO_CLASS_HORIZONTAL);
        this.impl_pseudoClassStateChanged(PSEUDO_CLASS_VERTICAL);
        this.setData(observableList);
    }

    public BarChart(Axis<X> axis, Axis<Y> axis2, ObservableList<XYChart.Series<X, Y>> observableList, double d) {
        this(axis, axis2);
        this.setData(observableList);
        this.setCategoryGap(d);
    }

    @Override
    protected void dataItemAdded(XYChart.Series<X, Y> series, int n, XYChart.Data<X, Y> data) {
        String string = this.orientation == Orientation.VERTICAL ? (String)data.getXValue() : (String)data.getYValue();
        Map<String, XYChart.Data<X, Y>> map = this.seriesCategoryMap.get(series);
        if (map == null) {
            map = new HashMap<String, XYChart.Data<X, Y>>();
            this.seriesCategoryMap.put(series, map);
        }
        map.put(string, data);
        Node node = this.createBar(series, this.getData().indexOf(series), data, n);
        if (this.shouldAnimate()) {
            if (this.dataRemoveTimeline != null && this.dataRemoveTimeline.getStatus().equals((Object)Animation.Status.RUNNING) && this.dataItemBeingRemoved != null && this.dataItemBeingRemoved == data) {
                this.dataRemoveTimeline.stop();
                this.getPlotChildren().remove(node);
                this.removeDataItemFromDisplay(this.seriesOfDataRemoved, data);
                this.dataItemBeingRemoved = null;
                this.seriesOfDataRemoved = null;
            }
            this.animateDataAdd(data, node);
        } else {
            this.getPlotChildren().add(node);
        }
    }

    @Override
    protected void dataItemRemoved(final XYChart.Data<X, Y> data, final XYChart.Series<X, Y> series) {
        final Node node = data.getNode();
        if (this.shouldAnimate()) {
            this.dataRemoveTimeline = this.createDataRemoveTimeline(data, node, series);
            this.dataItemBeingRemoved = data;
            this.seriesOfDataRemoved = series;
            this.dataRemoveTimeline.setOnFinished(new EventHandler<ActionEvent>(){

                @Override
                public void handle(ActionEvent actionEvent) {
                    BarChart.this.getPlotChildren().remove(node);
                    BarChart.this.removeDataItemFromDisplay(series, data);
                    BarChart.this.dataItemBeingRemoved = null;
                }
            });
            this.dataRemoveTimeline.play();
        } else {
            this.getPlotChildren().remove(node);
            this.removeDataItemFromDisplay(series, data);
        }
    }

    @Override
    protected void dataItemChanged(XYChart.Data<X, Y> data) {
        double d;
        double d2;
        if (this.orientation == Orientation.VERTICAL) {
            d2 = ((Number)data.getYValue()).doubleValue();
            d = ((Number)data.getCurrentY()).doubleValue();
        } else {
            d2 = ((Number)data.getXValue()).doubleValue();
            d = ((Number)data.getCurrentX()).doubleValue();
        }
        if (d > 0.0 && d2 < 0.0) {
            data.getNode().getStyleClass().add("negative");
        } else if (d < 0.0 && d2 > 0.0) {
            data.getNode().getStyleClass().remove("negative");
        }
    }

    private void animateDataAdd(XYChart.Data<X, Y> data, Node node) {
        if (this.orientation == Orientation.VERTICAL) {
            double d = ((Number)data.getYValue()).doubleValue();
            if (d < 0.0) {
                node.getStyleClass().add("negative");
            }
            data.setYValue(this.getYAxis().toRealValue(this.bottomPos));
            data.setCurrentY(this.getYAxis().toRealValue(this.bottomPos));
            this.getPlotChildren().add(node);
            data.setYValue(this.getYAxis().toRealValue(d));
            this.animate(new KeyFrame(Duration.ZERO, new KeyValue(data.currentYProperty(), data.getCurrentY())), new KeyFrame(Duration.millis(700.0), new KeyValue(data.currentYProperty(), data.getYValue(), Interpolator.EASE_BOTH)));
        } else {
            double d = ((Number)data.getXValue()).doubleValue();
            if (d < 0.0) {
                node.getStyleClass().add("negative");
            }
            data.setXValue(this.getXAxis().toRealValue(this.getXAxis().getZeroPosition()));
            data.setCurrentX(this.getXAxis().toRealValue(this.getXAxis().getZeroPosition()));
            this.getPlotChildren().add(node);
            data.setXValue(this.getXAxis().toRealValue(d));
            this.animate(new KeyFrame(Duration.ZERO, new KeyValue(data.currentXProperty(), data.getCurrentX())), new KeyFrame(Duration.millis(700.0), new KeyValue(data.currentXProperty(), data.getXValue(), Interpolator.EASE_BOTH)));
        }
    }

    @Override
    protected void seriesAdded(XYChart.Series<X, Y> series, int n) {
        HashMap<String, XYChart.Data> hashMap = new HashMap<String, XYChart.Data>();
        for (int i = 0; i < series.getData().size(); ++i) {
            double d;
            XYChart.Data data = (XYChart.Data)series.getData().get(i);
            Node node = this.createBar(series, n, data, i);
            String string = this.orientation == Orientation.VERTICAL ? (String)data.getXValue() : (String)data.getYValue();
            hashMap.put(string, data);
            if (this.shouldAnimate()) {
                this.animateDataAdd(data, node);
                continue;
            }
            double d2 = d = this.orientation == Orientation.VERTICAL ? ((Number)data.getYValue()).doubleValue() : ((Number)data.getXValue()).doubleValue();
            if (d < 0.0) {
                node.getStyleClass().add("negative");
            }
            this.getPlotChildren().add(node);
        }
        if (hashMap.size() > 0) {
            this.seriesCategoryMap.put(series, hashMap);
        }
    }

    private Timeline createDataRemoveTimeline(XYChart.Data<X, Y> data, final Node node, XYChart.Series<X, Y> series) {
        Timeline timeline = new Timeline();
        if (this.orientation == Orientation.VERTICAL) {
            data.setYValue(this.getYAxis().toRealValue(this.bottomPos));
            timeline.getKeyFrames().addAll((KeyFrame[])new KeyFrame[]{new KeyFrame(Duration.ZERO, new KeyValue(data.currentYProperty(), data.getCurrentY())), new KeyFrame(Duration.millis(700.0), new EventHandler<ActionEvent>(){

                @Override
                public void handle(ActionEvent actionEvent) {
                    BarChart.this.getPlotChildren().remove(node);
                }
            }, new KeyValue(data.currentYProperty(), data.getYValue(), Interpolator.EASE_BOTH))});
        } else {
            data.setXValue(this.getXAxis().toRealValue(this.getXAxis().getZeroPosition()));
            timeline.getKeyFrames().addAll((KeyFrame[])new KeyFrame[]{new KeyFrame(Duration.ZERO, new KeyValue(data.currentXProperty(), data.getCurrentX())), new KeyFrame(Duration.millis(700.0), new EventHandler<ActionEvent>(){

                @Override
                public void handle(ActionEvent actionEvent) {
                    BarChart.this.getPlotChildren().remove(node);
                }
            }, new KeyValue(data.currentXProperty(), data.getXValue(), Interpolator.EASE_BOTH))});
        }
        return timeline;
    }

    @Override
    protected void seriesRemoved(final XYChart.Series<X, Y> series) {
        if (this.shouldAnimate()) {
            ParallelTransition parallelTransition = new ParallelTransition();
            parallelTransition.setOnFinished(new EventHandler<ActionEvent>(){

                @Override
                public void handle(ActionEvent actionEvent) {
                    BarChart.this.removeSeriesFromDisplay(series);
                }
            });
            for (XYChart.Data data : series.getData()) {
                final Node node = data.getNode();
                this.seriesRemove = true;
                if (this.getSeriesSize() > 1) {
                    for (int i = 0; i < series.getData().size(); ++i) {
                        XYChart.Data data2 = (XYChart.Data)series.getData().get(i);
                        Timeline timeline = this.createDataRemoveTimeline(data2, node, series);
                        parallelTransition.getChildren().add(timeline);
                    }
                    continue;
                }
                FadeTransition fadeTransition = new FadeTransition(Duration.millis(700.0), node);
                fadeTransition.setFromValue(1.0);
                fadeTransition.setToValue(0.0);
                fadeTransition.setOnFinished(new EventHandler<ActionEvent>(){

                    @Override
                    public void handle(ActionEvent actionEvent) {
                        BarChart.this.getPlotChildren().remove(node);
                    }
                });
                parallelTransition.getChildren().add(fadeTransition);
            }
            parallelTransition.play();
        } else {
            for (XYChart.Data data : series.getData()) {
                Node node = data.getNode();
                this.getPlotChildren().remove(node);
            }
            this.removeSeriesFromDisplay(series);
        }
    }

    @Override
    protected void layoutPlotChildren() {
        double d = this.categoryAxis.getCategorySpacing();
        double d2 = d - (this.getCategoryGap() + this.getBarGap());
        double d3 = d2 / (double)this.getSeriesSize() - this.getBarGap();
        double d4 = -((d - this.getCategoryGap()) / 2.0);
        double d5 = this.valueAxis.getZeroPosition();
        int n = 0;
        for (String string : this.categoryAxis.getCategories()) {
            int n2 = 0;
            XYChart.Series series = this.begin;
            while (series != null) {
                XYChart.Data<X, Y> data = this.getDataItem(series, n2, n, string);
                if (data != null) {
                    double d6;
                    double d7;
                    Node node = data.getNode();
                    if (this.orientation == Orientation.VERTICAL) {
                        d7 = this.getXAxis().getDisplayPosition(data.getCurrentX());
                        d6 = this.getYAxis().getDisplayPosition(data.getCurrentY());
                    } else {
                        d7 = this.getYAxis().getDisplayPosition(data.getCurrentY());
                        d6 = this.getXAxis().getDisplayPosition(data.getCurrentX());
                    }
                    double d8 = Math.min(d6, d5);
                    double d9 = Math.max(d6, d5);
                    this.bottomPos = d8;
                    if (this.orientation == Orientation.VERTICAL) {
                        node.resizeRelocate(d7 + d4 + (d3 + this.getBarGap()) * (double)n2, d8, d3, d9 - d8);
                    } else {
                        node.resizeRelocate(d8, d7 + d4 + (d3 + this.getBarGap()) * (double)n2, d9 - d8, d3);
                    }
                    ++n2;
                }
                series = series.next;
            }
            ++n;
        }
    }

    @Override
    protected void updateLegend() {
        this.legend.getItems().clear();
        if (this.getData() != null) {
            for (int i = 0; i < this.getData().size(); ++i) {
                XYChart.Series series = (XYChart.Series)this.getData().get(i);
                Legend.LegendItem legendItem = new Legend.LegendItem(series.getName());
                legendItem.getSymbol().getStyleClass().addAll((String[])new String[]{"chart-bar", "series" + i, "bar-legend-symbol", series.defaultColorStyleClass});
                this.legend.getItems().add(legendItem);
            }
        }
        if (this.legend.getItems().size() > 0) {
            if (this.getLegend() == null) {
                this.setLegend(this.legend);
            }
        } else {
            this.setLegend(null);
        }
    }

    private Node createBar(XYChart.Series series, int n, XYChart.Data data, int n2) {
        Node node = data.getNode();
        if (node == null) {
            node = new StackPane();
            data.setNode(node);
        }
        node.getStyleClass().setAll((String[])new String[]{"chart-bar", "series" + n, "data" + n2, series.defaultColorStyleClass});
        return node;
    }

    private XYChart.Data<X, Y> getDataItem(XYChart.Series<X, Y> series, int n, int n2, String string) {
        Map<String, XYChart.Data<X, Y>> map = this.seriesCategoryMap.get(series);
        return map.get(string);
    }

    @Deprecated
    public static List<StyleableProperty> impl_CSS_STYLEABLES() {
        return StyleableProperties.STYLEABLES;
    }

    @Override
    @Deprecated
    public List<StyleableProperty> impl_getStyleableProperties() {
        return BarChart.impl_CSS_STYLEABLES();
    }

    @Override
    @Deprecated
    public long impl_getPseudoClassState() {
        long l = super.impl_getPseudoClassState();
        return l |= this.orientation == Orientation.VERTICAL ? VERTICAL_PSEUDOCLASS_STATE : HORIZONTAL_PSEUDOCLASS_STATE;
    }

    private static class StyleableProperties {
        private static final StyleableProperty<BarChart, Number> BAR_GAP = new StyleableProperty<BarChart, Number>("-fx-bar-gap", (StyleConverter)SizeConverter.getInstance(), (Number)4.0){

            @Override
            public boolean isSettable(BarChart barChart) {
                return barChart.barGap == null || !barChart.barGap.isBound();
            }

            @Override
            public WritableValue<Number> getWritableValue(BarChart barChart) {
                return barChart.barGapProperty();
            }
        };
        private static final StyleableProperty<BarChart, Number> CATEGORY_GAP = new StyleableProperty<BarChart, Number>("-fx-category-gap", (StyleConverter)SizeConverter.getInstance(), (Number)10.0){

            @Override
            public boolean isSettable(BarChart barChart) {
                return barChart.categoryGap == null || !barChart.categoryGap.isBound();
            }

            @Override
            public WritableValue<Number> getWritableValue(BarChart barChart) {
                return barChart.categoryGapProperty();
            }
        };
        private static final List<StyleableProperty> STYLEABLES;

        private StyleableProperties() {
        }

        static {
            ArrayList<StyleableProperty> arrayList = new ArrayList<StyleableProperty>(XYChart.impl_CSS_STYLEABLES());
            Collections.addAll(arrayList, BAR_GAP, CATEGORY_GAP);
            STYLEABLES = Collections.unmodifiableList(arrayList);
        }
    }
}

