/*
 * Decompiled with CFR 0.152.
 */
package sun.invoke.util;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Array;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import sun.invoke.util.VerifyType;
import sun.invoke.util.Wrapper;

public class ValueConversions {
    private static final Class<?> THIS_CLASS = ValueConversions.class;
    private static final int MAX_ARITY;
    private static final MethodHandles.Lookup IMPL_LOOKUP;
    private static final EnumMap<Wrapper, MethodHandle>[] UNBOX_CONVERSIONS;
    private static final Integer ZERO_INT;
    private static final Integer ONE_INT;
    private static final EnumMap<Wrapper, MethodHandle>[] BOX_CONVERSIONS;
    private static final EnumMap<Wrapper, MethodHandle>[] REBOX_CONVERSIONS;
    private static final EnumMap<Wrapper, MethodHandle>[] CONSTANT_FUNCTIONS;
    private static final MethodHandle IDENTITY;
    private static final MethodHandle IDENTITY_I;
    private static final MethodHandle IDENTITY_J;
    private static final MethodHandle CAST_REFERENCE;
    private static final MethodHandle ALWAYS_NULL;
    private static final MethodHandle ALWAYS_ZERO;
    private static final MethodHandle ZERO_OBJECT;
    private static final MethodHandle IGNORE;
    private static final MethodHandle EMPTY;
    private static final MethodHandle NEW_ARRAY;
    private static final EnumMap<Wrapper, MethodHandle>[] WRAPPER_CASTS;
    private static final EnumMap<Wrapper, MethodHandle>[] CONVERT_FLOAT_FUNCTIONS;
    private static final Object[] NO_ARGS_ARRAY;
    private static final MethodHandle[] ARRAYS;
    private static final MethodHandle[] FILL_ARRAYS;
    private static final MethodHandle[] FILLERS;
    private static final ClassValue<MethodHandle[]> TYPED_COLLECTORS;
    private static final List<Object> NO_ARGS_LIST;
    private static final MethodHandle[] LISTS;

    private static EnumMap<Wrapper, MethodHandle>[] newWrapperCaches(int n) {
        EnumMap[] enumMapArray = new EnumMap[n];
        for (int i = 0; i < n; ++i) {
            enumMapArray[i] = new EnumMap(Wrapper.class);
        }
        return enumMapArray;
    }

    static int unboxInteger(Object object, boolean bl) {
        if (object instanceof Integer) {
            return (Integer)object;
        }
        return ValueConversions.primitiveConversion(Wrapper.INT, object, bl).intValue();
    }

    static byte unboxByte(Object object, boolean bl) {
        if (object instanceof Byte) {
            return (Byte)object;
        }
        return ValueConversions.primitiveConversion(Wrapper.BYTE, object, bl).byteValue();
    }

    static short unboxShort(Object object, boolean bl) {
        if (object instanceof Short) {
            return (Short)object;
        }
        return ValueConversions.primitiveConversion(Wrapper.SHORT, object, bl).shortValue();
    }

    static boolean unboxBoolean(Object object, boolean bl) {
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        return (ValueConversions.primitiveConversion(Wrapper.BOOLEAN, object, bl).intValue() & 1) != 0;
    }

    static char unboxCharacter(Object object, boolean bl) {
        if (object instanceof Character) {
            return ((Character)object).charValue();
        }
        return (char)ValueConversions.primitiveConversion(Wrapper.CHAR, object, bl).intValue();
    }

    static long unboxLong(Object object, boolean bl) {
        if (object instanceof Long) {
            return (Long)object;
        }
        return ValueConversions.primitiveConversion(Wrapper.LONG, object, bl).longValue();
    }

    static float unboxFloat(Object object, boolean bl) {
        if (object instanceof Float) {
            return ((Float)object).floatValue();
        }
        return ValueConversions.primitiveConversion(Wrapper.FLOAT, object, bl).floatValue();
    }

    static double unboxDouble(Object object, boolean bl) {
        if (object instanceof Double) {
            return (Double)object;
        }
        return ValueConversions.primitiveConversion(Wrapper.DOUBLE, object, bl).doubleValue();
    }

    static int unboxByteRaw(Object object, boolean bl) {
        return ValueConversions.unboxByte(object, bl);
    }

    static int unboxShortRaw(Object object, boolean bl) {
        return ValueConversions.unboxShort(object, bl);
    }

    static int unboxBooleanRaw(Object object, boolean bl) {
        return ValueConversions.unboxBoolean(object, bl) ? 1 : 0;
    }

    static int unboxCharacterRaw(Object object, boolean bl) {
        return ValueConversions.unboxCharacter(object, bl);
    }

    static int unboxFloatRaw(Object object, boolean bl) {
        return Float.floatToIntBits(ValueConversions.unboxFloat(object, bl));
    }

    static long unboxDoubleRaw(Object object, boolean bl) {
        return Double.doubleToRawLongBits(ValueConversions.unboxDouble(object, bl));
    }

    private static MethodType unboxType(Wrapper wrapper, boolean bl) {
        return MethodType.methodType(ValueConversions.rawWrapper(wrapper, bl).primitiveType(), Object.class, Boolean.TYPE);
    }

    private static MethodHandle unbox(Wrapper wrapper, boolean bl, boolean bl2) {
        EnumMap<Wrapper, MethodHandle> enumMap = UNBOX_CONVERSIONS[(bl2 ? 1 : 0) + (bl ? 2 : 0)];
        MethodHandle methodHandle = enumMap.get((Object)wrapper);
        if (methodHandle != null) {
            return methodHandle;
        }
        switch (wrapper) {
            case OBJECT: {
                methodHandle = IDENTITY;
                break;
            }
            case VOID: {
                methodHandle = bl ? ALWAYS_ZERO : IGNORE;
                break;
            }
            case INT: 
            case LONG: {
                if (!bl) break;
                methodHandle = ValueConversions.unbox(wrapper, false, bl2);
            }
        }
        if (methodHandle != null) {
            enumMap.put(wrapper, methodHandle);
            return methodHandle;
        }
        String string = "unbox" + wrapper.simpleName() + (bl ? "Raw" : "");
        MethodType methodType = ValueConversions.unboxType(wrapper, bl);
        try {
            methodHandle = IMPL_LOOKUP.findStatic(THIS_CLASS, string, methodType);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            methodHandle = null;
        }
        if (methodHandle != null) {
            methodHandle = MethodHandles.insertArguments(methodHandle, 1, bl2);
            enumMap.put(wrapper, methodHandle);
            return methodHandle;
        }
        throw new IllegalArgumentException("cannot find unbox adapter for " + (Object)((Object)wrapper) + (bl2 ? " (cast)" : "") + (bl ? " (raw)" : ""));
    }

    public static MethodHandle unboxCast(Wrapper wrapper) {
        return ValueConversions.unbox(wrapper, false, true);
    }

    public static MethodHandle unboxRaw(Wrapper wrapper) {
        return ValueConversions.unbox(wrapper, true, false);
    }

    public static MethodHandle unbox(Class<?> clazz) {
        return ValueConversions.unbox(Wrapper.forPrimitiveType(clazz), false, false);
    }

    public static MethodHandle unboxCast(Class<?> clazz) {
        return ValueConversions.unbox(Wrapper.forPrimitiveType(clazz), false, true);
    }

    public static MethodHandle unboxRaw(Class<?> clazz) {
        return ValueConversions.unbox(Wrapper.forPrimitiveType(clazz), true, false);
    }

    public static Number primitiveConversion(Wrapper wrapper, Object object, boolean bl) {
        Number number = null;
        if (object == null) {
            if (!bl) {
                return null;
            }
            return ZERO_INT;
        }
        number = object instanceof Number ? (Number)((Number)object) : (Number)(object instanceof Boolean ? (Number)((Boolean)object != false ? ONE_INT : ZERO_INT) : (Number)(object instanceof Character ? (Number)Integer.valueOf(((Character)object).charValue()) : (Number)((Number)object)));
        Wrapper wrapper2 = Wrapper.findWrapperType(object.getClass());
        if (wrapper2 == null || !bl && !wrapper.isConvertibleFrom(wrapper2)) {
            return (Number)wrapper.wrapperType().cast(object);
        }
        return number;
    }

    static Integer boxInteger(int n) {
        return n;
    }

    static Byte boxByte(byte by) {
        return by;
    }

    static Short boxShort(short s) {
        return s;
    }

    static Boolean boxBoolean(boolean bl) {
        return bl;
    }

    static Character boxCharacter(char c) {
        return Character.valueOf(c);
    }

    static Long boxLong(long l) {
        return l;
    }

    static Float boxFloat(float f) {
        return Float.valueOf(f);
    }

    static Double boxDouble(double d) {
        return d;
    }

    static Byte boxByteRaw(int n) {
        return ValueConversions.boxByte((byte)n);
    }

    static Short boxShortRaw(int n) {
        return ValueConversions.boxShort((short)n);
    }

    static Boolean boxBooleanRaw(int n) {
        return ValueConversions.boxBoolean(n != 0);
    }

    static Character boxCharacterRaw(int n) {
        return ValueConversions.boxCharacter((char)n);
    }

    static Float boxFloatRaw(int n) {
        return ValueConversions.boxFloat(Float.intBitsToFloat(n));
    }

    static Double boxDoubleRaw(long l) {
        return ValueConversions.boxDouble(Double.longBitsToDouble(l));
    }

    static Void boxVoidRaw(int n) {
        return null;
    }

    private static MethodType boxType(Wrapper wrapper, boolean bl) {
        Class<?> clazz = wrapper.wrapperType();
        return MethodType.methodType(clazz, ValueConversions.rawWrapper(wrapper, bl).primitiveType());
    }

    private static Wrapper rawWrapper(Wrapper wrapper, boolean bl) {
        if (bl) {
            return wrapper.isDoubleWord() ? Wrapper.LONG : Wrapper.INT;
        }
        return wrapper;
    }

    private static MethodHandle box(Wrapper wrapper, boolean bl, boolean bl2) {
        EnumMap<Wrapper, MethodHandle> enumMap = BOX_CONVERSIONS[(bl ? 1 : 0) + (bl2 ? 2 : 0)];
        MethodHandle methodHandle = enumMap.get((Object)wrapper);
        if (methodHandle != null) {
            return methodHandle;
        }
        switch (wrapper) {
            case OBJECT: {
                methodHandle = IDENTITY;
                break;
            }
            case VOID: {
                if (bl2) break;
                methodHandle = ZERO_OBJECT;
                break;
            }
            case INT: 
            case LONG: {
                if (!bl2) break;
                methodHandle = ValueConversions.box(wrapper, bl, false);
            }
        }
        if (methodHandle != null) {
            enumMap.put(wrapper, methodHandle);
            return methodHandle;
        }
        String string = "box" + wrapper.simpleName() + (bl2 ? "Raw" : "");
        MethodType methodType = ValueConversions.boxType(wrapper, bl2);
        if (bl) {
            try {
                methodHandle = IMPL_LOOKUP.findStatic(THIS_CLASS, string, methodType);
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                methodHandle = null;
            }
        } else {
            methodHandle = ValueConversions.box(wrapper, !bl, bl2).asType(methodType.erase());
        }
        if (methodHandle != null) {
            enumMap.put(wrapper, methodHandle);
            return methodHandle;
        }
        throw new IllegalArgumentException("cannot find box adapter for " + (Object)((Object)wrapper) + (bl ? " (exact)" : "") + (bl2 ? " (raw)" : ""));
    }

    public static MethodHandle box(Class<?> clazz) {
        boolean bl = false;
        return ValueConversions.box(Wrapper.forPrimitiveType(clazz), bl, false);
    }

    public static MethodHandle boxRaw(Class<?> clazz) {
        boolean bl = false;
        return ValueConversions.box(Wrapper.forPrimitiveType(clazz), bl, true);
    }

    public static MethodHandle box(Wrapper wrapper) {
        boolean bl = false;
        return ValueConversions.box(wrapper, bl, false);
    }

    public static MethodHandle boxRaw(Wrapper wrapper) {
        boolean bl = false;
        return ValueConversions.box(wrapper, bl, true);
    }

    static int unboxRawInteger(Object object) {
        if (object instanceof Integer) {
            return (Integer)object;
        }
        return (int)ValueConversions.unboxLong(object, false);
    }

    static Integer reboxRawInteger(Object object) {
        if (object instanceof Integer) {
            return (Integer)object;
        }
        return (int)ValueConversions.unboxLong(object, false);
    }

    static Byte reboxRawByte(Object object) {
        if (object instanceof Byte) {
            return (Byte)object;
        }
        return ValueConversions.boxByteRaw(ValueConversions.unboxRawInteger(object));
    }

    static Short reboxRawShort(Object object) {
        if (object instanceof Short) {
            return (Short)object;
        }
        return ValueConversions.boxShortRaw(ValueConversions.unboxRawInteger(object));
    }

    static Boolean reboxRawBoolean(Object object) {
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        return ValueConversions.boxBooleanRaw(ValueConversions.unboxRawInteger(object));
    }

    static Character reboxRawCharacter(Object object) {
        if (object instanceof Character) {
            return (Character)object;
        }
        return ValueConversions.boxCharacterRaw(ValueConversions.unboxRawInteger(object));
    }

    static Float reboxRawFloat(Object object) {
        if (object instanceof Float) {
            return (Float)object;
        }
        return ValueConversions.boxFloatRaw(ValueConversions.unboxRawInteger(object));
    }

    static Long reboxRawLong(Object object) {
        return (Long)object;
    }

    static Double reboxRawDouble(Object object) {
        if (object instanceof Double) {
            return (Double)object;
        }
        return ValueConversions.boxDoubleRaw(ValueConversions.unboxLong(object, true));
    }

    private static MethodType reboxType(Wrapper wrapper) {
        Class<?> clazz = wrapper.wrapperType();
        return MethodType.methodType(clazz, Object.class);
    }

    public static MethodHandle rebox(Wrapper wrapper) {
        EnumMap<Wrapper, MethodHandle> enumMap = REBOX_CONVERSIONS[0];
        MethodHandle methodHandle = enumMap.get((Object)wrapper);
        if (methodHandle != null) {
            return methodHandle;
        }
        switch (wrapper) {
            case OBJECT: {
                methodHandle = IDENTITY;
                break;
            }
            case VOID: {
                throw new IllegalArgumentException("cannot rebox a void");
            }
        }
        if (methodHandle != null) {
            enumMap.put(wrapper, methodHandle);
            return methodHandle;
        }
        String string = "reboxRaw" + wrapper.simpleName();
        MethodType methodType = ValueConversions.reboxType(wrapper);
        try {
            methodHandle = IMPL_LOOKUP.findStatic(THIS_CLASS, string, methodType);
            methodHandle = methodHandle.asType(IDENTITY.type());
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            methodHandle = null;
        }
        if (methodHandle != null) {
            enumMap.put(wrapper, methodHandle);
            return methodHandle;
        }
        throw new IllegalArgumentException("cannot find rebox adapter for " + (Object)((Object)wrapper));
    }

    public static MethodHandle rebox(Class<?> clazz) {
        return ValueConversions.rebox(Wrapper.forPrimitiveType(clazz));
    }

    static long widenInt(int n) {
        return n;
    }

    static Long widenBoxedInt(Integer n) {
        return (long)n;
    }

    static int narrowLong(long l) {
        return (int)l;
    }

    static Integer narrowBoxedLong(Long l) {
        return (int)l.longValue();
    }

    static void ignore(Object object) {
    }

    static void empty() {
    }

    static Object zeroObject() {
        return null;
    }

    static int zeroInteger() {
        return 0;
    }

    static long zeroLong() {
        return 0L;
    }

    static float zeroFloat() {
        return 0.0f;
    }

    static double zeroDouble() {
        return 0.0;
    }

    public static MethodHandle zeroConstantFunction(Wrapper wrapper) {
        EnumMap<Wrapper, MethodHandle> enumMap = CONSTANT_FUNCTIONS[0];
        MethodHandle methodHandle = enumMap.get((Object)wrapper);
        if (methodHandle != null) {
            return methodHandle;
        }
        MethodType methodType = MethodType.methodType(wrapper.primitiveType());
        switch (wrapper) {
            case VOID: {
                methodHandle = EMPTY;
                break;
            }
            case OBJECT: 
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: {
                try {
                    methodHandle = IMPL_LOOKUP.findStatic(THIS_CLASS, "zero" + wrapper.simpleName(), methodType);
                    break;
                }
                catch (ReflectiveOperationException reflectiveOperationException) {
                    methodHandle = null;
                }
            }
        }
        if (methodHandle != null) {
            enumMap.put(wrapper, methodHandle);
            return methodHandle;
        }
        Wrapper wrapper2 = wrapper.rawPrimitive();
        if (methodHandle == null && wrapper2 != wrapper) {
            methodHandle = MethodHandles.explicitCastArguments(ValueConversions.zeroConstantFunction(wrapper2), methodType);
        }
        if (methodHandle != null) {
            enumMap.put(wrapper, methodHandle);
            return methodHandle;
        }
        throw new IllegalArgumentException("cannot find zero constant for " + (Object)((Object)wrapper));
    }

    static Object alwaysNull(Object object) {
        return null;
    }

    static int alwaysZero(Object object) {
        return 0;
    }

    static <T> T identity(T t) {
        return t;
    }

    static int identity(int n) {
        return n;
    }

    static byte identity(byte by) {
        return by;
    }

    static short identity(short s) {
        return s;
    }

    static boolean identity(boolean bl) {
        return bl;
    }

    static char identity(char c) {
        return c;
    }

    static long identity(long l) {
        return l;
    }

    static float identity(float f) {
        return f;
    }

    static double identity(double d) {
        return d;
    }

    static <T, U> T castReference(Class<? extends T> clazz, U u) {
        return clazz.cast(u);
    }

    public static MethodHandle cast(Class<?> clazz) {
        boolean bl = false;
        if (clazz.isPrimitive()) {
            throw new IllegalArgumentException("cannot cast primitive type " + clazz);
        }
        MethodHandle methodHandle = null;
        Wrapper wrapper = null;
        EnumMap<Wrapper, MethodHandle> enumMap = null;
        if (Wrapper.isWrapperType(clazz) && (methodHandle = (enumMap = WRAPPER_CASTS[bl ? 1 : 0]).get((Object)(wrapper = Wrapper.forWrapperType(clazz)))) != null) {
            return methodHandle;
        }
        methodHandle = VerifyType.isNullReferenceConversion(Object.class, clazz) ? IDENTITY : (VerifyType.isNullType(clazz) ? ALWAYS_NULL : MethodHandles.insertArguments(CAST_REFERENCE, 0, clazz));
        if (bl) {
            MethodType methodType = MethodType.methodType(clazz, Object.class);
            methodHandle = MethodHandles.explicitCastArguments(methodHandle, methodType);
        }
        if (enumMap != null) {
            enumMap.put(wrapper, methodHandle);
        }
        return methodHandle;
    }

    public static MethodHandle identity() {
        return IDENTITY;
    }

    public static MethodHandle identity(Class<?> clazz) {
        return MethodHandles.identity(clazz);
    }

    public static MethodHandle identity(Wrapper wrapper) {
        EnumMap<Wrapper, MethodHandle> enumMap = CONSTANT_FUNCTIONS[1];
        MethodHandle methodHandle = enumMap.get((Object)wrapper);
        if (methodHandle != null) {
            return methodHandle;
        }
        MethodType methodType = MethodType.methodType(wrapper.primitiveType());
        if (wrapper != Wrapper.VOID) {
            methodType = methodType.appendParameterTypes(wrapper.primitiveType());
        }
        try {
            methodHandle = IMPL_LOOKUP.findStatic(THIS_CLASS, "identity", methodType);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            methodHandle = null;
        }
        if (methodHandle == null && wrapper == Wrapper.VOID) {
            methodHandle = EMPTY;
        }
        if (methodHandle != null) {
            enumMap.put(wrapper, methodHandle);
            return methodHandle;
        }
        if (methodHandle != null) {
            enumMap.put(wrapper, methodHandle);
            return methodHandle;
        }
        throw new IllegalArgumentException("cannot find identity for " + (Object)((Object)wrapper));
    }

    static float doubleToFloat(double d) {
        return (float)d;
    }

    static double floatToDouble(float f) {
        return f;
    }

    static long doubleToLong(double d) {
        return (long)d;
    }

    static int doubleToInt(double d) {
        return (int)d;
    }

    static short doubleToShort(double d) {
        return (short)d;
    }

    static char doubleToChar(double d) {
        return (char)d;
    }

    static byte doubleToByte(double d) {
        return (byte)d;
    }

    static boolean doubleToBoolean(double d) {
        return ValueConversions.toBoolean((byte)d);
    }

    static long floatToLong(float f) {
        return (long)f;
    }

    static int floatToInt(float f) {
        return (int)f;
    }

    static short floatToShort(float f) {
        return (short)f;
    }

    static char floatToChar(float f) {
        return (char)f;
    }

    static byte floatToByte(float f) {
        return (byte)f;
    }

    static boolean floatToBoolean(float f) {
        return ValueConversions.toBoolean((byte)f);
    }

    static double longToDouble(long l) {
        return l;
    }

    static double intToDouble(int n) {
        return n;
    }

    static double shortToDouble(short s) {
        return s;
    }

    static double charToDouble(char c) {
        return c;
    }

    static double byteToDouble(byte by) {
        return by;
    }

    static double booleanToDouble(boolean bl) {
        return ValueConversions.fromBoolean(bl);
    }

    static float longToFloat(long l) {
        return l;
    }

    static float intToFloat(int n) {
        return n;
    }

    static float shortToFloat(short s) {
        return s;
    }

    static float charToFloat(char c) {
        return c;
    }

    static float byteToFloat(byte by) {
        return by;
    }

    static float booleanToFloat(boolean bl) {
        return ValueConversions.fromBoolean(bl);
    }

    static boolean toBoolean(byte by) {
        return (by & 1) != 0;
    }

    static byte fromBoolean(boolean bl) {
        return bl ? (byte)1 : 0;
    }

    static MethodHandle convertFloatFunction(Wrapper wrapper, boolean bl, boolean bl2) {
        Class<Number> clazz;
        EnumMap<Wrapper, MethodHandle> enumMap = CONVERT_FLOAT_FUNCTIONS[(bl ? 1 : 0) + (bl2 ? 2 : 0)];
        MethodHandle methodHandle = enumMap.get((Object)wrapper);
        if (methodHandle != null) {
            return methodHandle;
        }
        Wrapper wrapper2 = bl2 ? Wrapper.DOUBLE : Wrapper.FLOAT;
        Class<?> clazz2 = wrapper.primitiveType();
        Class<Number> clazz3 = bl2 ? Double.TYPE : Float.TYPE;
        Class<Object> clazz4 = bl ? clazz2 : clazz3;
        Class<Number> clazz5 = clazz = bl ? clazz3 : clazz2;
        if (clazz4 == clazz) {
            return ValueConversions.identity(wrapper);
        }
        MethodType methodType = MethodType.methodType(clazz, clazz4);
        switch (wrapper) {
            case VOID: {
                methodHandle = bl ? ValueConversions.zeroConstantFunction(wrapper2) : MethodHandles.dropArguments(EMPTY, 0, clazz3);
                break;
            }
            case OBJECT: {
                methodHandle = bl ? ValueConversions.unbox(clazz3) : ValueConversions.box(clazz3);
                break;
            }
            default: {
                try {
                    methodHandle = IMPL_LOOKUP.findStatic(THIS_CLASS, clazz4.getSimpleName() + "To" + ValueConversions.capitalize(clazz.getSimpleName()), methodType);
                    break;
                }
                catch (ReflectiveOperationException reflectiveOperationException) {
                    methodHandle = null;
                }
            }
        }
        if (methodHandle != null) {
            assert (methodHandle.type() == methodType) : methodHandle;
            enumMap.put(wrapper, methodHandle);
            return methodHandle;
        }
        throw new IllegalArgumentException("cannot find float conversion constant for " + clazz4.getSimpleName() + " -> " + clazz.getSimpleName());
    }

    public static MethodHandle convertFromFloat(Class<?> clazz) {
        Wrapper wrapper = Wrapper.forPrimitiveType(clazz);
        return ValueConversions.convertFloatFunction(wrapper, false, false);
    }

    public static MethodHandle convertFromDouble(Class<?> clazz) {
        Wrapper wrapper = Wrapper.forPrimitiveType(clazz);
        return ValueConversions.convertFloatFunction(wrapper, false, true);
    }

    public static MethodHandle convertToFloat(Class<?> clazz) {
        Wrapper wrapper = Wrapper.forPrimitiveType(clazz);
        return ValueConversions.convertFloatFunction(wrapper, true, false);
    }

    public static MethodHandle convertToDouble(Class<?> clazz) {
        Wrapper wrapper = Wrapper.forPrimitiveType(clazz);
        return ValueConversions.convertFloatFunction(wrapper, true, true);
    }

    private static String capitalize(String string) {
        return Character.toUpperCase(string.charAt(0)) + string.substring(1);
    }

    public static Object convertArrayElements(Class<?> clazz, Object object) {
        Wrapper wrapper;
        Class<?> clazz2 = object.getClass().getComponentType();
        Class<?> clazz3 = clazz.getComponentType();
        if (clazz2 == null || clazz3 == null) {
            throw new IllegalArgumentException("not array type");
        }
        Wrapper wrapper2 = clazz2.isPrimitive() ? Wrapper.forPrimitiveType(clazz2) : null;
        Wrapper wrapper3 = wrapper = clazz3.isPrimitive() ? Wrapper.forPrimitiveType(clazz3) : null;
        if (wrapper2 == null) {
            Object[] objectArray = (Object[])object;
            int n = objectArray.length;
            if (wrapper == null) {
                return Arrays.copyOf(objectArray, n, clazz.asSubclass(Object[].class));
            }
            Object object2 = wrapper.makeArray(n);
            wrapper.copyArrayUnboxing(objectArray, 0, object2, 0, n);
            return object2;
        }
        int n = Array.getLength(object);
        Object[] objectArray = wrapper == null ? Arrays.copyOf(NO_ARGS_ARRAY, n, clazz.asSubclass(Object[].class)) : new Object[n];
        wrapper2.copyArrayBoxing(object, 0, objectArray, 0, n);
        if (wrapper == null) {
            return objectArray;
        }
        Object object3 = wrapper.makeArray(n);
        wrapper.copyArrayUnboxing(objectArray, 0, object3, 0, n);
        return object3;
    }

    private static MethodHandle findCollector(String string, int n, Class<?> clazz, Class<?> ... classArray) {
        MethodType methodType = MethodType.genericMethodType(n).changeReturnType(clazz).insertParameterTypes(0, classArray);
        try {
            return IMPL_LOOKUP.findStatic(THIS_CLASS, string, methodType);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            return null;
        }
    }

    private static Object[] makeArray(Object ... objectArray) {
        return objectArray;
    }

    private static Object[] array() {
        return NO_ARGS_ARRAY;
    }

    private static Object[] array(Object object) {
        return ValueConversions.makeArray(object);
    }

    private static Object[] array(Object object, Object object2) {
        return ValueConversions.makeArray(object, object2);
    }

    private static Object[] array(Object object, Object object2, Object object3) {
        return ValueConversions.makeArray(object, object2, object3);
    }

    private static Object[] array(Object object, Object object2, Object object3, Object object4) {
        return ValueConversions.makeArray(object, object2, object3, object4);
    }

    private static Object[] array(Object object, Object object2, Object object3, Object object4, Object object5) {
        return ValueConversions.makeArray(object, object2, object3, object4, object5);
    }

    private static Object[] array(Object object, Object object2, Object object3, Object object4, Object object5, Object object6) {
        return ValueConversions.makeArray(object, object2, object3, object4, object5, object6);
    }

    private static Object[] array(Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7) {
        return ValueConversions.makeArray(object, object2, object3, object4, object5, object6, object7);
    }

    private static Object[] array(Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8) {
        return ValueConversions.makeArray(object, object2, object3, object4, object5, object6, object7, object8);
    }

    private static Object[] array(Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8, Object object9) {
        return ValueConversions.makeArray(object, object2, object3, object4, object5, object6, object7, object8, object9);
    }

    private static Object[] array(Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8, Object object9, Object object10) {
        return ValueConversions.makeArray(object, object2, object3, object4, object5, object6, object7, object8, object9, object10);
    }

    private static MethodHandle[] makeArrays() {
        MethodHandle methodHandle;
        ArrayList<MethodHandle> arrayList = new ArrayList<MethodHandle>();
        while ((methodHandle = ValueConversions.findCollector("array", arrayList.size(), Object[].class, new Class[0])) != null) {
            arrayList.add(methodHandle);
        }
        assert (arrayList.size() == 11);
        return arrayList.toArray(new MethodHandle[MAX_ARITY + 1]);
    }

    private static Object[] newArray(int n) {
        return new Object[n];
    }

    private static void fillWithArguments(Object[] objectArray, int n, Object ... objectArray2) {
        System.arraycopy(objectArray2, 0, objectArray, n, objectArray2.length);
    }

    private static Object[] fillArray(Object[] objectArray, Integer n, Object object) {
        ValueConversions.fillWithArguments(objectArray, n, object);
        return objectArray;
    }

    private static Object[] fillArray(Object[] objectArray, Integer n, Object object, Object object2) {
        ValueConversions.fillWithArguments(objectArray, n, object, object2);
        return objectArray;
    }

    private static Object[] fillArray(Object[] objectArray, Integer n, Object object, Object object2, Object object3) {
        ValueConversions.fillWithArguments(objectArray, n, object, object2, object3);
        return objectArray;
    }

    private static Object[] fillArray(Object[] objectArray, Integer n, Object object, Object object2, Object object3, Object object4) {
        ValueConversions.fillWithArguments(objectArray, n, object, object2, object3, object4);
        return objectArray;
    }

    private static Object[] fillArray(Object[] objectArray, Integer n, Object object, Object object2, Object object3, Object object4, Object object5) {
        ValueConversions.fillWithArguments(objectArray, n, object, object2, object3, object4, object5);
        return objectArray;
    }

    private static Object[] fillArray(Object[] objectArray, Integer n, Object object, Object object2, Object object3, Object object4, Object object5, Object object6) {
        ValueConversions.fillWithArguments(objectArray, n, object, object2, object3, object4, object5, object6);
        return objectArray;
    }

    private static Object[] fillArray(Object[] objectArray, Integer n, Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7) {
        ValueConversions.fillWithArguments(objectArray, n, object, object2, object3, object4, object5, object6, object7);
        return objectArray;
    }

    private static Object[] fillArray(Object[] objectArray, Integer n, Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8) {
        ValueConversions.fillWithArguments(objectArray, n, object, object2, object3, object4, object5, object6, object7, object8);
        return objectArray;
    }

    private static Object[] fillArray(Object[] objectArray, Integer n, Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8, Object object9) {
        ValueConversions.fillWithArguments(objectArray, n, object, object2, object3, object4, object5, object6, object7, object8, object9);
        return objectArray;
    }

    private static Object[] fillArray(Object[] objectArray, Integer n, Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8, Object object9, Object object10) {
        ValueConversions.fillWithArguments(objectArray, n, object, object2, object3, object4, object5, object6, object7, object8, object9, object10);
        return objectArray;
    }

    private static MethodHandle[] makeFillArrays() {
        MethodHandle methodHandle;
        ArrayList<MethodHandle> arrayList = new ArrayList<MethodHandle>();
        arrayList.add(null);
        while ((methodHandle = ValueConversions.findCollector("fillArray", arrayList.size(), Object[].class, Object[].class, Integer.class)) != null) {
            arrayList.add(methodHandle);
        }
        assert (arrayList.size() == 11);
        return arrayList.toArray(new MethodHandle[0]);
    }

    private static Object[] copyAsReferenceArray(Class<? extends Object[]> clazz, Object ... objectArray) {
        return Arrays.copyOf(objectArray, objectArray.length, clazz);
    }

    private static Object copyAsPrimitiveArray(Wrapper wrapper, Object ... objectArray) {
        Object object = wrapper.makeArray(objectArray.length);
        wrapper.copyArrayUnboxing(objectArray, 0, object, 0, objectArray.length);
        return object;
    }

    public static MethodHandle varargsArray(int n) {
        MethodHandle methodHandle = ARRAYS[n];
        if (methodHandle != null) {
            return methodHandle;
        }
        methodHandle = ValueConversions.findCollector("array", n, Object[].class, new Class[0]);
        if (methodHandle != null) {
            ValueConversions.ARRAYS[n] = methodHandle;
            return ValueConversions.ARRAYS[n];
        }
        MethodHandle methodHandle2 = ValueConversions.filler(0);
        ValueConversions.ARRAYS[n] = ValueConversions.buildVarargsArray(methodHandle2, n);
        return ValueConversions.ARRAYS[n];
    }

    private static MethodHandle buildVarargsArray(MethodHandle methodHandle, int n) {
        MethodHandle methodHandle2 = ValueConversions.filler(n);
        MethodHandle methodHandle3 = methodHandle;
        methodHandle3 = MethodHandles.dropArguments(methodHandle3, 1, methodHandle2.type().parameterList());
        methodHandle3 = MethodHandles.foldArguments(methodHandle3, methodHandle2);
        methodHandle3 = MethodHandles.foldArguments(methodHandle3, ValueConversions.buildNewArray(n));
        return methodHandle3;
    }

    private static MethodHandle buildNewArray(int n) {
        return MethodHandles.insertArguments(NEW_ARRAY, 0, n);
    }

    private static MethodHandle filler(int n) {
        MethodHandle methodHandle = FILLERS[n];
        if (methodHandle != null) {
            return methodHandle;
        }
        ValueConversions.FILLERS[n] = ValueConversions.buildFiller(n);
        return ValueConversions.FILLERS[n];
    }

    private static MethodHandle buildFiller(int n) {
        if (n == 0) {
            return MethodHandles.identity(Object[].class);
        }
        int n2 = FILL_ARRAYS.length - 1;
        int n3 = n % n2;
        int n4 = n - n3;
        if (n3 == 0 && FILLERS[n4 = n - (n3 = n2)] == null) {
            for (int i = 0; i < n4; i += n2) {
                ValueConversions.filler(i);
            }
        }
        MethodHandle methodHandle = ValueConversions.filler(n4);
        MethodHandle methodHandle2 = FILL_ARRAYS[n3];
        methodHandle2 = MethodHandles.insertArguments(methodHandle2, 1, n4);
        MethodHandle methodHandle3 = ValueConversions.filler(0);
        methodHandle3 = MethodHandles.dropArguments(methodHandle3, 1, methodHandle2.type().parameterList());
        methodHandle3 = MethodHandles.foldArguments(methodHandle3, methodHandle2);
        if (n4 > 0) {
            methodHandle3 = MethodHandles.dropArguments(methodHandle3, 1, methodHandle.type().parameterList());
            methodHandle3 = MethodHandles.foldArguments(methodHandle3, methodHandle);
        }
        return methodHandle3;
    }

    public static MethodHandle varargsArray(Class<?> clazz, int n) {
        MethodHandle methodHandle;
        Class<?> clazz2 = clazz.getComponentType();
        if (clazz2 == null) {
            throw new IllegalArgumentException("not an array: " + clazz);
        }
        if (clazz2 == Object.class) {
            return ValueConversions.varargsArray(n);
        }
        MethodHandle[] methodHandleArray = TYPED_COLLECTORS.get(clazz2);
        MethodHandle methodHandle2 = methodHandle = n < methodHandleArray.length ? methodHandleArray[n] : null;
        if (methodHandle != null) {
            return methodHandle;
        }
        MethodHandle methodHandle3 = ValueConversions.buildArrayProducer(clazz);
        methodHandle = ValueConversions.buildVarargsArray(methodHandle3, n);
        methodHandleArray[n] = methodHandle = methodHandle.asType(MethodType.methodType(clazz, Collections.nCopies(n, clazz2)));
        return methodHandle;
    }

    private static MethodHandle buildArrayProducer(Class<?> clazz) {
        Class<?> clazz2 = clazz.getComponentType();
        if (clazz2.isPrimitive()) {
            return LazyStatics.COPY_AS_PRIMITIVE_ARRAY.bindTo((Object)Wrapper.forPrimitiveType(clazz2));
        }
        return LazyStatics.COPY_AS_REFERENCE_ARRAY.bindTo(clazz);
    }

    private static List<Object> makeList(Object ... objectArray) {
        return Arrays.asList(objectArray);
    }

    private static List<Object> list() {
        return NO_ARGS_LIST;
    }

    private static List<Object> list(Object object) {
        return ValueConversions.makeList(object);
    }

    private static List<Object> list(Object object, Object object2) {
        return ValueConversions.makeList(object, object2);
    }

    private static List<Object> list(Object object, Object object2, Object object3) {
        return ValueConversions.makeList(object, object2, object3);
    }

    private static List<Object> list(Object object, Object object2, Object object3, Object object4) {
        return ValueConversions.makeList(object, object2, object3, object4);
    }

    private static List<Object> list(Object object, Object object2, Object object3, Object object4, Object object5) {
        return ValueConversions.makeList(object, object2, object3, object4, object5);
    }

    private static List<Object> list(Object object, Object object2, Object object3, Object object4, Object object5, Object object6) {
        return ValueConversions.makeList(object, object2, object3, object4, object5, object6);
    }

    private static List<Object> list(Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7) {
        return ValueConversions.makeList(object, object2, object3, object4, object5, object6, object7);
    }

    private static List<Object> list(Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8) {
        return ValueConversions.makeList(object, object2, object3, object4, object5, object6, object7, object8);
    }

    private static List<Object> list(Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8, Object object9) {
        return ValueConversions.makeList(object, object2, object3, object4, object5, object6, object7, object8, object9);
    }

    private static List<Object> list(Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8, Object object9, Object object10) {
        return ValueConversions.makeList(object, object2, object3, object4, object5, object6, object7, object8, object9, object10);
    }

    private static MethodHandle[] makeLists() {
        MethodHandle methodHandle;
        ArrayList<MethodHandle> arrayList = new ArrayList<MethodHandle>();
        while ((methodHandle = ValueConversions.findCollector("list", arrayList.size(), List.class, new Class[0])) != null) {
            arrayList.add(methodHandle);
        }
        assert (arrayList.size() == 11);
        return arrayList.toArray(new MethodHandle[MAX_ARITY + 1]);
    }

    public static MethodHandle varargsList(int n) {
        MethodHandle methodHandle = LISTS[n];
        if (methodHandle != null) {
            return methodHandle;
        }
        methodHandle = ValueConversions.findCollector("list", n, List.class, new Class[0]);
        if (methodHandle != null) {
            ValueConversions.LISTS[n] = methodHandle;
            return ValueConversions.LISTS[n];
        }
        ValueConversions.LISTS[n] = ValueConversions.buildVarargsList(n);
        return ValueConversions.LISTS[n];
    }

    private static MethodHandle buildVarargsList(int n) {
        return MethodHandles.filterReturnValue(ValueConversions.varargsArray(n), LazyStatics.MAKE_LIST);
    }

    static {
        Object object = new Object[]{255};
        AccessController.doPrivileged(new PrivilegedAction<Void>((Object[])object){
            final /* synthetic */ Object[] val$values;
            {
                this.val$values = objectArray;
            }

            @Override
            public Void run() {
                this.val$values[0] = Integer.getInteger(THIS_CLASS.getName() + ".MAX_ARITY", 255);
                return null;
            }
        });
        MAX_ARITY = (Integer)object[0];
        IMPL_LOOKUP = MethodHandles.lookup();
        UNBOX_CONVERSIONS = ValueConversions.newWrapperCaches(4);
        ZERO_INT = 0;
        ONE_INT = 1;
        BOX_CONVERSIONS = ValueConversions.newWrapperCaches(4);
        REBOX_CONVERSIONS = ValueConversions.newWrapperCaches(1);
        CONSTANT_FUNCTIONS = ValueConversions.newWrapperCaches(2);
        try {
            object = MethodType.genericMethodType(1);
            MethodType methodType = ((MethodType)object).insertParameterTypes(0, Class.class);
            MethodType methodType2 = ((MethodType)object).changeReturnType(Integer.TYPE);
            MethodType methodType3 = ((MethodType)object).changeReturnType(Void.TYPE);
            MethodType methodType4 = MethodType.genericMethodType(0);
            IDENTITY = IMPL_LOOKUP.findStatic(THIS_CLASS, "identity", (MethodType)object);
            IDENTITY_I = IMPL_LOOKUP.findStatic(THIS_CLASS, "identity", MethodType.methodType(Integer.TYPE, Integer.TYPE));
            IDENTITY_J = IMPL_LOOKUP.findStatic(THIS_CLASS, "identity", MethodType.methodType(Long.TYPE, Long.TYPE));
            CAST_REFERENCE = IMPL_LOOKUP.findStatic(THIS_CLASS, "castReference", methodType);
            ALWAYS_NULL = IMPL_LOOKUP.findStatic(THIS_CLASS, "alwaysNull", (MethodType)object);
            ALWAYS_ZERO = IMPL_LOOKUP.findStatic(THIS_CLASS, "alwaysZero", methodType2);
            ZERO_OBJECT = IMPL_LOOKUP.findStatic(THIS_CLASS, "zeroObject", methodType4);
            IGNORE = IMPL_LOOKUP.findStatic(THIS_CLASS, "ignore", methodType3);
            EMPTY = IMPL_LOOKUP.findStatic(THIS_CLASS, "empty", methodType3.dropParameterTypes(0, 1));
            NEW_ARRAY = IMPL_LOOKUP.findStatic(THIS_CLASS, "newArray", MethodType.methodType(Object[].class, Integer.TYPE));
        }
        catch (IllegalAccessException | NoSuchMethodException reflectiveOperationException) {
            InternalError internalError = new InternalError("uncaught exception");
            internalError.initCause(reflectiveOperationException);
            throw internalError;
        }
        WRAPPER_CASTS = ValueConversions.newWrapperCaches(2);
        CONVERT_FLOAT_FUNCTIONS = ValueConversions.newWrapperCaches(4);
        NO_ARGS_ARRAY = new Object[0];
        ARRAYS = ValueConversions.makeArrays();
        FILL_ARRAYS = ValueConversions.makeFillArrays();
        FILLERS = new MethodHandle[MAX_ARITY + 1];
        TYPED_COLLECTORS = new ClassValue<MethodHandle[]>(){

            @Override
            protected MethodHandle[] computeValue(Class<?> clazz) {
                return new MethodHandle[256];
            }
        };
        NO_ARGS_LIST = Arrays.asList(NO_ARGS_ARRAY);
        LISTS = ValueConversions.makeLists();
    }

    static class LazyStatics {
        private static final MethodHandle COPY_AS_REFERENCE_ARRAY;
        private static final MethodHandle COPY_AS_PRIMITIVE_ARRAY;
        private static final MethodHandle MAKE_LIST;

        LazyStatics() {
        }

        static {
            try {
                COPY_AS_REFERENCE_ARRAY = IMPL_LOOKUP.findStatic(THIS_CLASS, "copyAsReferenceArray", MethodType.methodType(Object[].class, Class.class, Object[].class));
                COPY_AS_PRIMITIVE_ARRAY = IMPL_LOOKUP.findStatic(THIS_CLASS, "copyAsPrimitiveArray", MethodType.methodType(Object.class, Wrapper.class, Object[].class));
                MAKE_LIST = IMPL_LOOKUP.findStatic(THIS_CLASS, "makeList", MethodType.methodType(List.class, Object[].class));
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                InternalError internalError = new InternalError("uncaught exception");
                internalError.initCause(reflectiveOperationException);
                throw internalError;
            }
        }
    }
}

