/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scenario.effect;

import com.sun.javafx.geom.BaseBounds;
import com.sun.javafx.geom.RectBounds;
import com.sun.javafx.geom.Rectangle;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.scenario.effect.CoreEffect;
import com.sun.scenario.effect.Effect;
import com.sun.scenario.effect.FilterContext;
import com.sun.scenario.effect.ImageData;
import com.sun.scenario.effect.impl.Renderer;
import com.sun.scenario.effect.impl.state.BoxBlurState;

public class BoxBlur
extends CoreEffect {
    private final BoxBlurState state = new BoxBlurState();

    public BoxBlur() {
        this(1, 1);
    }

    public BoxBlur(int n, int n2) {
        this(n, n2, 1, DefaultInput);
    }

    public BoxBlur(int n, int n2, int n3) {
        this(n, n2, n3, DefaultInput);
    }

    public BoxBlur(int n, int n2, int n3, Effect effect) {
        super(effect);
        this.setHorizontalSize(n);
        this.setVerticalSize(n2);
        this.setPasses(n3);
    }

    @Override
    Object getState() {
        return this.state;
    }

    public final Effect getInput() {
        return this.getInputs().get(0);
    }

    public void setInput(Effect effect) {
        this.setInput(0, effect);
    }

    public int getHorizontalSize() {
        return this.state.getHsize();
    }

    public void setHorizontalSize(int n) {
        int n2 = this.state.getHsize();
        this.state.setHsize(n);
        this.firePropertyChange("hsize", n2, n);
    }

    public int getVerticalSize() {
        return this.state.getVsize();
    }

    public void setVerticalSize(int n) {
        int n2 = this.state.getVsize();
        this.state.setVsize(n);
        this.firePropertyChange("vsize", n2, n);
    }

    public int getPasses() {
        return this.state.getBlurPasses();
    }

    public void setPasses(int n) {
        int n2 = this.state.getBlurPasses();
        this.state.setBlurPasses(n);
        this.firePropertyChange("passes", n2, n);
    }

    @Override
    public Effect.AccelType getAccelType(FilterContext filterContext) {
        return Renderer.getRenderer(filterContext).getAccelType();
    }

    @Override
    public BaseBounds getBounds(BaseTransform baseTransform, Effect effect) {
        BaseBounds baseBounds = super.getBounds(null, effect);
        int n = this.state.getKernelSize(0) / 2;
        int n2 = this.state.getKernelSize(1) / 2;
        RectBounds rectBounds = new RectBounds(baseBounds.getMinX(), baseBounds.getMinY(), baseBounds.getMaxX(), baseBounds.getMaxY());
        rectBounds.grow(n, n2);
        return BoxBlur.transformBounds(baseTransform, rectBounds);
    }

    @Override
    public Rectangle getResultBounds(BaseTransform baseTransform, Rectangle rectangle, ImageData ... imageDataArray) {
        Rectangle rectangle2 = imageDataArray[0].getTransformedBounds(null);
        rectangle2 = this.state.getResultBounds(rectangle2, 0);
        rectangle2 = this.state.getResultBounds(rectangle2, 1);
        rectangle2.intersectWith(rectangle);
        return rectangle2;
    }

    @Override
    public ImageData filterImageDatas(FilterContext filterContext, BaseTransform baseTransform, Rectangle rectangle, ImageData ... imageDataArray) {
        return this.state.filterImageDatas(this, filterContext, baseTransform, rectangle, imageDataArray);
    }

    @Override
    public boolean operatesInUserSpace() {
        return true;
    }

    @Override
    protected Rectangle getInputClip(int n, BaseTransform baseTransform, Rectangle rectangle) {
        int n2;
        int n3;
        if (rectangle != null && ((n3 = this.state.getKernelSize(0) / 2) | (n2 = this.state.getKernelSize(1) / 2)) != 0) {
            rectangle = new Rectangle(rectangle);
            rectangle.grow(n3, n2);
        }
        return rectangle;
    }
}

