/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.behavior;

import com.sun.javafx.scene.control.behavior.KeyBinding;
import java.util.StringTokenizer;
import javafx.scene.input.KeyCode;

public class TextBinding {
    private String MNEMONIC_SYMBOL = "_";
    private String text = null;
    private KeyCode mnemonic = KeyCode.UNDEFINED;
    private int mnemonicIndex = -1;
    private String extendedMnemonicText = null;
    private KeyBinding accelerator = null;
    private String acceleratorText = null;
    private boolean ctrl = false;
    private boolean shift = false;
    private boolean alt = false;
    private boolean meta = false;

    public String getText() {
        return this.text;
    }

    public KeyCode getMnemonic() {
        return this.mnemonic;
    }

    public int getMnemonicIndex() {
        return this.mnemonicIndex;
    }

    public String getExtendedMnemonicText() {
        return this.extendedMnemonicText;
    }

    public KeyBinding getAccelerator() {
        return this.accelerator;
    }

    public String getAcceleratorText() {
        return this.acceleratorText;
    }

    public boolean getCtrl() {
        return this.ctrl;
    }

    public boolean getShift() {
        return this.shift;
    }

    public boolean getAlt() {
        return this.shift;
    }

    public boolean getMeta() {
        return this.shift;
    }

    public TextBinding(String string) {
        this.parseAndSplit(string);
    }

    private void parseAndSplit(String string) {
        if (string == null || string.length() == 0) {
            this.text = string;
            return;
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        int n = stringBuffer.indexOf("@");
        while (n >= 0 && n < stringBuffer.length() - 1) {
            if (stringBuffer.charAt(n + 1) == '@') {
                stringBuffer.delete(n, n + 1);
            } else {
                this.acceleratorText = stringBuffer.substring(n + 1);
                this.accelerator = this.parseAcceleratorText(this.acceleratorText);
                if (this.accelerator != null) {
                    stringBuffer.delete(n, stringBuffer.length());
                    break;
                }
                this.acceleratorText = null;
            }
            n = stringBuffer.indexOf("@", n + 1);
        }
        n = stringBuffer.indexOf(this.MNEMONIC_SYMBOL);
        while (n >= 0 && n < stringBuffer.length() - 1) {
            if (this.MNEMONIC_SYMBOL.equals(Character.valueOf(stringBuffer.charAt(n + 1)))) {
                stringBuffer.delete(n, n + 1);
            } else {
                if (stringBuffer.charAt(n + 1) != '(' || n == stringBuffer.length() - 2) {
                    String string2 = stringBuffer.substring(n + 1, n + 2);
                    this.mnemonic = KeyCode.getKeyCode(string2.toUpperCase());
                    if (this.mnemonic != null) {
                        this.mnemonicIndex = n;
                    }
                    stringBuffer.delete(n, n + 1);
                    break;
                }
                int n2 = stringBuffer.indexOf(")", n + 3);
                if (n2 == -1) {
                    String string3 = stringBuffer.substring(n + 1, n + 2);
                    this.mnemonic = KeyCode.getKeyCode(string3.toUpperCase());
                    if (this.mnemonic != null) {
                        this.mnemonicIndex = n;
                    }
                    stringBuffer.delete(n, n + 1);
                    break;
                }
                if (n2 == n + 3) {
                    String string4 = stringBuffer.substring(n + 2, n + 3);
                    this.mnemonic = KeyCode.getKeyCode(string4.toUpperCase());
                    this.extendedMnemonicText = stringBuffer.substring(n + 1, n + 4);
                    stringBuffer.delete(n, n2 + 3);
                    break;
                }
            }
            n = stringBuffer.indexOf(this.MNEMONIC_SYMBOL, n + 1);
        }
        this.text = stringBuffer.toString();
    }

    private KeyBinding parseAcceleratorText(String string) {
        Object object;
        KeyBinding keyBinding = null;
        String string2 = null;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "+");
        block6: while (!bl5 && stringTokenizer.hasMoreTokens()) {
            object = stringTokenizer.nextToken();
            if (!stringTokenizer.hasMoreTokens()) {
                string2 = object;
                continue;
            }
            KeyCode keyCode = KeyCode.getKeyCode(((String)object).toUpperCase());
            if (keyCode != null) {
                switch (keyCode) {
                    case CONTROL: {
                        bl = true;
                        continue block6;
                    }
                    case ALT: {
                        bl2 = true;
                        continue block6;
                    }
                    case SHIFT: {
                        bl3 = true;
                        continue block6;
                    }
                    case META: {
                        bl4 = true;
                        continue block6;
                    }
                }
                string2 = null;
                bl5 = true;
                continue;
            }
            string2 = null;
            bl5 = true;
        }
        if (string2 != null && (object = KeyCode.getKeyCode(string2.toUpperCase())) != null && object != KeyCode.UNDEFINED) {
            keyBinding = new KeyBinding((KeyCode)((Object)object), null);
            if (bl) {
                this.ctrl = true;
                keyBinding.ctrl();
            }
            if (bl2) {
                this.alt = true;
                keyBinding.alt();
            }
            if (bl3) {
                this.shift = true;
                keyBinding.shift();
            }
            if (bl4) {
                this.meta = true;
                keyBinding.meta();
            }
        }
        return keyBinding;
    }

    public String toString() {
        return "TextBinding [text=" + this.getText() + ",mnemonic=" + (Object)((Object)this.getMnemonic()) + ", mnemonicIndex=" + this.getMnemonicIndex() + ", extendedMnemonicText=" + this.getExtendedMnemonicText() + ", accelerator=" + this.getAccelerator() + ", acceleratorText=" + this.getAcceleratorText() + "]";
    }
}

