/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tk.quantum;

import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;

public abstract class AbstractEventLoop {
    private Object curCallableValue;

    public void send(Runnable runnable) {
        RunnableTask runnableTask = new RunnableTask(runnable);
        this.await(runnableTask);
    }

    public <V> V send(Callable<V> callable) {
        CallableTask<V> callableTask = new CallableTask<V>(callable);
        this.await(callableTask);
        return callableTask.getResult();
    }

    protected abstract void schedule(Runnable var1);

    public abstract void start();

    public abstract void stop();

    private void await(Task task) {
        this.schedule(task);
        try {
            task.await();
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException(interruptedException);
        }
    }

    static final class RunnableTask
    extends Task {
        private final Runnable r;

        RunnableTask(Runnable runnable) {
            this.r = runnable;
        }

        @Override
        public void doRun() {
            this.r.run();
        }
    }

    static final class CallableTask<V>
    extends Task {
        private V retValue;
        private final Callable<V> c;
        private Exception e;

        CallableTask(Callable<V> callable) {
            this.c = callable;
        }

        @Override
        public void doRun() {
            try {
                this.retValue = this.c.call();
            }
            catch (Exception exception) {
                this.e = exception;
            }
        }

        V getResult() {
            if (this.e == null) {
                return this.retValue;
            }
            throw new RuntimeException(this.e);
        }
    }

    static abstract class Task
    implements Runnable {
        private final CountDownLatch latch = new CountDownLatch(1);

        Task() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this.doRun();
            }
            finally {
                this.latch.countDown();
            }
        }

        protected abstract void doRun();

        void await() throws InterruptedException {
            this.latch.await();
        }
    }
}

