/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.client.sei;

import com.sun.xml.internal.ws.api.message.Message;
import com.sun.xml.internal.ws.api.message.Packet;
import com.sun.xml.internal.ws.client.RequestContext;
import com.sun.xml.internal.ws.client.ResponseContextReceiver;
import com.sun.xml.internal.ws.client.sei.ResponseBuilder;
import com.sun.xml.internal.ws.client.sei.SEIMethodHandler;
import com.sun.xml.internal.ws.client.sei.SEIStub;
import com.sun.xml.internal.ws.client.sei.ValueGetterFactory;
import com.sun.xml.internal.ws.client.sei.ValueSetterFactory;
import com.sun.xml.internal.ws.encoding.soap.DeserializationException;
import com.sun.xml.internal.ws.fault.SOAPFaultBuilder;
import com.sun.xml.internal.ws.model.JavaMethodImpl;
import javax.xml.bind.JAXBException;
import javax.xml.stream.XMLStreamException;

final class SyncMethodHandler
extends SEIMethodHandler {
    private final ResponseBuilder responseBuilder;

    SyncMethodHandler(SEIStub sEIStub, JavaMethodImpl javaMethodImpl) {
        super(sEIStub, javaMethodImpl);
        this.responseBuilder = this.buildResponseBuilder(javaMethodImpl, ValueSetterFactory.SYNC);
    }

    @Override
    Object invoke(Object object, Object[] objectArray) throws Throwable {
        return this.invoke(object, objectArray, this.owner.requestContext, this.owner);
    }

    Object invoke(Object object, Object[] objectArray, RequestContext requestContext, ResponseContextReceiver responseContextReceiver) throws Throwable {
        Packet packet = new Packet(this.createRequestMessage(objectArray));
        packet.soapAction = this.soapAction;
        packet.expectReply = !this.isOneWay;
        packet.getMessage().assertOneWay(this.isOneWay);
        packet.setWSDLOperation(this.javaMethod.getOperation().getName());
        Packet packet2 = this.owner.doProcess(packet, requestContext, responseContextReceiver);
        Message message = packet2.getMessage();
        if (message == null) {
            return null;
        }
        try {
            if (message.isFault()) {
                SOAPFaultBuilder sOAPFaultBuilder = SOAPFaultBuilder.create(message);
                throw sOAPFaultBuilder.createException(this.checkedExceptions);
            }
            return this.responseBuilder.readResponse(message, objectArray);
        }
        catch (JAXBException jAXBException) {
            throw new DeserializationException("failed.to.read.response", new Object[]{jAXBException});
        }
        catch (XMLStreamException xMLStreamException) {
            throw new DeserializationException("failed.to.read.response", new Object[]{xMLStreamException});
        }
    }

    @Override
    ValueGetterFactory getValueGetterFactory() {
        return ValueGetterFactory.SYNC;
    }
}

