/*
 * Decompiled with CFR 0.152.
 */
package com.mouseviator.utils.internatialization;

import com.mouseviator.utils.internatialization.LanguageFile;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.security.InvalidParameterException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class Translator {
    private static String languageFolder;
    private static String bundleName;
    private static LanguageFile activeLanguageLF;
    private static Properties activeLanguageProps;
    private static Map<String, LanguageFile> languages;
    private static ResourceBundle resourceBundle;

    public static String getLanguageFolder() {
        return languageFolder;
    }

    public static void setLanguageFolder(String languageFolder) throws IOException, NullPointerException {
        Translator.loadLanguages(languageFolder);
        Translator.languageFolder = languageFolder;
    }

    public static String getBundleName() {
        return bundleName;
    }

    public static void setBundleName(String bundleName) {
        if (bundleName != null && !bundleName.isEmpty()) {
            resourceBundle = activeLanguageLF != null ? ResourceBundle.getBundle(bundleName, activeLanguageLF.getLocale()) : ResourceBundle.getBundle(bundleName);
            Translator.bundleName = bundleName;
        }
    }

    public static Map<String, LanguageFile> getLanguages() {
        return languages;
    }

    private static void checkLanguageFolder(String languageFolder) throws IOException, NullPointerException {
        if (languageFolder == null) {
            throw new NullPointerException(ResourceBundle.getBundle("murdock/utils/internatialization/Translation").getString("Translator.checkLanguageFolder.null_exception"));
        }
        File f = new File(languageFolder);
        if (!f.exists() || !f.isDirectory()) {
            throw new IOException(MessageFormat.format(ResourceBundle.getBundle("murdock/utils/internatialization/Translation").getString("Translator.checkLanguageFolder.io_exception"), languageFolder));
        }
    }

    private static void loadLanguages(String languageFolder) throws IOException, NullPointerException {
        Translator.checkLanguageFolder(languageFolder);
        File folder = new File(languageFolder);
        final Pattern pattern = Pattern.compile("^(.*?)(_)([\\w]{2})(_)([\\w]{2})(.properties)$", 2);
        File[] files = folder.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                Matcher matcher = pattern.matcher(pathname.getPath());
                return matcher.matches();
            }
        });
        languages.clear();
        for (File f : files) {
            try {
                LanguageFile lf = new LanguageFile(f.getPath());
                String key = lf.getNameWithLocale();
                languages.put(key, lf);
            }
            catch (IOException | InvalidParameterException ex) {
                Logger.getLogger(Translator.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean setLanguage(String lang_key) {
        boolean bRet = false;
        if (lang_key != null && !lang_key.isEmpty()) {
            LanguageFile lf = languages.get(lang_key);
            if (lf != null) {
                FileInputStream fis = null;
                InputStreamReader reader = null;
                try {
                    Properties props = new Properties();
                    fis = new FileInputStream(lf.getFilePath());
                    reader = new InputStreamReader((InputStream)fis, Charset.forName("UTF-8"));
                    props.load(reader);
                    if (!props.isEmpty()) {
                        activeLanguageProps = props;
                        activeLanguageLF = lf;
                        bRet = true;
                    }
                    System.gc();
                }
                catch (IOException ex) {
                    Logger.getLogger(Translator.class.getName()).log(Level.SEVERE, null, ex);
                }
                finally {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (IOException ex) {
                            Logger.getLogger(Translator.class.getName()).log(Level.SEVERE, null, ex);
                        }
                    }
                    if (fis != null) {
                        try {
                            fis.close();
                        }
                        catch (IOException ex) {
                            Logger.getLogger(Translator.class.getName()).log(Level.SEVERE, null, ex);
                        }
                    }
                }
            }
        } else {
            activeLanguageLF = null;
            activeLanguageProps.clear();
            bRet = true;
        }
        return bRet;
    }

    public static String getString(String key) {
        String value = "";
        if (key != null && !key.isEmpty()) {
            value = !activeLanguageProps.isEmpty() ? (activeLanguageProps.getProperty(key) != null && !activeLanguageProps.getProperty(key).isEmpty() ? activeLanguageProps.getProperty(key) : Translator.getStringFromBundle(key)) : Translator.getStringFromBundle(key);
        }
        return value;
    }

    private static String getStringFromBundle(String key) {
        if (resourceBundle != null) {
            return resourceBundle.getString(key);
        }
        return "";
    }

    static {
        activeLanguageProps = new Properties();
        languages = new HashMap<String, LanguageFile>();
    }
}

