/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.fs;

import java.io.FilePermission;
import java.io.IOException;
import java.net.URI;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.channels.FileChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.AccessDeniedException;
import java.nio.file.AccessMode;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemAlreadyExistsException;
import java.nio.file.LinkOption;
import java.nio.file.LinkPermission;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.ProviderMismatchException;
import java.nio.file.attribute.AclFileAttributeView;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.DosFileAttributeView;
import java.nio.file.attribute.DosFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileAttributeView;
import java.nio.file.attribute.FileOwnerAttributeView;
import java.nio.file.attribute.UserDefinedFileAttributeView;
import java.security.AccessController;
import java.security.Permission;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import sun.misc.Unsafe;
import sun.nio.ch.ThreadPool;
import sun.nio.fs.AbstractFileSystemProvider;
import sun.nio.fs.DynamicFileAttributeView;
import sun.nio.fs.FileOwnerAttributeViewImpl;
import sun.nio.fs.NativeBuffer;
import sun.nio.fs.NativeBuffers;
import sun.nio.fs.Util;
import sun.nio.fs.WindowsAclFileAttributeView;
import sun.nio.fs.WindowsChannelFactory;
import sun.nio.fs.WindowsDirectoryStream;
import sun.nio.fs.WindowsException;
import sun.nio.fs.WindowsFileAttributeViews;
import sun.nio.fs.WindowsFileAttributes;
import sun.nio.fs.WindowsFileCopy;
import sun.nio.fs.WindowsFileStore;
import sun.nio.fs.WindowsFileSystem;
import sun.nio.fs.WindowsLinkSupport;
import sun.nio.fs.WindowsNativeDispatcher;
import sun.nio.fs.WindowsPath;
import sun.nio.fs.WindowsPathType;
import sun.nio.fs.WindowsSecurity;
import sun.nio.fs.WindowsSecurityDescriptor;
import sun.nio.fs.WindowsUriSupport;
import sun.nio.fs.WindowsUserDefinedFileAttributeView;

public class WindowsFileSystemProvider
extends AbstractFileSystemProvider {
    private static final Unsafe unsafe = Unsafe.getUnsafe();
    private static final String USER_DIR = "user.dir";
    private final WindowsFileSystem theFileSystem = new WindowsFileSystem(this, System.getProperty("user.dir"));

    @Override
    public String getScheme() {
        return "file";
    }

    private void checkUri(URI uRI) {
        if (!uRI.getScheme().equalsIgnoreCase(this.getScheme())) {
            throw new IllegalArgumentException("URI does not match this provider");
        }
        if (uRI.getAuthority() != null) {
            throw new IllegalArgumentException("Authority component present");
        }
        if (uRI.getPath() == null) {
            throw new IllegalArgumentException("Path component is undefined");
        }
        if (!uRI.getPath().equals("/")) {
            throw new IllegalArgumentException("Path component should be '/'");
        }
        if (uRI.getQuery() != null) {
            throw new IllegalArgumentException("Query component present");
        }
        if (uRI.getFragment() != null) {
            throw new IllegalArgumentException("Fragment component present");
        }
    }

    @Override
    public FileSystem newFileSystem(URI uRI, Map<String, ?> map) throws IOException {
        this.checkUri(uRI);
        throw new FileSystemAlreadyExistsException();
    }

    @Override
    public final FileSystem getFileSystem(URI uRI) {
        this.checkUri(uRI);
        return this.theFileSystem;
    }

    @Override
    public Path getPath(URI uRI) {
        return WindowsUriSupport.fromUri(this.theFileSystem, uRI);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FileChannel newFileChannel(Path path, Set<? extends OpenOption> set, FileAttribute<?> ... fileAttributeArray) throws IOException {
        if (path == null) {
            throw new NullPointerException();
        }
        if (!(path instanceof WindowsPath)) {
            throw new ProviderMismatchException();
        }
        WindowsPath windowsPath = (WindowsPath)path;
        WindowsSecurityDescriptor windowsSecurityDescriptor = WindowsSecurityDescriptor.fromAttribute(fileAttributeArray);
        try {
            FileChannel fileChannel = WindowsChannelFactory.newFileChannel(windowsPath.getPathForWin32Calls(), windowsPath.getPathForPermissionCheck(), set, windowsSecurityDescriptor.address());
            return fileChannel;
        }
        catch (WindowsException windowsException) {
            windowsException.rethrowAsIOException(windowsPath);
            FileChannel fileChannel = null;
            return fileChannel;
        }
        finally {
            if (windowsSecurityDescriptor != null) {
                windowsSecurityDescriptor.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AsynchronousFileChannel newAsynchronousFileChannel(Path path, Set<? extends OpenOption> set, ExecutorService executorService, FileAttribute<?> ... fileAttributeArray) throws IOException {
        if (path == null) {
            throw new NullPointerException();
        }
        if (!(path instanceof WindowsPath)) {
            throw new ProviderMismatchException();
        }
        WindowsPath windowsPath = (WindowsPath)path;
        ThreadPool threadPool = executorService == null ? null : ThreadPool.wrap(executorService, 0);
        WindowsSecurityDescriptor windowsSecurityDescriptor = WindowsSecurityDescriptor.fromAttribute(fileAttributeArray);
        try {
            AsynchronousFileChannel asynchronousFileChannel = WindowsChannelFactory.newAsynchronousFileChannel(windowsPath.getPathForWin32Calls(), windowsPath.getPathForPermissionCheck(), set, windowsSecurityDescriptor.address(), threadPool);
            return asynchronousFileChannel;
        }
        catch (WindowsException windowsException) {
            windowsException.rethrowAsIOException(windowsPath);
            AsynchronousFileChannel asynchronousFileChannel = null;
            return asynchronousFileChannel;
        }
        finally {
            if (windowsSecurityDescriptor != null) {
                windowsSecurityDescriptor.release();
            }
        }
    }

    @Override
    public <V extends FileAttributeView> V getFileAttributeView(Path path, Class<V> clazz, LinkOption ... linkOptionArray) {
        WindowsPath windowsPath = WindowsPath.toWindowsPath(path);
        if (clazz == null) {
            throw new NullPointerException();
        }
        boolean bl = Util.followLinks(linkOptionArray);
        if (clazz == BasicFileAttributeView.class) {
            return (V)WindowsFileAttributeViews.createBasicView(windowsPath, bl);
        }
        if (clazz == DosFileAttributeView.class) {
            return (V)WindowsFileAttributeViews.createDosView(windowsPath, bl);
        }
        if (clazz == AclFileAttributeView.class) {
            return (V)new WindowsAclFileAttributeView(windowsPath, bl);
        }
        if (clazz == FileOwnerAttributeView.class) {
            return (V)new FileOwnerAttributeViewImpl(new WindowsAclFileAttributeView(windowsPath, bl));
        }
        if (clazz == UserDefinedFileAttributeView.class) {
            return (V)new WindowsUserDefinedFileAttributeView(windowsPath, bl);
        }
        return (V)((FileAttributeView)null);
    }

    @Override
    public <A extends BasicFileAttributes> A readAttributes(Path path, Class<A> clazz, LinkOption ... linkOptionArray) throws IOException {
        Class<BasicFileAttributeView> clazz2;
        if (clazz == BasicFileAttributes.class) {
            clazz2 = BasicFileAttributeView.class;
        } else if (clazz == DosFileAttributes.class) {
            clazz2 = DosFileAttributeView.class;
        } else {
            if (clazz == null) {
                throw new NullPointerException();
            }
            throw new UnsupportedOperationException();
        }
        return (A)this.getFileAttributeView(path, clazz2, linkOptionArray).readAttributes();
    }

    @Override
    public DynamicFileAttributeView getFileAttributeView(Path path, String string, LinkOption ... linkOptionArray) {
        WindowsPath windowsPath = WindowsPath.toWindowsPath(path);
        boolean bl = Util.followLinks(linkOptionArray);
        if (string.equals("basic")) {
            return WindowsFileAttributeViews.createBasicView(windowsPath, bl);
        }
        if (string.equals("dos")) {
            return WindowsFileAttributeViews.createDosView(windowsPath, bl);
        }
        if (string.equals("acl")) {
            return new WindowsAclFileAttributeView(windowsPath, bl);
        }
        if (string.equals("owner")) {
            return new FileOwnerAttributeViewImpl(new WindowsAclFileAttributeView(windowsPath, bl));
        }
        if (string.equals("user")) {
            return new WindowsUserDefinedFileAttributeView(windowsPath, bl);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SeekableByteChannel newByteChannel(Path path, Set<? extends OpenOption> set, FileAttribute<?> ... fileAttributeArray) throws IOException {
        WindowsPath windowsPath = WindowsPath.toWindowsPath(path);
        WindowsSecurityDescriptor windowsSecurityDescriptor = WindowsSecurityDescriptor.fromAttribute(fileAttributeArray);
        try {
            FileChannel fileChannel = WindowsChannelFactory.newFileChannel(windowsPath.getPathForWin32Calls(), windowsPath.getPathForPermissionCheck(), set, windowsSecurityDescriptor.address());
            return fileChannel;
        }
        catch (WindowsException windowsException) {
            windowsException.rethrowAsIOException(windowsPath);
            SeekableByteChannel seekableByteChannel = null;
            return seekableByteChannel;
        }
        finally {
            windowsSecurityDescriptor.release();
        }
    }

    @Override
    boolean implDelete(Path path, boolean bl) throws IOException {
        WindowsPath windowsPath = WindowsPath.toWindowsPath(path);
        windowsPath.checkDelete();
        WindowsFileAttributes windowsFileAttributes = null;
        try {
            windowsFileAttributes = WindowsFileAttributes.get(windowsPath, false);
            if (windowsFileAttributes.isDirectory() || windowsFileAttributes.isDirectoryLink()) {
                WindowsNativeDispatcher.RemoveDirectory(windowsPath.getPathForWin32Calls());
            } else {
                WindowsNativeDispatcher.DeleteFile(windowsPath.getPathForWin32Calls());
            }
            return true;
        }
        catch (WindowsException windowsException) {
            if (!(bl || windowsException.lastError() != 2 && windowsException.lastError() != 3)) {
                return false;
            }
            if (windowsFileAttributes != null && windowsFileAttributes.isDirectory() && (windowsException.lastError() == 145 || windowsException.lastError() == 183)) {
                throw new DirectoryNotEmptyException(windowsPath.getPathForExceptionMessage());
            }
            windowsException.rethrowAsIOException(windowsPath);
            return false;
        }
    }

    @Override
    public void copy(Path path, Path path2, CopyOption ... copyOptionArray) throws IOException {
        WindowsFileCopy.copy(WindowsPath.toWindowsPath(path), WindowsPath.toWindowsPath(path2), copyOptionArray);
    }

    @Override
    public void move(Path path, Path path2, CopyOption ... copyOptionArray) throws IOException {
        WindowsFileCopy.move(WindowsPath.toWindowsPath(path), WindowsPath.toWindowsPath(path2), copyOptionArray);
    }

    private static NativeBuffer getUserInfo(WindowsPath windowsPath) throws IOException {
        try {
            long l = WindowsSecurity.processTokenWithQueryAccess;
            int n = WindowsNativeDispatcher.GetTokenInformation(l, 1, 0L, 0);
            assert (n > 0);
            NativeBuffer nativeBuffer = NativeBuffers.getNativeBuffer(n);
            try {
                int n2 = WindowsNativeDispatcher.GetTokenInformation(l, 1, nativeBuffer.address(), n);
                if (n2 != n) {
                    throw new AssertionError();
                }
                return nativeBuffer;
            }
            catch (WindowsException windowsException) {
                nativeBuffer.release();
                throw windowsException;
            }
        }
        catch (WindowsException windowsException) {
            throw new IOException(windowsException.getMessage());
        }
    }

    /*
     * Exception decompiling
     */
    private static int getEffectiveAccess(WindowsPath var0) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void checkAccess(Path path, AccessMode ... accessModeArray) throws IOException {
        WindowsPath windowsPath = WindowsPath.toWindowsPath(path);
        if (accessModeArray.length == 0) {
            windowsPath.checkRead();
            try {
                WindowsFileAttributes.get(windowsPath, true);
            }
            catch (WindowsException windowsException) {
                windowsException.rethrowAsIOException(windowsPath);
            }
            return;
        }
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        block9: for (AccessMode accessMode : accessModeArray) {
            switch (accessMode) {
                case READ: {
                    bl = true;
                    continue block9;
                }
                case WRITE: {
                    bl2 = true;
                    continue block9;
                }
                case EXECUTE: {
                    bl3 = true;
                    continue block9;
                }
                default: {
                    throw new AssertionError((Object)"Should not get here");
                }
            }
        }
        int n = 0;
        if (bl) {
            windowsPath.checkRead();
            n |= 1;
        }
        if (bl2) {
            windowsPath.checkWrite();
            n |= 2;
        }
        if (bl3) {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                securityManager.checkExec(windowsPath.getPathForPermissionCheck());
            }
            n |= 0x20;
        }
        if ((WindowsFileSystemProvider.getEffectiveAccess(windowsPath) & n) == 0) {
            throw new AccessDeniedException(windowsPath.getPathForExceptionMessage(), null, "Effective permissions does not allow requested access");
        }
        if (bl2) {
            try {
                WindowsFileAttributes windowsFileAttributes = WindowsFileAttributes.get(windowsPath, true);
                if (!windowsFileAttributes.isDirectory() && windowsFileAttributes.isReadOnly()) {
                    throw new AccessDeniedException(windowsPath.getPathForExceptionMessage(), null, "DOS readonly attribute is set");
                }
            }
            catch (WindowsException windowsException) {
                windowsException.rethrowAsIOException(windowsPath);
            }
            if (WindowsFileStore.create(windowsPath).isReadOnly()) {
                throw new AccessDeniedException(windowsPath.getPathForExceptionMessage(), null, "Read-only file system");
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isSameFile(Path path, Path path2) throws IOException {
        WindowsPath windowsPath = WindowsPath.toWindowsPath(path);
        if (windowsPath.equals(path2)) {
            return true;
        }
        if (path2 == null) {
            throw new NullPointerException();
        }
        if (!(path2 instanceof WindowsPath)) {
            return false;
        }
        WindowsPath windowsPath2 = (WindowsPath)path2;
        windowsPath.checkRead();
        windowsPath2.checkRead();
        long l = 0L;
        try {
            l = windowsPath.openForReadAttributeAccess(true);
        }
        catch (WindowsException windowsException) {
            windowsException.rethrowAsIOException(windowsPath);
        }
        try {
            boolean bl;
            WindowsFileAttributes windowsFileAttributes = null;
            try {
                windowsFileAttributes = WindowsFileAttributes.readAttributes(l);
            }
            catch (WindowsException windowsException) {
                windowsException.rethrowAsIOException(windowsPath);
            }
            long l2 = 0L;
            try {
                l2 = windowsPath2.openForReadAttributeAccess(true);
            }
            catch (WindowsException windowsException) {
                windowsException.rethrowAsIOException(windowsPath2);
            }
            try {
                WindowsFileAttributes windowsFileAttributes2 = null;
                try {
                    windowsFileAttributes2 = WindowsFileAttributes.readAttributes(l2);
                }
                catch (WindowsException windowsException) {
                    windowsException.rethrowAsIOException(windowsPath2);
                }
                bl = WindowsFileAttributes.isSameFile(windowsFileAttributes, windowsFileAttributes2);
            }
            catch (Throwable throwable) {
                WindowsNativeDispatcher.CloseHandle(l2);
                throw throwable;
            }
            WindowsNativeDispatcher.CloseHandle(l2);
            return bl;
        }
        finally {
            WindowsNativeDispatcher.CloseHandle(l);
        }
    }

    @Override
    public boolean isHidden(Path path) throws IOException {
        WindowsPath windowsPath = WindowsPath.toWindowsPath(path);
        windowsPath.checkRead();
        WindowsFileAttributes windowsFileAttributes = null;
        try {
            windowsFileAttributes = WindowsFileAttributes.get(windowsPath, true);
        }
        catch (WindowsException windowsException) {
            windowsException.rethrowAsIOException(windowsPath);
        }
        if (windowsFileAttributes.isDirectory()) {
            return false;
        }
        return windowsFileAttributes.isHidden();
    }

    @Override
    public FileStore getFileStore(Path path) throws IOException {
        WindowsPath windowsPath = WindowsPath.toWindowsPath(path);
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new RuntimePermission("getFileStoreAttributes"));
            windowsPath.checkRead();
        }
        return WindowsFileStore.create(windowsPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createDirectory(Path path, FileAttribute<?> ... fileAttributeArray) throws IOException {
        WindowsPath windowsPath = WindowsPath.toWindowsPath(path);
        windowsPath.checkWrite();
        WindowsSecurityDescriptor windowsSecurityDescriptor = WindowsSecurityDescriptor.fromAttribute(fileAttributeArray);
        try {
            WindowsNativeDispatcher.CreateDirectory(windowsPath.getPathForWin32Calls(), windowsSecurityDescriptor.address());
        }
        catch (WindowsException windowsException) {
            windowsException.rethrowAsIOException(windowsPath);
        }
        finally {
            windowsSecurityDescriptor.release();
        }
    }

    @Override
    public DirectoryStream<Path> newDirectoryStream(Path path, DirectoryStream.Filter<? super Path> filter) throws IOException {
        WindowsPath windowsPath = WindowsPath.toWindowsPath(path);
        windowsPath.checkRead();
        if (filter == null) {
            throw new NullPointerException();
        }
        return new WindowsDirectoryStream(windowsPath, filter);
    }

    @Override
    public void createSymbolicLink(Path path, Path path2, FileAttribute<?> ... fileAttributeArray) throws IOException {
        WindowsPath windowsPath;
        WindowsPath windowsPath2 = WindowsPath.toWindowsPath(path);
        WindowsPath windowsPath3 = WindowsPath.toWindowsPath(path2);
        if (!windowsPath2.getFileSystem().supportsLinks()) {
            throw new UnsupportedOperationException("Symbolic links not supported on this operating system");
        }
        if (fileAttributeArray.length > 0) {
            WindowsSecurityDescriptor.fromAttribute(fileAttributeArray);
            throw new UnsupportedOperationException("Initial file attributesnot supported when creating symbolic link");
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new LinkPermission("symbolic"));
            windowsPath2.checkWrite();
        }
        if (windowsPath3.type() == WindowsPathType.DRIVE_RELATIVE) {
            throw new IOException("Cannot create symbolic link to working directory relative target");
        }
        WindowsPath windowsPath4 = windowsPath3.type() == WindowsPathType.RELATIVE ? ((windowsPath = windowsPath2.getParent()) == null ? windowsPath3 : windowsPath.resolve(windowsPath3)) : windowsPath2.resolve(windowsPath3);
        int n = 0;
        try {
            WindowsFileAttributes windowsFileAttributes = WindowsFileAttributes.get(windowsPath4, false);
            if (windowsFileAttributes.isDirectory() || windowsFileAttributes.isDirectoryLink()) {
                n |= 1;
            }
        }
        catch (WindowsException windowsException) {
            // empty catch block
        }
        try {
            WindowsNativeDispatcher.CreateSymbolicLink(windowsPath2.getPathForWin32Calls(), WindowsPath.addPrefixIfNeeded(windowsPath3.toString()), n);
        }
        catch (WindowsException windowsException) {
            if (windowsException.lastError() == 4392) {
                windowsException.rethrowAsIOException(windowsPath2, windowsPath3);
            }
            windowsException.rethrowAsIOException(windowsPath2);
        }
    }

    @Override
    public void createLink(Path path, Path path2) throws IOException {
        WindowsPath windowsPath = WindowsPath.toWindowsPath(path);
        WindowsPath windowsPath2 = WindowsPath.toWindowsPath(path2);
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new LinkPermission("hard"));
            windowsPath.checkWrite();
            windowsPath2.checkWrite();
        }
        try {
            WindowsNativeDispatcher.CreateHardLink(windowsPath.getPathForWin32Calls(), windowsPath2.getPathForWin32Calls());
        }
        catch (WindowsException windowsException) {
            windowsException.rethrowAsIOException(windowsPath, windowsPath2);
        }
    }

    @Override
    public Path readSymbolicLink(Path path) throws IOException {
        Object object;
        WindowsPath windowsPath = WindowsPath.toWindowsPath(path);
        WindowsFileSystem windowsFileSystem = windowsPath.getFileSystem();
        if (!windowsFileSystem.supportsLinks()) {
            throw new UnsupportedOperationException("symbolic links not supported");
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            object = new FilePermission(windowsPath.getPathForPermissionCheck(), "readlink");
            AccessController.checkPermission((Permission)object);
        }
        object = WindowsLinkSupport.readLink(windowsPath);
        return WindowsPath.createFromNormalizedPath(windowsFileSystem, (String)object);
    }
}

