/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Component;
import java.awt.Image;
import java.awt.ImageMediaEntry;
import java.awt.MediaEntry;
import java.io.Serializable;

public class MediaTracker
implements Serializable {
    Component target;
    MediaEntry head;
    private static final long serialVersionUID = -483174189758638095L;
    public static final int LOADING = 1;
    public static final int ABORTED = 2;
    public static final int ERRORED = 4;
    public static final int COMPLETE = 8;
    static final int DONE = 14;

    public MediaTracker(Component component) {
        this.target = component;
    }

    public void addImage(Image image, int n) {
        this.addImage(image, n, -1, -1);
    }

    public synchronized void addImage(Image image, int n, int n2, int n3) {
        this.head = MediaEntry.insert(this.head, new ImageMediaEntry(this, image, n, n2, n3));
    }

    public boolean checkAll() {
        return this.checkAll(false, true);
    }

    public boolean checkAll(boolean bl) {
        return this.checkAll(bl, true);
    }

    private synchronized boolean checkAll(boolean bl, boolean bl2) {
        MediaEntry mediaEntry = this.head;
        boolean bl3 = true;
        while (mediaEntry != null) {
            if ((mediaEntry.getStatus(bl, bl2) & 0xE) == 0) {
                bl3 = false;
            }
            mediaEntry = mediaEntry.next;
        }
        return bl3;
    }

    public synchronized boolean isErrorAny() {
        MediaEntry mediaEntry = this.head;
        while (mediaEntry != null) {
            if ((mediaEntry.getStatus(false, true) & 4) != 0) {
                return true;
            }
            mediaEntry = mediaEntry.next;
        }
        return false;
    }

    public synchronized Object[] getErrorsAny() {
        MediaEntry mediaEntry = this.head;
        int n = 0;
        while (mediaEntry != null) {
            if ((mediaEntry.getStatus(false, true) & 4) != 0) {
                ++n;
            }
            mediaEntry = mediaEntry.next;
        }
        if (n == 0) {
            return null;
        }
        Object[] objectArray = new Object[n];
        mediaEntry = this.head;
        n = 0;
        while (mediaEntry != null) {
            if ((mediaEntry.getStatus(false, false) & 4) != 0) {
                objectArray[n++] = mediaEntry.getMedia();
            }
            mediaEntry = mediaEntry.next;
        }
        return objectArray;
    }

    public void waitForAll() throws InterruptedException {
        this.waitForAll(0L);
    }

    public synchronized boolean waitForAll(long l) throws InterruptedException {
        long l2 = System.currentTimeMillis() + l;
        boolean bl = true;
        int n;
        while (((n = this.statusAll(bl, bl)) & 1) != 0) {
            long l3;
            bl = false;
            if (l == 0L) {
                l3 = 0L;
            } else {
                l3 = l2 - System.currentTimeMillis();
                if (l3 <= 0L) {
                    return false;
                }
            }
            this.wait(l3);
        }
        return n == 8;
    }

    public int statusAll(boolean bl) {
        return this.statusAll(bl, true);
    }

    private synchronized int statusAll(boolean bl, boolean bl2) {
        MediaEntry mediaEntry = this.head;
        int n = 0;
        while (mediaEntry != null) {
            n |= mediaEntry.getStatus(bl, bl2);
            mediaEntry = mediaEntry.next;
        }
        return n;
    }

    public boolean checkID(int n) {
        return this.checkID(n, false, true);
    }

    public boolean checkID(int n, boolean bl) {
        return this.checkID(n, bl, true);
    }

    private synchronized boolean checkID(int n, boolean bl, boolean bl2) {
        MediaEntry mediaEntry = this.head;
        boolean bl3 = true;
        while (mediaEntry != null) {
            if (mediaEntry.getID() == n && (mediaEntry.getStatus(bl, bl2) & 0xE) == 0) {
                bl3 = false;
            }
            mediaEntry = mediaEntry.next;
        }
        return bl3;
    }

    public synchronized boolean isErrorID(int n) {
        MediaEntry mediaEntry = this.head;
        while (mediaEntry != null) {
            if (mediaEntry.getID() == n && (mediaEntry.getStatus(false, true) & 4) != 0) {
                return true;
            }
            mediaEntry = mediaEntry.next;
        }
        return false;
    }

    public synchronized Object[] getErrorsID(int n) {
        MediaEntry mediaEntry = this.head;
        int n2 = 0;
        while (mediaEntry != null) {
            if (mediaEntry.getID() == n && (mediaEntry.getStatus(false, true) & 4) != 0) {
                ++n2;
            }
            mediaEntry = mediaEntry.next;
        }
        if (n2 == 0) {
            return null;
        }
        Object[] objectArray = new Object[n2];
        mediaEntry = this.head;
        n2 = 0;
        while (mediaEntry != null) {
            if (mediaEntry.getID() == n && (mediaEntry.getStatus(false, false) & 4) != 0) {
                objectArray[n2++] = mediaEntry.getMedia();
            }
            mediaEntry = mediaEntry.next;
        }
        return objectArray;
    }

    public void waitForID(int n) throws InterruptedException {
        this.waitForID(n, 0L);
    }

    public synchronized boolean waitForID(int n, long l) throws InterruptedException {
        long l2 = System.currentTimeMillis() + l;
        boolean bl = true;
        int n2;
        while (((n2 = this.statusID(n, bl, bl)) & 1) != 0) {
            long l3;
            bl = false;
            if (l == 0L) {
                l3 = 0L;
            } else {
                l3 = l2 - System.currentTimeMillis();
                if (l3 <= 0L) {
                    return false;
                }
            }
            this.wait(l3);
        }
        return n2 == 8;
    }

    public int statusID(int n, boolean bl) {
        return this.statusID(n, bl, true);
    }

    private synchronized int statusID(int n, boolean bl, boolean bl2) {
        MediaEntry mediaEntry = this.head;
        int n2 = 0;
        while (mediaEntry != null) {
            if (mediaEntry.getID() == n) {
                n2 |= mediaEntry.getStatus(bl, bl2);
            }
            mediaEntry = mediaEntry.next;
        }
        return n2;
    }

    public synchronized void removeImage(Image image) {
        MediaEntry mediaEntry = this.head;
        MediaEntry mediaEntry2 = null;
        while (mediaEntry != null) {
            MediaEntry mediaEntry3 = mediaEntry.next;
            if (mediaEntry.getMedia() == image) {
                if (mediaEntry2 == null) {
                    this.head = mediaEntry3;
                } else {
                    mediaEntry2.next = mediaEntry3;
                }
                mediaEntry.cancel();
            } else {
                mediaEntry2 = mediaEntry;
            }
            mediaEntry = mediaEntry3;
        }
        this.notifyAll();
    }

    public synchronized void removeImage(Image image, int n) {
        MediaEntry mediaEntry = this.head;
        MediaEntry mediaEntry2 = null;
        while (mediaEntry != null) {
            MediaEntry mediaEntry3 = mediaEntry.next;
            if (mediaEntry.getID() == n && mediaEntry.getMedia() == image) {
                if (mediaEntry2 == null) {
                    this.head = mediaEntry3;
                } else {
                    mediaEntry2.next = mediaEntry3;
                }
                mediaEntry.cancel();
            } else {
                mediaEntry2 = mediaEntry;
            }
            mediaEntry = mediaEntry3;
        }
        this.notifyAll();
    }

    public synchronized void removeImage(Image image, int n, int n2, int n3) {
        MediaEntry mediaEntry = this.head;
        MediaEntry mediaEntry2 = null;
        while (mediaEntry != null) {
            MediaEntry mediaEntry3 = mediaEntry.next;
            if (mediaEntry.getID() == n && mediaEntry instanceof ImageMediaEntry && ((ImageMediaEntry)mediaEntry).matches(image, n2, n3)) {
                if (mediaEntry2 == null) {
                    this.head = mediaEntry3;
                } else {
                    mediaEntry2.next = mediaEntry3;
                }
                mediaEntry.cancel();
            } else {
                mediaEntry2 = mediaEntry;
            }
            mediaEntry = mediaEntry3;
        }
        this.notifyAll();
    }

    synchronized void setDone() {
        this.notifyAll();
    }
}

