/*
 * Decompiled with CFR 0.152.
 */
package com.mouseviator.spelling.alphabet.trainer;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.table.AbstractTableModel;

public class SpellTableModel
extends AbstractTableModel {
    private List<String[]> data = new ArrayList<String[]>();
    private String properties_file;
    private String[] column_names = new String[2];

    public SpellTableModel() {
        this.column_names[0] = "Character";
        this.column_names[1] = "Spelling";
    }

    @Override
    public int getRowCount() {
        return this.data.size();
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (columnIndex >= 0 && columnIndex < this.getColumnCount() && rowIndex >= 0 && rowIndex < this.getRowCount()) {
            String[] row = this.data.get(rowIndex);
            return row[columnIndex];
        }
        return null;
    }

    public String getPropertiesFile() {
        return this.properties_file;
    }

    public void setPropertiesFile(String properties_file) {
        this.properties_file = properties_file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadPropertiesFile(String properties_file) {
        Properties props = new Properties();
        FileInputStream fis = null;
        InputStreamReader reader = null;
        try {
            this.data.clear();
            this.properties_file = properties_file;
            fis = new FileInputStream(properties_file);
            reader = new InputStreamReader((InputStream)fis, Charset.forName("UTF-8"));
            props.load(reader);
            if (props.size() > 0) {
                for (String string : props.keySet()) {
                    String[] row = new String[]{string, props.getProperty(string)};
                    this.data.add(row);
                }
                System.gc();
            }
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(SpellTableModel.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(SpellTableModel.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException ex) {
                    Logger.getLogger(SpellTableModel.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException ex) {
                    Logger.getLogger(SpellTableModel.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            this.fireTableDataChanged();
        }
    }

    @Override
    public String getColumnName(int col) {
        return this.getColumnNames()[col];
    }

    public Class getColumnClass(int c) {
        return this.getValueAt(0, c).getClass();
    }

    public String[] getColumnNames() {
        return this.column_names;
    }

    public List<String[]> getData() {
        return this.data;
    }

    public void setColumnNames(String[] column_names) {
        this.column_names = column_names;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return true;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        if (this.data != null && row >= 0 && row < this.getRowCount() && col >= 0 && col < this.getColumnCount()) {
            String[] row_data = this.data.get(row);
            row_data[col] = String.valueOf(value);
            this.fireTableCellUpdated(row, col);
        }
    }

    public void deleteRows(int[] indexes) {
        if (this.data != null) {
            Arrays.sort(indexes);
            for (int i = indexes.length - 1; i >= 0; --i) {
                int index = indexes[i];
                this.data.remove(index);
            }
            this.fireTableDataChanged();
        }
    }

    public void deleteAll() {
        this.data.clear();
        this.fireTableDataChanged();
    }

    public void addRow(String[] row) {
        if (this.data != null) {
            this.data.add(row);
            this.fireTableRowsInserted(this.data.size(), this.data.size());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean savePropertiesFile(String file_name) {
        boolean bRet = false;
        Properties props = new Properties();
        FileOutputStream fos = null;
        OutputStreamWriter writer = null;
        try {
            for (String[] row_data : this.data) {
                if (row_data[0].trim().isEmpty() || row_data[1].trim().isEmpty()) continue;
                props.setProperty(row_data[0].trim(), row_data[1].trim());
            }
            fos = new FileOutputStream(file_name);
            writer = new OutputStreamWriter((OutputStream)fos, Charset.forName("UTF-8"));
            props.store(writer, "");
            bRet = true;
            return bRet;
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(SpellTableModel.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(SpellTableModel.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException ex) {
                    Logger.getLogger(SpellTableModel.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException ex) {
                    Logger.getLogger(SpellTableModel.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            return bRet;
        }
    }

    public boolean savePropertiesFile() {
        return this.savePropertiesFile(this.properties_file);
    }
}

