/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.gtk;

import com.sun.glass.ui.Pen;
import com.sun.glass.ui.Pixels;
import com.sun.glass.ui.View;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.Map;

class GtkView
extends View {
    private boolean imEnabled = false;
    private StringBuilder preedit = new StringBuilder();
    private int lastCaret;

    public GtkView(Pen pen) {
        super(pen);
    }

    protected void _enableInputMethodEvents(long ptr, boolean enable) {
        this.enableInputMethodEventsImpl(ptr, enable);
        if (this.imEnabled) {
            this.preedit.setLength(0);
        }
        this.imEnabled = enable;
    }

    protected native long _create(Map var1);

    protected native long _getNativeView(long var1);

    protected native int _getX(long var1);

    protected native int _getY(long var1);

    protected native void _setParent(long var1, long var3);

    protected native boolean _close(long var1);

    protected native void _repaint(long var1);

    protected native boolean _begin(long var1, boolean var3);

    protected native void _end(long var1, boolean var3, boolean var4);

    protected void _uploadPixels(long ptr, Pixels pixels) {
        Buffer data = pixels.getPixels();
        if (data.isDirect()) {
            this._uploadPixelsDirect(ptr, data, pixels.getWidth(), pixels.getHeight());
        } else if (data.hasArray()) {
            if (pixels.getBytesPerComponent() == 1) {
                ByteBuffer bytes = (ByteBuffer)data;
                this._uploadPixelsByteArray(ptr, bytes.array(), bytes.arrayOffset(), pixels.getWidth(), pixels.getHeight());
            } else {
                IntBuffer ints = (IntBuffer)data;
                this._uploadPixelsIntArray(ptr, ints.array(), ints.arrayOffset(), pixels.getWidth(), pixels.getHeight());
            }
        } else {
            this._uploadPixelsDirect(ptr, pixels.asByteBuffer(), pixels.getWidth(), pixels.getHeight());
        }
    }

    native void _uploadPixelsDirect(long var1, Buffer var3, int var4, int var5);

    native void _uploadPixelsByteArray(long var1, byte[] var3, int var4, int var5, int var6);

    native void _uploadPixelsIntArray(long var1, int[] var3, int var4, int var5, int var6);

    protected native boolean _enterFullscreen(long var1, boolean var3, boolean var4, boolean var5);

    protected native void _exitFullscreen(long var1, boolean var3);

    protected void notifyInputMethodDraw(String text, int first, int length, int caret) {
        if (text != null) {
            this.preedit.replace(first, first + length, text);
            this.notifyInputMethod(this.preedit.toString(), null, null, null, 0, caret, 0);
            this.lastCaret = caret;
        } else {
            this.preedit.setLength(0);
        }
    }

    protected void notifyInputMethodCaret(int pos, int direction, int style) {
        switch (direction) {
            case 0: {
                this.lastCaret += pos;
                break;
            }
            case 1: {
                this.lastCaret -= pos;
                break;
            }
            case 10: {
                this.lastCaret = pos;
                break;
            }
        }
        this.notifyInputMethod(this.preedit.toString(), null, null, null, 0, this.lastCaret, 0);
    }

    protected native void enableInputMethodEventsImpl(long var1, boolean var3);
}

