/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.cs.ext;

import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import sun.nio.cs.HistoricallyNamedCharset;
import sun.nio.cs.Surrogate;
import sun.nio.cs.ext.EUC_JP;
import sun.nio.cs.ext.ExtendedCharsets;
import sun.nio.cs.ext.JIS_X_0201;
import sun.nio.cs.ext.JIS_X_0208_Solaris_Decoder;
import sun.nio.cs.ext.JIS_X_0208_Solaris_Encoder;
import sun.nio.cs.ext.JIS_X_0212_Solaris_Decoder;
import sun.nio.cs.ext.JIS_X_0212_Solaris_Encoder;

public class EUC_JP_Open
extends Charset
implements HistoricallyNamedCharset {
    public EUC_JP_Open() {
        super("x-eucJP-Open", ExtendedCharsets.aliasesFor("x-eucJP-Open"));
    }

    @Override
    public String historicalName() {
        return "EUC_JP_Solaris";
    }

    @Override
    public boolean contains(Charset charset) {
        return charset.name().equals("US-ASCII") || charset instanceof JIS_X_0201 || charset instanceof EUC_JP;
    }

    @Override
    public CharsetDecoder newDecoder() {
        return new Decoder(this);
    }

    @Override
    public CharsetEncoder newEncoder() {
        byte[] byArray = new byte[]{63};
        return new Encoder(this).replaceWith(byArray);
    }

    private static class Decoder
    extends EUC_JP.Decoder {
        JIS_X_0201.Decoder decoderJ0201;
        JIS_X_0212_Solaris_Decoder decodeMappingJ0212;
        JIS_X_0208_Solaris_Decoder decodeMappingJ0208;
        private static final short[] j0208Index1 = JIS_X_0208_Solaris_Decoder.getIndex1();
        private static final String[] j0208Index2 = JIS_X_0208_Solaris_Decoder.getIndex2();
        private static final int start = 161;
        private static final int end = 254;
        protected final char REPLACE_CHAR = (char)65533;

        private Decoder(Charset charset) {
            super(charset);
            this.decoderJ0201 = new JIS_X_0201.Decoder(charset);
            this.decodeMappingJ0212 = new JIS_X_0212_Solaris_Decoder(charset);
        }

        @Override
        protected char decode0212(int n, int n2) {
            return this.decodeMappingJ0212.decodeDouble(n, n2);
        }

        @Override
        protected char decodeDouble(int n, int n2) {
            if (n == 142) {
                return this.decoderJ0201.decode(n2 - 256);
            }
            if (n < 0 || n > j0208Index1.length || n2 < 161 || n2 > 254) {
                return '\ufffd';
            }
            char c = super.decodeDouble(n, n2);
            if (c != '\ufffd') {
                return c;
            }
            int n3 = (j0208Index1[n - 128] & 0xF) * 94 + (n2 - 161);
            return j0208Index2[j0208Index1[n - 128] >> 4].charAt(n3);
        }
    }

    private static class Encoder
    extends EUC_JP.Encoder {
        JIS_X_0201.Encoder encoderJ0201;
        JIS_X_0212_Solaris_Encoder encoderJ0212;
        private static final short[] j0208Index1 = JIS_X_0208_Solaris_Encoder.getIndex1();
        private static final String[] j0208Index2 = JIS_X_0208_Solaris_Encoder.getIndex2();
        private final Surrogate.Parser sgp = new Surrogate.Parser();

        private Encoder(Charset charset) {
            super(charset);
            this.encoderJ0201 = new JIS_X_0201.Encoder(charset);
            this.encoderJ0212 = new JIS_X_0212_Solaris_Encoder(charset);
        }

        @Override
        protected int encodeSingle(char c, byte[] byArray) {
            if (c == '\u0000') {
                byArray[0] = 0;
                return 1;
            }
            byte by = this.encoderJ0201.encode(c);
            if (by == 0) {
                return 0;
            }
            if (by > 0 && by < 128) {
                byArray[0] = by;
                return 1;
            }
            byArray[0] = -114;
            byArray[1] = by;
            return 2;
        }

        @Override
        protected int encodeDouble(char c) {
            int n = super.encodeDouble(c);
            if (n != 0) {
                return n;
            }
            int n2 = j0208Index1[(c & 0xFF00) >> 8] << 8;
            n = j0208Index2[n2 >> 12].charAt((n2 & 0xFFF) + (c & 0xFF));
            if (n > 29952) {
                return 0x8F8080 + this.encoderJ0212.encodeDouble(c);
            }
            return n == 0 ? 0 : n + 32896;
        }
    }
}

