/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.channels.AlreadyConnectedException;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.CompletionHandler;
import java.nio.channels.ConnectionPendingException;
import java.nio.channels.InterruptedByTimeoutException;
import java.nio.channels.ShutdownChannelGroupException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import sun.misc.Unsafe;
import sun.nio.ch.AsynchronousChannelGroupImpl;
import sun.nio.ch.AsynchronousSocketChannelImpl;
import sun.nio.ch.CompletedFuture;
import sun.nio.ch.DirectBuffer;
import sun.nio.ch.IOUtil;
import sun.nio.ch.Invoker;
import sun.nio.ch.Iocp;
import sun.nio.ch.Net;
import sun.nio.ch.PendingFuture;
import sun.nio.ch.PendingIoCache;
import sun.nio.ch.Util;

class WindowsAsynchronousSocketChannelImpl
extends AsynchronousSocketChannelImpl
implements Iocp.OverlappedChannel {
    private static final Unsafe unsafe = Unsafe.getUnsafe();
    private static int addressSize = unsafe.addressSize();
    private static final int SIZEOF_WSABUF = WindowsAsynchronousSocketChannelImpl.dependsArch(8, 16);
    private static final int OFFSETOF_LEN = 0;
    private static final int OFFSETOF_BUF = WindowsAsynchronousSocketChannelImpl.dependsArch(4, 8);
    private static final int MAX_WSABUF = 16;
    private static final int SIZEOF_WSABUFARRAY = 16 * SIZEOF_WSABUF;
    final long handle;
    private final Iocp iocp;
    private final int completionKey;
    private final PendingIoCache ioCache;
    private final long readBufferArray;
    private final long writeBufferArray;

    private static int dependsArch(int n, int n2) {
        return addressSize == 4 ? n : n2;
    }

    WindowsAsynchronousSocketChannelImpl(Iocp iocp, boolean bl) throws IOException {
        super(iocp);
        long l = IOUtil.fdVal(this.fd);
        int n = 0;
        try {
            n = iocp.associate(this, l);
        }
        catch (ShutdownChannelGroupException shutdownChannelGroupException) {
            if (bl) {
                WindowsAsynchronousSocketChannelImpl.closesocket0(l);
                throw shutdownChannelGroupException;
            }
        }
        catch (IOException iOException) {
            WindowsAsynchronousSocketChannelImpl.closesocket0(l);
            throw iOException;
        }
        this.handle = l;
        this.iocp = iocp;
        this.completionKey = n;
        this.ioCache = new PendingIoCache();
        this.readBufferArray = unsafe.allocateMemory(SIZEOF_WSABUFARRAY);
        this.writeBufferArray = unsafe.allocateMemory(SIZEOF_WSABUFARRAY);
    }

    WindowsAsynchronousSocketChannelImpl(Iocp iocp) throws IOException {
        this(iocp, true);
    }

    @Override
    public AsynchronousChannelGroupImpl group() {
        return this.iocp;
    }

    @Override
    public <V, A> PendingFuture<V, A> getByOverlapped(long l) {
        return this.ioCache.remove(l);
    }

    long handle() {
        return this.handle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setConnected(SocketAddress socketAddress, SocketAddress socketAddress2) {
        Object object = this.stateLock;
        synchronized (object) {
            this.state = 2;
            this.localAddress = socketAddress;
            this.remoteAddress = socketAddress2;
        }
    }

    @Override
    void implClose() throws IOException {
        WindowsAsynchronousSocketChannelImpl.closesocket0(this.handle);
        this.ioCache.close();
        unsafe.freeMemory(this.readBufferArray);
        unsafe.freeMemory(this.writeBufferArray);
        if (this.completionKey != 0) {
            this.iocp.disassociate(this.completionKey);
        }
    }

    @Override
    public void onCancel(PendingFuture<?, ?> pendingFuture) {
        if (pendingFuture.getContext() instanceof ConnectTask) {
            this.killConnect();
        }
        if (pendingFuture.getContext() instanceof ReadTask) {
            this.killReading();
        }
        if (pendingFuture.getContext() instanceof WriteTask) {
            this.killWriting();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    <A> Future<Void> implConnect(SocketAddress socketAddress, A a, CompletionHandler<Void, ? super A> completionHandler) {
        if (!this.isOpen()) {
            ClosedChannelException closedChannelException = new ClosedChannelException();
            if (completionHandler == null) {
                return CompletedFuture.withFailure(closedChannelException);
            }
            Invoker.invoke(this, completionHandler, a, null, closedChannelException);
            return null;
        }
        InetSocketAddress inetSocketAddress = Net.checkAddress(socketAddress);
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkConnect(inetSocketAddress.getAddress().getHostAddress(), inetSocketAddress.getPort());
        }
        IOException iOException = null;
        PendingFuture<Void, A> pendingFuture = this.stateLock;
        synchronized (pendingFuture) {
            if (this.state == 2) {
                throw new AlreadyConnectedException();
            }
            if (this.state == 1) {
                throw new ConnectionPendingException();
            }
            if (this.localAddress == null) {
                try {
                    this.bind(new InetSocketAddress(0));
                }
                catch (IOException iOException2) {
                    iOException = iOException2;
                }
            }
            if (iOException == null) {
                this.state = 1;
            }
        }
        if (iOException != null) {
            try {
                this.close();
            }
            catch (IOException iOException3) {
                // empty catch block
            }
            if (completionHandler == null) {
                return CompletedFuture.withFailure(iOException);
            }
            Invoker.invoke(this, completionHandler, a, null, iOException);
            return null;
        }
        pendingFuture = new PendingFuture<Void, A>(this, completionHandler, a);
        ConnectTask<A> connectTask = new ConnectTask<A>(inetSocketAddress, pendingFuture);
        pendingFuture.setContext(connectTask);
        if (Iocp.supportsThreadAgnosticIo()) {
            connectTask.run();
        } else {
            Invoker.invokeOnThreadInThreadPool(this, connectTask);
        }
        return pendingFuture;
    }

    @Override
    <V extends Number, A> Future<V> implRead(boolean bl, ByteBuffer byteBuffer, ByteBuffer[] byteBufferArray, long l, TimeUnit timeUnit, A a, CompletionHandler<V, ? super A> completionHandler) {
        PendingFuture<V, A> pendingFuture = new PendingFuture<V, A>(this, completionHandler, a);
        ByteBuffer[] byteBufferArray2 = bl ? byteBufferArray : new ByteBuffer[]{byteBuffer};
        final ReadTask<V, A> readTask = new ReadTask<V, A>(byteBufferArray2, bl, pendingFuture);
        pendingFuture.setContext(readTask);
        if (l > 0L) {
            Future<?> future = this.iocp.schedule(new Runnable(){

                @Override
                public void run() {
                    readTask.timeout();
                }
            }, l, timeUnit);
            pendingFuture.setTimeoutTask(future);
        }
        if (Iocp.supportsThreadAgnosticIo()) {
            readTask.run();
        } else {
            Invoker.invokeOnThreadInThreadPool(this, readTask);
        }
        return pendingFuture;
    }

    @Override
    <V extends Number, A> Future<V> implWrite(boolean bl, ByteBuffer byteBuffer, ByteBuffer[] byteBufferArray, long l, TimeUnit timeUnit, A a, CompletionHandler<V, ? super A> completionHandler) {
        PendingFuture<V, A> pendingFuture = new PendingFuture<V, A>(this, completionHandler, a);
        ByteBuffer[] byteBufferArray2 = bl ? byteBufferArray : new ByteBuffer[]{byteBuffer};
        final WriteTask<V, A> writeTask = new WriteTask<V, A>(byteBufferArray2, bl, pendingFuture);
        pendingFuture.setContext(writeTask);
        if (l > 0L) {
            Future<?> future = this.iocp.schedule(new Runnable(){

                @Override
                public void run() {
                    writeTask.timeout();
                }
            }, l, timeUnit);
            pendingFuture.setTimeoutTask(future);
        }
        if (Iocp.supportsThreadAgnosticIo()) {
            writeTask.run();
        } else {
            Invoker.invokeOnThreadInThreadPool(this, writeTask);
        }
        return pendingFuture;
    }

    private static native void initIDs();

    private static native int connect0(long var0, boolean var2, InetAddress var3, int var4, long var5) throws IOException;

    private static native void updateConnectContext(long var0) throws IOException;

    private static native int read0(long var0, int var2, long var3, long var5) throws IOException;

    private static native int write0(long var0, int var2, long var3, long var5) throws IOException;

    private static native void shutdown0(long var0, int var2) throws IOException;

    private static native void closesocket0(long var0) throws IOException;

    static {
        Util.load();
        WindowsAsynchronousSocketChannelImpl.initIDs();
    }

    private class ConnectTask<A>
    implements Runnable,
    Iocp.ResultHandler {
        private final InetSocketAddress remote;
        private final PendingFuture<Void, A> result;

        ConnectTask(InetSocketAddress inetSocketAddress, PendingFuture<Void, A> pendingFuture) {
            this.remote = inetSocketAddress;
            this.result = pendingFuture;
        }

        private void closeChannel() {
            try {
                WindowsAsynchronousSocketChannelImpl.this.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        private IOException toIOException(Throwable throwable) {
            if (throwable instanceof IOException) {
                if (throwable instanceof ClosedChannelException) {
                    throwable = new AsynchronousCloseException();
                }
                return (IOException)throwable;
            }
            return new IOException(throwable);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void afterConnect() throws IOException {
            WindowsAsynchronousSocketChannelImpl.updateConnectContext(WindowsAsynchronousSocketChannelImpl.this.handle);
            Object object = WindowsAsynchronousSocketChannelImpl.this.stateLock;
            synchronized (object) {
                WindowsAsynchronousSocketChannelImpl.this.state = 2;
                WindowsAsynchronousSocketChannelImpl.this.remoteAddress = this.remote;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            long l = 0L;
            Throwable throwable = null;
            try {
                WindowsAsynchronousSocketChannelImpl.this.begin();
                PendingFuture<Void, A> pendingFuture = this.result;
                synchronized (pendingFuture) {
                    block12: {
                        l = WindowsAsynchronousSocketChannelImpl.this.ioCache.add(this.result);
                        int n = WindowsAsynchronousSocketChannelImpl.connect0(WindowsAsynchronousSocketChannelImpl.this.handle, Net.isIPv6Available(), this.remote.getAddress(), this.remote.getPort(), l);
                        if (n != -2) break block12;
                        return;
                    }
                    this.afterConnect();
                    this.result.setResult(null);
                }
            }
            catch (Throwable throwable2) {
                if (l != 0L) {
                    WindowsAsynchronousSocketChannelImpl.this.ioCache.remove(l);
                }
                throwable = throwable2;
            }
            finally {
                WindowsAsynchronousSocketChannelImpl.this.end();
            }
            if (throwable != null) {
                this.closeChannel();
                this.result.setFailure(this.toIOException(throwable));
            }
            Invoker.invoke(this.result);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void completed(int n, boolean bl) {
            Throwable throwable = null;
            try {
                WindowsAsynchronousSocketChannelImpl.this.begin();
                this.afterConnect();
                this.result.setResult(null);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
            }
            finally {
                WindowsAsynchronousSocketChannelImpl.this.end();
            }
            if (throwable != null) {
                this.closeChannel();
                this.result.setFailure(this.toIOException(throwable));
            }
            if (bl) {
                Invoker.invokeUnchecked(this.result);
            } else {
                Invoker.invoke(this.result);
            }
        }

        @Override
        public void failed(int n, IOException iOException) {
            if (WindowsAsynchronousSocketChannelImpl.this.isOpen()) {
                this.closeChannel();
                this.result.setFailure(iOException);
            } else {
                this.result.setFailure(new AsynchronousCloseException());
            }
            Invoker.invoke(this.result);
        }
    }

    private class ReadTask<V, A>
    implements Runnable,
    Iocp.ResultHandler {
        private final ByteBuffer[] bufs;
        private final int numBufs;
        private final boolean scatteringRead;
        private final PendingFuture<V, A> result;
        private ByteBuffer[] shadow;

        ReadTask(ByteBuffer[] byteBufferArray, boolean bl, PendingFuture<V, A> pendingFuture) {
            this.bufs = byteBufferArray;
            this.numBufs = byteBufferArray.length > 16 ? 16 : byteBufferArray.length;
            this.scatteringRead = bl;
            this.result = pendingFuture;
        }

        void prepareBuffers() {
            this.shadow = new ByteBuffer[this.numBufs];
            long l = WindowsAsynchronousSocketChannelImpl.this.readBufferArray;
            for (int i = 0; i < this.numBufs; ++i) {
                long l2;
                int n;
                ByteBuffer byteBuffer = this.bufs[i];
                int n2 = byteBuffer.position();
                int n3 = byteBuffer.limit();
                assert (n2 <= n3);
                int n4 = n = n2 <= n3 ? n3 - n2 : 0;
                if (!(byteBuffer instanceof DirectBuffer)) {
                    ByteBuffer byteBuffer2;
                    this.shadow[i] = byteBuffer2 = Util.getTemporaryDirectBuffer(n);
                    l2 = ((DirectBuffer)((Object)byteBuffer2)).address();
                } else {
                    this.shadow[i] = byteBuffer;
                    l2 = ((DirectBuffer)((Object)byteBuffer)).address() + (long)n2;
                }
                unsafe.putAddress(l + (long)OFFSETOF_BUF, l2);
                unsafe.putInt(l + 0L, n);
                l += (long)SIZEOF_WSABUF;
            }
        }

        void updateBuffers(int n) {
            int n2;
            for (n2 = 0; n2 < this.numBufs; ++n2) {
                int n3;
                ByteBuffer byteBuffer = this.shadow[n2];
                int n4 = byteBuffer.position();
                int n5 = byteBuffer.remaining();
                if (n >= n5) {
                    n -= n5;
                    n3 = n4 + n5;
                    try {
                        byteBuffer.position(n3);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                    continue;
                }
                if (n <= 0) break;
                assert ((long)(n4 + n) < Integer.MAX_VALUE);
                n3 = n4 + n;
                try {
                    byteBuffer.position(n3);
                }
                catch (IllegalArgumentException illegalArgumentException) {}
                break;
            }
            for (n2 = 0; n2 < this.numBufs; ++n2) {
                if (this.bufs[n2] instanceof DirectBuffer) continue;
                this.shadow[n2].flip();
                try {
                    this.bufs[n2].put(this.shadow[n2]);
                    continue;
                }
                catch (BufferOverflowException bufferOverflowException) {
                    // empty catch block
                }
            }
        }

        void releaseBuffers() {
            for (int i = 0; i < this.numBufs; ++i) {
                if (this.bufs[i] instanceof DirectBuffer) continue;
                Util.releaseTemporaryDirectBuffer(this.shadow[i]);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block15: {
                long l = 0L;
                boolean bl = false;
                boolean bl2 = false;
                try {
                    WindowsAsynchronousSocketChannelImpl.this.begin();
                    this.prepareBuffers();
                    bl = true;
                    l = WindowsAsynchronousSocketChannelImpl.this.ioCache.add(this.result);
                    int n = WindowsAsynchronousSocketChannelImpl.read0(WindowsAsynchronousSocketChannelImpl.this.handle, this.numBufs, WindowsAsynchronousSocketChannelImpl.this.readBufferArray, l);
                    if (n == -2) {
                        bl2 = true;
                        return;
                    }
                    if (n == -1) {
                        WindowsAsynchronousSocketChannelImpl.this.enableReading();
                        if (this.scatteringRead) {
                            this.result.setResult(-1L);
                        } else {
                            this.result.setResult(-1);
                        }
                        break block15;
                    }
                    throw new InternalError("Read completed immediately");
                }
                catch (Throwable throwable) {
                    IOException iOException;
                    WindowsAsynchronousSocketChannelImpl.this.enableReading();
                    if (throwable instanceof ClosedChannelException) {
                        iOException = new AsynchronousCloseException();
                    }
                    if (!(iOException instanceof IOException)) {
                        iOException = new IOException(iOException);
                    }
                    this.result.setFailure(iOException);
                }
                finally {
                    if (!bl2) {
                        if (l != 0L) {
                            WindowsAsynchronousSocketChannelImpl.this.ioCache.remove(l);
                        }
                        if (bl) {
                            this.releaseBuffers();
                        }
                    }
                    WindowsAsynchronousSocketChannelImpl.this.end();
                }
            }
            Invoker.invoke(this.result);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void completed(int n, boolean bl) {
            if (n == 0) {
                n = -1;
            } else {
                this.updateBuffers(n);
            }
            this.releaseBuffers();
            PendingFuture<V, A> pendingFuture = this.result;
            synchronized (pendingFuture) {
                if (this.result.isDone()) {
                    return;
                }
                WindowsAsynchronousSocketChannelImpl.this.enableReading();
                if (this.scatteringRead) {
                    this.result.setResult(Long.valueOf(n));
                } else {
                    this.result.setResult(n);
                }
            }
            if (bl) {
                Invoker.invokeUnchecked(this.result);
            } else {
                Invoker.invoke(this.result);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void failed(int n, IOException iOException) {
            this.releaseBuffers();
            if (!WindowsAsynchronousSocketChannelImpl.this.isOpen()) {
                iOException = new AsynchronousCloseException();
            }
            PendingFuture<V, A> pendingFuture = this.result;
            synchronized (pendingFuture) {
                if (this.result.isDone()) {
                    return;
                }
                WindowsAsynchronousSocketChannelImpl.this.enableReading();
                this.result.setFailure(iOException);
            }
            Invoker.invoke(this.result);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void timeout() {
            PendingFuture<V, A> pendingFuture = this.result;
            synchronized (pendingFuture) {
                if (this.result.isDone()) {
                    return;
                }
                WindowsAsynchronousSocketChannelImpl.this.enableReading(true);
                this.result.setFailure(new InterruptedByTimeoutException());
            }
            Invoker.invoke(this.result);
        }
    }

    private class WriteTask<V, A>
    implements Runnable,
    Iocp.ResultHandler {
        private final ByteBuffer[] bufs;
        private final int numBufs;
        private final boolean gatheringWrite;
        private final PendingFuture<V, A> result;
        private ByteBuffer[] shadow;

        WriteTask(ByteBuffer[] byteBufferArray, boolean bl, PendingFuture<V, A> pendingFuture) {
            this.bufs = byteBufferArray;
            this.numBufs = byteBufferArray.length > 16 ? 16 : byteBufferArray.length;
            this.gatheringWrite = bl;
            this.result = pendingFuture;
        }

        void prepareBuffers() {
            this.shadow = new ByteBuffer[this.numBufs];
            long l = WindowsAsynchronousSocketChannelImpl.this.writeBufferArray;
            for (int i = 0; i < this.numBufs; ++i) {
                long l2;
                int n;
                ByteBuffer byteBuffer = this.bufs[i];
                int n2 = byteBuffer.position();
                int n3 = byteBuffer.limit();
                assert (n2 <= n3);
                int n4 = n = n2 <= n3 ? n3 - n2 : 0;
                if (!(byteBuffer instanceof DirectBuffer)) {
                    ByteBuffer byteBuffer2 = Util.getTemporaryDirectBuffer(n);
                    byteBuffer2.put(byteBuffer);
                    byteBuffer2.flip();
                    byteBuffer.position(n2);
                    this.shadow[i] = byteBuffer2;
                    l2 = ((DirectBuffer)((Object)byteBuffer2)).address();
                } else {
                    this.shadow[i] = byteBuffer;
                    l2 = ((DirectBuffer)((Object)byteBuffer)).address() + (long)n2;
                }
                unsafe.putAddress(l + (long)OFFSETOF_BUF, l2);
                unsafe.putInt(l + 0L, n);
                l += (long)SIZEOF_WSABUF;
            }
        }

        void updateBuffers(int n) {
            for (int i = 0; i < this.numBufs; ++i) {
                int n2;
                int n3;
                int n4;
                ByteBuffer byteBuffer = this.bufs[i];
                int n5 = byteBuffer.position();
                int n6 = n4 = n5 <= (n3 = byteBuffer.limit()) ? n3 - n5 : n3;
                if (n >= n4) {
                    n -= n4;
                    n2 = n5 + n4;
                    try {
                        byteBuffer.position(n2);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                    continue;
                }
                if (n <= 0) break;
                assert ((long)(n5 + n) < Integer.MAX_VALUE);
                n2 = n5 + n;
                try {
                    byteBuffer.position(n2);
                }
                catch (IllegalArgumentException illegalArgumentException) {}
                break;
            }
        }

        void releaseBuffers() {
            for (int i = 0; i < this.numBufs; ++i) {
                if (this.bufs[i] instanceof DirectBuffer) continue;
                Util.releaseTemporaryDirectBuffer(this.shadow[i]);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            int n;
            boolean bl;
            boolean bl2;
            boolean bl3;
            long l;
            block15: {
                block16: {
                    block17: {
                        l = 0L;
                        bl3 = false;
                        bl2 = false;
                        bl = false;
                        WindowsAsynchronousSocketChannelImpl.this.begin();
                        this.prepareBuffers();
                        bl3 = true;
                        l = WindowsAsynchronousSocketChannelImpl.this.ioCache.add(this.result);
                        n = WindowsAsynchronousSocketChannelImpl.write0(WindowsAsynchronousSocketChannelImpl.this.handle, this.numBufs, WindowsAsynchronousSocketChannelImpl.this.writeBufferArray, l);
                        if (n != -2) break block15;
                        bl2 = true;
                        if (bl2) break block16;
                        if (l == 0L) break block17;
                        WindowsAsynchronousSocketChannelImpl.this.ioCache.remove(l);
                    }
                    if (bl3) {
                        this.releaseBuffers();
                    }
                }
                WindowsAsynchronousSocketChannelImpl.this.end();
                return;
            }
            try {
                try {
                    if (n == -1) {
                        bl = true;
                        throw new ClosedChannelException();
                    }
                    throw new InternalError("Write completed immediately");
                }
                catch (Throwable throwable) {
                    IOException iOException;
                    WindowsAsynchronousSocketChannelImpl.this.enableWriting();
                    if (!bl && throwable instanceof ClosedChannelException) {
                        iOException = new AsynchronousCloseException();
                    }
                    if (!(iOException instanceof IOException)) {
                        iOException = new IOException(iOException);
                    }
                    this.result.setFailure(iOException);
                    if (!bl2) {
                        if (l != 0L) {
                            WindowsAsynchronousSocketChannelImpl.this.ioCache.remove(l);
                        }
                        if (bl3) {
                            this.releaseBuffers();
                        }
                    }
                    WindowsAsynchronousSocketChannelImpl.this.end();
                }
            }
            catch (Throwable throwable) {
                if (!bl2) {
                    if (l != 0L) {
                        WindowsAsynchronousSocketChannelImpl.this.ioCache.remove(l);
                    }
                    if (bl3) {
                        this.releaseBuffers();
                    }
                }
                WindowsAsynchronousSocketChannelImpl.this.end();
                throw throwable;
            }
            Invoker.invoke(this.result);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void completed(int n, boolean bl) {
            this.updateBuffers(n);
            this.releaseBuffers();
            PendingFuture<V, A> pendingFuture = this.result;
            synchronized (pendingFuture) {
                if (this.result.isDone()) {
                    return;
                }
                WindowsAsynchronousSocketChannelImpl.this.enableWriting();
                if (this.gatheringWrite) {
                    this.result.setResult(Long.valueOf(n));
                } else {
                    this.result.setResult(n);
                }
            }
            if (bl) {
                Invoker.invokeUnchecked(this.result);
            } else {
                Invoker.invoke(this.result);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void failed(int n, IOException iOException) {
            this.releaseBuffers();
            if (!WindowsAsynchronousSocketChannelImpl.this.isOpen()) {
                iOException = new AsynchronousCloseException();
            }
            PendingFuture<V, A> pendingFuture = this.result;
            synchronized (pendingFuture) {
                if (this.result.isDone()) {
                    return;
                }
                WindowsAsynchronousSocketChannelImpl.this.enableWriting();
                this.result.setFailure(iOException);
            }
            Invoker.invoke(this.result);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void timeout() {
            PendingFuture<V, A> pendingFuture = this.result;
            synchronized (pendingFuture) {
                if (this.result.isDone()) {
                    return;
                }
                WindowsAsynchronousSocketChannelImpl.this.enableWriting(true);
                this.result.setFailure(new InterruptedByTimeoutException());
            }
            Invoker.invoke(this.result);
        }
    }
}

