/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.IllegalComponentStateException;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.image.ColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;
import java.beans.ConstructorProperties;
import java.beans.Transient;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.net.URL;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.Locale;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleIcon;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleStateSet;
import javax.swing.Icon;
import sun.awt.AppContext;

public class ImageIcon
implements Icon,
Serializable,
Accessible {
    private transient String filename;
    private transient URL location;
    transient Image image;
    transient int loadStatus = 0;
    ImageObserver imageObserver;
    String description = null;
    protected static final Component component = AccessController.doPrivileged(new PrivilegedAction<Component>(){

        @Override
        public Component run() {
            try {
                Component component = ImageIcon.createNoPermsComponent();
                Field field = Component.class.getDeclaredField("appContext");
                field.setAccessible(true);
                field.set(component, null);
                return component;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                return null;
            }
        }
    });
    protected static final MediaTracker tracker = new MediaTracker(component);
    private static int mediaTrackerID;
    private static final Object TRACKER_KEY;
    int width = -1;
    int height = -1;
    private AccessibleImageIcon accessibleContext = null;

    private static Component createNoPermsComponent() {
        return AccessController.doPrivileged(new PrivilegedAction<Component>(){

            @Override
            public Component run() {
                return new Component(){};
            }
        }, new AccessControlContext(new ProtectionDomain[]{new ProtectionDomain(null, null)}));
    }

    public ImageIcon(String string, String string2) {
        this.image = Toolkit.getDefaultToolkit().getImage(string);
        if (this.image == null) {
            return;
        }
        this.filename = string;
        this.description = string2;
        this.loadImage(this.image);
    }

    @ConstructorProperties(value={"description"})
    public ImageIcon(String string) {
        this(string, string);
    }

    public ImageIcon(URL uRL, String string) {
        this.image = Toolkit.getDefaultToolkit().getImage(uRL);
        if (this.image == null) {
            return;
        }
        this.location = uRL;
        this.description = string;
        this.loadImage(this.image);
    }

    public ImageIcon(URL uRL) {
        this(uRL, uRL.toExternalForm());
    }

    public ImageIcon(Image image, String string) {
        this(image);
        this.description = string;
    }

    public ImageIcon(Image image) {
        this.image = image;
        Object object = image.getProperty("comment", this.imageObserver);
        if (object instanceof String) {
            this.description = (String)object;
        }
        this.loadImage(image);
    }

    public ImageIcon(byte[] byArray, String string) {
        this.image = Toolkit.getDefaultToolkit().createImage(byArray);
        if (this.image == null) {
            return;
        }
        this.description = string;
        this.loadImage(this.image);
    }

    public ImageIcon(byte[] byArray) {
        this.image = Toolkit.getDefaultToolkit().createImage(byArray);
        if (this.image == null) {
            return;
        }
        Object object = this.image.getProperty("comment", this.imageObserver);
        if (object instanceof String) {
            this.description = (String)object;
        }
        this.loadImage(this.image);
    }

    public ImageIcon() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadImage(Image image) {
        MediaTracker mediaTracker;
        MediaTracker mediaTracker2 = mediaTracker = this.getTracker();
        synchronized (mediaTracker2) {
            int n = this.getNextID();
            mediaTracker.addImage(image, n);
            try {
                mediaTracker.waitForID(n, 0L);
            }
            catch (InterruptedException interruptedException) {
                System.out.println("INTERRUPTED while loading Image");
            }
            this.loadStatus = mediaTracker.statusID(n, false);
            mediaTracker.removeImage(image, n);
            this.width = image.getWidth(this.imageObserver);
            this.height = image.getHeight(this.imageObserver);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getNextID() {
        MediaTracker mediaTracker = this.getTracker();
        synchronized (mediaTracker) {
            return ++mediaTrackerID;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MediaTracker getTracker() {
        Object object;
        AppContext appContext;
        AppContext appContext2 = appContext = AppContext.getAppContext();
        synchronized (appContext2) {
            object = appContext.get(TRACKER_KEY);
            if (object == null) {
                Component component = new Component(){};
                object = new MediaTracker(component);
                appContext.put(TRACKER_KEY, object);
            }
        }
        return (MediaTracker)object;
    }

    public int getImageLoadStatus() {
        return this.loadStatus;
    }

    @Transient
    public Image getImage() {
        return this.image;
    }

    public void setImage(Image image) {
        this.image = image;
        this.loadImage(image);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    @Override
    public synchronized void paintIcon(Component component, Graphics graphics, int n, int n2) {
        if (this.imageObserver == null) {
            graphics.drawImage(this.image, n, n2, component);
        } else {
            graphics.drawImage(this.image, n, n2, this.imageObserver);
        }
    }

    @Override
    public int getIconWidth() {
        return this.width;
    }

    @Override
    public int getIconHeight() {
        return this.height;
    }

    public void setImageObserver(ImageObserver imageObserver) {
        this.imageObserver = imageObserver;
    }

    @Transient
    public ImageObserver getImageObserver() {
        return this.imageObserver;
    }

    public String toString() {
        if (this.description != null) {
            return this.description;
        }
        return super.toString();
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        int n2 = objectInputStream.readInt();
        int[] nArray = (int[])objectInputStream.readObject();
        if (nArray != null) {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            ColorModel colorModel = ColorModel.getRGBdefault();
            this.image = toolkit.createImage(new MemoryImageSource(n, n2, colorModel, nArray, 0, n));
            this.loadImage(this.image);
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        int[] nArray;
        objectOutputStream.defaultWriteObject();
        int n = this.getIconWidth();
        int n2 = this.getIconHeight();
        int[] nArray2 = nArray = this.image != null ? new int[n * n2] : null;
        if (this.image != null) {
            try {
                PixelGrabber pixelGrabber = new PixelGrabber(this.image, 0, 0, n, n2, nArray, 0, n);
                pixelGrabber.grabPixels();
                if ((pixelGrabber.getStatus() & 0x80) != 0) {
                    throw new IOException("failed to load image contents");
                }
            }
            catch (InterruptedException interruptedException) {
                throw new IOException("image load interrupted");
            }
        }
        objectOutputStream.writeInt(n);
        objectOutputStream.writeInt(n2);
        objectOutputStream.writeObject(nArray);
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleImageIcon();
        }
        return this.accessibleContext;
    }

    static {
        TRACKER_KEY = new StringBuilder("TRACKER_KEY");
    }

    protected class AccessibleImageIcon
    extends AccessibleContext
    implements AccessibleIcon,
    Serializable {
        protected AccessibleImageIcon() {
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.ICON;
        }

        @Override
        public AccessibleStateSet getAccessibleStateSet() {
            return null;
        }

        @Override
        public Accessible getAccessibleParent() {
            return null;
        }

        @Override
        public int getAccessibleIndexInParent() {
            return -1;
        }

        @Override
        public int getAccessibleChildrenCount() {
            return 0;
        }

        @Override
        public Accessible getAccessibleChild(int n) {
            return null;
        }

        @Override
        public Locale getLocale() throws IllegalComponentStateException {
            return null;
        }

        @Override
        public String getAccessibleIconDescription() {
            return ImageIcon.this.getDescription();
        }

        @Override
        public void setAccessibleIconDescription(String string) {
            ImageIcon.this.setDescription(string);
        }

        @Override
        public int getAccessibleIconHeight() {
            return ImageIcon.this.height;
        }

        @Override
        public int getAccessibleIconWidth() {
            return ImageIcon.this.width;
        }

        private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
            objectInputStream.defaultReadObject();
        }

        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            objectOutputStream.defaultWriteObject();
        }
    }
}

