/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.policy.sourcemodel;

import com.sun.xml.internal.ws.policy.privateutil.LocalizationMessages;
import com.sun.xml.internal.ws.policy.privateutil.PolicyLogger;
import com.sun.xml.internal.ws.policy.privateutil.PolicyUtils;
import java.net.URI;
import java.net.URISyntaxException;

final class PolicyReferenceData {
    private static final PolicyLogger LOGGER = PolicyLogger.getLogger(PolicyReferenceData.class);
    private static final URI DEFAULT_DIGEST_ALGORITHM_URI;
    private static final URISyntaxException CLASS_INITIALIZATION_EXCEPTION;
    private final URI referencedModelUri;
    private final String digest;
    private final URI digestAlgorithmUri;

    public PolicyReferenceData(URI uRI) {
        this.referencedModelUri = uRI;
        this.digest = null;
        this.digestAlgorithmUri = null;
    }

    public PolicyReferenceData(URI uRI, String string, URI uRI2) {
        if (CLASS_INITIALIZATION_EXCEPTION != null) {
            throw LOGGER.logSevereException(new IllegalStateException(LocalizationMessages.WSP_0015_UNABLE_TO_INSTANTIATE_DIGEST_ALG_URI_FIELD(), CLASS_INITIALIZATION_EXCEPTION));
        }
        if (uRI2 != null && string == null) {
            throw LOGGER.logSevereException(new IllegalArgumentException(LocalizationMessages.WSP_0072_DIGEST_MUST_NOT_BE_NULL_WHEN_ALG_DEFINED()));
        }
        this.referencedModelUri = uRI;
        if (string == null) {
            this.digest = null;
            this.digestAlgorithmUri = null;
        } else {
            this.digest = string;
            this.digestAlgorithmUri = uRI2 == null ? DEFAULT_DIGEST_ALGORITHM_URI : uRI2;
        }
    }

    public URI getReferencedModelUri() {
        return this.referencedModelUri;
    }

    public String getDigest() {
        return this.digest;
    }

    public URI getDigestAlgorithmUri() {
        return this.digestAlgorithmUri;
    }

    public String toString() {
        return this.toString(0, new StringBuffer()).toString();
    }

    public StringBuffer toString(int n, StringBuffer stringBuffer) {
        String string = PolicyUtils.Text.createIndent(n);
        String string2 = PolicyUtils.Text.createIndent(n + 1);
        stringBuffer.append(string).append("reference data {").append(PolicyUtils.Text.NEW_LINE);
        stringBuffer.append(string2).append("referenced policy model URI = '").append(this.referencedModelUri).append('\'').append(PolicyUtils.Text.NEW_LINE);
        if (this.digest == null) {
            stringBuffer.append(string2).append("no digest specified").append(PolicyUtils.Text.NEW_LINE);
        } else {
            stringBuffer.append(string2).append("digest algorith URI = '").append(this.digestAlgorithmUri).append('\'').append(PolicyUtils.Text.NEW_LINE);
            stringBuffer.append(string2).append("digest = '").append(this.digest).append('\'').append(PolicyUtils.Text.NEW_LINE);
        }
        stringBuffer.append(string).append('}');
        return stringBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        URISyntaxException uRISyntaxException = null;
        URI uRI = null;
        try {
            uRI = new URI("http://schemas.xmlsoap.org/ws/2004/09/policy/Sha1Exc");
        }
        catch (URISyntaxException uRISyntaxException2) {
            uRISyntaxException = uRISyntaxException2;
        }
        finally {
            DEFAULT_DIGEST_ALGORITHM_URI = uRI;
            CLASS_INITIALIZATION_EXCEPTION = uRISyntaxException;
        }
    }
}

