/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.effect;

import com.sun.javafx.effect.EffectDirtyBits;
import com.sun.javafx.geom.BaseBounds;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.scene.BoundsAccessor;
import javafx.beans.Observable;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.scene.Node;
import javafx.scene.effect.EffectChangeListener;

public abstract class Effect {
    private com.sun.scenario.effect.Effect peer;
    private IntegerProperty effectDirty = new SimpleIntegerProperty(this, "effectDirty");

    protected Effect() {
        this.markDirty(EffectDirtyBits.EFFECT_DIRTY);
    }

    void effectBoundsChanged() {
        this.toggleDirty(EffectDirtyBits.BOUNDS_CHANGED);
    }

    abstract com.sun.scenario.effect.Effect impl_createImpl();

    @Deprecated
    public com.sun.scenario.effect.Effect impl_getImpl() {
        if (this.peer == null) {
            this.peer = this.impl_createImpl();
        }
        return this.peer;
    }

    private void setEffectDirty(int n) {
        this.impl_effectDirtyProperty().set(n);
    }

    @Deprecated
    public final IntegerProperty impl_effectDirtyProperty() {
        return this.effectDirty;
    }

    @Deprecated
    public final boolean impl_isEffectDirty() {
        return this.isEffectDirty(EffectDirtyBits.EFFECT_DIRTY);
    }

    final void markDirty(EffectDirtyBits effectDirtyBits) {
        this.setEffectDirty(this.effectDirty.get() | effectDirtyBits.getMask());
    }

    private void toggleDirty(EffectDirtyBits effectDirtyBits) {
        this.setEffectDirty(this.effectDirty.get() ^ effectDirtyBits.getMask());
    }

    private boolean isEffectDirty(EffectDirtyBits effectDirtyBits) {
        return (this.effectDirty.get() & effectDirtyBits.getMask()) != 0;
    }

    private void clearEffectDirty(EffectDirtyBits effectDirtyBits) {
        this.setEffectDirty(this.effectDirty.get() & ~effectDirtyBits.getMask());
    }

    @Deprecated
    public final void impl_sync() {
        if (this.isEffectDirty(EffectDirtyBits.EFFECT_DIRTY)) {
            this.impl_update();
            this.clearEffectDirty(EffectDirtyBits.EFFECT_DIRTY);
        }
    }

    abstract void impl_update();

    abstract boolean impl_checkChainContains(Effect var1);

    boolean impl_containsCycles(Effect effect) {
        return effect != null && (effect == this || effect.impl_checkChainContains(this));
    }

    @Deprecated
    public abstract BaseBounds impl_getBounds(BaseBounds var1, BaseTransform var2, Node var3, BoundsAccessor var4);

    @Deprecated
    public abstract Effect impl_copy();

    class EffectInputProperty
    extends ObjectPropertyBase<Effect> {
        private final String propertyName;
        private Effect validInput = null;
        private final EffectInputChangeListener effectChangeListener = new EffectInputChangeListener();

        public EffectInputProperty(String string) {
            this.propertyName = string;
        }

        @Override
        public void invalidated() {
            Effect effect = (Effect)super.get();
            if (Effect.this.impl_containsCycles(effect)) {
                if (this.isBound()) {
                    this.unbind();
                    this.set(this.validInput);
                    throw new IllegalArgumentException("Cycle in effect chain detected, binding was set to incorrect value, unbinding the input property");
                }
                this.set(this.validInput);
                throw new IllegalArgumentException("Cycle in effect chain detected");
            }
            this.validInput = effect;
            this.effectChangeListener.register(effect);
            Effect.this.markDirty(EffectDirtyBits.EFFECT_DIRTY);
            Effect.this.effectBoundsChanged();
        }

        @Override
        public Object getBean() {
            return Effect.this;
        }

        @Override
        public String getName() {
            return this.propertyName;
        }
    }

    class EffectInputChangeListener
    extends EffectChangeListener {
        private int oldBits;

        EffectInputChangeListener() {
        }

        public void register(Effect effect) {
            super.register(effect == null ? null : effect.impl_effectDirtyProperty());
            if (effect != null) {
                this.oldBits = effect.impl_effectDirtyProperty().get();
            }
        }

        @Override
        public void invalidated(Observable observable) {
            int n = ((IntegerProperty)observable).get();
            int n2 = n ^ this.oldBits;
            this.oldBits = n;
            if (EffectDirtyBits.isSet(n2, EffectDirtyBits.EFFECT_DIRTY) && EffectDirtyBits.isSet(n, EffectDirtyBits.EFFECT_DIRTY)) {
                Effect.this.markDirty(EffectDirtyBits.EFFECT_DIRTY);
            }
            if (EffectDirtyBits.isSet(n2, EffectDirtyBits.BOUNDS_CHANGED)) {
                Effect.this.toggleDirty(EffectDirtyBits.BOUNDS_CHANGED);
            }
        }
    }
}

