/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.behavior;

import com.sun.javafx.PlatformUtil;
import com.sun.javafx.scene.control.behavior.BehaviorBase;
import com.sun.javafx.scene.control.behavior.KeyBinding;
import com.sun.javafx.scene.control.behavior.TreeCellBehavior;
import java.util.ArrayList;
import java.util.List;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.scene.control.FocusModel;
import javafx.scene.control.MultipleSelectionModel;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.util.Callback;

public class TreeViewBehavior<T>
extends BehaviorBase<TreeView<T>> {
    protected static final List<KeyBinding> TREE_VIEW_BINDINGS = new ArrayList<KeyBinding>();
    private boolean isShiftDown = false;
    private boolean isCtrlDown = false;
    private Callback<Integer, Integer> onScrollPageUp;
    private Callback<Integer, Integer> onScrollPageDown;
    private Runnable onSelectPreviousRow;
    private Runnable onSelectNextRow;
    private Runnable onMoveToFirstCell;
    private Runnable onMoveToLastCell;
    private Runnable onFocusPreviousRow;
    private Runnable onFocusNextRow;
    private boolean selectionChanging = false;
    private ListChangeListener<Integer> selectedIndicesListener = new ListChangeListener<Integer>(){

        @Override
        public void onChanged(ListChangeListener.Change change) {
            block0: while (change.next()) {
                if (!TreeViewBehavior.this.selectionChanging) {
                    if (change.getList().isEmpty()) {
                        TreeViewBehavior.this.setAnchor(-1);
                    } else if (!change.getList().contains(TreeViewBehavior.this.getAnchor())) {
                        TreeViewBehavior.this.setAnchor(-1);
                    }
                }
                int n = change.getAddedSize();
                if (TreeViewBehavior.this.hasAnchor() || n <= 0) continue;
                List list = change.getAddedSubList();
                for (int i = 0; i < n; ++i) {
                    int n2 = (Integer)list.get(i);
                    if (n2 < 0) continue;
                    TreeViewBehavior.this.setAnchor(n2);
                    continue block0;
                }
            }
        }
    };

    @Override
    protected void callAction(String string) {
        if ("SelectPreviousRow".equals(string)) {
            this.selectPreviousRow();
        } else if ("SelectNextRow".equals(string)) {
            this.selectNextRow();
        } else if ("SelectFirstRow".equals(string)) {
            this.selectFirstRow();
        } else if ("SelectLastRow".equals(string)) {
            this.selectLastRow();
        } else if ("SelectAllPageUp".equals(string)) {
            this.selectAllPageUp();
        } else if ("SelectAllPageDown".equals(string)) {
            this.selectAllPageDown();
        } else if ("SelectAllToFirstRow".equals(string)) {
            this.selectAllToFirstRow();
        } else if ("SelectAllToLastRow".equals(string)) {
            this.selectAllToLastRow();
        } else if ("AlsoSelectNextRow".equals(string)) {
            this.alsoSelectNextRow();
        } else if ("AlsoSelectPreviousRow".equals(string)) {
            this.alsoSelectPreviousRow();
        } else if ("ClearSelection".equals(string)) {
            this.clearSelection();
        } else if ("SelectAll".equals(string)) {
            this.selectAll();
        } else if ("ScrollUp".equals(string)) {
            this.scrollUp();
        } else if ("ScrollDown".equals(string)) {
            this.scrollDown();
        } else if ("ExpandRow".equals(string)) {
            this.expandRow();
        } else if ("CollapseRow".equals(string)) {
            this.collapseRow();
        } else if ("ExpandAll".equals(string)) {
            this.expandAll();
        } else if ("Edit".equals(string)) {
            this.edit();
        } else if ("CancelEdit".equals(string)) {
            this.cancelEdit();
        } else if ("FocusFirstRow".equals(string)) {
            this.focusFirstRow();
        } else if ("FocusLastRow".equals(string)) {
            this.focusLastRow();
        } else if ("toggleFocusOwnerSelection".equals(string)) {
            this.toggleFocusOwnerSelection();
        } else if ("SelectAllToFocus".equals(string)) {
            this.selectAllToFocus();
        } else if ("FocusPageUp".equals(string)) {
            this.focusPageUp();
        } else if ("FocusPageDown".equals(string)) {
            this.focusPageDown();
        } else if ("FocusPreviousRow".equals(string)) {
            this.focusPreviousRow();
        } else if ("FocusNextRow".equals(string)) {
            this.focusNextRow();
        } else if ("DiscontinuousSelectNextRow".equals(string)) {
            this.discontinuousSelectNextRow();
        } else if ("DiscontinuousSelectPreviousRow".equals(string)) {
            this.discontinuousSelectPreviousRow();
        } else if ("DiscontinuousSelectPageUp".equals(string)) {
            this.discontinuousSelectPageUp();
        } else if ("DiscontinuousSelectPageDown".equals(string)) {
            this.discontinuousSelectPageDown();
        } else if ("DiscontinuousSelectAllToLastRow".equals(string)) {
            this.discontinuousSelectAllToLastRow();
        } else if ("DiscontinuousSelectAllToFirstRow".equals(string)) {
            this.discontinuousSelectAllToFirstRow();
        } else {
            super.callAction(string);
        }
    }

    @Override
    protected List<KeyBinding> createKeyBindings() {
        return TREE_VIEW_BINDINGS;
    }

    @Override
    protected void callActionForEvent(KeyEvent keyEvent) {
        this.isShiftDown = keyEvent.getEventType() == KeyEvent.KEY_PRESSED && keyEvent.isShiftDown();
        this.isCtrlDown = keyEvent.getEventType() == KeyEvent.KEY_PRESSED && keyEvent.isControlDown();
        super.callActionForEvent(keyEvent);
    }

    public void setOnScrollPageUp(Callback<Integer, Integer> callback) {
        this.onScrollPageUp = callback;
    }

    public void setOnScrollPageDown(Callback<Integer, Integer> callback) {
        this.onScrollPageDown = callback;
    }

    public void setOnSelectPreviousRow(Runnable runnable) {
        this.onSelectPreviousRow = runnable;
    }

    public void setOnSelectNextRow(Runnable runnable) {
        this.onSelectNextRow = runnable;
    }

    public void setOnMoveToFirstCell(Runnable runnable) {
        this.onMoveToFirstCell = runnable;
    }

    public void setOnMoveToLastCell(Runnable runnable) {
        this.onMoveToLastCell = runnable;
    }

    public void setOnFocusPreviousRow(Runnable runnable) {
        this.onFocusPreviousRow = runnable;
    }

    public void setOnFocusNextRow(Runnable runnable) {
        this.onFocusNextRow = runnable;
    }

    public TreeViewBehavior(TreeView treeView) {
        super(treeView);
        ((TreeView)this.getControl()).selectionModelProperty().addListener(new ChangeListener<MultipleSelectionModel<TreeItem<T>>>(){

            @Override
            public void changed(ObservableValue<? extends MultipleSelectionModel<TreeItem<T>>> observableValue, MultipleSelectionModel<TreeItem<T>> multipleSelectionModel, MultipleSelectionModel<TreeItem<T>> multipleSelectionModel2) {
                if (multipleSelectionModel != null) {
                    multipleSelectionModel.getSelectedIndices().removeListener(TreeViewBehavior.this.selectedIndicesListener);
                }
                if (multipleSelectionModel2 != null) {
                    multipleSelectionModel2.getSelectedIndices().addListener(TreeViewBehavior.this.selectedIndicesListener);
                }
            }
        });
        if (treeView.getSelectionModel() != null) {
            treeView.getSelectionModel().getSelectedIndices().addListener(this.selectedIndicesListener);
        }
    }

    private void setAnchor(int n) {
        TreeCellBehavior.setAnchor((TreeView)this.getControl(), n);
    }

    private int getAnchor() {
        return TreeCellBehavior.getAnchor((TreeView)this.getControl());
    }

    private boolean hasAnchor() {
        return TreeCellBehavior.hasAnchor((TreeView)this.getControl());
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        super.mousePressed(mouseEvent);
        if (!mouseEvent.isShiftDown()) {
            int n = ((TreeView)this.getControl()).getSelectionModel().getSelectedIndex();
            this.setAnchor(n);
        }
        if (!((TreeView)this.getControl()).isFocused() && ((TreeView)this.getControl()).isFocusTraversable()) {
            ((TreeView)this.getControl()).requestFocus();
        }
    }

    private void clearSelection() {
        ((TreeView)this.getControl()).getSelectionModel().clearSelection();
    }

    private void scrollUp() {
        int n = -1;
        if (this.onScrollPageUp != null) {
            n = this.onScrollPageUp.call(this.getAnchor());
        }
        if (n == -1) {
            return;
        }
        MultipleSelectionModel multipleSelectionModel = ((TreeView)this.getControl()).getSelectionModel();
        if (multipleSelectionModel == null) {
            return;
        }
        multipleSelectionModel.clearAndSelect(n);
    }

    private void scrollDown() {
        int n = -1;
        if (this.onScrollPageDown != null) {
            n = this.onScrollPageDown.call(this.getAnchor());
        }
        if (n == -1) {
            return;
        }
        MultipleSelectionModel multipleSelectionModel = ((TreeView)this.getControl()).getSelectionModel();
        if (multipleSelectionModel == null) {
            return;
        }
        multipleSelectionModel.clearAndSelect(n);
    }

    private void focusFirstRow() {
        FocusModel focusModel = ((TreeView)this.getControl()).getFocusModel();
        if (focusModel == null) {
            return;
        }
        focusModel.focus(0);
        if (this.onMoveToFirstCell != null) {
            this.onMoveToFirstCell.run();
        }
    }

    private void focusLastRow() {
        FocusModel focusModel = ((TreeView)this.getControl()).getFocusModel();
        if (focusModel == null) {
            return;
        }
        focusModel.focus(((TreeView)this.getControl()).impl_getTreeItemCount() - 1);
        if (this.onMoveToLastCell != null) {
            this.onMoveToLastCell.run();
        }
    }

    private void focusPreviousRow() {
        FocusModel focusModel = ((TreeView)this.getControl()).getFocusModel();
        if (focusModel == null) {
            return;
        }
        MultipleSelectionModel multipleSelectionModel = ((TreeView)this.getControl()).getSelectionModel();
        if (multipleSelectionModel == null) {
            return;
        }
        focusModel.focusPrevious();
        if (!this.isCtrlDown || this.getAnchor() == -1) {
            this.setAnchor(focusModel.getFocusedIndex());
        }
        if (this.onFocusPreviousRow != null) {
            this.onFocusPreviousRow.run();
        }
    }

    private void focusNextRow() {
        FocusModel focusModel = ((TreeView)this.getControl()).getFocusModel();
        if (focusModel == null) {
            return;
        }
        MultipleSelectionModel multipleSelectionModel = ((TreeView)this.getControl()).getSelectionModel();
        if (multipleSelectionModel == null) {
            return;
        }
        focusModel.focusNext();
        if (!this.isCtrlDown || this.getAnchor() == -1) {
            this.setAnchor(focusModel.getFocusedIndex());
        }
        if (this.onFocusNextRow != null) {
            this.onFocusNextRow.run();
        }
    }

    private void focusPageUp() {
        int n = this.onScrollPageUp.call(this.getAnchor());
        FocusModel focusModel = ((TreeView)this.getControl()).getFocusModel();
        if (focusModel == null) {
            return;
        }
        focusModel.focus(n);
    }

    private void focusPageDown() {
        int n = this.onScrollPageDown.call(this.getAnchor());
        FocusModel focusModel = ((TreeView)this.getControl()).getFocusModel();
        if (focusModel == null) {
            return;
        }
        focusModel.focus(n);
    }

    private void alsoSelectPreviousRow() {
        FocusModel focusModel = ((TreeView)this.getControl()).getFocusModel();
        if (focusModel == null) {
            return;
        }
        MultipleSelectionModel multipleSelectionModel = ((TreeView)this.getControl()).getSelectionModel();
        if (multipleSelectionModel == null) {
            return;
        }
        if (this.isShiftDown && this.getAnchor() != -1) {
            int n = focusModel.getFocusedIndex() - 1;
            int n2 = this.getAnchor();
            if (!this.hasAnchor()) {
                this.setAnchor(focusModel.getFocusedIndex());
            }
            this.clearSelectionOutsideRange(n2, n);
            if (n2 > n) {
                multipleSelectionModel.selectRange(n2, n - 1);
            } else {
                multipleSelectionModel.selectRange(n2, n + 1);
            }
        } else {
            multipleSelectionModel.selectPrevious();
        }
        this.onSelectPreviousRow.run();
    }

    private void alsoSelectNextRow() {
        FocusModel focusModel = ((TreeView)this.getControl()).getFocusModel();
        if (focusModel == null) {
            return;
        }
        MultipleSelectionModel multipleSelectionModel = ((TreeView)this.getControl()).getSelectionModel();
        if (multipleSelectionModel == null) {
            return;
        }
        if (this.isShiftDown && this.getAnchor() != -1) {
            int n = focusModel.getFocusedIndex() + 1;
            int n2 = this.getAnchor();
            if (!this.hasAnchor()) {
                this.setAnchor(focusModel.getFocusedIndex());
            }
            this.clearSelectionOutsideRange(n2, n);
            if (n2 > n) {
                multipleSelectionModel.selectRange(n2, n - 1);
            } else {
                multipleSelectionModel.selectRange(n2, n + 1);
            }
        } else {
            multipleSelectionModel.selectNext();
        }
        this.onSelectNextRow.run();
    }

    private void clearSelectionOutsideRange(int n, int n2) {
        MultipleSelectionModel multipleSelectionModel = ((TreeView)this.getControl()).getSelectionModel();
        if (multipleSelectionModel == null) {
            return;
        }
        int n3 = Math.min(n, n2);
        int n4 = Math.max(n, n2);
        ArrayList<Integer> arrayList = new ArrayList<Integer>(multipleSelectionModel.getSelectedIndices());
        this.selectionChanging = true;
        for (int i = 0; i < arrayList.size(); ++i) {
            int n5 = (Integer)arrayList.get(i);
            if (n5 >= n3 && n5 < n4) continue;
            multipleSelectionModel.clearSelection(n5);
        }
        this.selectionChanging = false;
    }

    private void selectPreviousRow() {
        FocusModel focusModel = ((TreeView)this.getControl()).getFocusModel();
        if (focusModel == null) {
            return;
        }
        int n = focusModel.getFocusedIndex();
        if (n <= 0) {
            return;
        }
        this.setAnchor(n - 1);
        ((TreeView)this.getControl()).getSelectionModel().clearAndSelect(n - 1);
        this.onSelectPreviousRow.run();
    }

    private void selectNextRow() {
        FocusModel focusModel = ((TreeView)this.getControl()).getFocusModel();
        if (focusModel == null) {
            return;
        }
        int n = focusModel.getFocusedIndex();
        if (n == ((TreeView)this.getControl()).impl_getTreeItemCount() - 1) {
            return;
        }
        this.setAnchor(n + 1);
        ((TreeView)this.getControl()).getSelectionModel().clearAndSelect(n + 1);
        this.onSelectNextRow.run();
    }

    private void selectFirstRow() {
        if (((TreeView)this.getControl()).impl_getTreeItemCount() > 0) {
            ((TreeView)this.getControl()).getSelectionModel().clearAndSelect(0);
            if (this.onMoveToFirstCell != null) {
                this.onMoveToFirstCell.run();
            }
        }
    }

    private void selectLastRow() {
        ((TreeView)this.getControl()).getSelectionModel().clearAndSelect(((TreeView)this.getControl()).impl_getTreeItemCount() - 1);
        this.onMoveToLastCell.run();
    }

    private void selectAllToFirstRow() {
        MultipleSelectionModel multipleSelectionModel = ((TreeView)this.getControl()).getSelectionModel();
        if (multipleSelectionModel == null) {
            return;
        }
        int n = multipleSelectionModel.getSelectedIndex();
        if (this.isShiftDown) {
            n = this.getAnchor() == -1 ? multipleSelectionModel.getSelectedIndex() : this.getAnchor();
        }
        multipleSelectionModel.clearSelection();
        multipleSelectionModel.selectRange(0, n + 1);
        if (this.isShiftDown) {
            this.setAnchor(n);
        }
        if (this.onMoveToFirstCell != null) {
            this.onMoveToFirstCell.run();
        }
    }

    private void selectAllToLastRow() {
        MultipleSelectionModel multipleSelectionModel = ((TreeView)this.getControl()).getSelectionModel();
        if (multipleSelectionModel == null) {
            return;
        }
        int n = multipleSelectionModel.getSelectedIndex();
        if (this.isShiftDown) {
            n = this.getAnchor() == -1 ? multipleSelectionModel.getSelectedIndex() : this.getAnchor();
        }
        multipleSelectionModel.clearSelection();
        multipleSelectionModel.selectRange(n, ((TreeView)this.getControl()).impl_getTreeItemCount() - 1);
        if (this.isShiftDown) {
            this.setAnchor(n);
        }
        if (this.onMoveToLastCell != null) {
            this.onMoveToLastCell.run();
        }
    }

    private void selectAll() {
        ((TreeView)this.getControl()).getSelectionModel().selectAll();
    }

    private void selectAllPageUp() {
        FocusModel focusModel = ((TreeView)this.getControl()).getFocusModel();
        if (focusModel == null) {
            return;
        }
        int n = focusModel.getFocusedIndex();
        if (this.isShiftDown) {
            n = this.getAnchor() == -1 ? n : this.getAnchor();
            this.setAnchor(n);
        }
        int n2 = this.onScrollPageUp.call(this.getAnchor());
        MultipleSelectionModel multipleSelectionModel = ((TreeView)this.getControl()).getSelectionModel();
        if (multipleSelectionModel == null) {
            return;
        }
        this.selectionChanging = true;
        multipleSelectionModel.clearSelection();
        multipleSelectionModel.selectRange(n2, n + 1);
        this.selectionChanging = false;
    }

    private void selectAllPageDown() {
        FocusModel focusModel = ((TreeView)this.getControl()).getFocusModel();
        if (focusModel == null) {
            return;
        }
        int n = focusModel.getFocusedIndex();
        if (this.isShiftDown) {
            n = this.getAnchor() == -1 ? n : this.getAnchor();
            this.setAnchor(n);
        }
        int n2 = this.onScrollPageDown.call(this.getAnchor());
        MultipleSelectionModel multipleSelectionModel = ((TreeView)this.getControl()).getSelectionModel();
        if (multipleSelectionModel == null) {
            return;
        }
        this.selectionChanging = true;
        multipleSelectionModel.clearSelection();
        multipleSelectionModel.selectRange(n, n2 + 1);
        this.selectionChanging = false;
    }

    private void selectAllToFocus() {
        MultipleSelectionModel multipleSelectionModel = ((TreeView)this.getControl()).getSelectionModel();
        if (multipleSelectionModel == null) {
            return;
        }
        FocusModel focusModel = ((TreeView)this.getControl()).getFocusModel();
        if (focusModel == null) {
            return;
        }
        int n = focusModel.getFocusedIndex();
        int n2 = this.getAnchor();
        multipleSelectionModel.clearSelection();
        int n3 = n2;
        int n4 = n2 > n ? n - 1 : n + 1;
        multipleSelectionModel.selectRange(n3, n4);
        this.setAnchor(n2);
    }

    private void expandRow() {
        MultipleSelectionModel multipleSelectionModel = ((TreeView)this.getControl()).getSelectionModel();
        if (multipleSelectionModel == null) {
            return;
        }
        TreeItem treeItem = (TreeItem)multipleSelectionModel.getSelectedItem();
        if (treeItem == null || treeItem.isLeaf()) {
            return;
        }
        if (treeItem.isExpanded()) {
            ObservableList observableList = treeItem.getChildren();
            if (!observableList.isEmpty()) {
                multipleSelectionModel.clearAndSelect(((TreeView)this.getControl()).getRow((TreeItem)observableList.get(0)));
            }
        } else {
            treeItem.setExpanded(true);
        }
    }

    private void expandAll() {
        TreeItem treeItem = ((TreeView)this.getControl()).getRoot();
        if (treeItem == null) {
            return;
        }
        treeItem.setExpanded(true);
        this.expandChildren(treeItem);
    }

    private void expandChildren(TreeItem treeItem) {
        if (treeItem == null) {
            return;
        }
        ObservableList observableList = treeItem.getChildren();
        if (observableList == null) {
            return;
        }
        for (int i = 0; i < observableList.size(); ++i) {
            TreeItem treeItem2 = (TreeItem)observableList.get(i);
            if (treeItem2 == null || treeItem2.isLeaf()) continue;
            treeItem2.setExpanded(true);
            this.expandChildren(treeItem2);
        }
    }

    private void collapseRow() {
        TreeItem treeItem = (TreeItem)((TreeView)this.getControl()).getSelectionModel().getSelectedItem();
        if (treeItem == null) {
            return;
        }
        TreeItem treeItem2 = ((TreeView)this.getControl()).getRoot();
        if (treeItem2 == null) {
            return;
        }
        if (!((TreeView)this.getControl()).isShowRoot() && !treeItem.isExpanded() && treeItem2.equals(treeItem.getParent())) {
            return;
        }
        if (treeItem2.equals(treeItem) && (!treeItem2.isExpanded() || treeItem2.getChildren().isEmpty())) {
            return;
        }
        if (treeItem.isLeaf() || !treeItem.isExpanded()) {
            ((TreeView)this.getControl()).getSelectionModel().clearSelection();
            ((TreeView)this.getControl()).getSelectionModel().select(treeItem.getParent());
        } else {
            treeItem.setExpanded(false);
        }
    }

    private void cancelEdit() {
        ((TreeView)this.getControl()).edit(null);
    }

    private void edit() {
        TreeItem treeItem = (TreeItem)((TreeView)this.getControl()).getSelectionModel().getSelectedItem();
        if (treeItem == null) {
            return;
        }
        ((TreeView)this.getControl()).edit(treeItem);
    }

    private void toggleFocusOwnerSelection() {
        MultipleSelectionModel multipleSelectionModel = ((TreeView)this.getControl()).getSelectionModel();
        if (multipleSelectionModel == null) {
            return;
        }
        FocusModel focusModel = ((TreeView)this.getControl()).getFocusModel();
        if (focusModel == null) {
            return;
        }
        int n = focusModel.getFocusedIndex();
        if (multipleSelectionModel.isSelected(n)) {
            multipleSelectionModel.clearSelection(n);
            focusModel.focus(n);
        } else {
            multipleSelectionModel.select(n);
        }
        this.setAnchor(n);
    }

    private void discontinuousSelectPreviousRow() {
        MultipleSelectionModel multipleSelectionModel = ((TreeView)this.getControl()).getSelectionModel();
        if (multipleSelectionModel == null) {
            return;
        }
        FocusModel focusModel = ((TreeView)this.getControl()).getFocusModel();
        if (focusModel == null) {
            return;
        }
        int n = focusModel.getFocusedIndex() - 1;
        if (n < 0) {
            return;
        }
        multipleSelectionModel.select(n);
    }

    private void discontinuousSelectNextRow() {
        MultipleSelectionModel multipleSelectionModel = ((TreeView)this.getControl()).getSelectionModel();
        if (multipleSelectionModel == null) {
            return;
        }
        FocusModel focusModel = ((TreeView)this.getControl()).getFocusModel();
        if (focusModel == null) {
            return;
        }
        int n = focusModel.getFocusedIndex() + 1;
        multipleSelectionModel.select(n);
    }

    private void discontinuousSelectPageUp() {
        MultipleSelectionModel multipleSelectionModel = ((TreeView)this.getControl()).getSelectionModel();
        if (multipleSelectionModel == null) {
            return;
        }
        FocusModel focusModel = ((TreeView)this.getControl()).getFocusModel();
        if (focusModel == null) {
            return;
        }
        int n = focusModel.getFocusedIndex();
        int n2 = this.onScrollPageUp.call(this.getAnchor());
        multipleSelectionModel.selectRange(n2, n + 1);
    }

    private void discontinuousSelectPageDown() {
        MultipleSelectionModel multipleSelectionModel = ((TreeView)this.getControl()).getSelectionModel();
        if (multipleSelectionModel == null) {
            return;
        }
        FocusModel focusModel = ((TreeView)this.getControl()).getFocusModel();
        if (focusModel == null) {
            return;
        }
        int n = focusModel.getFocusedIndex();
        int n2 = this.onScrollPageDown.call(this.getAnchor());
        multipleSelectionModel.selectRange(n, n2 + 1);
    }

    private void discontinuousSelectAllToFirstRow() {
        MultipleSelectionModel multipleSelectionModel = ((TreeView)this.getControl()).getSelectionModel();
        if (multipleSelectionModel == null) {
            return;
        }
        FocusModel focusModel = ((TreeView)this.getControl()).getFocusModel();
        if (focusModel == null) {
            return;
        }
        int n = focusModel.getFocusedIndex();
        multipleSelectionModel.selectRange(0, n);
        if (this.onMoveToFirstCell != null) {
            this.onMoveToFirstCell.run();
        }
    }

    private void discontinuousSelectAllToLastRow() {
        MultipleSelectionModel multipleSelectionModel = ((TreeView)this.getControl()).getSelectionModel();
        if (multipleSelectionModel == null) {
            return;
        }
        FocusModel focusModel = ((TreeView)this.getControl()).getFocusModel();
        if (focusModel == null) {
            return;
        }
        int n = focusModel.getFocusedIndex() + 1;
        multipleSelectionModel.selectRange(n, ((TreeView)this.getControl()).impl_getTreeItemCount());
        if (this.onMoveToLastCell != null) {
            this.onMoveToLastCell.run();
        }
    }

    static {
        TREE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.TAB, "TraverseNext"));
        TREE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.TAB, "TraversePrevious").shift());
        TREE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.HOME, "SelectFirstRow"));
        TREE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.END, "SelectLastRow"));
        TREE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.HOME, "SelectAllToFirstRow").shift());
        TREE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.END, "SelectAllToLastRow").shift());
        TREE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.PAGE_UP, "SelectAllPageUp").shift());
        TREE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.PAGE_DOWN, "SelectAllPageDown").shift());
        TREE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.SPACE, "SelectAllToFocus").shift());
        TREE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.HOME, "FocusFirstRow").ctrl());
        TREE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.END, "FocusLastRow").ctrl());
        TREE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.PAGE_UP, "ScrollUp"));
        TREE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.PAGE_DOWN, "ScrollDown"));
        if (PlatformUtil.isMac()) {
            TREE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.A, "SelectAll").meta());
            TREE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.SPACE, "toggleFocusOwnerSelection").ctrl().meta());
            TREE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.PAGE_UP, "FocusPageUp").meta());
            TREE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.PAGE_DOWN, "FocusPageDown").meta());
            TREE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.UP, "FocusPreviousRow").meta());
            TREE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.DOWN, "FocusNextRow").meta());
            TREE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.UP, "DiscontinuousSelectPreviousRow").meta().shift());
            TREE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.DOWN, "DiscontinuousSelectNextRow").meta().shift());
            TREE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.PAGE_UP, "DiscontinuousSelectPageUp").meta().shift());
            TREE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.PAGE_DOWN, "DiscontinuousSelectPageDown").meta().shift());
            TREE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.HOME, "DiscontinuousSelectAllToFirstRow").meta().shift());
            TREE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.END, "DiscontinuousSelectAllToLastRow").meta().shift());
        } else {
            TREE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.A, "SelectAll").ctrl());
            TREE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.SPACE, "toggleFocusOwnerSelection").ctrl());
            TREE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.PAGE_UP, "FocusPageUp").ctrl());
            TREE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.PAGE_DOWN, "FocusPageDown").ctrl());
            TREE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.UP, "FocusPreviousRow").ctrl());
            TREE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.DOWN, "FocusNextRow").ctrl());
            TREE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.UP, "DiscontinuousSelectPreviousRow").ctrl().shift());
            TREE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.DOWN, "DiscontinuousSelectNextRow").ctrl().shift());
            TREE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.PAGE_UP, "DiscontinuousSelectPageUp").ctrl().shift());
            TREE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.PAGE_DOWN, "DiscontinuousSelectPageDown").ctrl().shift());
            TREE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.HOME, "DiscontinuousSelectAllToFirstRow").ctrl().shift());
            TREE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.END, "DiscontinuousSelectAllToLastRow").ctrl().shift());
        }
        TREE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.LEFT, "CollapseRow"));
        TREE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.KP_LEFT, "CollapseRow"));
        TREE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.RIGHT, "ExpandRow"));
        TREE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.KP_RIGHT, "ExpandRow"));
        TREE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.MULTIPLY, "ExpandAll"));
        TREE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.ADD, "ExpandRow"));
        TREE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.SUBTRACT, "CollapseRow"));
        TREE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.UP, "SelectPreviousRow"));
        TREE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.KP_UP, "SelectPreviousRow"));
        TREE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.DOWN, "SelectNextRow"));
        TREE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.KP_DOWN, "SelectNextRow"));
        TREE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.UP, "AlsoSelectPreviousRow").shift());
        TREE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.KP_UP, "AlsoSelectPreviousRow").shift());
        TREE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.DOWN, "AlsoSelectNextRow").shift());
        TREE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.KP_DOWN, "AlsoSelectNextRow").shift());
        TREE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.ENTER, "Edit"));
        TREE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.F2, "Edit"));
        TREE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.ESCAPE, "CancelEdit"));
    }
}

