/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui;

import java.security.AccessController;
import java.security.PrivilegedAction;

public class Platform {
    public static final String MAC = "Mac";
    public static final String WINDOWS = "Win";
    public static final String X11 = "X11";
    public static final String GTK = "Gtk";
    public static final String UNKNOWN = "unknown";
    private static String type = null;

    public static synchronized String DeterminePlatform() {
        if (type == null) {
            String userPlatform = AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    return System.getProperty("glass.platform");
                }
            });
            if (userPlatform != null) {
                type = userPlatform.equals("macosx") ? MAC : (userPlatform.equals("windows") ? WINDOWS : (userPlatform.equals("linux") ? GTK : (userPlatform.equals("x11") ? X11 : (userPlatform.equals("gtk") ? GTK : userPlatform))));
                return type;
            }
            String osName = System.getProperty("os.name");
            String osNameLowerCase = osName.toLowerCase();
            if (osNameLowerCase.startsWith("mac") || osNameLowerCase.startsWith("darwin")) {
                type = MAC;
            } else if (osNameLowerCase.startsWith("wind")) {
                type = WINDOWS;
            } else if (osNameLowerCase.startsWith("linux")) {
                type = GTK;
            }
        }
        return type;
    }
}

