/*
 * Decompiled with CFR 0.152.
 */
package oracle.jrockit.jfr;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.util.concurrent.ConcurrentHashMap;
import oracle.jrockit.jfr.JFR;
import oracle.jrockit.jfr.Logger;

@Deprecated
public class StringConstantPool {
    private final Logger logger = Logger.loggerFor("jfr");
    private final ConcurrentHashMap<String, Integer> mappings = new ConcurrentHashMap();
    private final ByteBuffer data;
    private final JFR jfr;
    private final DataOutputStream out;
    private final int constantIndex;
    private final boolean emptyOnRotation;
    private volatile boolean enabled = false;
    private volatile boolean bufferFull = false;
    private static final int POSITION = 0;
    private static final int OFFSET = 4;
    private static final int DATA = 8;

    public StringConstantPool(JFR jFR, int n, int n2, boolean bl) {
        this.jfr = jFR;
        this.constantIndex = n;
        this.emptyOnRotation = bl;
        if (n2 == 0) {
            n2 = 0x200000;
        }
        this.data = ByteBuffer.allocateDirect(n2);
        this.data.putInt(0, 0);
        this.data.putInt(4, 1);
        this.out = new DataOutputStream(new OutputStream(){

            @Override
            public void write(byte[] byArray, int n, int n2) throws IOException {
                int n3;
                int n4;
                int n5;
                if (n2 > StringConstantPool.this.data.capacity() - 12) {
                    throw new OutOfMemoryError("Too large string");
                }
                do {
                    n5 = StringConstantPool.this.data.getInt(0);
                    n4 = StringConstantPool.this.data.getInt(n5);
                    if (n5 == 0) {
                        StringConstantPool.this.data.position(8);
                        n4 = StringConstantPool.this.data.getInt(4);
                    } else {
                        StringConstantPool.this.data.position(n5);
                    }
                    StringConstantPool.this.data.putInt(n4);
                    StringConstantPool.this.data.put(byArray, n, n2);
                    n3 = StringConstantPool.this.data.position();
                } while (StringConstantPool.this.data.getInt(0) != n5);
                StringConstantPool.this.data.putInt(n4 + 1);
                StringConstantPool.this.data.putInt(0, n3);
            }

            @Override
            public void write(int n) throws IOException {
            }
        });
    }

    public synchronized void enable() {
        if (!this.enabled) {
            this.enabled = true;
            this.jfr.addConstpool(this);
        }
    }

    public synchronized void disable() {
        if (this.enabled) {
            this.enabled = false;
            this.jfr.removeConstpool(this);
        }
    }

    public ByteBuffer getConstantData() {
        return this.data;
    }

    public int getConstantIndex() {
        return this.constantIndex;
    }

    public boolean emptyOnRotation() {
        return this.emptyOnRotation;
    }

    public int asConstant(String string) {
        if (string == null) {
            return 0;
        }
        Integer n;
        int n2;
        while ((n2 = this.data.getInt(0)) <= 0 || (n = this.mappings.get(string)) == null) {
            ByteBuffer byteBuffer = this.data;
            synchronized (byteBuffer) {
                n2 = this.data.getInt(0);
                if (n2 == 0) {
                    this.mappings.clear();
                } else {
                    n = this.mappings.get(string);
                    if (n != null) {
                        return n;
                    }
                }
                if (this.bufferFull) {
                    throw new OutOfMemoryError("String constant pool buffer full, and emptyOnRotation not set.");
                }
                try {
                    this.out.writeUTF(string);
                    n2 = this.data.getInt(0);
                    if (n2 == 0) {
                        continue;
                    }
                    int n3 = this.data.getInt(n2) - 1;
                    assert (n3 != 0);
                    this.mappings.put(string, n3);
                    return n3;
                }
                catch (BufferOverflowException bufferOverflowException) {
                    this.logger.trace("String constant pool buffer full. Storing in chunk.");
                    if (!this.jfr.storeConstpool(this)) {
                        this.logger.info("String constant pool store failed.");
                        this.logger.trace("String constant pool store failed at: ", Thread.currentThread().getStackTrace());
                    }
                    if (!this.emptyOnRotation) {
                        this.bufferFull = true;
                    }
                    // MONITOREXIT @DISABLED, blocks:[0, 2, 3, 6] lbl39 : MonitorExitStatement: MONITOREXIT : var4_4
                    continue;
                }
                catch (IOException iOException) {
                    throw new InternalError();
                }
            }
            break;
        }
        return n;
    }

    protected void finalize() throws Throwable {
        this.disable();
    }
}

