/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.com;

import java.awt.Component;
import java.beans.BeanInfo;
import java.beans.Beans;
import java.beans.EventSetDescriptor;
import java.beans.FeatureDescriptor;
import java.beans.Introspector;
import java.beans.MethodDescriptor;
import java.beans.ParameterDescriptor;
import java.beans.PropertyDescriptor;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Vector;
import sun.plugin.com.TypeMap;

public class Packager {
    private PrintStream ps;
    private File idlFile;
    private boolean isGUI;
    public static final int NONGUI_EXITCODE = 101;
    private String[] javaProps;
    private String[] notAllowedMethods;
    private String[] notAllowedProps;
    private String[] comProps;
    private HashMap methodMap;
    private HashMap eventMap;
    private HashMap overLoadedMap;

    Packager(String string, String string2) {
        block2: {
            this.ps = null;
            this.idlFile = null;
            this.isGUI = false;
            this.javaProps = new String[]{"background", "font", "foreground"};
            this.notAllowedMethods = new String[]{"enable", "disable", "class", "minimumSize", "preferredSize", "warning"};
            this.notAllowedProps = new String[]{"layout", "action"};
            this.comProps = new String[]{"[id(0xfffffe0b)]\nOLE_COLOR BackColor;", "[id(0xfffffe00)]\nFont* Font;", "[id(0xfffffdff)]\nOLE_COLOR ForeColor;"};
            this.methodMap = new HashMap();
            this.eventMap = new HashMap();
            this.overLoadedMap = new HashMap();
            try {
                String string3 = string.substring(string.lastIndexOf(46) + 1);
                this.idlFile = new File(string2 + File.separator + string3 + ".idl");
                this.ps = new PrintStream(new FileOutputStream(this.idlFile));
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                if (this.idlFile == null) break block2;
                this.idlFile.delete();
            }
        }
    }

    public static void main(String[] stringArray) {
        Packager packager = new Packager(stringArray[0], stringArray[1]);
        packager.generate(stringArray[0], stringArray[2], stringArray[3], stringArray[4], stringArray[5]);
        int n = 0;
        if (!packager.isGUI) {
            n = 101;
        }
        Runtime.getRuntime().exit(n);
    }

    public void generate(String string, String string2, String string3, String string4, String string5) {
        block3: {
            try {
                ClassLoader classLoader = this.getClass().getClassLoader();
                Object object = Beans.instantiate(classLoader, string);
                if (object instanceof Component) {
                    this.isGUI = true;
                }
                BeanInfo beanInfo = Introspector.getBeanInfo(object.getClass());
                int n = string.lastIndexOf(46);
                String string6 = string.substring(n + 1);
                this.ps.println("[");
                this.ps.println("uuid(" + string3.substring(1, string3.length() - 1) + "),");
                this.ps.println("version(1.0)");
                this.ps.println("]");
                this.ps.println("library " + string6);
                this.ps.println("{");
                this.ps.println("importlib(\"Stdole2.tlb\");");
                this.ps.println("dispinterface " + string6 + "Source;");
                this.ps.println("dispinterface " + string6 + "Dispatch;");
                this.ps.println("[");
                this.ps.println("uuid(" + string4.substring(1, string4.length() - 1) + "),");
                this.ps.println("version(1.0)");
                this.ps.println("]");
                this.ps.println("dispinterface " + string6 + "Source {");
                this.ps.println("properties:");
                this.ps.println("methods:");
                this.printEvents(beanInfo.getEventSetDescriptors());
                this.ps.println("};");
                this.ps.println("[");
                this.ps.println("uuid(" + string5.substring(1, string5.length() - 1) + "),");
                this.ps.println("version(1.0)");
                this.ps.println("]");
                this.ps.println("dispinterface " + string6 + "Dispatch {");
                this.ps.println("properties:");
                this.printProperties(beanInfo, true);
                this.ps.println("methods:");
                this.printProperties(beanInfo, false);
                this.printMethods(beanInfo.getMethodDescriptors(), 32768, this.methodMap);
                this.ps.println("};");
                this.ps.println("[");
                this.ps.println("uuid(" + string2.substring(1, string2.length() - 1) + "),");
                this.ps.println("version(1.0)");
                this.ps.println("]");
                this.ps.println("coclass " + string6 + " {");
                this.ps.println("[default, source] dispinterface " + string6 + "Source;");
                this.ps.println("[default] dispinterface " + string6 + "Dispatch;");
                this.ps.println("};");
                this.ps.println("};");
            }
            catch (Exception exception) {
                exception.printStackTrace();
                if (this.idlFile == null) break block3;
                this.idlFile.delete();
            }
        }
    }

    private void printMethods(MethodDescriptor[] methodDescriptorArray, int n, HashMap hashMap) {
        Method method;
        int n2;
        HashMap<String, Method> hashMap2 = new HashMap<String, Method>();
        for (n2 = 0; n2 < methodDescriptorArray.length; ++n2) {
            method = methodDescriptorArray[n2].getMethod();
            Method method2 = (Method)hashMap2.get(method.getName());
            if (method2 != null) {
                if (method2.getParameterTypes().length < method.getParameterTypes().length) {
                    this.overLoadedMap.put(method.getName(), method);
                } else {
                    this.overLoadedMap.put(method.getName(), method2);
                }
            }
            hashMap2.put(method.getName(), method);
        }
        Packager.sort(methodDescriptorArray);
        for (n2 = 0; n2 < methodDescriptorArray.length; ++n2) {
            Method method3;
            method = methodDescriptorArray[n2].getMethod();
            boolean bl = false;
            for (int i = 0; i < this.notAllowedMethods.length; ++i) {
                if (!method.getName().equals(this.notAllowedMethods[i])) continue;
                bl = true;
                break;
            }
            if (bl || (method3 = (Method)this.overLoadedMap.get(method.getName())) != null && !method.equals(method3)) continue;
            hashMap.put(method.getName(), method);
            if (method3 != null) {
                this.printOverLoadedMethod(methodDescriptorArray[n2], n + n2);
                continue;
            }
            this.printMethod(methodDescriptorArray[n2], n + n2);
        }
    }

    private void printOverLoadedMethod(MethodDescriptor methodDescriptor, int n) {
        Method method = methodDescriptor.getMethod();
        ParameterDescriptor[] parameterDescriptorArray = methodDescriptor.getParameterDescriptors();
        Class<?>[] classArray = method.getParameterTypes();
        StringBuffer stringBuffer = new StringBuffer("[id(" + n + ")]\n");
        stringBuffer.append("VARIANT " + method.getName() + "(");
        String string = ", ";
        for (int i = 0; i < classArray.length; ++i) {
            stringBuffer.append("[optional] VARIANT ");
            if (i == classArray.length - 1) {
                string = ");";
            }
            if (parameterDescriptorArray != null && parameterDescriptorArray[i] != null) {
                stringBuffer.append(parameterDescriptorArray[i].getName() + string);
                continue;
            }
            stringBuffer.append("var" + i + string);
        }
        if (classArray.length == 0) {
            stringBuffer.append(");");
        }
        this.ps.println(stringBuffer);
    }

    private void printMethod(MethodDescriptor methodDescriptor, int n) {
        Method method = methodDescriptor.getMethod();
        StringBuffer stringBuffer = new StringBuffer("[id(" + n + ")]\n");
        String string = TypeMap.getCOMType(method.getReturnType());
        stringBuffer.append(string + " " + method.getName() + "(");
        Class<?>[] classArray = method.getParameterTypes();
        ParameterDescriptor[] parameterDescriptorArray = methodDescriptor.getParameterDescriptors();
        String string2 = ", ";
        for (int i = 0; i < classArray.length; ++i) {
            stringBuffer.append(TypeMap.getCOMType(classArray[i]) + " ");
            if (i == classArray.length - 1) {
                string2 = ");";
            }
            if (parameterDescriptorArray != null && parameterDescriptorArray[i] != null) {
                stringBuffer.append(parameterDescriptorArray[i].getName() + string2);
                continue;
            }
            stringBuffer.append("arg" + i + string2);
        }
        if (classArray.length == 0) {
            stringBuffer.append(");");
        }
        this.ps.println(stringBuffer);
    }

    private void printEventMethods(MethodDescriptor[] methodDescriptorArray, int n, HashMap hashMap) {
        for (int i = 0; i < methodDescriptorArray.length; ++i) {
            Method method = methodDescriptorArray[i].getMethod();
            Method method2 = (Method)hashMap.get(method.getName());
            if (method2 != null) continue;
            hashMap.put(method.getName(), method);
            this.printMethod(methodDescriptorArray[i], n + i);
        }
    }

    private void printEvents(EventSetDescriptor[] eventSetDescriptorArray) {
        if (eventSetDescriptorArray == null) {
            return;
        }
        Object[] objectArray = null;
        Vector<Object> vector = new Vector<Object>();
        for (int i = 0; i < eventSetDescriptorArray.length; ++i) {
            objectArray = eventSetDescriptorArray[i].getListenerMethodDescriptors();
            for (int j = 0; j < objectArray.length; ++j) {
                vector.addElement(objectArray[j]);
            }
        }
        objectArray = vector.toArray(new MethodDescriptor[0]);
        Packager.sort(objectArray);
        this.printEventMethods((MethodDescriptor[])objectArray, 16384, this.eventMap);
    }

    private void printProperties(BeanInfo beanInfo, boolean bl) {
        Object[] objectArray = beanInfo.getPropertyDescriptors();
        Packager.sort(objectArray);
        int n = beanInfo.getDefaultPropertyIndex();
        for (int i = 0; i < objectArray.length; ++i) {
            Method method = ((PropertyDescriptor)objectArray[i]).getReadMethod();
            Method method2 = ((PropertyDescriptor)objectArray[i]).getWriteMethod();
            if (method != null && method2 != null && bl) {
                this.printProperty((PropertyDescriptor)objectArray[i], i, i == n);
            }
            if (bl || this.methodMap.get(((FeatureDescriptor)objectArray[i]).getName()) != null) continue;
            boolean bl2 = false;
            for (int j = 0; j < this.notAllowedMethods.length; ++j) {
                if (!((FeatureDescriptor)objectArray[i]).getName().equals(this.notAllowedMethods[j])) continue;
                bl2 = true;
            }
            bl2 = true;
            if (true) continue;
            if (method != null) {
                this.printGetProperty((PropertyDescriptor)objectArray[i], i, i == n);
                continue;
            }
            if (method2 == null) continue;
            this.printPutProperty((PropertyDescriptor)objectArray[i], i, i == n);
        }
    }

    private void printPropertyAttrib(PropertyDescriptor propertyDescriptor, int n, String string) {
        int n2 = 4096 + n;
        StringBuffer stringBuffer = new StringBuffer("[id(" + n2 + ")");
        if (string != null) {
            stringBuffer.append(", " + string);
        }
        if (propertyDescriptor.isBound()) {
            stringBuffer.append(", bindable");
        }
        if (propertyDescriptor.isConstrained()) {
            stringBuffer.append(", requestedit");
        }
        stringBuffer.append("]");
        this.ps.println(stringBuffer);
    }

    private void printProperty(PropertyDescriptor propertyDescriptor, int n, boolean bl) {
        int n2;
        for (n2 = 0; n2 < this.javaProps.length; ++n2) {
            if (!propertyDescriptor.getName().equals(this.javaProps[n2])) continue;
            this.ps.println(this.comProps[n2]);
            return;
        }
        for (n2 = 0; n2 < this.notAllowedProps.length; ++n2) {
            if (!propertyDescriptor.getName().equals(this.notAllowedProps[n2])) continue;
            return;
        }
        this.printPropertyAttrib(propertyDescriptor, n, null);
        StringBuffer stringBuffer = new StringBuffer();
        String string = TypeMap.getCOMType(propertyDescriptor.getPropertyType());
        stringBuffer.append(string + " " + propertyDescriptor.getName() + ";");
        this.ps.println(stringBuffer);
    }

    private void printGetProperty(PropertyDescriptor propertyDescriptor, int n, boolean bl) {
        Method method = propertyDescriptor.getReadMethod();
        this.methodMap.put(propertyDescriptor.getName(), method);
        this.printPropertyAttrib(propertyDescriptor, n, "propget");
        StringBuffer stringBuffer = new StringBuffer();
        String string = TypeMap.getCOMType(propertyDescriptor.getPropertyType());
        stringBuffer.append(string + " " + propertyDescriptor.getName() + "();");
        this.ps.println(stringBuffer);
    }

    private void printPutProperty(PropertyDescriptor propertyDescriptor, int n, boolean bl) {
        Method method = propertyDescriptor.getReadMethod();
        this.methodMap.put(propertyDescriptor.getName(), method);
        this.printPropertyAttrib(propertyDescriptor, n, "propput");
        StringBuffer stringBuffer = new StringBuffer();
        String string = TypeMap.getCOMType(propertyDescriptor.getPropertyType());
        stringBuffer.append("void " + propertyDescriptor.getName() + "(" + string + ");");
        this.ps.println(stringBuffer);
    }

    static void sort(Object[] objectArray) {
        Arrays.sort(objectArray, new Comparator(){

            public int compare(Object object, Object object2) {
                String string = ((FeatureDescriptor)object).getName();
                String string2 = ((FeatureDescriptor)object2).getName();
                return string.compareTo(string2);
            }
        });
    }
}

