/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws.jnl;

import com.sun.deploy.config.Config;
import com.sun.deploy.config.JREInfo;
import com.sun.deploy.model.ResourceProvider;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.util.VersionString;
import com.sun.javaws.jnl.ExtensionDesc;
import com.sun.javaws.jnl.JREDesc;
import com.sun.javaws.jnl.JavaFXRuntimeDesc;
import com.sun.javaws.jnl.LaunchDesc;
import com.sun.javaws.jnl.LaunchDescFactory;
import com.sun.javaws.jnl.MatchJREIf;
import com.sun.javaws.jnl.ResourceVisitor;
import com.sun.javaws.jnl.ResourcesDesc;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;

public class LaunchSelection {
    private static final String anyJREVersion = "0+";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static JREInfo selectJRE(LaunchDesc launchDesc, MatchJREIf matchJREIf, boolean bl) {
        MatchJREIf matchJREIf2 = matchJREIf;
        synchronized (matchJREIf2) {
            if (!matchJREIf.hasBeenRun() || bl) {
                matchJREIf.beginTraversal(launchDesc);
                ResourcesDesc resourcesDesc = launchDesc.getResources();
                if (resourcesDesc != null) {
                    LaunchSelection.selectJREDescHelper(launchDesc, matchJREIf);
                    JREDesc jREDesc = matchJREIf.getSelectedJREDesc();
                    if (jREDesc != null) {
                        jREDesc.markAsSelected();
                        resourcesDesc.addNested(jREDesc.getNestedResources());
                    }
                    LaunchSelection.selectJREExtensionHelper(launchDesc, matchJREIf);
                }
                matchJREIf.endTraversal(launchDesc);
            }
            return matchJREIf.getSelectedJREInfo();
        }
    }

    private static void selectJREDescHelper(final LaunchDesc launchDesc, MatchJREIf matchJREIf) {
        ResourcesDesc resourcesDesc = launchDesc.getResources();
        if (resourcesDesc == null) {
            return;
        }
        final ArrayList arrayList = new ArrayList();
        resourcesDesc.visit(new ResourceVisitor(){

            public void visitJREDesc(JREDesc jREDesc) {
                if (launchDesc.isLibrary()) {
                    Trace.println((String)("JNLP JREDesc in Component ignored: " + launchDesc.getLocation()));
                } else {
                    arrayList.add(jREDesc);
                }
            }
        });
        JREDesc jREDesc = null;
        JREInfo jREInfo = null;
        JavaFXRuntimeDesc javaFXRuntimeDesc = launchDesc.getJavaFXRuntimeDescriptor();
        if (arrayList.size() > 0) {
            for (int i = 0; jREInfo == null && i < arrayList.size(); ++i) {
                jREDesc = (JREDesc)arrayList.get(i);
                URL uRL = jREDesc.getHref();
                jREInfo = LaunchSelection.selectJRE(uRL, jREDesc.getVersion(), javaFXRuntimeDesc == null ? null : javaFXRuntimeDesc.getVersion(), matchJREIf);
            }
            if (jREInfo == null) {
                jREDesc = (JREDesc)arrayList.get(0);
            }
        } else {
            jREDesc = new JREDesc(anyJREVersion, -1L, -1L, null, null, new ResourcesDesc());
            resourcesDesc.addResource(jREDesc);
            jREInfo = LaunchSelection.selectJRE(jREDesc.getHref(), jREDesc.getVersion(), javaFXRuntimeDesc == null ? null : javaFXRuntimeDesc.getVersion(), matchJREIf);
        }
        matchJREIf.digest(jREDesc, jREInfo);
    }

    private static void selectJREExtensionHelper(LaunchDesc launchDesc, MatchJREIf matchJREIf) {
        ResourcesDesc resourcesDesc = launchDesc.getResources();
        if (resourcesDesc == null) {
            return;
        }
        final ArrayList arrayList = new ArrayList();
        resourcesDesc.visit(new ResourceVisitor(){

            public void visitExtensionDesc(ExtensionDesc extensionDesc) {
                arrayList.add(extensionDesc);
            }
        });
        matchJREIf.digest(launchDesc);
        if (launchDesc.isInstaller()) {
            return;
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            ExtensionDesc extensionDesc = (ExtensionDesc)arrayList.get(i);
            LaunchDesc launchDesc2 = extensionDesc.getExtensionDesc();
            if (launchDesc2 == null) {
                try {
                    File file = ResourceProvider.get().getCachedJNLPFile(extensionDesc.getLocation(), extensionDesc.getVersion());
                    if (null != file) {
                        launchDesc2 = LaunchDescFactory.buildDescriptor(file, extensionDesc.getCodebase(), extensionDesc.getLocation(), extensionDesc.getLocation());
                    }
                }
                catch (Exception exception) {
                    Trace.ignoredException((Exception)exception);
                }
            }
            if (null == launchDesc2 || launchDesc2.isInstaller()) continue;
            extensionDesc.setExtensionDesc(launchDesc2);
            LaunchSelection.selectJREExtensionHelper(launchDesc2, matchJREIf);
        }
    }

    public static JREInfo selectJRE(URL uRL, String string, MatchJREIf matchJREIf) {
        return LaunchSelection.selectJRE(uRL, string, null, matchJREIf);
    }

    public static JREInfo selectJRE(URL uRL, String string, String string2, MatchJREIf matchJREIf) {
        JREInfo[] jREInfoArray = JREInfo.getAll();
        if (jREInfoArray == null) {
            return null;
        }
        VersionString versionString = new VersionString(string);
        for (int i = 0; i < jREInfoArray.length; ++i) {
            if (!jREInfoArray[i].isOsInfoMatch(Config.getOSName(), Config.getOSArch()) || !jREInfoArray[i].isEnabled() && !jREInfoArray[i].getPath().equals(JREInfo.getHomeJRE().getPath())) continue;
            VersionString versionString2 = new VersionString(string2);
            if (!matchJREIf.isVersionMatch(jREInfoArray[i], versionString, uRL) || !matchJREIf.isFXVersionMatch(jREInfoArray[i], versionString2)) continue;
            return jREInfoArray[i];
        }
        return null;
    }
}

