/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.image;

import com.sun.javafx.runtime.async.AsyncOperation;
import com.sun.javafx.runtime.async.AsyncOperationListener;
import com.sun.javafx.tk.ImageLoader;
import com.sun.javafx.tk.PlatformImage;
import com.sun.javafx.tk.Toolkit;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.LinkedList;
import java.util.Queue;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.ReadOnlyDoublePropertyBase;
import javafx.beans.property.ReadOnlyDoubleWrapper;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectPropertyBase;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.image.PixelFormat;
import javafx.scene.image.PixelReader;
import javafx.scene.image.WritablePixelFormat;
import javafx.scene.paint.Color;
import javafx.util.Duration;

public class Image {
    private static final String URL_QUICKMATCH = "^\\p{Alpha}[\\p{Alnum}+.-]*:.*$";
    private final String url;
    private final InputStream impl_source;
    private ReadOnlyDoubleWrapper progress;
    private final double requestedWidth;
    private final double requestedHeight;
    private DoublePropertyImpl width;
    private DoublePropertyImpl height;
    private final boolean preserveRatio;
    private final boolean smooth;
    private final boolean backgroundLoading;
    private ReadOnlyBooleanWrapper error;
    private ObjectPropertyImpl<PlatformImage> platformImage;
    private ImageTask backgroundTask;
    private Timeline timeline;
    private static final int MAX_RUNNING_TASKS = 4;
    private static int runningTasks = 0;
    private static final Queue<ImageTask> pendingTasks = new LinkedList<ImageTask>();
    private PixelReader reader;

    @Deprecated
    public final String impl_getUrl() {
        return this.url;
    }

    final InputStream getImpl_source() {
        return this.impl_source;
    }

    private void setProgress(double d) {
        this.progressPropertyImpl().set(d);
    }

    public final double getProgress() {
        return this.progress == null ? 0.0 : this.progress.get();
    }

    public final ReadOnlyDoubleProperty progressProperty() {
        return this.progressPropertyImpl().getReadOnlyProperty();
    }

    private ReadOnlyDoubleWrapper progressPropertyImpl() {
        if (this.progress == null) {
            this.progress = new ReadOnlyDoubleWrapper(this, "progress");
        }
        return this.progress;
    }

    public final double getRequestedWidth() {
        return this.requestedWidth;
    }

    public final double getRequestedHeight() {
        return this.requestedHeight;
    }

    public final double getWidth() {
        return this.width == null ? 0.0 : this.width.get();
    }

    public final ReadOnlyDoubleProperty widthProperty() {
        return this.widthPropertyImpl();
    }

    private DoublePropertyImpl widthPropertyImpl() {
        if (this.width == null) {
            this.width = new DoublePropertyImpl("width");
        }
        return this.width;
    }

    public final double getHeight() {
        return this.height == null ? 0.0 : this.height.get();
    }

    public final ReadOnlyDoubleProperty heightProperty() {
        return this.heightPropertyImpl();
    }

    private DoublePropertyImpl heightPropertyImpl() {
        if (this.height == null) {
            this.height = new DoublePropertyImpl("height");
        }
        return this.height;
    }

    public final boolean isPreserveRatio() {
        return this.preserveRatio;
    }

    public final boolean isSmooth() {
        return this.smooth;
    }

    public final boolean isBackgroundLoading() {
        return this.backgroundLoading;
    }

    private void setError(boolean bl) {
        this.errorPropertyImpl().set(bl);
    }

    public final boolean isError() {
        return this.error == null ? false : this.error.get();
    }

    public final ReadOnlyBooleanProperty errorProperty() {
        return this.errorPropertyImpl().getReadOnlyProperty();
    }

    private ReadOnlyBooleanWrapper errorPropertyImpl() {
        if (this.error == null) {
            this.error = new ReadOnlyBooleanWrapper(this, "error");
        }
        return this.error;
    }

    @Deprecated
    public final Object impl_getPlatformImage() {
        return this.platformImage == null ? null : this.platformImage.get();
    }

    @Deprecated
    public final ReadOnlyObjectProperty<PlatformImage> impl_platformImageProperty() {
        return this.platformImagePropertyImpl();
    }

    private ObjectPropertyImpl<PlatformImage> platformImagePropertyImpl() {
        if (this.platformImage == null) {
            this.platformImage = new ObjectPropertyImpl("platformImage");
        }
        return this.platformImage;
    }

    void pixelsDirty() {
        this.platformImagePropertyImpl().fireValueChangedEvent();
    }

    public Image(String string) {
        this(Image.validateUrl(string), null, 0.0, 0.0, false, false, false);
        this.initialize(null);
    }

    public Image(String string, boolean bl) {
        this(Image.validateUrl(string), null, 0.0, 0.0, false, false, bl);
        this.initialize(null);
    }

    public Image(String string, double d, double d2, boolean bl, boolean bl2) {
        this(Image.validateUrl(string), null, d, d2, bl, bl2, false);
        this.initialize(null);
    }

    public Image(String string, double d, double d2, boolean bl, boolean bl2, boolean bl3) {
        this(Image.validateUrl(string), null, d, d2, bl, bl2, bl3);
        this.initialize(null);
    }

    public Image(InputStream inputStream) {
        this(null, Image.validateInputStream(inputStream), 0.0, 0.0, false, false, false);
        this.initialize(null);
    }

    public Image(InputStream inputStream, double d, double d2, boolean bl, boolean bl2) {
        this(null, Image.validateInputStream(inputStream), d, d2, bl, bl2, false);
        this.initialize(null);
    }

    Image(int n, int n2) {
        this(null, null, n, n2, false, false, false);
        if (n <= 0 || n2 <= 0) {
            throw new IllegalArgumentException("Image dimensions must be positive (w,h > 0)");
        }
        this.initialize(Toolkit.getToolkit().createPlatformImage(n, n2));
    }

    private Image(Object object) {
        this(null, null, 0.0, 0.0, false, false, false);
        this.initialize(object);
    }

    private Image(String string, InputStream inputStream, double d, double d2, boolean bl, boolean bl2, boolean bl3) {
        this.url = string;
        this.impl_source = inputStream;
        this.requestedWidth = d;
        this.requestedHeight = d2;
        this.preserveRatio = bl;
        this.smooth = bl2;
        this.backgroundLoading = bl3;
    }

    public void cancel() {
        if (this.backgroundTask != null) {
            this.backgroundTask.cancel();
        }
    }

    void dispose() {
        this.cancel();
        if (this.timeline != null) {
            this.timeline.stop();
        }
    }

    private void initialize(Object object) {
        if (object != null) {
            ImageLoader imageLoader = Image.loadPlatformImage(object);
            this.finishImage(imageLoader);
        } else if (this.isBackgroundLoading() && this.impl_source == null) {
            this.loadInBackground();
        } else {
            ImageLoader imageLoader = this.impl_source != null ? Image.loadImage(this.impl_source, this.getRequestedWidth(), this.getRequestedHeight(), this.isPreserveRatio(), this.isSmooth()) : Image.loadImage(this.impl_getUrl(), this.getRequestedWidth(), this.getRequestedHeight(), this.isPreserveRatio(), this.isSmooth());
            this.finishImage(imageLoader);
        }
    }

    private void finishImage(ImageLoader imageLoader) {
        if (imageLoader != null && !imageLoader.getError()) {
            if (imageLoader.getFrameCount() > 1) {
                this.makeAnimationTimeline(imageLoader);
            } else {
                this.setPlatformImageWH(imageLoader.getFrame(0), imageLoader.getWidth(), imageLoader.getHeight());
            }
        } else {
            this.setError(true);
            this.setPlatformImageWH(null, 0.0, 0.0);
        }
        this.setProgress(1.0);
    }

    private void makeAnimationTimeline(ImageLoader imageLoader) {
        PlatformImage[] platformImageArray = imageLoader.getFrames();
        this.timeline = new Timeline();
        this.timeline.setCycleCount(-1);
        ObservableList<KeyFrame> observableList = this.timeline.getKeyFrames();
        int n = 0;
        for (int i = 0; i < platformImageArray.length; ++i) {
            observableList.add(this.createPlatformImageSetKeyFrame(n, platformImageArray[i]));
            n += imageLoader.getFrameDelay(i);
        }
        observableList.add(this.createPlatformImageSetKeyFrame(n, platformImageArray[0]));
        this.setPlatformImageWH(platformImageArray[0], imageLoader.getWidth(), imageLoader.getHeight());
        this.timeline.play();
    }

    private KeyFrame createPlatformImageSetKeyFrame(long l, final PlatformImage platformImage) {
        return new KeyFrame(Duration.millis(l), new EventHandler<ActionEvent>(){

            @Override
            public void handle(ActionEvent actionEvent) {
                Image.this.platformImagePropertyImpl().set(platformImage);
            }
        }, new KeyValue[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cycleTasks() {
        Queue<ImageTask> queue = pendingTasks;
        synchronized (queue) {
            --runningTasks;
            ImageTask imageTask = pendingTasks.poll();
            if (imageTask != null) {
                ++runningTasks;
                imageTask.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadInBackground() {
        this.backgroundTask = new ImageTask();
        Queue<ImageTask> queue = pendingTasks;
        synchronized (queue) {
            if (runningTasks >= 4) {
                pendingTasks.offer(this.backgroundTask);
            } else {
                ++runningTasks;
                this.backgroundTask.start();
            }
        }
    }

    @Deprecated
    public static Image impl_fromPlatformImage(Object object) {
        return new Image(object);
    }

    private void setPlatformImageWH(PlatformImage platformImage, double d, double d2) {
        if (this.impl_getPlatformImage() == platformImage && this.getWidth() == d && this.getHeight() == d2) {
            return;
        }
        Object object = this.impl_getPlatformImage();
        double d3 = this.getWidth();
        double d4 = this.getHeight();
        this.storePlatformImageWH(platformImage, d, d2);
        if (object != platformImage) {
            this.platformImagePropertyImpl().fireValueChangedEvent();
        }
        if (d3 != d) {
            this.widthPropertyImpl().fireValueChangedEvent();
        }
        if (d4 != d2) {
            this.heightPropertyImpl().fireValueChangedEvent();
        }
    }

    private void storePlatformImageWH(PlatformImage platformImage, double d, double d2) {
        this.platformImagePropertyImpl().store(platformImage);
        this.widthPropertyImpl().store(d);
        this.heightPropertyImpl().store(d2);
    }

    void setPlatformImage(PlatformImage platformImage) {
        this.platformImage.set(platformImage);
    }

    private static ImageLoader loadImage(String string, double d, double d2, boolean bl, boolean bl2) {
        return Toolkit.getToolkit().loadImage(string, (int)d, (int)d2, bl, bl2);
    }

    private static ImageLoader loadImage(InputStream inputStream, double d, double d2, boolean bl, boolean bl2) {
        return Toolkit.getToolkit().loadImage(inputStream, (int)d, (int)d2, bl, bl2);
    }

    private static AsyncOperation loadImageAsync(AsyncOperationListener<? extends ImageLoader> asyncOperationListener, String string, double d, double d2, boolean bl, boolean bl2) {
        return Toolkit.getToolkit().loadImageAsync(asyncOperationListener, string, (int)d, (int)d2, bl, bl2);
    }

    private static ImageLoader loadPlatformImage(Object object) {
        return Toolkit.getToolkit().loadPlatformImage(object);
    }

    private static String validateUrl(String string) {
        if (string == null) {
            throw new NullPointerException("URL must not be null");
        }
        if (string.trim().isEmpty()) {
            throw new IllegalArgumentException("URL must not be empty");
        }
        try {
            if (!string.matches(URL_QUICKMATCH)) {
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                URL uRL = string.charAt(0) == '/' ? classLoader.getResource(string.substring(1)) : classLoader.getResource(string);
                if (uRL == null) {
                    throw new IllegalArgumentException("Invalid URL or resource not found");
                }
                return uRL.toString();
            }
            return new URL(string).toString();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IllegalArgumentException(Image.constructDetailedExceptionMessage("Invalid URL", illegalArgumentException), illegalArgumentException);
        }
        catch (MalformedURLException malformedURLException) {
            throw new IllegalArgumentException(Image.constructDetailedExceptionMessage("Invalid URL", malformedURLException), malformedURLException);
        }
    }

    private static InputStream validateInputStream(InputStream inputStream) {
        if (inputStream == null) {
            throw new NullPointerException("Input stream must not be null");
        }
        return inputStream;
    }

    private static String constructDetailedExceptionMessage(String string, Throwable throwable) {
        if (throwable == null) {
            return string;
        }
        String string2 = throwable.getMessage();
        return Image.constructDetailedExceptionMessage(string2 != null ? string + ": " + string2 : string, throwable.getCause());
    }

    @Deprecated
    public Object impl_toExternalImage(Object object) {
        return Toolkit.getToolkit().toExternalImage(this.impl_getPlatformImage(), object);
    }

    @Deprecated
    public static Image impl_fromExternalImage(Object object) {
        return Image.impl_isExternalFormatSupported(object.getClass()) ? new Image(object) : null;
    }

    @Deprecated
    public static boolean impl_isExternalFormatSupported(Class clazz) {
        return Toolkit.getToolkit().isExternalFormatSupported(clazz);
    }

    boolean isAnimation() {
        return this.timeline != null;
    }

    boolean pixelsReadable() {
        return this.getProgress() >= 1.0 && !this.isAnimation() && !this.isError();
    }

    public final PixelReader getPixelReader() {
        if (!this.pixelsReadable()) {
            return null;
        }
        if (this.reader == null) {
            this.reader = new PixelReader(){

                @Override
                public PixelFormat getPixelFormat() {
                    PlatformImage platformImage = (PlatformImage)Image.this.platformImage.get();
                    return platformImage.getPlatformPixelFormat();
                }

                @Override
                public int getArgb(int n, int n2) {
                    PlatformImage platformImage = (PlatformImage)Image.this.platformImage.get();
                    return platformImage.getArgb(n, n2);
                }

                @Override
                public Color getColor(int n, int n2) {
                    int n3 = this.getArgb(n, n2);
                    int n4 = n3 >>> 24;
                    int n5 = n3 >> 16 & 0xFF;
                    int n6 = n3 >> 8 & 0xFF;
                    int n7 = n3 & 0xFF;
                    return Color.rgb(n5, n6, n7, (double)n4 / 255.0);
                }

                @Override
                public <T extends Buffer> void getPixels(int n, int n2, int n3, int n4, WritablePixelFormat<T> writablePixelFormat, T t, int n5) {
                    PlatformImage platformImage = (PlatformImage)Image.this.platformImage.get();
                    platformImage.getPixels(n, n2, n3, n4, writablePixelFormat, t, n5);
                }

                @Override
                public void getPixels(int n, int n2, int n3, int n4, WritablePixelFormat<ByteBuffer> writablePixelFormat, byte[] byArray, int n5, int n6) {
                    PlatformImage platformImage = (PlatformImage)Image.this.platformImage.get();
                    platformImage.getPixels(n, n2, n3, n4, writablePixelFormat, byArray, n5, n6);
                }

                @Override
                public void getPixels(int n, int n2, int n3, int n4, WritablePixelFormat<IntBuffer> writablePixelFormat, int[] nArray, int n5, int n6) {
                    PlatformImage platformImage = (PlatformImage)Image.this.platformImage.get();
                    platformImage.getPixels(n, n2, n3, n4, writablePixelFormat, nArray, n5, n6);
                }
            };
        }
        return this.reader;
    }

    PlatformImage getWritablePlatformImage() {
        PlatformImage platformImage = this.platformImage.get();
        if (!platformImage.isWritable()) {
            platformImage = platformImage.promoteToWritableImage();
            this.platformImage.set(platformImage);
        }
        return platformImage;
    }

    private final class ImageTask
    implements AsyncOperationListener<ImageLoader> {
        private final AsyncOperation peer = this.constructPeer();

        @Override
        public void onCancel() {
            Image.this.finishImage(null);
            Image.this.cycleTasks();
        }

        @Override
        public void onException(Exception exception) {
            Image.this.finishImage(null);
            Image.this.cycleTasks();
        }

        @Override
        public void onCompletion(ImageLoader imageLoader) {
            Image.this.finishImage(imageLoader);
            Image.this.cycleTasks();
        }

        @Override
        public void onProgress(int n, int n2) {
            double d;
            if (n2 > 0 && (d = (double)n / (double)n2) < 1.0 && d >= Image.this.getProgress() + 0.1) {
                Image.this.setProgress(d);
            }
        }

        public void start() {
            this.peer.start();
        }

        public void cancel() {
            this.peer.cancel();
        }

        private AsyncOperation constructPeer() {
            return Image.loadImageAsync(this, Image.this.url, Image.this.requestedWidth, Image.this.requestedHeight, Image.this.preserveRatio, Image.this.smooth);
        }
    }

    private final class ObjectPropertyImpl<T>
    extends ReadOnlyObjectPropertyBase<T> {
        private final String name;
        private T value;

        public ObjectPropertyImpl(String string) {
            this.name = string;
        }

        public void store(T t) {
            this.value = t;
        }

        public void set(T t) {
            if (this.value != t) {
                this.value = t;
                this.fireValueChangedEvent();
            }
        }

        @Override
        public void fireValueChangedEvent() {
            super.fireValueChangedEvent();
        }

        @Override
        public T get() {
            return this.value;
        }

        @Override
        public Object getBean() {
            return Image.this;
        }

        @Override
        public String getName() {
            return this.name;
        }
    }

    private final class DoublePropertyImpl
    extends ReadOnlyDoublePropertyBase {
        private final String name;
        private double value;

        public DoublePropertyImpl(String string) {
            this.name = string;
        }

        public void store(double d) {
            this.value = d;
        }

        @Override
        public void fireValueChangedEvent() {
            super.fireValueChangedEvent();
        }

        @Override
        public double get() {
            return this.value;
        }

        @Override
        public Object getBean() {
            return Image.this;
        }

        @Override
        public String getName() {
            return this.name;
        }
    }
}

