/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webpane.webkit.dom;

import com.sun.webpane.platform.Disposer;
import com.sun.webpane.platform.DisposerRecord;
import com.sun.webpane.webkit.dom.NodeImpl;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.NodeFilter;

public class NodeFilterImpl
implements NodeFilter {
    protected final long contextPeer;
    protected final long rootPeer;
    protected final long peer;
    public static final int FILTER_ACCEPT = 1;
    public static final int FILTER_REJECT = 2;
    public static final int FILTER_SKIP = 3;
    public static final int SHOW_ALL = -1;
    public static final int SHOW_ELEMENT = 1;
    public static final int SHOW_ATTRIBUTE = 2;
    public static final int SHOW_TEXT = 4;
    public static final int SHOW_CDATA_SECTION = 8;
    public static final int SHOW_ENTITY_REFERENCE = 16;
    public static final int SHOW_ENTITY = 32;
    public static final int SHOW_PROCESSING_INSTRUCTION = 64;
    public static final int SHOW_COMMENT = 128;
    public static final int SHOW_DOCUMENT = 256;
    public static final int SHOW_DOCUMENT_TYPE = 512;
    public static final int SHOW_DOCUMENT_FRAGMENT = 1024;
    public static final int SHOW_NOTATION = 2048;

    NodeFilterImpl(long peer, long contextPeer, long rootPeer) {
        this.peer = peer;
        this.contextPeer = contextPeer;
        this.rootPeer = rootPeer;
        Disposer.addRecord(this, new SelfDisposer(peer));
    }

    static NodeFilter create(long peer, long contextPeer, long rootPeer) {
        if (peer == 0L) {
            return null;
        }
        return new NodeFilterImpl(peer, contextPeer, rootPeer);
    }

    long getPeer() {
        return this.peer;
    }

    static long getPeer(NodeFilter arg) {
        return arg == null ? 0L : ((NodeFilterImpl)arg).getPeer();
    }

    public boolean equals(Object that) {
        return that instanceof NodeFilterImpl && this.peer == ((NodeFilterImpl)that).peer;
    }

    public int hashCode() {
        long p = this.peer;
        return (int)(p ^ p >> 17);
    }

    private static native void dispose(long var0);

    static NodeFilter getImpl(long peer, long contextPeer, long rootPeer) {
        return NodeFilterImpl.create(peer, contextPeer, rootPeer);
    }

    @Override
    public short acceptNode(Node n) {
        return NodeFilterImpl.acceptNodeImpl(this.getPeer(), NodeImpl.getPeer(n));
    }

    static native short acceptNodeImpl(long var0, long var2);

    static class SelfDisposer
    implements DisposerRecord {
        private final long peer;

        SelfDisposer(long peer) {
            this.peer = peer;
        }

        @Override
        public void dispose() {
            NodeFilterImpl.dispose(this.peer);
        }
    }
}

