/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webpane.webkit.dom;

import com.sun.webpane.platform.Disposer;
import com.sun.webpane.platform.DisposerRecord;
import com.sun.webpane.webkit.dom.HTMLOptionsCollectionImpl;
import com.sun.webpane.webkit.dom.NodeImpl;
import org.w3c.dom.Node;
import org.w3c.dom.html.HTMLCollection;

public class HTMLCollectionImpl
implements HTMLCollection {
    protected final long contextPeer;
    protected final long rootPeer;
    protected final long peer;
    private static final int TYPE_HTMLOptionsCollection = 1;

    HTMLCollectionImpl(long peer, long contextPeer, long rootPeer) {
        this.peer = peer;
        this.contextPeer = contextPeer;
        this.rootPeer = rootPeer;
        Disposer.addRecord(this, new SelfDisposer(peer));
    }

    static HTMLCollection create(long peer, long contextPeer, long rootPeer) {
        if (peer == 0L) {
            return null;
        }
        switch (HTMLCollectionImpl.getCPPTypeImpl(peer)) {
            case 1: {
                return new HTMLOptionsCollectionImpl(peer, contextPeer, rootPeer);
            }
        }
        return new HTMLCollectionImpl(peer, contextPeer, rootPeer);
    }

    long getPeer() {
        return this.peer;
    }

    static long getPeer(HTMLCollection arg) {
        return arg == null ? 0L : ((HTMLCollectionImpl)arg).getPeer();
    }

    public boolean equals(Object that) {
        return that instanceof HTMLCollectionImpl && this.peer == ((HTMLCollectionImpl)that).peer;
    }

    public int hashCode() {
        long p = this.peer;
        return (int)(p ^ p >> 17);
    }

    private static native void dispose(long var0);

    private static native int getCPPTypeImpl(long var0);

    static HTMLCollection getImpl(long peer, long contextPeer, long rootPeer) {
        return HTMLCollectionImpl.create(peer, contextPeer, rootPeer);
    }

    @Override
    public int getLength() {
        return HTMLCollectionImpl.getLengthImpl(this.getPeer());
    }

    static native int getLengthImpl(long var0);

    @Override
    public Node item(int index) {
        return NodeImpl.getImpl(HTMLCollectionImpl.itemImpl(this.getPeer(), index), this.contextPeer, this.rootPeer);
    }

    static native long itemImpl(long var0, int var2);

    @Override
    public Node namedItem(String name) {
        return NodeImpl.getImpl(HTMLCollectionImpl.namedItemImpl(this.getPeer(), name), this.contextPeer, this.rootPeer);
    }

    static native long namedItemImpl(long var0, String var2);

    static class SelfDisposer
    implements DisposerRecord {
        private final long peer;

        SelfDisposer(long peer) {
            this.peer = peer;
        }

        @Override
        public void dispose() {
            HTMLCollectionImpl.dispose(this.peer);
        }
    }
}

