/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webpane.sg.prism;

import com.sun.javafx.font.FontFactory;
import com.sun.javafx.font.FontStrike;
import com.sun.javafx.font.PGFont;
import com.sun.javafx.geom.RectBounds;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.prism.GraphicsPipeline;
import com.sun.webpane.platform.graphics.WCFont;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WCFontImpl
extends WCFont {
    private static final Logger log = Logger.getLogger(WCFontImpl.class.getName());
    private static final HashMap<String, String> FONT_MAP = new HashMap();
    private final PGFont font;
    private FontStrike strike;
    private double xheight = Double.MAX_VALUE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static WCFont getFont(String string, boolean bl, boolean bl2, float f) {
        FontFactory fontFactory = GraphicsPipeline.getPipeline().getFontFactory();
        Object object = FONT_MAP;
        synchronized (object) {
            if (FONT_MAP.isEmpty()) {
                FONT_MAP.put("serif", "Serif");
                FONT_MAP.put("dialog", "SansSerif");
                FONT_MAP.put("helvetica", "SansSerif");
                FONT_MAP.put("sansserif", "SansSerif");
                FONT_MAP.put("sans-serif", "SansSerif");
                FONT_MAP.put("monospace", "Monospaced");
                FONT_MAP.put("monospaced", "Monospaced");
                for (String string2 : fontFactory.getFontFamilyNames()) {
                    FONT_MAP.put(string2.toLowerCase(), string2);
                }
            }
        }
        object = FONT_MAP.get(string.toLowerCase());
        if (log.isLoggable(Level.FINE)) {
            String[] stringArray = new StringBuilder("WCFontImpl.get(");
            stringArray.append(string).append(", ").append(f);
            if (bl) {
                stringArray.append(", bold");
            }
            if (bl2) {
                stringArray.append(", italic");
            }
            log.fine(stringArray.append(") = ").append((String)object).toString());
        }
        return object != null ? new WCFontImpl(fontFactory.createFont((String)object, bl, bl2, f)) : null;
    }

    private WCFontImpl(PGFont pGFont) {
        this.font = pGFont;
    }

    @Override
    public int getOffsetForPosition(String string, int n, float f, float f2) {
        return 0;
    }

    private FontStrike getFontStrike() {
        if (this.strike == null) {
            this.strike = this.font.getStrike(BaseTransform.IDENTITY_TRANSFORM, 1);
        }
        return this.strike;
    }

    @Override
    public double getGlyphWidth(int n) {
        double d = this.getFontStrike().getCharAdvance((char)n);
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, "getGlyphWidth({0}, {1}, {2})= {3}", new Object[]{this.font.getName(), Float.valueOf(this.font.getSize()), new String(Character.toChars(n)), d});
        }
        return (float)d;
    }

    @Override
    public double getXHeight() {
        if (this.xheight == Double.MAX_VALUE) {
            this.xheight = this.getFontStrike().getGlyph('x').getBBox().getHeight();
            if (this.xheight == 0.0) {
                this.xheight = (double)this.getFontStrike().getMetrics().getAscent() * 0.56;
            }
        }
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, "getXHeight({0}, {1}) = {2}", new Object[]{this.font.getName(), Float.valueOf(this.font.getSize()), (int)this.xheight});
        }
        return this.xheight;
    }

    @Override
    public int[] getGlyphCodes(int[] nArray) {
        return nArray;
    }

    @Override
    public double getStringLength(String string, float f, float f2) {
        if (string.length() == 0) {
            return 0.0;
        }
        double d = this.getFontStrike().getStringWidth(string);
        log.log(Level.FINER, "getStringLength({0}) = {1}", new Object[]{string, d});
        return d;
    }

    @Override
    public double[] getStringBounds(String string, int n, int n2, boolean bl, float f, float f2) {
        RectBounds rectBounds = this.getFontStrike().getStringBounds(string.substring(n, n2));
        log.log(Level.FINER, "getStringBounds({0}, {1}, {2}) = [{3}, {4}, {5}, {6}])", new Object[]{string, n, n2, Float.valueOf(rectBounds.getMinX()), Float.valueOf(rectBounds.getMinY()), Float.valueOf(rectBounds.getWidth()), Float.valueOf(rectBounds.getHeight())});
        return new double[]{rectBounds.getMinX(), rectBounds.getMinY(), rectBounds.getWidth(), rectBounds.getHeight()};
    }

    @Override
    public int getAscent() {
        int n = -((int)this.getFontStrike().getMetrics().getAscent());
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, "getAscent({0}, {1}) = {2}", new Object[]{this.font.getName(), Float.valueOf(this.font.getSize()), n});
        }
        return n;
    }

    @Override
    public int getDescent() {
        int n = (int)this.getFontStrike().getMetrics().getDescent();
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, "getDescent({0}, {1}) = {2}", new Object[]{this.font.getName(), Float.valueOf(this.font.getSize()), n});
        }
        return n;
    }

    @Override
    public int getHeight() {
        int n = (int)this.getFontStrike().getMetrics().getLineHeight();
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, "getHeight({0}, {1}) = {2}", new Object[]{this.font.getName(), Float.valueOf(this.font.getSize()), n});
        }
        return n;
    }

    @Override
    public boolean hasUniformLineMetrics() {
        return false;
    }

    @Override
    public Object getPlatformFont() {
        return this.font;
    }
}

