/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jfxmediaimpl;

import com.sun.media.jfxmedia.AudioClip;
import com.sun.media.jfxmedia.logging.Logger;
import com.sun.media.jfxmediaimpl.NativeAudioClip;
import com.sun.media.jfxmediaimpl.NativeMediaAudioClip;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;

public class AudioClipProvider {
    private static AudioClipProvider primaDonna;
    private boolean useNative = false;

    public static synchronized AudioClipProvider getProvider() {
        if (null == primaDonna) {
            primaDonna = new AudioClipProvider();
        }
        return primaDonna;
    }

    private AudioClipProvider() {
        try {
            this.useNative = NativeAudioClip.init();
        }
        catch (UnsatisfiedLinkError ule) {
            Logger.logMsg(1, "JavaFX AudioClip native methods not linked, using NativeMedia implementation");
        }
        catch (Exception t) {
            Logger.logMsg(4, "Exception while loading native AudioClip library: " + t);
        }
    }

    public AudioClip load(URI source) throws URISyntaxException, FileNotFoundException, IOException {
        if (this.useNative) {
            return NativeAudioClip.load(source);
        }
        return NativeMediaAudioClip.load(source);
    }

    public AudioClip create(byte[] data, int dataOffset, int sampleCount, int sampleFormat, int channels, int sampleRate) throws IllegalArgumentException {
        if (this.useNative) {
            return NativeAudioClip.create(data, dataOffset, sampleCount, sampleFormat, channels, sampleRate);
        }
        return NativeMediaAudioClip.create(data, dataOffset, sampleCount, sampleFormat, channels, sampleRate);
    }

    public void stopAllClips() {
        if (this.useNative) {
            NativeAudioClip.stopAllClips();
        }
        NativeMediaAudioClip.stopAllClips();
    }
}

