/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.util;

import com.sun.javafx.util.MessageBusEvent;
import java.util.ArrayList;
import java.util.HashMap;
import javafx.event.EventHandler;

public class MessageBus {
    private static HashMap<Class<?>, ArrayList<?>> topics = new HashMap();

    public static <M> void subscribe(Class<M> clazz, EventHandler<MessageBusEvent<M>> eventHandler) {
        ArrayList<Object> arrayList = topics.get(clazz);
        if (arrayList == null) {
            arrayList = new ArrayList();
            topics.put(clazz, arrayList);
        }
        arrayList.add(eventHandler);
    }

    public static <M> void unsubscribe(Class<M> clazz, EventHandler<MessageBusEvent<M>> eventHandler) {
        ArrayList<?> arrayList = topics.get(clazz);
        if (arrayList == null) {
            throw new IllegalArgumentException(clazz.getName() + " does not exist.");
        }
        arrayList.remove(eventHandler);
        if (arrayList.isEmpty()) {
            topics.remove(clazz);
        }
    }

    public static <M> void sendMessage(M m) {
        for (Class<?> clazz = m.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            ArrayList<?> arrayList = topics.get(clazz);
            MessageBusEvent<M> messageBusEvent = new MessageBusEvent<M>(m);
            if (arrayList == null) continue;
            for (EventHandler eventHandler : arrayList) {
                eventHandler.handle(messageBusEvent);
            }
        }
    }
}

