/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tk.quantum;

import com.sun.glass.ui.ClipboardAssistance;
import com.sun.javafx.tk.quantum.GlassDragEvent;
import com.sun.javafx.tk.quantum.GlassScene;
import com.sun.javafx.tk.quantum.QuantumClipboard;
import com.sun.javafx.tk.quantum.QuantumToolkit;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javafx.application.Platform;
import javafx.scene.input.Dragboard;
import javafx.scene.input.TransferMode;

public class GlassSceneDnDEventHandler {
    private final GlassScene scene;
    private final boolean verbose;
    private final DragEventListener del;
    private static final QuantumToolkit toolkit = (QuantumToolkit)QuantumToolkit.getToolkit();

    public GlassSceneDnDEventHandler(GlassScene glassScene, DragEventListener dragEventListener, boolean bl) {
        this.scene = glassScene;
        this.verbose = bl;
        this.del = dragEventListener;
    }

    public GlassSceneDnDEventHandler(GlassScene glassScene, DragEventListener dragEventListener) {
        this(glassScene, dragEventListener, false);
    }

    private static boolean toolkit() {
        return toolkit.getFxUserThread() != null;
    }

    public TransferMode handleDragEnter(final int n, final int n2, final int n3, final int n4, final int n5, final ClipboardAssistance clipboardAssistance) {
        assert (Platform.isFxApplicationThread());
        return AccessController.doPrivileged(new PrivilegedAction<TransferMode>(){

            @Override
            public TransferMode run() {
                if (((GlassSceneDnDEventHandler)GlassSceneDnDEventHandler.this).scene.dropTargetListener != null && GlassSceneDnDEventHandler.toolkit()) {
                    Dragboard dragboard = GlassSceneDnDEventHandler.createDragboard(clipboardAssistance);
                    GlassDragEvent glassDragEvent = GlassSceneDnDEventHandler.createEvent(3, n, n2, n3, n4, dragboard, 0, GlassSceneDnDEventHandler.this.scene, n5, GlassSceneDnDEventHandler.this.del);
                    return ((GlassSceneDnDEventHandler)GlassSceneDnDEventHandler.this).scene.dropTargetListener.dragEnter(glassDragEvent);
                }
                return null;
            }
        }, this.scene.getAccessControlContext());
    }

    public void handleDragLeave(final ClipboardAssistance clipboardAssistance) {
        assert (Platform.isFxApplicationThread());
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                if (((GlassSceneDnDEventHandler)GlassSceneDnDEventHandler.this).scene.dropTargetListener != null && GlassSceneDnDEventHandler.toolkit()) {
                    Dragboard dragboard = GlassSceneDnDEventHandler.createDragboard(clipboardAssistance);
                    GlassDragEvent glassDragEvent = GlassSceneDnDEventHandler.createEvent(5, 0, 0, 0, 0, dragboard, 0, GlassSceneDnDEventHandler.this.scene, 0, GlassSceneDnDEventHandler.this.del);
                    ((GlassSceneDnDEventHandler)GlassSceneDnDEventHandler.this).scene.dropTargetListener.dragExit(glassDragEvent);
                }
                return null;
            }
        }, this.scene.getAccessControlContext());
    }

    public TransferMode handleDragDrop(final int n, final int n2, final int n3, final int n4, final int n5, final ClipboardAssistance clipboardAssistance) {
        assert (Platform.isFxApplicationThread());
        return AccessController.doPrivileged(new PrivilegedAction<TransferMode>(){

            @Override
            public TransferMode run() {
                Dragboard dragboard = GlassSceneDnDEventHandler.createDragboard(clipboardAssistance);
                GlassDragEvent glassDragEvent = GlassSceneDnDEventHandler.createEvent(2, n, n2, n3, n4, dragboard, 0, GlassSceneDnDEventHandler.this.scene, n5, GlassSceneDnDEventHandler.this.del);
                if (((GlassSceneDnDEventHandler)GlassSceneDnDEventHandler.this).scene.dropTargetListener != null && GlassSceneDnDEventHandler.toolkit()) {
                    return ((GlassSceneDnDEventHandler)GlassSceneDnDEventHandler.this).scene.dropTargetListener.drop(glassDragEvent);
                }
                return null;
            }
        }, this.scene.getAccessControlContext());
    }

    public TransferMode handleDragOver(final int n, final int n2, final int n3, final int n4, final int n5, final ClipboardAssistance clipboardAssistance) {
        assert (Platform.isFxApplicationThread());
        return AccessController.doPrivileged(new PrivilegedAction<TransferMode>(){

            @Override
            public TransferMode run() {
                if (((GlassSceneDnDEventHandler)GlassSceneDnDEventHandler.this).scene.dropTargetListener != null && GlassSceneDnDEventHandler.toolkit()) {
                    Dragboard dragboard = GlassSceneDnDEventHandler.createDragboard(clipboardAssistance);
                    GlassDragEvent glassDragEvent = GlassSceneDnDEventHandler.createEvent(4, n, n2, n3, n4, dragboard, 0, GlassSceneDnDEventHandler.this.scene, n5, GlassSceneDnDEventHandler.this.del);
                    return ((GlassSceneDnDEventHandler)GlassSceneDnDEventHandler.this).scene.dropTargetListener.dragOver(glassDragEvent);
                }
                return null;
            }
        }, this.scene.getAccessControlContext());
    }

    public void handleDragStart(final int n, final int n2, final int n3, final int n4, final int n5, final ClipboardAssistance clipboardAssistance) {
        assert (Platform.isFxApplicationThread());
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                if (((GlassSceneDnDEventHandler)GlassSceneDnDEventHandler.this).scene.dragGestureListener != null && GlassSceneDnDEventHandler.toolkit()) {
                    Dragboard dragboard = GlassSceneDnDEventHandler.createDragboard(clipboardAssistance);
                    GlassDragEvent glassDragEvent = GlassSceneDnDEventHandler.createEvent(1, n2, n3, n4, n5, dragboard, n, GlassSceneDnDEventHandler.this.scene, 0, GlassSceneDnDEventHandler.this.del);
                    ((GlassSceneDnDEventHandler)GlassSceneDnDEventHandler.this).scene.dragGestureListener.dragGestureRecognized(glassDragEvent);
                }
                return null;
            }
        }, this.scene.getAccessControlContext());
    }

    public void handleDragEnd(final int n, final ClipboardAssistance clipboardAssistance) {
        assert (Platform.isFxApplicationThread());
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                if (((GlassSceneDnDEventHandler)GlassSceneDnDEventHandler.this).scene.dragSourceListener != null && GlassSceneDnDEventHandler.toolkit()) {
                    Dragboard dragboard = GlassSceneDnDEventHandler.createDragboard(clipboardAssistance);
                    GlassDragEvent glassDragEvent = GlassSceneDnDEventHandler.createEvent(2, 0, 0, 0, 0, dragboard, 0, GlassSceneDnDEventHandler.this.scene, n, GlassSceneDnDEventHandler.this.del);
                    ((GlassSceneDnDEventHandler)GlassSceneDnDEventHandler.this).scene.dragSourceListener.dragDropEnd(glassDragEvent);
                }
                return null;
            }
        }, this.scene.getAccessControlContext());
    }

    public TransferMode handleDragEnter(int n, int n2, int n3, int n4, TransferMode transferMode, ClipboardAssistance clipboardAssistance) {
        return this.handleDragEnter(n, n2, n3, n4, GlassSceneDnDEventHandler.TransferModeToAction(transferMode), clipboardAssistance);
    }

    public TransferMode handleDragDrop(int n, int n2, int n3, int n4, TransferMode transferMode, ClipboardAssistance clipboardAssistance) {
        return this.handleDragDrop(n, n2, n3, n4, GlassSceneDnDEventHandler.TransferModeToAction(transferMode), clipboardAssistance);
    }

    public TransferMode handleDragOver(int n, int n2, int n3, int n4, TransferMode transferMode, ClipboardAssistance clipboardAssistance) {
        return this.handleDragOver(n, n2, n3, n4, GlassSceneDnDEventHandler.TransferModeToAction(transferMode), clipboardAssistance);
    }

    public void handleDragEnd(TransferMode transferMode, ClipboardAssistance clipboardAssistance) {
        this.handleDragEnd(GlassSceneDnDEventHandler.TransferModeToAction(transferMode), clipboardAssistance);
    }

    public static int TransferModeToAction(TransferMode transferMode) {
        if (transferMode == null) {
            return 0;
        }
        switch (transferMode) {
            case COPY: {
                return 1;
            }
            case MOVE: {
                return 2;
            }
            case LINK: {
                return 0x40000000;
            }
        }
        return 0;
    }

    static Dragboard createDragboard(ClipboardAssistance clipboardAssistance) {
        QuantumClipboard quantumClipboard = QuantumClipboard.getDragboardInstance(clipboardAssistance);
        return Dragboard.impl_create(quantumClipboard);
    }

    private static GlassDragEvent createEvent(int n, int n2, int n3, int n4, int n5, Dragboard dragboard, int n6, GlassScene glassScene, int n7, DragEventListener dragEventListener) {
        if (dragEventListener == null) {
            return new GlassDragEvent(n, n2, n3, n4, n5, dragboard, n6, glassScene, n7);
        }
        return new GlassDragEventWithListener(n, n2, n3, n4, n5, dragboard, n6, glassScene, n7, dragEventListener);
    }

    private static class GlassDragEventWithListener
    extends GlassDragEvent {
        private final DragEventListener del;

        GlassDragEventWithListener(int n, int n2, int n3, int n4, int n5, Dragboard dragboard, int n6, GlassScene glassScene, int n7, DragEventListener dragEventListener) {
            super(n, n2, n3, n4, n5, dragboard, n6, glassScene, n7);
            this.del = dragEventListener;
        }

        @Override
        public void accept(TransferMode transferMode) {
            this.del.eventAccepted(transferMode);
        }

        @Override
        public void reject() {
            this.del.eventRejected();
        }
    }

    public static interface DragEventListener {
        public void eventAccepted(TransferMode var1);

        public void eventRejected();
    }
}

