/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.skin;

import com.sun.javafx.css.StyleConverter;
import com.sun.javafx.css.StyleableDoubleProperty;
import com.sun.javafx.css.StyleableObjectProperty;
import com.sun.javafx.css.StyleableProperty;
import com.sun.javafx.css.converters.EnumConverter;
import com.sun.javafx.css.converters.SizeConverter;
import com.sun.javafx.scene.control.behavior.ToolBarBehavior;
import com.sun.javafx.scene.control.skin.SkinBase;
import com.sun.javafx.scene.traversal.Direction;
import com.sun.javafx.scene.traversal.TraversalEngine;
import com.sun.javafx.scene.traversal.TraverseListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.geometry.Bounds;
import javafx.geometry.HPos;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.geometry.Side;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.CustomMenuItem;
import javafx.scene.control.MenuItem;
import javafx.scene.control.Separator;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.ToolBar;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;

public class ToolBarSkin
extends SkinBase<ToolBar, ToolBarBehavior>
implements TraverseListener {
    private Pane box;
    private ToolBarOverflowMenu overflowMenu;
    private boolean overflow = false;
    private double previousWidth = 0.0;
    private double previousHeight = 0.0;
    private double savedPrefWidth = 0.0;
    private double savedPrefHeight = 0.0;
    private ObservableList<MenuItem> overflowMenuItems = FXCollections.observableArrayList();
    private boolean needsUpdate = false;
    private TraversalEngine engine;
    private Direction direction;
    private DoubleProperty spacing;
    private ObjectProperty<Pos> boxAlignment;

    public ToolBarSkin(ToolBar toolBar) {
        super(toolBar, new ToolBarBehavior(toolBar));
        this.initialize();
        this.registerChangeListener(toolBar.orientationProperty(), "ORIENTATION");
        this.engine = new TraversalEngine(this, false){

            @Override
            public void trav(Node node, Direction direction) {
                if (ToolBarSkin.this.overflow) {
                    ToolBarSkin.this.engine.reg(ToolBarSkin.this.overflowMenu);
                }
                ToolBarSkin.this.direction = direction;
                super.trav(node, direction);
                if (ToolBarSkin.this.overflow) {
                    ToolBarSkin.this.engine.unreg(ToolBarSkin.this.overflowMenu);
                }
            }
        };
        this.engine.addTraverseListener(this);
        this.setImpl_traversalEngine(this.engine);
        toolBar.focusedProperty().addListener(new ChangeListener<Boolean>(){

            @Override
            public void changed(ObservableValue<? extends Boolean> observableValue, Boolean bl, Boolean bl2) {
                if (bl2.booleanValue()) {
                    if (!ToolBarSkin.this.box.getChildren().isEmpty()) {
                        ((Node)ToolBarSkin.this.box.getChildren().get(0)).requestFocus();
                    } else {
                        ToolBarSkin.this.overflowMenu.requestFocus();
                    }
                }
            }
        });
        toolBar.getItems().addListener(new ListChangeListener<Node>(){

            @Override
            public void onChanged(ListChangeListener.Change<? extends Node> change) {
                while (change.next()) {
                    for (Node node : change.getRemoved()) {
                        ToolBarSkin.this.box.getChildren().remove(node);
                    }
                    ToolBarSkin.this.box.getChildren().addAll((Collection<Node>)change.getAddedSubList());
                }
                ToolBarSkin.this.needsUpdate = true;
                ToolBarSkin.this.requestLayout();
            }
        });
    }

    public final void setSpacing(double d) {
        this.spacingProperty().set(this.snapSpace(d));
    }

    public final double getSpacing() {
        return this.spacing == null ? 0.0 : this.snapSpace(this.spacing.get());
    }

    public final DoubleProperty spacingProperty() {
        if (this.spacing == null) {
            this.spacing = new StyleableDoubleProperty(){

                @Override
                protected void invalidated() {
                    double d = this.get();
                    if (((ToolBar)ToolBarSkin.this.getSkinnable()).getOrientation() == Orientation.VERTICAL) {
                        ((VBox)ToolBarSkin.this.box).setSpacing(d);
                    } else {
                        ((HBox)ToolBarSkin.this.box).setSpacing(d);
                    }
                }

                @Override
                public Object getBean() {
                    return ToolBarSkin.this;
                }

                @Override
                public String getName() {
                    return "spacing";
                }

                @Override
                public StyleableProperty getStyleableProperty() {
                    return StyleableProperties.SPACING;
                }
            };
        }
        return this.spacing;
    }

    public final void setBoxAlignment(Pos pos) {
        this.boxAlignmentProperty().set(pos);
    }

    public final Pos getBoxAlignment() {
        return this.boxAlignment == null ? Pos.TOP_LEFT : (Pos)((Object)this.boxAlignment.get());
    }

    public final ObjectProperty<Pos> boxAlignmentProperty() {
        if (this.boxAlignment == null) {
            this.boxAlignment = new StyleableObjectProperty<Pos>(Pos.TOP_LEFT){

                @Override
                public void invalidated() {
                    Pos pos = (Pos)((Object)this.get());
                    if (((ToolBar)ToolBarSkin.this.getSkinnable()).getOrientation() == Orientation.VERTICAL) {
                        ((VBox)ToolBarSkin.this.box).setAlignment(pos);
                    } else {
                        ((HBox)ToolBarSkin.this.box).setAlignment(pos);
                    }
                }

                @Override
                public Object getBean() {
                    return ToolBarSkin.this;
                }

                @Override
                public String getName() {
                    return "boxAlignment";
                }

                @Override
                public StyleableProperty getStyleableProperty() {
                    return StyleableProperties.ALIGNMENT;
                }
            };
        }
        return this.boxAlignment;
    }

    @Override
    protected void handleControlPropertyChanged(String string) {
        super.handleControlPropertyChanged(string);
        if (string == "ORIENTATION") {
            this.initialize();
        }
    }

    @Override
    protected double computeMinWidth(double d) {
        return ((ToolBar)this.getSkinnable()).getOrientation() == Orientation.VERTICAL ? this.computePrefWidth(-1.0) : this.snapSize(this.overflowMenu.prefWidth(-1.0)) + this.snapSpace(this.getInsets().getLeft()) + this.snapSpace(this.getInsets().getRight());
    }

    @Override
    protected double computeMinHeight(double d) {
        return ((ToolBar)this.getSkinnable()).getOrientation() == Orientation.VERTICAL ? this.snapSize(this.overflowMenu.prefHeight(-1.0)) + this.snapSpace(this.getInsets().getTop()) + this.snapSpace(this.getInsets().getBottom()) : this.computePrefHeight(-1.0);
    }

    @Override
    protected double computePrefWidth(double d) {
        double d2 = 0.0;
        if (((ToolBar)this.getSkinnable()).getOrientation() == Orientation.HORIZONTAL) {
            for (Node node : ((ToolBar)this.getSkinnable()).getItems()) {
                d2 += this.snapSize(node.prefWidth(-1.0)) + this.getSpacing();
            }
            d2 -= this.getSpacing();
        } else {
            for (Node node : ((ToolBar)this.getSkinnable()).getItems()) {
                d2 = Math.max(d2, this.snapSize(node.prefWidth(-1.0)));
            }
            if (((ToolBar)this.getSkinnable()).getItems().size() > 0) {
                this.savedPrefWidth = d2;
            } else {
                d2 = this.savedPrefWidth;
            }
        }
        return this.snapSpace(this.getInsets().getLeft()) + d2 + this.snapSpace(this.getInsets().getRight());
    }

    @Override
    protected double computePrefHeight(double d) {
        double d2 = 0.0;
        if (((ToolBar)this.getSkinnable()).getOrientation() == Orientation.VERTICAL) {
            for (Node node : ((ToolBar)this.getSkinnable()).getItems()) {
                d2 += this.snapSize(node.prefHeight(-1.0)) + this.getSpacing();
            }
            d2 -= this.getSpacing();
        } else {
            for (Node node : ((ToolBar)this.getSkinnable()).getItems()) {
                d2 = Math.max(d2, this.snapSize(node.prefHeight(-1.0)));
            }
            if (((ToolBar)this.getSkinnable()).getItems().size() > 0) {
                this.savedPrefHeight = d2;
            } else {
                d2 = this.savedPrefHeight;
            }
        }
        return this.snapSpace(this.getInsets().getTop()) + d2 + this.snapSpace(this.getInsets().getBottom());
    }

    @Override
    protected double computeMaxWidth(double d) {
        return ((ToolBar)this.getSkinnable()).getOrientation() == Orientation.VERTICAL ? this.snapSize(((ToolBar)this.getSkinnable()).prefWidth(-1.0)) : Double.MAX_VALUE;
    }

    @Override
    protected double computeMaxHeight(double d) {
        return ((ToolBar)this.getSkinnable()).getOrientation() == Orientation.VERTICAL ? Double.MAX_VALUE : this.snapSize(((ToolBar)this.getSkinnable()).prefHeight(-1.0));
    }

    @Override
    protected void layoutChildren() {
        super.layoutChildren();
        if (((ToolBar)this.getSkinnable()).getOrientation() == Orientation.VERTICAL) {
            if (this.snapSize(this.getHeight()) != this.previousHeight || this.needsUpdate) {
                ((VBox)this.box).setSpacing(this.getSpacing());
                ((VBox)this.box).setAlignment(this.getBoxAlignment());
                this.previousHeight = this.snapSize(this.getHeight());
                this.addNodesToToolBar();
            }
        } else if (this.snapSize(this.getWidth()) != this.previousWidth || this.needsUpdate) {
            ((HBox)this.box).setSpacing(this.getSpacing());
            ((HBox)this.box).setAlignment(this.getBoxAlignment());
            this.previousWidth = this.snapSize(this.getWidth());
            this.addNodesToToolBar();
        }
        this.needsUpdate = false;
        double d = this.snapSize(this.getWidth()) - (this.snapSpace(this.getInsets().getLeft()) + this.snapSpace(this.getInsets().getRight()));
        double d2 = this.snapSize(this.getHeight()) - (this.snapSpace(this.getInsets().getTop()) + this.snapSpace(this.getInsets().getBottom()));
        if (((ToolBar)this.getSkinnable()).getOrientation() == Orientation.VERTICAL) {
            d2 -= this.overflow ? this.snapSize(this.overflowMenu.prefHeight(-1.0)) : 0.0;
        } else {
            d -= this.overflow ? this.snapSize(this.overflowMenu.prefWidth(-1.0)) : 0.0;
        }
        this.box.resize(d, d2);
        this.positionInArea(this.box, this.snapSpace(this.getInsets().getLeft()), this.snapSpace(this.getInsets().getTop()), d, d2, 0.0, HPos.CENTER, VPos.CENTER);
        if (this.overflow) {
            double d3;
            double d4;
            double d5 = this.snapSize(this.overflowMenu.prefWidth(-1.0));
            double d6 = this.snapSize(this.overflowMenu.prefHeight(-1.0));
            if (((ToolBar)this.getSkinnable()).getOrientation() == Orientation.VERTICAL) {
                HPos hPos;
                if (d == 0.0) {
                    d = this.savedPrefWidth;
                }
                d4 = HPos.LEFT.equals((Object)(hPos = ((VBox)this.box).getAlignment().getHpos())) ? this.snapSpace(this.getInsets().getLeft()) + Math.abs((d - d5) / 2.0) : (HPos.RIGHT.equals((Object)hPos) ? this.snapSize(this.getWidth()) - this.snapSpace(this.getInsets().getRight()) - d + Math.abs((d - d5) / 2.0) : this.snapSpace(this.getInsets().getLeft()) + Math.abs((this.snapSize(this.getWidth()) - (this.snapSpace(this.getInsets().getLeft()) + this.snapSpace(this.getInsets().getRight())) - d5) / 2.0));
                d3 = this.snapSize(this.getHeight()) - d6 - this.snapSpace(this.getInsets().getTop());
            } else {
                VPos vPos;
                if (d2 == 0.0) {
                    d2 = this.savedPrefHeight;
                }
                d3 = VPos.TOP.equals((Object)(vPos = ((HBox)this.box).getAlignment().getVpos())) ? this.snapSpace(this.getInsets().getTop()) + Math.abs((d2 - d6) / 2.0) : (VPos.BOTTOM.equals((Object)vPos) ? this.snapSize(this.getHeight()) - this.snapSpace(this.getInsets().getBottom()) - d2 + Math.abs((d2 - d6) / 2.0) : this.snapSpace(this.getInsets().getTop()) + Math.abs((this.snapSize(this.getHeight()) - (this.snapSpace(this.getInsets().getTop()) + this.snapSpace(this.getInsets().getBottom())) - d6) / 2.0));
                d4 = this.snapSize(this.getWidth()) - d5 - this.snapSpace(this.getInsets().getRight());
            }
            this.overflowMenu.resize(d5, d6);
            this.positionInArea(this.overflowMenu, d4, d3, d5, d6, 0.0, HPos.CENTER, VPos.CENTER);
        }
    }

    private void initialize() {
        this.box = ((ToolBar)this.getSkinnable()).getOrientation() == Orientation.VERTICAL ? new VBox() : new HBox();
        this.box.getChildren().addAll((Collection<Node>)((ToolBar)this.getSkinnable()).getItems());
        this.overflowMenu = new ToolBarOverflowMenu(this.overflowMenuItems);
        this.overflowMenu.setVisible(false);
        this.overflowMenu.setManaged(false);
        this.getChildren().clear();
        this.getChildren().add(this.box);
        this.getChildren().add(this.overflowMenu);
        this.previousWidth = 0.0;
        this.previousHeight = 0.0;
        this.savedPrefWidth = 0.0;
        this.savedPrefHeight = 0.0;
        this.needsUpdate = true;
        this.requestLayout();
    }

    private void addNodesToToolBar() {
        double d = 0.0;
        d = ((ToolBar)this.getSkinnable()).getOrientation() == Orientation.VERTICAL ? this.snapSize(this.getHeight()) - (this.snapSpace(this.getInsets().getTop()) + this.snapSpace(this.getInsets().getBottom())) + this.getSpacing() : this.snapSize(this.getWidth()) - (this.snapSpace(this.getInsets().getLeft()) + this.snapSpace(this.getInsets().getRight())) + this.getSpacing();
        double d2 = 0.0;
        boolean bl = false;
        for (Node node : ((ToolBar)this.getSkinnable()).getItems()) {
            d2 = ((ToolBar)this.getSkinnable()).getOrientation() == Orientation.VERTICAL ? (d2 += this.snapSize(node.prefHeight(-1.0)) + this.getSpacing()) : (d2 += this.snapSize(node.prefWidth(-1.0)) + this.getSpacing());
            if (!(d2 > d)) continue;
            bl = true;
            break;
        }
        if (bl) {
            d = ((ToolBar)this.getSkinnable()).getOrientation() == Orientation.VERTICAL ? (d -= this.snapSize(this.overflowMenu.prefHeight(-1.0))) : (d -= this.snapSize(this.overflowMenu.prefWidth(-1.0)));
            d -= this.getSpacing();
        }
        d2 = 0.0;
        this.overflowMenuItems.clear();
        this.box.getChildren().clear();
        for (Node node : ((ToolBar)this.getSkinnable()).getItems()) {
            node.getStyleClass().remove("menu-item");
            node.getStyleClass().remove("custom-menu-item");
            d2 = ((ToolBar)this.getSkinnable()).getOrientation() == Orientation.VERTICAL ? (d2 += this.snapSize(node.prefHeight(-1.0)) + this.getSpacing()) : (d2 += this.snapSize(node.prefWidth(-1.0)) + this.getSpacing());
            if (d2 <= d) {
                this.box.getChildren().add(node);
                continue;
            }
            if (node.isFocused()) {
                if (!this.box.getChildren().isEmpty()) {
                    this.engine.registeredNodes.get(this.engine.registeredNodes.size() - 1).requestFocus();
                } else {
                    this.overflowMenu.requestFocus();
                }
            }
            if (node instanceof Separator) {
                this.overflowMenuItems.add(new SeparatorMenuItem());
                continue;
            }
            this.overflowMenuItems.add(new CustomMenuItem(node));
        }
        boolean bl2 = this.overflow = this.overflowMenuItems.size() > 0;
        if (!this.overflow && this.overflowMenu.isFocused()) {
            this.engine.registeredNodes.get(this.engine.registeredNodes.size() - 1).requestFocus();
        }
        this.overflowMenu.setVisible(this.overflow);
        this.overflowMenu.setManaged(this.overflow);
    }

    @Override
    public void onTraverse(Node node, Bounds bounds) {
        int n = this.engine.registeredNodes.indexOf(node);
        if (n == -1 && this.direction.equals((Object)Direction.NEXT) && this.overflow) {
            this.overflowMenu.requestFocus();
        }
    }

    @Deprecated
    public static List<StyleableProperty> impl_CSS_STYLEABLES() {
        return StyleableProperties.STYLEABLES;
    }

    @Override
    @Deprecated
    public List<StyleableProperty> impl_getStyleableProperties() {
        return ToolBarSkin.impl_CSS_STYLEABLES();
    }

    private static class StyleableProperties {
        private static final StyleableProperty<ToolBarSkin, Number> SPACING = new StyleableProperty<ToolBarSkin, Number>("-fx-spacing", (StyleConverter)SizeConverter.getInstance(), (Number)0.0){

            @Override
            public boolean isSettable(ToolBarSkin toolBarSkin) {
                return toolBarSkin.spacing == null || !toolBarSkin.spacing.isBound();
            }

            @Override
            public WritableValue<Number> getWritableValue(ToolBarSkin toolBarSkin) {
                return toolBarSkin.spacingProperty();
            }
        };
        private static final StyleableProperty<ToolBarSkin, Pos> ALIGNMENT = new StyleableProperty<ToolBarSkin, Pos>("-fx-alignment", new EnumConverter(Pos.class), Pos.TOP_LEFT){

            @Override
            public boolean isSettable(ToolBarSkin toolBarSkin) {
                return toolBarSkin.boxAlignment == null || !toolBarSkin.boxAlignment.isBound();
            }

            @Override
            public WritableValue<Pos> getWritableValue(ToolBarSkin toolBarSkin) {
                return toolBarSkin.boxAlignmentProperty();
            }
        };
        private static final List<StyleableProperty> STYLEABLES;

        private StyleableProperties() {
        }

        static {
            ArrayList<StyleableProperty> arrayList = new ArrayList<StyleableProperty>(SkinBase.impl_CSS_STYLEABLES());
            String string = ALIGNMENT.getProperty();
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                StyleableProperty styleableProperty = (StyleableProperty)arrayList.get(i);
                if (!string.equals(styleableProperty.getProperty())) continue;
                arrayList.remove(styleableProperty);
            }
            Collections.addAll(arrayList, SPACING, ALIGNMENT);
            STYLEABLES = Collections.unmodifiableList(arrayList);
        }
    }

    class ToolBarOverflowMenu
    extends StackPane {
        private StackPane downArrow;
        private ContextMenu popup;
        private ObservableList<MenuItem> menuItems;

        public ToolBarOverflowMenu(ObservableList<MenuItem> observableList) {
            this.getStyleClass().setAll((String[])new String[]{"tool-bar-overflow-button"});
            this.menuItems = observableList;
            this.downArrow = new StackPane();
            this.downArrow.getStyleClass().setAll((String[])new String[]{"arrow"});
            this.downArrow.setOnMousePressed((EventHandler<? super MouseEvent>)new EventHandler<MouseEvent>(){

                @Override
                public void handle(MouseEvent mouseEvent) {
                    if (ToolBarOverflowMenu.this.popup.isShowing()) {
                        ToolBarOverflowMenu.this.popup.hide();
                    } else {
                        ToolBarOverflowMenu.this.popup.getItems().clear();
                        ToolBarOverflowMenu.this.popup.getItems().addAll(ToolBarOverflowMenu.this.menuItems);
                        ToolBarOverflowMenu.this.popup.show(ToolBarOverflowMenu.this.downArrow, Side.BOTTOM, 0.0, 0.0);
                    }
                }
            });
            this.setOnKeyPressed((EventHandler<? super KeyEvent>)new EventHandler<KeyEvent>(){

                @Override
                public void handle(KeyEvent keyEvent) {
                    if (KeyCode.SPACE.equals((Object)keyEvent.getCode())) {
                        if (!ToolBarOverflowMenu.this.popup.isShowing()) {
                            ToolBarOverflowMenu.this.popup.getItems().clear();
                            ToolBarOverflowMenu.this.popup.getItems().addAll(ToolBarOverflowMenu.this.menuItems);
                            ToolBarOverflowMenu.this.popup.show(ToolBarOverflowMenu.this.downArrow, Side.BOTTOM, 0.0, 0.0);
                        }
                    } else if (KeyCode.ESCAPE.equals((Object)keyEvent.getCode())) {
                        if (ToolBarOverflowMenu.this.popup.isShowing()) {
                            ToolBarOverflowMenu.this.popup.hide();
                        }
                    } else if (KeyCode.ENTER.equals((Object)keyEvent.getCode())) {
                        if (ToolBarOverflowMenu.this.popup.isShowing()) {
                            ToolBarOverflowMenu.this.popup.hide();
                        } else {
                            ToolBarOverflowMenu.this.popup.getItems().clear();
                            ToolBarOverflowMenu.this.popup.getItems().addAll(ToolBarOverflowMenu.this.menuItems);
                            ToolBarOverflowMenu.this.popup.show(ToolBarOverflowMenu.this.downArrow, Side.BOTTOM, 0.0, 0.0);
                        }
                    } else if (KeyCode.UP.equals((Object)keyEvent.getCode()) || KeyCode.LEFT.equals((Object)keyEvent.getCode()) || KeyCode.TAB.equals((Object)keyEvent.getCode()) && keyEvent.isShiftDown()) {
                        if (((ToolBarSkin)ToolBarSkin.this).engine.registeredNodes.isEmpty()) {
                            return;
                        }
                        int n = ToolBarSkin.this.box.getChildren().indexOf(((ToolBarSkin)ToolBarSkin.this).engine.registeredNodes.get(((ToolBarSkin)ToolBarSkin.this).engine.registeredNodes.size() - 1));
                        if (n != -1) {
                            ((Node)ToolBarSkin.this.box.getChildren().get(n)).requestFocus();
                        } else if (!ToolBarSkin.this.box.getChildren().isEmpty()) {
                            ((Node)ToolBarSkin.this.box.getChildren().get(0)).requestFocus();
                        } else {
                            new TraversalEngine((Parent)((Object)ToolBarSkin.this.getSkinnable()), false).trav((Node)((Object)ToolBarSkin.this.getSkinnable()), Direction.PREVIOUS);
                        }
                    } else if (KeyCode.DOWN.equals((Object)keyEvent.getCode()) || KeyCode.RIGHT.equals((Object)keyEvent.getCode()) || KeyCode.TAB.equals((Object)keyEvent.getCode())) {
                        new TraversalEngine((Parent)((Object)ToolBarSkin.this.getSkinnable()), false).trav((Node)((Object)ToolBarSkin.this.getSkinnable()), Direction.NEXT);
                    }
                    keyEvent.consume();
                }
            });
            this.focusedProperty().addListener(new ChangeListener<Boolean>(){

                @Override
                public void changed(ObservableValue<? extends Boolean> observableValue, Boolean bl, Boolean bl2) {
                    if (bl2.booleanValue()) {
                        if (!ToolBarOverflowMenu.this.popup.isShowing()) {
                            ToolBarOverflowMenu.this.popup.getItems().clear();
                            ToolBarOverflowMenu.this.popup.getItems().addAll(ToolBarOverflowMenu.this.menuItems);
                            ToolBarOverflowMenu.this.popup.show(ToolBarOverflowMenu.this.downArrow, Side.BOTTOM, 0.0, 0.0);
                        }
                    } else if (ToolBarOverflowMenu.this.popup.isShowing()) {
                        ToolBarOverflowMenu.this.popup.hide();
                    }
                }
            });
            this.visibleProperty().addListener(new ChangeListener<Boolean>(){

                @Override
                public void changed(ObservableValue<? extends Boolean> observableValue, Boolean bl, Boolean bl2) {
                    if (bl2.booleanValue() && ToolBarSkin.this.box.getChildren().isEmpty()) {
                        ToolBarOverflowMenu.this.setFocusTraversable(true);
                    }
                }
            });
            this.popup = new ContextMenu();
            this.setVisible(false);
            this.setManaged(false);
            this.getChildren().add(this.downArrow);
        }

        @Override
        protected double computePrefWidth(double d) {
            return this.snapSize(this.getInsets().getLeft()) + this.snapSize(this.getInsets().getRight());
        }

        @Override
        protected double computePrefHeight(double d) {
            return this.snapSize(this.getInsets().getTop()) + this.snapSize(this.getInsets().getBottom());
        }

        @Override
        protected void layoutChildren() {
            double d = this.snapSize(this.downArrow.prefWidth(-1.0));
            double d2 = this.snapSize(this.downArrow.prefHeight(-1.0));
            double d3 = (this.snapSize(this.getWidth()) - d) / 2.0;
            double d4 = (this.snapSize(this.getHeight()) - d2) / 2.0;
            if (((ToolBar)ToolBarSkin.this.getSkinnable()).getOrientation() == Orientation.VERTICAL) {
                this.downArrow.setRotate(0.0);
            }
            this.downArrow.resize(d, d2);
            this.positionInArea(this.downArrow, d3, d4, d, d2, 0.0, HPos.CENTER, VPos.CENTER);
        }
    }
}

