/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.skin;

import com.sun.javafx.scene.control.behavior.BehaviorBase;
import com.sun.javafx.scene.control.skin.SkinBase;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.geometry.HPos;
import javafx.geometry.Orientation;
import javafx.geometry.VPos;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.control.SplitPane;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.StackPane;
import javafx.scene.shape.Rectangle;

public class SplitPaneSkin
extends SkinBase<SplitPane, BehaviorBase<SplitPane>> {
    private ObservableList<Content> contentRegions;
    private ObservableList<ContentDivider> contentDividers;
    private boolean horizontal;
    private double previousArea = -1.0;
    private double previousWidth = -1.0;
    private double previousHeight = -1.0;
    private int lastDividerUpdate = 0;
    private boolean resize = false;
    private boolean checkDividerPos = true;

    public SplitPaneSkin(SplitPane splitPane) {
        super(splitPane, new BehaviorBase<SplitPane>(splitPane));
        this.setManaged(false);
        this.horizontal = ((SplitPane)this.getSkinnable()).getOrientation() == Orientation.HORIZONTAL;
        this.contentRegions = FXCollections.observableArrayList();
        this.contentDividers = FXCollections.observableArrayList();
        int n = 0;
        for (Node object : ((SplitPane)this.getSkinnable()).getItems()) {
            this.addContent(n++, object);
        }
        this.initializeContentListener();
        for (SplitPane.Divider divider : ((SplitPane)this.getSkinnable()).getDividers()) {
            this.addDivider(divider);
        }
        this.registerChangeListener(splitPane.orientationProperty(), "ORIENTATION");
        this.registerChangeListener(splitPane.widthProperty(), "WIDTH");
        this.registerChangeListener(splitPane.heightProperty(), "HEIGHT");
    }

    private void addContent(int n, Node node) {
        Content content = new Content(node);
        this.contentRegions.add(n, content);
        this.getChildren().add(n, content);
    }

    private void removeContent(Node node) {
        for (Content content : this.contentRegions) {
            if (!content.getContent().equals(node)) continue;
            this.getChildren().remove(content);
            this.contentRegions.remove(content);
            break;
        }
    }

    private void initializeContentListener() {
        ((SplitPane)this.getSkinnable()).getItems().addListener(new ListChangeListener<Node>(){

            @Override
            public void onChanged(ListChangeListener.Change<? extends Node> change) {
                while (change.next()) {
                    for (Node node : change.getRemoved()) {
                        SplitPaneSkin.this.removeContent(node);
                    }
                    int n = change.getFrom();
                    for (Node node : change.getAddedSubList()) {
                        SplitPaneSkin.this.addContent(n++, node);
                    }
                }
                SplitPaneSkin.this.removeAllDividers();
                for (SplitPane.Divider divider : ((SplitPane)SplitPaneSkin.this.getSkinnable()).getDividers()) {
                    SplitPaneSkin.this.addDivider(divider);
                }
            }
        });
    }

    private void checkDividerPosition(ContentDivider contentDivider, double d, double d2) {
        double d3;
        double d4;
        double d5;
        double d6 = contentDivider.prefWidth(-1.0);
        Content content = this.getLeft(contentDivider);
        Content content2 = this.getRight(contentDivider);
        double d7 = content == null ? 0.0 : (d5 = this.horizontal ? content.minWidth(-1.0) : content.minHeight(-1.0));
        double d8 = content2 == null ? 0.0 : (d4 = this.horizontal ? content2.minWidth(-1.0) : content2.minHeight(-1.0));
        double d9 = content == null ? 0.0 : (content.getContent() != null ? (this.horizontal ? content.getContent().maxWidth(-1.0) : content.getContent().maxHeight(-1.0)) : (d3 = 0.0));
        double d10 = content2 == null ? 0.0 : (content2.getContent() != null ? (this.horizontal ? content2.getContent().maxWidth(-1.0) : content2.getContent().maxHeight(-1.0)) : 0.0);
        double d11 = 0.0;
        double d12 = this.getSize();
        int n = this.contentDividers.indexOf(contentDivider);
        if (n - 1 >= 0 && (d11 = ((ContentDivider)this.contentDividers.get(n - 1)).getDividerPos()) == -1.0) {
            d11 = this.getAbsoluteDividerPos((ContentDivider)this.contentDividers.get(n - 1));
        }
        if (n + 1 < this.contentDividers.size() && (d12 = ((ContentDivider)this.contentDividers.get(n + 1)).getDividerPos()) == -1.0) {
            d12 = this.getAbsoluteDividerPos((ContentDivider)this.contentDividers.get(n + 1));
        }
        this.checkDividerPos = false;
        if (d > d2) {
            double d13;
            double d14 = d11 == 0.0 ? d3 : d11 + d6 + d3;
            double d15 = Math.min(d14, d13 = d12 - d4 - d6);
            if (d >= d15) {
                this.setAbsoluteDividerPos(contentDivider, d15);
            } else {
                double d16 = d12 - d10 - d6;
                if (d <= d16) {
                    this.setAbsoluteDividerPos(contentDivider, d16);
                } else {
                    this.setAbsoluteDividerPos(contentDivider, d);
                }
            }
        } else {
            double d17 = d12 - d10 - d6;
            double d18 = d11 == 0.0 ? d5 : d11 + d5 + d6;
            double d19 = Math.max(d17, d18);
            if (d <= d19) {
                this.setAbsoluteDividerPos(contentDivider, d19);
            } else {
                double d20 = d11 + d3 + d6;
                if (d >= d20) {
                    this.setAbsoluteDividerPos(contentDivider, d20);
                } else {
                    this.setAbsoluteDividerPos(contentDivider, d);
                }
            }
        }
        this.checkDividerPos = true;
    }

    private void addDivider(SplitPane.Divider divider) {
        ContentDivider contentDivider = new ContentDivider(divider);
        contentDivider.setInitialPos(divider.getPosition());
        contentDivider.setDividerPos(-1.0);
        PosPropertyListener posPropertyListener = new PosPropertyListener(contentDivider);
        contentDivider.setPosPropertyListener(posPropertyListener);
        divider.positionProperty().addListener(posPropertyListener);
        this.initializeDivderEventHandlers(contentDivider);
        this.contentDividers.add(contentDivider);
        this.getChildren().add(contentDivider);
    }

    private void removeAllDividers() {
        ListIterator listIterator = this.contentDividers.listIterator();
        while (listIterator.hasNext()) {
            ContentDivider contentDivider = (ContentDivider)listIterator.next();
            this.getChildren().remove(contentDivider);
            contentDivider.getDivider().positionProperty().removeListener(contentDivider.getPosPropertyListener());
            listIterator.remove();
        }
        this.lastDividerUpdate = 0;
    }

    private void initializeDivderEventHandlers(final ContentDivider contentDivider) {
        contentDivider.addEventHandler(MouseEvent.ANY, new EventHandler<MouseEvent>(){

            @Override
            public void handle(MouseEvent mouseEvent) {
                mouseEvent.consume();
            }
        });
        contentDivider.setOnMousePressed((EventHandler<? super MouseEvent>)new EventHandler<MouseEvent>(){

            @Override
            public void handle(MouseEvent mouseEvent) {
                if (SplitPaneSkin.this.horizontal) {
                    contentDivider.setInitialPos(contentDivider.getDividerPos());
                    contentDivider.setPressPos(mouseEvent.getSceneX());
                } else {
                    contentDivider.setInitialPos(contentDivider.getDividerPos());
                    contentDivider.setPressPos(mouseEvent.getSceneY());
                }
                mouseEvent.consume();
            }
        });
        contentDivider.setOnMouseDragged((EventHandler<? super MouseEvent>)new EventHandler<MouseEvent>(){

            @Override
            public void handle(MouseEvent mouseEvent) {
                double d = (SplitPaneSkin.this.horizontal ? mouseEvent.getSceneX() : mouseEvent.getSceneY()) - contentDivider.getPressPos();
                double d2 = Math.ceil(contentDivider.getInitialPos() + d);
                SplitPaneSkin.this.checkDividerPos = true;
                SplitPaneSkin.this.setAbsoluteDividerPos(contentDivider, d2);
                mouseEvent.consume();
            }
        });
    }

    private Content getLeft(ContentDivider contentDivider) {
        int n = this.contentDividers.indexOf(contentDivider);
        if (n != -1) {
            return (Content)this.contentRegions.get(n);
        }
        return null;
    }

    private Content getRight(ContentDivider contentDivider) {
        int n = this.contentDividers.indexOf(contentDivider);
        if (n != -1) {
            return (Content)this.contentRegions.get(n + 1);
        }
        return null;
    }

    @Override
    protected void handleControlPropertyChanged(String string) {
        super.handleControlPropertyChanged(string);
        if (string == "ORIENTATION") {
            this.horizontal = ((SplitPane)this.getSkinnable()).getOrientation() == Orientation.HORIZONTAL;
            for (ContentDivider contentDivider : this.contentDividers) {
                contentDivider.setGrabberStyle(this.horizontal);
            }
            ((SplitPane)this.getSkinnable()).requestLayout();
        } else if (string == "WIDTH" || string == "HEIGHT") {
            this.requestLayout();
        }
    }

    private void setAbsoluteDividerPos(ContentDivider contentDivider, double d) {
        if (this.getWidth() > 0.0 && this.getHeight() > 0.0 && contentDivider != null) {
            SplitPane.Divider divider = contentDivider.getDivider();
            contentDivider.setDividerPos(d);
            double d2 = this.getSize();
            if (d2 != 0.0) {
                double d3 = d + contentDivider.prefWidth(-1.0) / 2.0;
                divider.setPosition(d3 / d2);
            } else {
                divider.setPosition(0.0);
            }
        }
    }

    private double getAbsoluteDividerPos(ContentDivider contentDivider) {
        if (this.getWidth() > 0.0 && this.getHeight() > 0.0 && contentDivider != null) {
            SplitPane.Divider divider = contentDivider.getDivider();
            double d = this.posToDividerPos(contentDivider, divider.getPosition());
            contentDivider.setDividerPos(d);
            return d;
        }
        return 0.0;
    }

    private double posToDividerPos(ContentDivider contentDivider, double d) {
        double d2 = this.getSize() * d;
        d2 = d == 1.0 ? (d2 -= contentDivider.prefWidth(-1.0)) : (d2 -= contentDivider.prefWidth(-1.0) / 2.0);
        return Math.round(d2);
    }

    private double totalMinSize() {
        double d = !this.contentDividers.isEmpty() ? (double)this.contentDividers.size() * ((ContentDivider)this.contentDividers.get(0)).prefWidth(-1.0) : 0.0;
        double d2 = 0.0;
        for (Content content : this.contentRegions) {
            if (this.horizontal) {
                d2 += content.minWidth(-1.0);
                continue;
            }
            d2 += content.minHeight(-1.0);
        }
        return d2 + d;
    }

    private double getSize() {
        double d = this.totalMinSize();
        if (this.horizontal) {
            if (this.getWidth() > d) {
                d = this.getWidth() - this.getInsets().getLeft() - this.getInsets().getRight();
            }
        } else if (this.getHeight() > d) {
            d = this.getHeight() - this.getInsets().getTop() - this.getInsets().getBottom();
        }
        return d;
    }

    private double distributeTo(List<Content> list, double d) {
        if (list.isEmpty()) {
            return d;
        }
        d = this.snapSize(d);
        int n = (int)d / list.size();
        while (d > 0.0 && !list.isEmpty()) {
            Iterator<Content> iterator = list.iterator();
            while (iterator.hasNext()) {
                double d2;
                Content content = iterator.next();
                double d3 = Math.min(this.horizontal ? content.maxWidth(-1.0) : content.maxHeight(-1.0), Double.MAX_VALUE);
                double d4 = d2 = this.horizontal ? content.minWidth(-1.0) : content.minHeight(-1.0);
                if (content.getArea() >= d3) {
                    content.setAvailable(content.getArea() - d2);
                    iterator.remove();
                    continue;
                }
                if ((double)n >= d3 - content.getArea()) {
                    d -= d3 - content.getArea();
                    content.setArea(d3);
                    content.setAvailable(d3 - d2);
                    iterator.remove();
                } else {
                    content.setArea(content.getArea() + (double)n);
                    content.setAvailable(content.getArea() - d2);
                    d -= (double)n;
                }
                if ((int)d != 0) continue;
                return d;
            }
            if (list.isEmpty()) {
                return d;
            }
            n = (int)d / list.size();
            int n2 = (int)d % list.size();
            if (n != 0 || n2 == 0) continue;
            n = n2;
            n2 = 0;
        }
        return d;
    }

    private double distributeFrom(double d, List<Content> list) {
        if (list.isEmpty()) {
            return d;
        }
        d = this.snapSize(d);
        int n = (int)d / list.size();
        while (d > 0.0 && !list.isEmpty()) {
            Iterator<Content> iterator = list.iterator();
            while (iterator.hasNext()) {
                Content content = iterator.next();
                if ((double)n >= content.getAvailable()) {
                    content.setArea(content.getArea() - content.getAvailable());
                    d -= content.getAvailable();
                    content.setAvailable(0.0);
                    iterator.remove();
                } else {
                    content.setArea(content.getArea() - (double)n);
                    content.setAvailable(content.getAvailable() - (double)n);
                    d -= (double)n;
                }
                if ((int)d != 0) continue;
                return d;
            }
            if (list.isEmpty()) {
                return d;
            }
            n = (int)d / list.size();
            int n2 = (int)d % list.size();
            if (n != 0 || n2 == 0) continue;
            n = n2;
            n2 = 0;
        }
        return d;
    }

    private void setupContentAndDividerForLayout() {
        double d = this.contentDividers.isEmpty() ? 0.0 : ((ContentDivider)this.contentDividers.get(0)).prefWidth(-1.0);
        double d2 = 0.0;
        double d3 = 0.0;
        for (Content stackPane : this.contentRegions) {
            if (this.resize && !stackPane.isResizableWithParent()) {
                stackPane.setArea(stackPane.getResizableWithParentArea());
            }
            stackPane.setX(d2);
            stackPane.setY(d3);
            if (this.horizontal) {
                d2 += stackPane.getArea() + d;
                continue;
            }
            d3 += stackPane.getArea() + d;
        }
        d2 = 0.0;
        d3 = 0.0;
        this.checkDividerPos = false;
        for (int i = 0; i < this.contentDividers.size(); ++i) {
            ContentDivider contentDivider = (ContentDivider)this.contentDividers.get(i);
            if (this.horizontal) {
                d2 += this.getLeft(contentDivider).getArea() + (i == 0 ? 0.0 : d);
            } else {
                d3 += this.getLeft(contentDivider).getArea() + (i == 0 ? 0.0 : d);
            }
            contentDivider.setX(d2);
            contentDivider.setY(d3);
            this.setAbsoluteDividerPos(contentDivider, this.horizontal ? contentDivider.getX() : contentDivider.getY());
        }
        this.checkDividerPos = true;
    }

    private void layoutDividersAndContent(double d, double d2) {
        double d3 = this.getInsets().getLeft();
        double d4 = this.getInsets().getTop();
        double d5 = this.contentDividers.isEmpty() ? 0.0 : ((ContentDivider)this.contentDividers.get(0)).prefWidth(-1.0);
        for (Content stackPane : this.contentRegions) {
            if (this.horizontal) {
                this.layoutInArea(stackPane, stackPane.getX() + d3, stackPane.getY() + d4, stackPane.getArea(), d2, 0.0, HPos.CENTER, VPos.CENTER);
                continue;
            }
            this.layoutInArea(stackPane, stackPane.getX() + d3, stackPane.getY() + d4, d, stackPane.getArea(), 0.0, HPos.CENTER, VPos.CENTER);
        }
        for (ContentDivider contentDivider : this.contentDividers) {
            if (this.horizontal) {
                contentDivider.resize(d5, d2);
                this.positionInArea(contentDivider, contentDivider.getX() + d3, contentDivider.getY() + d4, d5, d2, 0.0, HPos.CENTER, VPos.CENTER);
                continue;
            }
            contentDivider.resize(d, d5);
            this.positionInArea(contentDivider, contentDivider.getX() + d3, contentDivider.getY() + d4, d, d5, 0.0, HPos.CENTER, VPos.CENTER);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void layoutChildren() {
        int n;
        double d;
        double d2;
        double d3;
        block59: {
            block58: {
                int n2;
                int n3;
                boolean bl;
                ArrayList<Content> arrayList;
                block54: {
                    block57: {
                        if (!((SplitPane)this.getSkinnable()).isVisible()) return;
                        if (this.horizontal) {
                            if (this.getWidth() == 0.0) {
                                return;
                            }
                        } else if (this.getHeight() == 0.0) return;
                        if (this.contentRegions.isEmpty()) {
                            return;
                        }
                        d3 = this.contentDividers.isEmpty() ? 0.0 : ((ContentDivider)this.contentDividers.get(0)).prefWidth(-1.0);
                        d2 = this.getWidth() - (this.getInsets().getLeft() + this.getInsets().getRight());
                        d = this.getHeight() - (this.getInsets().getTop() + this.getInsets().getBottom());
                        if (this.contentDividers.size() <= 0 || this.previousArea == -1.0 || this.previousArea == this.getWidth() * this.getHeight()) break block57;
                        arrayList = new ArrayList<Content>();
                        for (Content content : this.contentRegions) {
                            if (!content.isResizableWithParent()) continue;
                            arrayList.add(content);
                        }
                        double d4 = this.horizontal ? this.getWidth() - this.previousWidth : this.getHeight() - this.previousHeight;
                        bl = d4 > 0.0;
                        d4 = Math.abs(d4);
                        if (arrayList.isEmpty()) break block58;
                        n3 = (int)d4 / arrayList.size();
                        n = (int)d4 % arrayList.size();
                        n2 = 0;
                        if (n3 == 0) {
                            n3 = n;
                            n2 = n;
                            n = 0;
                            break block54;
                        } else {
                            n2 = n3 * arrayList.size();
                        }
                        break block54;
                    }
                    this.previousArea = this.getWidth() * this.getHeight();
                    this.previousWidth = this.getWidth();
                    this.previousHeight = this.getHeight();
                    break block59;
                }
                while (n2 > 0 && !arrayList.isEmpty()) {
                    double d5;
                    Content content;
                    block55: {
                        double d6;
                        int n4;
                        if (bl) {
                            ++this.lastDividerUpdate;
                        } else {
                            --this.lastDividerUpdate;
                            if (this.lastDividerUpdate < 0) {
                                this.lastDividerUpdate = this.contentRegions.size() - 1;
                            }
                        }
                        if (!(content = (Content)this.contentRegions.get(n4 = this.lastDividerUpdate % this.contentRegions.size())).isResizableWithParent() || !arrayList.contains(content)) continue;
                        d5 = content.getArea();
                        if (bl) {
                            double d7 = d6 = this.horizontal ? content.maxWidth(-1.0) : content.maxHeight(-1.0);
                            if (d5 + (double)n3 <= d6) {
                                d5 += (double)n3;
                                break block55;
                            } else {
                                arrayList.remove(content);
                                continue;
                            }
                        }
                        double d8 = d6 = this.horizontal ? content.minWidth(-1.0) : content.minHeight(-1.0);
                        if (d5 - (double)n3 >= d6) {
                            d5 -= (double)n3;
                        } else {
                            arrayList.remove(content);
                            continue;
                        }
                    }
                    content.setArea(d5);
                    if ((n2 -= n3) == 0 && n != 0) {
                        n3 = n;
                        n2 = n;
                        n = 0;
                        continue;
                    }
                    if (n2 != 0) continue;
                }
            }
            this.previousArea = this.getWidth() * this.getHeight();
            this.previousWidth = this.getWidth();
            this.previousHeight = this.getHeight();
            for (Content content : this.contentRegions) {
                content.setResizableWithParentArea(content.getArea());
                content.setAvailable(0.0);
            }
            this.resize = true;
        }
        double d9 = this.totalMinSize();
        if (!(d9 > (this.horizontal ? d2 : d))) {
        } else {
            double d10 = 0.0;
            int n5 = 0;
            while (true) {
                if (n5 >= this.contentRegions.size()) {
                    this.setupContentAndDividerForLayout();
                    this.layoutDividersAndContent(d2, d);
                    this.resize = false;
                    return;
                }
                Content content = (Content)this.contentRegions.get(n5);
                double d11 = this.horizontal ? content.minWidth(-1.0) : content.minHeight(-1.0);
                d10 = d11 / d9;
                content.setArea(this.snapSpace(d10 * (this.horizontal ? d2 : d)));
                content.setAvailable(0.0);
                ++n5;
            }
        }
        for (int i = 0; i < 10; ++i) {
            ContentDivider contentDivider = null;
            Object object = null;
            for (n = 0; n < this.contentRegions.size(); ++n) {
                double d12 = 0.0;
                if (n < this.contentDividers.size()) {
                    object = (ContentDivider)this.contentDividers.get(n);
                    if (n == 0) {
                        d12 = this.getAbsoluteDividerPos((ContentDivider)object);
                    } else {
                        if (this.getAbsoluteDividerPos((ContentDivider)object) <= this.getAbsoluteDividerPos(contentDivider)) {
                            double d13 = this.getAbsoluteDividerPos(contentDivider);
                            this.checkDividerPos = true;
                            this.setAbsoluteDividerPos((ContentDivider)object, d13 + d3);
                        }
                        d12 = this.getAbsoluteDividerPos((ContentDivider)object) - (this.getAbsoluteDividerPos(contentDivider) + d3);
                    }
                } else if (n == this.contentDividers.size()) {
                    d12 = (this.horizontal ? d2 : d) - (contentDivider != null ? this.getAbsoluteDividerPos(contentDivider) + d3 : 0.0);
                }
                if (!this.resize) {
                    ((Content)this.contentRegions.get(n)).setArea(d12);
                }
                contentDivider = object;
            }
            double d14 = 0.0;
            double d15 = 0.0;
            for (Content content : this.contentRegions) {
                double d16 = 0.0;
                double d17 = 0.0;
                if (content != null) {
                    d16 = this.horizontal ? content.maxWidth(-1.0) : content.maxHeight(-1.0);
                    double d18 = d17 = this.horizontal ? content.minWidth(-1.0) : content.minHeight(-1.0);
                }
                if (content.getArea() >= d16) {
                    d15 += content.getArea() - d16;
                    content.setArea(d16);
                }
                content.setAvailable(content.getArea() - d17);
                if (!(content.getAvailable() < 0.0)) continue;
                d14 += content.getAvailable();
            }
            d14 = Math.abs(d14);
            ArrayList arrayList = new ArrayList();
            ArrayList<Content> arrayList2 = new ArrayList<Content>();
            ArrayList<Content> arrayList3 = new ArrayList<Content>();
            double d19 = 0.0;
            for (Content content : this.contentRegions) {
                if (content.getAvailable() >= 0.0) {
                    d19 += content.getAvailable();
                    arrayList.add(content);
                }
                if (this.resize && !content.isResizableWithParent()) {
                    if (content.getArea() >= content.getResizableWithParentArea()) {
                        d15 += content.getArea() - content.getResizableWithParentArea();
                    } else {
                        d14 += content.getResizableWithParentArea() - content.getArea();
                    }
                    content.setAvailable(0.0);
                }
                if (this.resize) {
                    if (content.isResizableWithParent()) {
                        arrayList2.add(content);
                    }
                } else {
                    arrayList2.add(content);
                }
                if (!(content.getAvailable() < 0.0)) continue;
                arrayList3.add(content);
            }
            if (d15 > 0.0) {
                d15 = this.distributeTo(arrayList2, d15);
                d14 = 0.0;
                arrayList3.clear();
                d19 = 0.0;
                arrayList.clear();
                for (Content content : this.contentRegions) {
                    if (content.getAvailable() < 0.0) {
                        d14 += content.getAvailable();
                        arrayList3.add(content);
                        continue;
                    }
                    d19 += content.getAvailable();
                    arrayList.add(content);
                }
                d14 = Math.abs(d14);
            }
            if (d19 >= d14) {
                for (Content content : arrayList3) {
                    double d20 = this.horizontal ? content.minWidth(-1.0) : content.minHeight(-1.0);
                    content.setArea(d20);
                    content.setAvailable(0.0);
                }
                if (d14 > 0.0 && !arrayList3.isEmpty()) {
                    this.distributeFrom(d14, arrayList);
                }
                if (this.resize) {
                    double d21 = 0.0;
                    for (Content content : this.contentRegions) {
                        if (content.isResizableWithParent()) {
                            d21 += content.getArea();
                            continue;
                        }
                        d21 += content.getResizableWithParentArea();
                    }
                    d21 += d3 * (double)this.contentDividers.size();
                    double d22 = this.horizontal ? d2 : d;
                    if (d21 < d22) {
                        this.distributeTo(arrayList2, d15 += (this.horizontal ? d2 : d) - d21);
                    } else {
                        this.distributeFrom(d14 += d21 - (this.horizontal ? d2 : d), arrayList2);
                    }
                }
            }
            this.setupContentAndDividerForLayout();
            boolean bl = true;
            for (Content content : this.contentRegions) {
                double d23;
                double d24 = this.horizontal ? content.maxWidth(-1.0) : content.maxHeight(-1.0);
                double d25 = d23 = this.horizontal ? content.minWidth(-1.0) : content.minHeight(-1.0);
                if (!(content.getArea() < d23) && !(content.getArea() > d24)) continue;
                bl = false;
                break;
            }
            if (bl) break;
        }
        this.layoutDividersAndContent(d2, d);
        this.resize = false;
    }

    @Override
    protected double computeMinWidth(double d) {
        double d2 = 0.0;
        double d3 = 0.0;
        for (Content stackPane : this.contentRegions) {
            d2 += stackPane.minWidth(-1.0);
            d3 = Math.max(d3, stackPane.minWidth(-1.0));
        }
        for (ContentDivider contentDivider : this.contentDividers) {
            d2 += contentDivider.prefWidth(-1.0);
        }
        if (this.horizontal) {
            return d2 + this.getInsets().getLeft() + this.getInsets().getRight();
        }
        return d3 + this.getInsets().getLeft() + this.getInsets().getRight();
    }

    @Override
    protected double computeMinHeight(double d) {
        double d2 = 0.0;
        double d3 = 0.0;
        for (Content stackPane : this.contentRegions) {
            d2 += stackPane.minHeight(-1.0);
            d3 = Math.max(d3, stackPane.minHeight(-1.0));
        }
        for (ContentDivider contentDivider : this.contentDividers) {
            d2 += contentDivider.prefWidth(-1.0);
        }
        if (this.horizontal) {
            return d3 + this.getInsets().getTop() + this.getInsets().getBottom();
        }
        return d2 + this.getInsets().getTop() + this.getInsets().getBottom();
    }

    @Override
    protected double computePrefWidth(double d) {
        double d2 = 0.0;
        double d3 = 0.0;
        for (Content stackPane : this.contentRegions) {
            d2 += stackPane.prefWidth(-1.0);
            d3 = Math.max(d3, stackPane.prefWidth(-1.0));
        }
        for (ContentDivider contentDivider : this.contentDividers) {
            d2 += contentDivider.prefWidth(-1.0);
        }
        if (this.horizontal) {
            return d2 + this.getInsets().getLeft() + this.getInsets().getRight();
        }
        return d3 + this.getInsets().getLeft() + this.getInsets().getRight();
    }

    @Override
    protected double computePrefHeight(double d) {
        double d2 = 0.0;
        double d3 = 0.0;
        for (Content stackPane : this.contentRegions) {
            d2 += stackPane.prefHeight(-1.0);
            d3 = Math.max(d3, stackPane.prefHeight(-1.0));
        }
        for (ContentDivider contentDivider : this.contentDividers) {
            d2 += contentDivider.prefWidth(-1.0);
        }
        if (this.horizontal) {
            return d3 + this.getInsets().getTop() + this.getInsets().getBottom();
        }
        return d2 + this.getInsets().getTop() + this.getInsets().getBottom();
    }

    private void printDividerPositions() {
        for (int i = 0; i < this.contentDividers.size(); ++i) {
            System.out.print("DIVIDER[" + i + "] " + ((ContentDivider)this.contentDividers.get(i)).getDividerPos() + " ");
        }
        System.out.println("");
    }

    private void printAreaAndAvailable() {
        int n;
        for (n = 0; n < this.contentRegions.size(); ++n) {
            System.out.print("AREA[" + n + "] " + ((Content)this.contentRegions.get(n)).getArea() + " ");
        }
        System.out.println("");
        for (n = 0; n < this.contentRegions.size(); ++n) {
            System.out.print("AVAILABLE[" + n + "] " + ((Content)this.contentRegions.get(n)).getAvailable() + " ");
        }
        System.out.println("");
        for (n = 0; n < this.contentRegions.size(); ++n) {
            System.out.print("RESIZABLEWTIHPARENT[" + n + "] " + ((Content)this.contentRegions.get(n)).getResizableWithParentArea() + " ");
        }
        System.out.println("");
    }

    class Content
    extends StackPane {
        private Node content;
        private Rectangle clipRect = new Rectangle();
        private double x;
        private double y;
        private double area;
        private double resizableWithParentArea;
        private double available;

        public Content(Node node) {
            this.setClip(this.clipRect);
            this.content = node;
            if (node != null) {
                this.setId(node.getId());
                this.getChildren().add(node);
            }
            this.x = 0.0;
            this.y = 0.0;
        }

        public Node getContent() {
            return this.content;
        }

        public double getX() {
            return this.x;
        }

        public void setX(double d) {
            this.x = d;
        }

        public double getY() {
            return this.y;
        }

        public void setY(double d) {
            this.y = d;
        }

        public double getArea() {
            return this.area;
        }

        public void setArea(double d) {
            this.area = d;
        }

        public double getAvailable() {
            return this.available;
        }

        public void setAvailable(double d) {
            this.available = d;
        }

        public boolean isResizableWithParent() {
            return SplitPane.isResizableWithParent(this.content);
        }

        public double getResizableWithParentArea() {
            return this.resizableWithParentArea;
        }

        public void setResizableWithParentArea(double d) {
            this.resizableWithParentArea = !this.isResizableWithParent() ? d : 0.0;
        }

        @Override
        protected void setWidth(double d) {
            super.setWidth(d);
            this.clipRect.setWidth(d);
        }

        @Override
        protected void setHeight(double d) {
            super.setHeight(d);
            this.clipRect.setHeight(d);
        }

        @Override
        protected double computeMaxWidth(double d) {
            return this.snapSize(this.content.maxWidth(d));
        }

        @Override
        protected double computeMaxHeight(double d) {
            return this.snapSize(this.content.maxHeight(d));
        }
    }

    class ContentDivider
    extends StackPane {
        private double initialPos;
        private double dividerPos;
        private double pressPos;
        private SplitPane.Divider d;
        private StackPane grabber;
        private double x;
        private double y;
        private ChangeListener listener;

        public ContentDivider(SplitPane.Divider divider) {
            this.getStyleClass().setAll((String[])new String[]{"split-pane-divider"});
            this.d = divider;
            this.initialPos = 0.0;
            this.dividerPos = 0.0;
            this.pressPos = 0.0;
            this.grabber = new StackPane(){

                @Override
                protected double computeMinWidth(double d) {
                    return 0.0;
                }

                @Override
                protected double computeMinHeight(double d) {
                    return 0.0;
                }

                @Override
                protected double computePrefWidth(double d) {
                    return this.getInsets().getLeft() + this.getInsets().getRight();
                }

                @Override
                protected double computePrefHeight(double d) {
                    return this.getInsets().getTop() + this.getInsets().getBottom();
                }

                @Override
                protected double computeMaxWidth(double d) {
                    return this.computePrefWidth(-1.0);
                }

                @Override
                protected double computeMaxHeight(double d) {
                    return this.computePrefHeight(-1.0);
                }
            };
            this.setGrabberStyle(SplitPaneSkin.this.horizontal);
            this.getChildren().add(this.grabber);
        }

        public SplitPane.Divider getDivider() {
            return this.d;
        }

        public final void setGrabberStyle(boolean bl) {
            this.grabber.getStyleClass().clear();
            this.grabber.getStyleClass().setAll((String[])new String[]{"vertical-grabber"});
            this.setCursor(Cursor.V_RESIZE);
            if (bl) {
                this.grabber.getStyleClass().setAll((String[])new String[]{"horizontal-grabber"});
                this.setCursor(Cursor.H_RESIZE);
            }
        }

        public double getInitialPos() {
            return this.initialPos;
        }

        public void setInitialPos(double d) {
            this.initialPos = d;
        }

        public double getDividerPos() {
            return this.dividerPos;
        }

        public void setDividerPos(double d) {
            this.dividerPos = d;
        }

        public double getPressPos() {
            return this.pressPos;
        }

        public void setPressPos(double d) {
            this.pressPos = d;
        }

        public double getX() {
            return this.x;
        }

        public void setX(double d) {
            this.x = d;
        }

        public double getY() {
            return this.y;
        }

        public void setY(double d) {
            this.y = d;
        }

        public ChangeListener getPosPropertyListener() {
            return this.listener;
        }

        public void setPosPropertyListener(ChangeListener changeListener) {
            this.listener = changeListener;
        }

        @Override
        protected double computeMinWidth(double d) {
            return this.computePrefWidth(d);
        }

        @Override
        protected double computeMinHeight(double d) {
            return this.computePrefHeight(d);
        }

        @Override
        protected double computePrefWidth(double d) {
            return this.snapSpace(this.getInsets().getLeft()) + this.snapSpace(this.getInsets().getRight());
        }

        @Override
        protected double computePrefHeight(double d) {
            return this.snapSpace(this.getInsets().getTop()) + this.snapSpace(this.getInsets().getBottom());
        }

        @Override
        protected double computeMaxWidth(double d) {
            return this.computePrefWidth(d);
        }

        @Override
        protected double computeMaxHeight(double d) {
            return this.computePrefHeight(d);
        }

        @Override
        protected void layoutChildren() {
            double d = this.grabber.prefWidth(-1.0);
            double d2 = this.grabber.prefHeight(-1.0);
            double d3 = (this.getWidth() - d) / 2.0;
            double d4 = (this.getHeight() - d2) / 2.0;
            this.grabber.resize(d, d2);
            this.positionInArea(this.grabber, d3, d4, d, d2, 0.0, HPos.CENTER, VPos.CENTER);
        }
    }

    class PosPropertyListener
    implements ChangeListener<Double> {
        ContentDivider divider;

        public PosPropertyListener(ContentDivider contentDivider) {
            this.divider = contentDivider;
        }

        @Override
        public void changed(ObservableValue observableValue, Double d, Double d2) {
            if (SplitPaneSkin.this.checkDividerPos) {
                SplitPaneSkin.this.checkDividerPosition(this.divider, SplitPaneSkin.this.posToDividerPos(this.divider, d2), SplitPaneSkin.this.posToDividerPos(this.divider, d));
            }
            SplitPaneSkin.this.requestLayout();
        }
    }
}

