/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.gtk;

import com.sun.glass.ui.Application;
import com.sun.glass.ui.CommonDialogs;
import com.sun.glass.ui.Cursor;
import com.sun.glass.ui.InvokeLaterDispatcher;
import com.sun.glass.ui.Launchable;
import com.sun.glass.ui.Pen;
import com.sun.glass.ui.Pixels;
import com.sun.glass.ui.Robot;
import com.sun.glass.ui.Screen;
import com.sun.glass.ui.Size;
import com.sun.glass.ui.Timer;
import com.sun.glass.ui.View;
import com.sun.glass.ui.Window;
import com.sun.glass.ui.gtk.GtkChildWindow;
import com.sun.glass.ui.gtk.GtkCommonDialogs;
import com.sun.glass.ui.gtk.GtkCursor;
import com.sun.glass.ui.gtk.GtkPixels;
import com.sun.glass.ui.gtk.GtkRobot;
import com.sun.glass.ui.gtk.GtkTimer;
import com.sun.glass.ui.gtk.GtkView;
import com.sun.glass.ui.gtk.GtkWindow;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GtkApplication
extends Application
implements InvokeLaterDispatcher.InvokeLaterSubmitter {
    public static int screen = -1;
    public static long display = 0L;
    public static long visualID = 0L;
    private final InvokeLaterDispatcher invokeLaterDispatcher = new InvokeLaterDispatcher(this);
    private Object eventLoopExitEnterPassValue;

    public GtkApplication() {
        this.invokeLaterDispatcher.start();
    }

    private void initDisplay() {
        Map ds = GtkApplication.getDeviceDetails();
        if (ds != null) {
            Object value = ds.get("XDisplay");
            if (value != null) {
                display = (Long)value;
            }
            if ((value = ds.get("XVisualID")) != null) {
                visualID = (Long)value;
            }
            if ((value = ds.get("XScreenID")) != null) {
                screen = (Integer)value;
            }
        }
    }

    private void init() {
        this.initDisplay();
        this._init();
    }

    @Override
    protected void runLoop(final String[] args, final Launchable launchable) {
        boolean isEventThread = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return Boolean.getBoolean("javafx.embed.isEventThread");
            }
        });
        final boolean isEmbedded = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return Boolean.getBoolean("javafx.macosx.embedded");
            }
        });
        if (isEventThread) {
            this.init();
            this.setEventThread(Thread.currentThread());
            launchable.finishLaunching(args);
            return;
        }
        Thread toolkitThread = AccessController.doPrivileged(new PrivilegedAction<Thread>(){

            @Override
            public Thread run() {
                Thread th = new Thread(new Runnable(){

                    public void run() {
                        GtkApplication.this.init();
                        GtkApplication.this._runLoop(args, launchable, isEmbedded);
                    }
                }, "GtkNativeMainLoopThread");
                return th;
            }
        });
        this.setEventThread(toolkitThread);
        toolkitThread.start();
    }

    @Override
    protected void finishTerminating() {
        Thread toolkitThread = this.getEventThread();
        if (toolkitThread != null) {
            this._terminateLoop();
            this.setEventThread(null);
        }
        super.finishTerminating();
    }

    @Override
    public boolean shouldUpdateWindow() {
        return true;
    }

    private native void _terminateLoop();

    private native void _init();

    protected native void _runLoop(String[] var1, Launchable var2, boolean var3);

    @Override
    protected native void _invokeAndWait(Runnable var1);

    @Override
    public native void submitForLaterInvocation(Runnable var1);

    @Override
    protected void _invokeLater(Runnable runnable) {
        this.invokeLaterDispatcher.invokeLater(runnable);
    }

    @Override
    protected void _postOnEventQueue(Runnable runnable) {
        this._invokeLater(runnable);
    }

    private native void enterNestedEventLoopImpl();

    private native void leaveNestedEventLoopImpl();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Object _enterNestedEventLoop() {
        this.invokeLaterDispatcher.notifyEnteringNestedEventLoop();
        try {
            this.enterNestedEventLoopImpl();
            Object retValue = this.eventLoopExitEnterPassValue;
            this.eventLoopExitEnterPassValue = null;
            Object object = retValue;
            return object;
        }
        finally {
            this.invokeLaterDispatcher.notifyLeftNestedEventLoop();
        }
    }

    @Override
    protected void _leaveNestedEventLoop(Object retValue) {
        this.invokeLaterDispatcher.notifyLeavingNestedEventLoop();
        this.eventLoopExitEnterPassValue = retValue;
        this.leaveNestedEventLoopImpl();
    }

    @Override
    public Window createWindow(Window owner, Screen screen, int styleMask) {
        return new GtkWindow(owner, screen, styleMask);
    }

    @Override
    public Window createWindow(long parent) {
        return new GtkChildWindow(parent);
    }

    @Override
    public View createView(Pen pen) {
        return new GtkView(pen);
    }

    @Override
    public Cursor createCursor(int type) {
        return new GtkCursor(type);
    }

    @Override
    public Cursor createCursor(int x, int y, Pixels pixels) {
        return new GtkCursor(x, y, pixels);
    }

    @Override
    protected void staticCursor_setVisible(boolean visible) {
    }

    @Override
    protected Size staticCursor_getBestSize(int width, int height) {
        return GtkCursor._getBestSize(width, height);
    }

    @Override
    public Pixels createPixels(int width, int height, ByteBuffer data) {
        return new GtkPixels(width, height, data);
    }

    @Override
    public Pixels createPixels(int width, int height, IntBuffer data) {
        return new GtkPixels(width, height, data);
    }

    @Override
    protected int staticPixels_getNativeFormat() {
        return 1;
    }

    @Override
    public Robot createRobot() {
        return new GtkRobot();
    }

    @Override
    protected Screen staticScreen_getDeepestScreen() {
        List<Screen> screens = this.staticScreen_getScreens();
        Screen deepest = screens.get(0);
        int nScreens = screens.size();
        for (int i = 1; i < nScreens; ++i) {
            if (deepest.getDepth() >= screens.get(i).getDepth()) continue;
            deepest = screens.get(i);
        }
        return deepest;
    }

    @Override
    protected Screen staticScreen_getMainScreen() {
        List<Screen> screens = this.staticScreen_getScreens();
        return screens.get(0);
    }

    @Override
    protected Screen staticScreen_getScreenForLocation(int x, int y) {
        List<Screen> screens = this.staticScreen_getScreens();
        for (Screen screen : screens) {
            if (x < screen.getX() || x > screen.getWidth() + screen.getX() || y < screen.getY() || y > screen.getHeight() + screen.getY()) continue;
            return screen;
        }
        return null;
    }

    @Override
    protected Screen staticScreen_getScreenForPtr(long screenPtr) {
        List<Screen> screens = this.staticScreen_getScreens();
        for (Screen screen : screens) {
            if (screen.getNativeScreen() != screenPtr) continue;
            return screen;
        }
        return null;
    }

    @Override
    protected native List<Screen> staticScreen_getScreens();

    @Override
    public Timer createTimer(Runnable runnable) {
        return new GtkTimer(runnable);
    }

    @Override
    protected native int staticTimer_getMinPeriod();

    @Override
    protected native int staticTimer_getMaxPeriod();

    @Override
    protected String[] staticCommonDialogs_showFileChooser(Window owner, String folder, String title, int type, boolean multipleMode, CommonDialogs.ExtensionFilter[] extensionFilters) {
        return GtkCommonDialogs.showFileChooser(owner, folder, title, type, multipleMode, extensionFilters);
    }

    @Override
    protected String staticCommonDialogs_showFolderChooser(Window owner, String folder, String title) {
        return GtkCommonDialogs.showFolderChooser(owner, folder, title);
    }

    @Override
    protected native long staticView_getMultiClickTime();

    @Override
    protected native int staticView_getMultiClickMaxX();

    @Override
    protected native int staticView_getMultiClickMaxY();

    @Override
    public native boolean supportsTransparentWindows();
}

