/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.resources;

import com.sun.deploy.trace.Trace;
import java.awt.Color;
import java.awt.Font;
import java.lang.reflect.Field;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JLabel;

public class ResourceManager {
    private static ResourceBundle rb;
    private static NumberFormat _numberFormat;
    static Class _keyEventClazz;
    static /* synthetic */ Class class$com$sun$deploy$resources$ResourceManager;

    static void reset() {
        rb = ResourceBundle.getBundle("com.sun.deploy.resources.Deployment");
        _numberFormat = NumberFormat.getInstance();
    }

    public static String getMessage(String string) {
        try {
            return ResourceManager.removeMnemonics(rb.getString(string));
        }
        catch (MissingResourceException missingResourceException) {
            return string;
        }
    }

    public static String getFormattedMessage(String string, Object[] objectArray) {
        try {
            MessageFormat messageFormat = new MessageFormat(ResourceManager.getMessage(string));
            return messageFormat.format(objectArray);
        }
        catch (MissingResourceException missingResourceException) {
            return string;
        }
    }

    public static String getString(String string) {
        return ResourceManager.getMessage(string);
    }

    public static int getInteger(String string) {
        try {
            return Integer.parseInt(ResourceManager.removeMnemonics(rb.getString(string)), 16);
        }
        catch (MissingResourceException missingResourceException) {
            Trace.ignoredException(missingResourceException);
            return -1;
        }
    }

    public static String getString(String string, String string2) {
        Object[] objectArray = new Object[]{string2};
        return ResourceManager.applyPattern(string, objectArray);
    }

    public static String getString(String string, String string2, String string3) {
        Object[] objectArray = new Object[]{string2, string3};
        return ResourceManager.applyPattern(string, objectArray);
    }

    public static String getString(String string, Long l, Long l2) {
        Object[] objectArray = new Object[]{l, l2};
        return ResourceManager.applyPattern(string, objectArray);
    }

    public static String getString(String string, String string2, String string3, String string4) {
        Object[] objectArray = new Object[]{string2, string3, string4};
        return ResourceManager.applyPattern(string, objectArray);
    }

    public static String getString(String string, String string2, String string3, String string4, String string5) {
        Object[] objectArray = new Object[]{string2, string3, string4, string5};
        return ResourceManager.applyPattern(string, objectArray);
    }

    public static String getString(String string, int n) {
        Object[] objectArray = new Object[]{new Integer(n)};
        return ResourceManager.applyPattern(string, objectArray);
    }

    public static String getString(String string, int n, int n2, int n3) {
        Object[] objectArray = new Object[]{new Integer(n), new Integer(n2), new Integer(n3)};
        return ResourceManager.applyPattern(string, objectArray);
    }

    public static String getString(String string, String string2, int n, String string3) {
        Object[] objectArray = new Object[]{string2, new Integer(n), string3};
        return ResourceManager.applyPattern(string, objectArray);
    }

    public static String getString(String string, String string2, int n) {
        Object[] objectArray = new Object[]{string2, new Integer(n)};
        return ResourceManager.applyPattern(string, objectArray);
    }

    public static synchronized String formatDouble(double d, int n) {
        _numberFormat.setGroupingUsed(true);
        _numberFormat.setMaximumFractionDigits(n);
        _numberFormat.setMinimumFractionDigits(n);
        return _numberFormat.format(d);
    }

    public static ImageIcon getIcon(String string) {
        String string2 = ResourceManager.getString(string);
        return new ImageIcon((class$com$sun$deploy$resources$ResourceManager == null ? (class$com$sun$deploy$resources$ResourceManager = ResourceManager.class$("com.sun.deploy.resources.ResourceManager")) : class$com$sun$deploy$resources$ResourceManager).getResource(string2));
    }

    public static ImageIcon[] getIcons(String string) {
        ImageIcon[] imageIconArray = new ImageIcon[4];
        String string2 = ResourceManager.getString(string);
        imageIconArray[0] = new ImageIcon((class$com$sun$deploy$resources$ResourceManager == null ? (class$com$sun$deploy$resources$ResourceManager = ResourceManager.class$("com.sun.deploy.resources.ResourceManager")) : class$com$sun$deploy$resources$ResourceManager).getResource(string2));
        int n = string2.lastIndexOf(".");
        String string3 = string2;
        String string4 = "";
        if (n > 0) {
            string3 = string2.substring(0, n);
            string4 = string2.substring(n);
        }
        imageIconArray[1] = new ImageIcon((class$com$sun$deploy$resources$ResourceManager == null ? (class$com$sun$deploy$resources$ResourceManager = ResourceManager.class$("com.sun.deploy.resources.ResourceManager")) : class$com$sun$deploy$resources$ResourceManager).getResource(string3 + "-p" + string4));
        imageIconArray[2] = new ImageIcon((class$com$sun$deploy$resources$ResourceManager == null ? (class$com$sun$deploy$resources$ResourceManager = ResourceManager.class$("com.sun.deploy.resources.ResourceManager")) : class$com$sun$deploy$resources$ResourceManager).getResource(string3 + "-d" + string4));
        imageIconArray[3] = new ImageIcon((class$com$sun$deploy$resources$ResourceManager == null ? (class$com$sun$deploy$resources$ResourceManager = ResourceManager.class$("com.sun.deploy.resources.ResourceManager")) : class$com$sun$deploy$resources$ResourceManager).getResource(string3 + "-o" + string4));
        return imageIconArray;
    }

    private static String applyPattern(String string, Object[] objectArray) {
        String string2 = ResourceManager.getString(string);
        String string3 = MessageFormat.format(string2, objectArray);
        return string3;
    }

    public static Color getColor(String string) {
        int n = ResourceManager.getInteger(string);
        return new Color(n);
    }

    public static Font getUIFont() {
        return new JLabel().getFont();
    }

    public static int getMinFontSize() {
        int n = 0;
        try {
            n = (Integer)rb.getObject("ui.min.font.size");
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return n;
    }

    public static String removeMnemonics(String string) {
        int n = string.indexOf("&");
        int n2 = string.length();
        if (n < 0 || n == n2 - 1) {
            return string;
        }
        int n3 = string.indexOf("&", n + 1);
        if (n3 == n + 1) {
            if (n3 + 1 == n2) {
                return string.substring(0, n);
            }
            return string.substring(0, n) + ResourceManager.removeMnemonics(string.substring(n3 + 1));
        }
        if (n == 0) {
            return ResourceManager.removeMnemonics(string.substring(1));
        }
        return string.substring(0, n) + ResourceManager.removeMnemonics(string.substring(n + 1));
    }

    public static String extractMnemonic(String string) {
        if (string != null) {
            try {
                int n = string.indexOf("&");
                int n2 = string.length();
                if (n < 0 || n == n2 - 1) {
                    return null;
                }
                int n3 = string.indexOf("&", n + 1);
                if (n3 == n + 1) {
                    if (n3 + 1 == n2) {
                        return null;
                    }
                    return ResourceManager.extractMnemonic(string.substring(n3 + 1));
                }
                return string.substring(n + 1, n + 2);
            }
            catch (Exception exception) {
                Trace.ignored(exception);
            }
        }
        return null;
    }

    public static int getMnemonic(String string) {
        String string2;
        try {
            string2 = rb.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            Trace.ignored(missingResourceException);
            return 0;
        }
        String string3 = ResourceManager.extractMnemonic(string2);
        if (string3 == null || string3.length() != 1) {
            return 0;
        }
        String string4 = "VK_" + string3.toUpperCase();
        try {
            if (_keyEventClazz == null) {
                _keyEventClazz = Class.forName("java.awt.event.KeyEvent");
            }
            Field field = _keyEventClazz.getDeclaredField(string4);
            int n = field.getInt(null);
            return n;
        }
        catch (ClassNotFoundException classNotFoundException) {
            Trace.ignoredException(classNotFoundException);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            Trace.ignoredException(noSuchFieldException);
        }
        catch (SecurityException securityException) {
            Trace.ignoredException(securityException);
        }
        catch (Exception exception) {
            Trace.ignoredException(exception);
        }
        return 0;
    }

    public static int getAcceleratorKey(String string) {
        return ResourceManager.getMnemonic(string);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        ResourceManager.reset();
        _keyEventClazz = null;
    }
}

