/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.net;

import com.sun.applet2.preloader.CancelException;
import com.sun.deploy.Environment;
import com.sun.deploy.cache.Cache;
import com.sun.deploy.cache.CacheEntry;
import com.sun.deploy.cache.MemoryCache;
import com.sun.deploy.config.Config;
import com.sun.deploy.jardiff.JarDiffPatcher;
import com.sun.deploy.jardiff.Patcher;
import com.sun.deploy.model.DownloadDelegate;
import com.sun.deploy.net.BasicHttpRequest;
import com.sun.deploy.net.FailedDownloadException;
import com.sun.deploy.net.HttpDownload;
import com.sun.deploy.net.HttpDownloadHelper;
import com.sun.deploy.net.HttpDownloadListener;
import com.sun.deploy.net.HttpRequest;
import com.sun.deploy.net.HttpResponse;
import com.sun.deploy.net.HttpUtils;
import com.sun.deploy.net.JARSigningException;
import com.sun.deploy.net.URLEncoder;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.security.JarVerifier;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.util.SystemUtils;
import com.sun.deploy.util.URLUtil;
import com.sun.deploy.util.VersionID;
import com.sun.deploy.util.VersionString;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Date;
import java.util.Hashtable;
import java.util.Locale;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Pack200;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipOutputStream;

public class DownloadEngine {
    private static final String ARG_ARCH = "arch";
    private static final String ARG_OS = "os";
    private static final String ARG_LOCALE = "locale";
    private static final String ARG_VERSION_ID = "version-id";
    private static final String ARG_JFX_VERSION_ID = "jfx-version-id";
    public static final String ARG_CURRENT_VERSION_ID = "current-version-id";
    private static final String ARG_PLATFORM_VERSION_ID = "platform-version-id";
    private static final String ARG_KNOWN_PLATFORMS = "known-platforms";
    private static final String REPLY_JNLP_VERSION = "x-java-jnlp-version-id";
    private static final String ERROR_MIME_TYPE = "application/x-java-jnlp-error";
    private static final String JARDIFF_MIME_TYPE = "application/x-java-archive-diff";
    private static final String JNLP_MIME_TYPE = "application/x-java-jnlp-file";
    private static final int BASIC_DOWNLOAD_PROTOCOL = 1;
    private static final int VERSION_DOWNLOAD_PROTOCOL = 2;
    private static final int EXTENSION_DOWNLOAD_PROTOCOL = 3;
    private static int BUF_SIZE = 8192;
    private static final String defaultLocaleString = Locale.getDefault().toString();
    private static HttpRequest _httpRequestImpl;
    private static HttpDownload _httpDownloadImpl;
    private static InheritableThreadLocal backgroundUpdateThreadLocal;
    private static ThreadLocal processingState;
    private static final ThreadLocal internalUse;
    private static Hashtable noCacheJarFileList;
    private static Hashtable noCacheRedirectFinalURLs;

    public static boolean haveDownloadInProgress() {
        return processingState.get() != null;
    }

    private static void setDownloadInProgress(boolean bl) {
        if (bl) {
            processingState.set(Boolean.TRUE);
        } else {
            processingState.set(null);
        }
    }

    public static boolean isBackgroundUpdateRequest() {
        return (Boolean)backgroundUpdateThreadLocal.get();
    }

    public static void _setBackgroundUpdateRequest(boolean bl) {
        backgroundUpdateThreadLocal.set(new Boolean(bl));
    }

    public static int _incrementInternalUse() {
        int n = DownloadEngine.getInternalUseLevel() + 1;
        SystemUtils.setThreadLocalInt(internalUse, n);
        return n;
    }

    public static void _decrementInternalUse(int n) {
        int n2 = DownloadEngine.getInternalUseLevel();
        if (n2 != n) {
            if (Trace.isEnabled(TraceLevel.NETWORK)) {
                Trace.ignored(new Exception("WARNING: unbalanced internalUse level: expect=" + n + " : got=" + n2));
            }
            n2 = n;
        }
        --n2;
        if (n2 < 0) {
            n2 = 0;
        }
        SystemUtils.setThreadLocalInt(internalUse, n2);
    }

    public static boolean isInternalUse() {
        return DownloadEngine.getInternalUseLevel() > 0;
    }

    private static int getInternalUseLevel() {
        return SystemUtils.getThreadLocalInt(internalUse);
    }

    public static boolean isNativeContentType(int n) {
        return DownloadEngine.hasBit(n, 16);
    }

    public static boolean isJarContentType(int n) {
        return DownloadEngine.hasBit(n, 256);
    }

    public static boolean isPackContentType(int n) {
        return DownloadEngine.hasBit(n, 4096);
    }

    private static boolean isVersionContentType(int n) {
        return DownloadEngine.hasBit(n, 65536);
    }

    private static boolean hasBit(int n, int n2) {
        return (n & n2) == n2;
    }

    static boolean isPack200Supported() {
        return Config.isJavaVersionAtLeast15();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static JarFile downloadJarFileWithoutCache(URL uRL, String string, int n, DownloadDelegate downloadDelegate) throws IOException {
        JarFile jarFile = null;
        try {
            DownloadEngine.setDownloadInProgress(true);
            try {
                jarFile = DownloadEngine.downloadTemporaryJarFile(uRL, string, n, downloadDelegate);
            }
            catch (JARSigningException jARSigningException) {
                throw jARSigningException;
            }
            catch (IOException iOException) {
                jarFile = DownloadEngine.downloadTemporaryJarFile(uRL, string, 256, downloadDelegate);
            }
            Object var7_7 = null;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            DownloadEngine.setDownloadInProgress(false);
            throw throwable;
        }
        DownloadEngine.setDownloadInProgress(false);
        return jarFile;
    }

    static boolean isZipFile(String string) {
        return string.toLowerCase().endsWith(".zip");
    }

    public static boolean isAlwaysCached(String string) {
        String string2 = string.toLowerCase();
        return string2.endsWith(".jar") || string2.endsWith(".jarjar") || string2.endsWith(".zip");
    }

    public static URL getNonCacheRedirectFinalURL(URL uRL) {
        return (URL)noCacheRedirectFinalURLs.get(uRL.toString());
    }

    public static URL getKnownRedirectFinalURL(URL uRL) {
        URL uRL2 = null;
        Object object = MemoryCache.getLoadedResource(uRL.toString());
        if (object instanceof CacheEntry) {
            CacheEntry cacheEntry = (CacheEntry)object;
            try {
                uRL2 = new URL(cacheEntry.getURL());
            }
            catch (MalformedURLException malformedURLException) {
                Trace.ignored(malformedURLException);
            }
        } else {
            uRL2 = DownloadEngine.getNonCacheRedirectFinalURL(uRL);
        }
        if (uRL2 == null) {
            uRL2 = uRL;
        }
        return uRL2;
    }

    public static void clearNoCacheJarFileList() {
        noCacheJarFileList.clear();
        noCacheRedirectFinalURLs.clear();
    }

    private static URL deriveRequestURL(URL uRL, String string, int n) {
        URL uRL2 = DownloadEngine.getRequestURL(uRL, string, null, false, null);
        if (DownloadEngine.isVersionContentType(n)) {
            uRL2 = DownloadEngine.getEmbeddedVersionUrl(uRL2, string);
        }
        if (DownloadEngine.isPackContentType(n)) {
            uRL2 = URLUtil.getPack200URL(uRL2, false);
        }
        return uRL2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static JarFile downloadTemporaryJarFile(final URL uRL, final String string, int n, final DownloadDelegate downloadDelegate) throws IOException {
        Object object;
        boolean bl;
        File file;
        FileOutputStream fileOutputStream;
        URLConnection uRLConnection;
        URL uRL2;
        block20: {
            boolean bl2 = DownloadEngine.isPackContentType(n);
            byte[] byArray = new byte[8192];
            uRL2 = DownloadEngine.deriveRequestURL(uRL, string, n);
            uRLConnection = uRL2.openConnection();
            if (DownloadEngine.isPack200Supported()) {
                uRLConnection.setRequestProperty("accept-encoding", "pack200-gzip,gzip");
            } else {
                uRLConnection.setRequestProperty("accept-encoding", "gzip");
            }
            InputStream inputStream = uRLConnection.getInputStream();
            int n2 = uRLConnection.getContentLength();
            String string2 = uRLConnection.getContentEncoding();
            int n3 = 0;
            if (downloadDelegate != null) {
                downloadDelegate.setTotalSize(n2);
            }
            HttpDownloadListener httpDownloadListener = downloadDelegate == null ? null : new HttpDownloadListener(){

                public boolean downloadProgress(int n, int n2) throws CancelException {
                    downloadDelegate.downloading(uRL, string, n, n2, false);
                    return true;
                }
            };
            fileOutputStream = null;
            file = null;
            bl = false;
            if (Trace.isEnabled(TraceLevel.NETWORK)) {
                Trace.println(ResourceManager.getString("httpDownloadHelper.doingDownload", uRL2.toString(), n2, string2), TraceLevel.NETWORK);
            }
            try {
                file = File.createTempFile("jar_cache", null);
                file.deleteOnExit();
                fileOutputStream = new FileOutputStream(file);
                int n4 = 0;
                if (bl2 || string2 != null && string2.equals("pack200-gzip")) {
                    object = new JarOutputStream(fileOutputStream);
                    Pack200.Unpacker unpacker = Pack200.newUnpacker();
                    unpacker.unpack((InputStream)new GZIPInputStream(inputStream, BUF_SIZE), (JarOutputStream)object);
                    ((ZipOutputStream)object).close();
                } else {
                    if (string2 != null && string2.equals("gzip")) {
                        inputStream = new GZIPInputStream(inputStream, BUF_SIZE);
                    }
                    int n5 = 0;
                    while ((n4 = inputStream.read(byArray)) != -1) {
                        if (n5 == 0 && !DownloadEngine.isJarHeaderValid(byArray)) {
                            throw new IOException("Invalid jar file");
                        }
                        ((OutputStream)fileOutputStream).write(byArray, 0, n4);
                        if ((n3 += n4) > n2 && n2 != 0) {
                            n3 = n2;
                        }
                        if (httpDownloadListener != null) {
                            httpDownloadListener.downloadProgress(n3, n2);
                        }
                        ++n5;
                    }
                }
                bl = true;
                Object var20_21 = null;
                if (inputStream == null) break block20;
            }
            catch (Throwable throwable) {
                Object var20_22 = null;
                if (inputStream != null) {
                    inputStream.close();
                }
                if (fileOutputStream != null) {
                    ((OutputStream)fileOutputStream).close();
                }
                if (!bl && file != null) {
                    file.delete();
                    file = null;
                }
                throw throwable;
            }
            inputStream.close();
        }
        if (fileOutputStream != null) {
            ((OutputStream)fileOutputStream).close();
        }
        if (!bl && file != null) {
            file.delete();
            file = null;
        }
        if (file == null) {
            return null;
        }
        JarFile jarFile = JarVerifier.getValidatedJarFile(file, uRL, uRL2, string, downloadDelegate);
        noCacheJarFileList.put(uRL.toString(), file);
        object = uRLConnection.getURL();
        if (!URLUtil.sameURLs((URL)object, uRL2)) {
            noCacheRedirectFinalURLs.put(uRL.toString(), object);
        }
        return jarFile;
    }

    public static void clearTemporaryResourceMaps(URL uRL) {
        noCacheJarFileList.remove(uRL.toString());
        noCacheRedirectFinalURLs.remove(uRL.toString());
    }

    public static JarFile getTemporaryJarFile(URL uRL, String string, boolean bl, int n, DownloadDelegate downloadDelegate) throws IOException {
        JarFile jarFile = null;
        File file = (File)noCacheJarFileList.get(uRL.toString());
        if (file != null) {
            URL uRL2 = DownloadEngine.deriveRequestURL(uRL, string, n);
            jarFile = JarVerifier.getValidatedJarFile(file, uRL, uRL2, string, downloadDelegate);
        } else if (bl) {
            jarFile = DownloadEngine.downloadJarFileWithoutCache(uRL, string, n, downloadDelegate);
        }
        return jarFile;
    }

    public static HttpRequest getHttpRequestImpl() {
        return _httpRequestImpl;
    }

    public static HttpDownload getHttpDownloadImpl() {
        return _httpDownloadImpl;
    }

    /*
     * Loose catch block
     */
    public static File applyPatch(File file, File file2, final URL uRL, final String string, final DownloadDelegate downloadDelegate, String string2) throws FailedDownloadException {
        File file3;
        block20: {
            JarDiffPatcher jarDiffPatcher = new JarDiffPatcher();
            file3 = new File(string2);
            FileOutputStream fileOutputStream = null;
            boolean bl = false;
            fileOutputStream = new FileOutputStream(file3);
            Patcher.PatchDelegate patchDelegate = null;
            if (downloadDelegate != null) {
                downloadDelegate.patching(uRL, string, 0);
                patchDelegate = new Patcher.PatchDelegate(){

                    public void patching(int n) throws CancelException {
                        downloadDelegate.patching(uRL, string, n);
                    }
                };
            }
            try {
                jarDiffPatcher.applyPatch(patchDelegate, file.getPath(), file2.getPath(), fileOutputStream);
            }
            catch (IOException iOException) {
                throw new FailedDownloadException(uRL, string, iOException);
            }
            bl = true;
            Object var13_13 = null;
            try {
                if (fileOutputStream != null) {
                    ((OutputStream)fileOutputStream).close();
                }
            }
            catch (IOException iOException) {
                Trace.ignoredException(iOException);
            }
            if (!bl) {
                file3.delete();
            }
            file2.delete();
            if (downloadDelegate != null && !bl) {
                try {
                    downloadDelegate.downloadFailed(uRL, string);
                }
                catch (CancelException iOException) {
                    throw new FailedDownloadException(uRL, string, iOException);
                }
            }
            break block20;
            {
                catch (IOException iOException) {
                    throw new FailedDownloadException(uRL, string, iOException);
                }
            }
            catch (Throwable throwable) {
                Object var13_14 = null;
                try {
                    if (fileOutputStream != null) {
                        ((OutputStream)fileOutputStream).close();
                    }
                }
                catch (IOException iOException) {
                    Trace.ignoredException(iOException);
                }
                if (!bl) {
                    file3.delete();
                }
                file2.delete();
                if (downloadDelegate != null && !bl) {
                    try {
                        downloadDelegate.downloadFailed(uRL, string);
                    }
                    catch (CancelException iOException) {
                        throw new FailedDownloadException(uRL, string, iOException);
                    }
                }
                throw throwable;
            }
        }
        return file3;
    }

    public static boolean isJnlpURL(URL uRL) {
        try {
            HttpResponse httpResponse = DownloadEngine.getHttpRequestImpl().doHeadRequest(uRL);
            return JNLP_MIME_TYPE.equals(httpResponse.getContentType());
        }
        catch (IOException iOException) {
            return false;
        }
    }

    private static String getVersionJarPath(String string, String string2) {
        String string3 = string.substring(string.lastIndexOf("/") + 1);
        string = string.substring(0, string.lastIndexOf("/") + 1);
        String string4 = string3;
        String string5 = null;
        if (string3.lastIndexOf(".") != -1) {
            string5 = string3.substring(string3.lastIndexOf(".") + 1);
            string3 = string3.substring(0, string3.lastIndexOf("."));
        }
        StringBuffer stringBuffer = new StringBuffer(string3);
        if (string2 != null) {
            stringBuffer.append("__V");
            stringBuffer.append(string2);
        }
        if (string5 != null) {
            stringBuffer.append(".");
            stringBuffer.append(string5);
        }
        string = string + stringBuffer.toString();
        return string;
    }

    private static URL getEmbeddedVersionUrl(URL uRL, String string) {
        if (string == null || string.indexOf("*") != -1 || string.indexOf("+") != -1) {
            return uRL;
        }
        URL uRL2 = null;
        String string2 = uRL.getProtocol();
        String string3 = uRL.getHost();
        int n = uRL.getPort();
        String string4 = uRL.getPath();
        string4 = DownloadEngine.getVersionJarPath(string4, string);
        try {
            uRL2 = new URL(string2, string3, n, string4);
        }
        catch (MalformedURLException malformedURLException) {
            Trace.ignoredException(malformedURLException);
        }
        return uRL2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static CacheEntry actionDownload(CacheEntry cacheEntry, final URL uRL, URL uRL2, String string, final DownloadDelegate downloadDelegate, int n, boolean bl, boolean bl2) throws IOException {
        CacheEntry cacheEntry2;
        block48: {
            CacheEntry cacheEntry3;
            block47: {
                CacheEntry cacheEntry4;
                block46: {
                    CacheEntry cacheEntry5;
                    block45: {
                        CacheEntry cacheEntry6;
                        block44: {
                            CacheEntry cacheEntry7;
                            block43: {
                                CacheEntry cacheEntry8;
                                block42: {
                                    boolean bl3 = false;
                                    int n2 = -1;
                                    String string2 = null;
                                    if (cacheEntry != null && string != null) {
                                        long l;
                                        if (cacheEntry.getVersion() != null && new VersionString(string).contains(new VersionID(cacheEntry.getVersion()))) {
                                            return cacheEntry;
                                        }
                                        if (Environment.isJavaPlugin() && (l = cacheEntry.getExpirationDate()) != 0L && new Date().after(new Date(l))) {
                                            cacheEntry = null;
                                        }
                                    }
                                    if (cacheEntry != null) {
                                        string2 = cacheEntry.getVersion();
                                    }
                                    try {
                                        try {
                                            Object object;
                                            boolean bl4;
                                            Object object2;
                                            DownloadEngine.setDownloadInProgress(true);
                                            HttpRequest httpRequest = DownloadEngine.getHttpRequestImpl();
                                            HttpResponse httpResponse = null;
                                            long l = 0L;
                                            if (cacheEntry != null) {
                                                l = cacheEntry.getLastModified();
                                            }
                                            URL uRL3 = uRL2;
                                            if (DownloadEngine.isVersionContentType(n)) {
                                                uRL3 = DownloadEngine.getEmbeddedVersionUrl(uRL3, string);
                                            }
                                            if (DownloadEngine.isPackContentType(n)) {
                                                uRL3 = URLUtil.getPack200URL(uRL3, false);
                                            }
                                            try {
                                                try {
                                                    httpResponse = httpRequest.doGetRequestEX(uRL3, l);
                                                }
                                                catch (FileNotFoundException fileNotFoundException) {
                                                    if (uRL2.toString().equals(uRL3.toString())) {
                                                        throw fileNotFoundException;
                                                    }
                                                    httpResponse = httpRequest.doGetRequestEX(uRL2, l);
                                                    bl3 = true;
                                                    n2 = n;
                                                    if (DownloadEngine.isPackContentType(n) && (DownloadEngine.isNativeContentType(n) || DownloadEngine.isJarContentType(n))) {
                                                        n2 &= 0xFFFFEFFF;
                                                    }
                                                    if (DownloadEngine.isVersionContentType(n)) {
                                                        n2 &= 0xFFFEFFFF;
                                                    }
                                                }
                                            }
                                            catch (FailedDownloadException failedDownloadException) {
                                                throw failedDownloadException;
                                            }
                                            catch (FileNotFoundException fileNotFoundException) {
                                                throw fileNotFoundException;
                                            }
                                            catch (IOException iOException) {
                                                Trace.ignoredException(iOException);
                                                httpResponse = httpRequest.doGetRequest(uRL2, false);
                                            }
                                            int n3 = httpResponse.getStatusCode();
                                            if (n3 == 404) {
                                                throw new FailedDownloadException(uRL, string, new IOException("HTTP response 404"));
                                            }
                                            if (n3 == 304) {
                                                httpResponse.disconnect();
                                                cacheEntry8 = cacheEntry;
                                                Object var31_25 = null;
                                                break block42;
                                            }
                                            int n4 = httpResponse.getContentLength();
                                            long l2 = httpResponse.getLastModified();
                                            long l3 = httpResponse.getExpiration();
                                            boolean bl5 = HttpUtils.isJNLPFile(uRL.toString(), httpResponse.getHeaders());
                                            if (!bl5 && Environment.isImportMode() && Environment.getImportModeExpiration() != null && l3 != 0L) {
                                                object2 = new Date(l3);
                                                if (((Date)object2).before(Environment.getImportModeExpiration())) {
                                                    httpResponse.disconnect();
                                                    cacheEntry7 = null;
                                                    break block43;
                                                }
                                            } else if (!bl5 && Environment.isImportMode() && Environment.getImportModeTimestamp() != null && l2 != 0L && ((Date)(object2 = new Date(l2))).before(Environment.getImportModeTimestamp())) {
                                                httpResponse.disconnect();
                                                cacheEntry6 = null;
                                                break block44;
                                            }
                                            object2 = httpResponse.getResponseHeader(REPLY_JNLP_VERSION);
                                            if (string != null && object2 == null && Environment.getImportModeCodebaseOverride() != null && new VersionID(string).isSimpleVersion()) {
                                                object2 = string;
                                            }
                                            if (cacheEntry != null) {
                                                if (object2 != null && new VersionString((String)object2).contains(string2)) {
                                                    httpResponse.disconnect();
                                                    cacheEntry5 = cacheEntry;
                                                    break block45;
                                                }
                                                if (n4 == cacheEntry.getContentLength() && l2 == l && string2 == null) {
                                                    httpResponse.disconnect();
                                                    cacheEntry4 = cacheEntry;
                                                    break block46;
                                                }
                                            }
                                            if (downloadDelegate != null) {
                                                downloadDelegate.setTotalSize(n4);
                                            }
                                            if (object2 == null && (Environment.isJavaPlugin() || DownloadEngine.isVersionContentType(bl3 ? n2 : n))) {
                                                object2 = string;
                                            }
                                            Object object3 = object2;
                                            String string3 = httpResponse.getContentType();
                                            boolean bl6 = bl4 = string3 != null && string3.equalsIgnoreCase(JARDIFF_MIME_TYPE);
                                            if (Trace.isEnabled(TraceLevel.NETWORK)) {
                                                Trace.println(ResourceManager.getString("downloadEngine.serverResponse", String.valueOf(n4), new Date(l2).toString(), (String)object2, string3), TraceLevel.NETWORK);
                                            }
                                            if (string3 != null && string3.equalsIgnoreCase(ERROR_MIME_TYPE)) {
                                                BufferedInputStream bufferedInputStream = httpResponse.getInputStream();
                                                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(bufferedInputStream));
                                                String string4 = bufferedReader.readLine();
                                                bufferedReader.close();
                                                throw new FailedDownloadException(uRL2, string, new IOException("Error returned: " + string4));
                                            }
                                            if (object2 == null && string != null && !DownloadEngine.isVersionContentType(bl3 ? n2 : n)) {
                                                throw new FailedDownloadException(uRL, string, new IOException("missing version response from server"));
                                            }
                                            if (object2 != null && string != null && !bl) {
                                                if (!new VersionString(string).contains((String)object2)) {
                                                    throw new FailedDownloadException(uRL, string, new IOException("bad version response from server:" + (String)object2));
                                                }
                                                object = new VersionID((String)object2);
                                                if (!((VersionID)object).isSimpleVersion()) {
                                                    throw new FailedDownloadException(uRL, string, new IOException("bad version response from server:" + (String)object2));
                                                }
                                            }
                                            Object object4 = object = downloadDelegate == null ? null : new HttpDownloadListener((String)object3){
                                                private final /* synthetic */ String val$responseVersion;
                                                {
                                                    this.val$responseVersion = string;
                                                }

                                                public boolean downloadProgress(int n, int n2) throws CancelException {
                                                    downloadDelegate.downloading(uRL, this.val$responseVersion, n, n2, false);
                                                    return true;
                                                }
                                            };
                                            if (bl2 && DownloadEngine.allowCaching(httpResponse)) {
                                                cacheEntry3 = Cache.downloadResourceToCache(uRL, (String)object2, httpResponse, (HttpDownloadListener)object, downloadDelegate, uRL2, bl4, bl3 ? n2 : n);
                                                break block47;
                                            }
                                            CacheEntry cacheEntry9 = Cache.downloadResourceToTempFile(uRL, (String)object2, httpResponse, (HttpDownloadListener)object, downloadDelegate, uRL2, bl4, bl3 ? n2 : n);
                                            cacheEntry9.setBusy(CacheEntry.BUSY_TRUE);
                                            cacheEntry9.setIncomplete(CacheEntry.INCOMPLETE_TRUE);
                                            cacheEntry9.updateIndexHeaderOnDisk();
                                            cacheEntry2 = cacheEntry9;
                                            break block48;
                                        }
                                        catch (Exception exception) {
                                            if (exception instanceof JARSigningException) {
                                                throw (JARSigningException)exception;
                                            }
                                            if (exception instanceof FailedDownloadException) {
                                                throw (FailedDownloadException)exception;
                                            }
                                            Trace.ignored(exception);
                                            throw new FailedDownloadException(uRL2, string, exception);
                                        }
                                    }
                                    catch (Throwable throwable) {
                                        Object var31_32 = null;
                                        DownloadEngine.setDownloadInProgress(false);
                                        throw throwable;
                                    }
                                }
                                DownloadEngine.setDownloadInProgress(false);
                                return cacheEntry8;
                            }
                            Object var31_26 = null;
                            DownloadEngine.setDownloadInProgress(false);
                            return cacheEntry7;
                        }
                        Object var31_27 = null;
                        DownloadEngine.setDownloadInProgress(false);
                        return cacheEntry6;
                    }
                    Object var31_28 = null;
                    DownloadEngine.setDownloadInProgress(false);
                    return cacheEntry5;
                }
                Object var31_29 = null;
                DownloadEngine.setDownloadInProgress(false);
                return cacheEntry4;
            }
            Object var31_30 = null;
            DownloadEngine.setDownloadInProgress(false);
            return cacheEntry3;
        }
        Object var31_31 = null;
        DownloadEngine.setDownloadInProgress(false);
        return cacheEntry2;
    }

    private static boolean allowCaching(HttpResponse httpResponse) {
        String string;
        if (httpResponse != null && (string = httpResponse.getResponseHeader("cache-control")) != null && string.toLowerCase().indexOf("no-store") != -1) {
            Trace.println("Not caching resource due to response header: cache-control: no-store", TraceLevel.NETWORK);
            return false;
        }
        return true;
    }

    private static void addURLArgument(StringBuffer stringBuffer, String string, String string2) {
        try {
            stringBuffer.append(URLEncoder.encode(string, "UTF-8"));
            stringBuffer.append('=');
            stringBuffer.append(URLEncoder.encode(string2, "UTF-8"));
            stringBuffer.append('&');
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Trace.ignoredException(unsupportedEncodingException);
        }
    }

    public static URL getRequestURL(URL uRL, String string, String string2, boolean bl, String string3) {
        int n = string == null ? 1 : 2;
        return DownloadEngine.getRequestURL(uRL, string, string2, bl, string3, n);
    }

    private static URL getRequestURL(URL uRL, String string, String string2, boolean bl, String string3, int n, String string4) {
        StringBuffer stringBuffer = new StringBuffer();
        if (string2 == null && string != null) {
            string2 = Cache.getCacheEntryVersion(uRL);
        }
        if (string != null && n == 2) {
            DownloadEngine.addURLArgument(stringBuffer, ARG_VERSION_ID, string);
            if (string2 != null) {
                DownloadEngine.addURLArgument(stringBuffer, ARG_CURRENT_VERSION_ID, string2);
            }
        }
        if (string != null && n == 3) {
            if (bl) {
                DownloadEngine.addURLArgument(stringBuffer, ARG_PLATFORM_VERSION_ID, string);
            } else {
                DownloadEngine.addURLArgument(stringBuffer, ARG_VERSION_ID, string);
            }
            DownloadEngine.addURLArgument(stringBuffer, ARG_ARCH, Config.getOSArch());
            DownloadEngine.addURLArgument(stringBuffer, ARG_OS, Config.getOSName());
            DownloadEngine.addURLArgument(stringBuffer, ARG_LOCALE, defaultLocaleString);
            if (string3 != null) {
                DownloadEngine.addURLArgument(stringBuffer, ARG_KNOWN_PLATFORMS, string3);
            }
            if (string4 != null) {
                DownloadEngine.addURLArgument(stringBuffer, ARG_JFX_VERSION_ID, string4);
            }
        }
        if (stringBuffer.length() > 0) {
            stringBuffer.setLength(stringBuffer.length() - 1);
        }
        if (stringBuffer.length() > 0) {
            stringBuffer.insert(0, '?');
        }
        try {
            return new URL(uRL.getProtocol(), uRL.getHost(), uRL.getPort(), uRL.getFile() + stringBuffer);
        }
        catch (MalformedURLException malformedURLException) {
            Trace.ignoredException(malformedURLException);
            return null;
        }
    }

    public static URL getRequestURL(URL uRL, String string, String string2, boolean bl, String string3, int n) {
        return DownloadEngine.getRequestURL(uRL, string, string2, bl, string3, n, null);
    }

    public static CacheEntry _downloadCacheEntry(CacheEntry cacheEntry, URL uRL, String string, DownloadDelegate downloadDelegate, boolean bl, String string2, int n, boolean bl2) throws IOException {
        int n2 = 1;
        if (string2 != null) {
            n2 = 3;
        } else if (string != null) {
            n2 = 2;
        }
        URL uRL2 = DownloadEngine.getRequestURL(uRL, string, null, bl, string2, n2);
        return DownloadEngine.actionDownload(cacheEntry, uRL, uRL2, string, downloadDelegate, n, bl, bl2);
    }

    public static String getAvailableVersion(URL uRL, String string, boolean bl, String string2) {
        return DownloadEngine.getAvailableVersion(uRL, string, bl, string2, null);
    }

    public static String getAvailableVersion(URL uRL, String string, boolean bl, String string2, String string3) {
        int n = string2 != null ? 3 : 2;
        URL uRL2 = DownloadEngine.getRequestURL(uRL, string, null, bl, string2, n, string3);
        HttpRequest httpRequest = DownloadEngine.getHttpRequestImpl();
        String string4 = null;
        try {
            HttpResponse httpResponse = httpRequest.doGetRequest(uRL2);
            if (httpResponse != null) {
                string4 = httpResponse.getResponseHeader(REPLY_JNLP_VERSION);
                httpResponse.disconnect();
            }
        }
        catch (Throwable throwable) {
            Trace.ignored(throwable);
        }
        return string4;
    }

    static boolean isJarHeaderValid(byte[] byArray) {
        return DownloadEngine.get32(byArray, 0) == 67324752L;
    }

    private static int get16(byte[] byArray, int n) {
        return byArray[n] & 0xFF | (byArray[n + 1] & 0xFF) << 8;
    }

    private static long get32(byte[] byArray, int n) {
        return (long)DownloadEngine.get16(byArray, n) | (long)DownloadEngine.get16(byArray, n + 2) << 16;
    }

    static {
        backgroundUpdateThreadLocal = new InheritableThreadLocal(){

            protected Object initialValue() {
                return Boolean.FALSE;
            }
        };
        processingState = new ThreadLocal();
        internalUse = new ThreadLocal();
        noCacheJarFileList = new Hashtable();
        noCacheRedirectFinalURLs = new Hashtable();
        _httpRequestImpl = new BasicHttpRequest();
        _httpDownloadImpl = new HttpDownloadHelper(_httpRequestImpl);
    }
}

