/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.cache;

import com.sun.deploy.cache.Cache;
import com.sun.deploy.cache.CacheEntry;
import com.sun.deploy.cache.CacheUpgrader;
import com.sun.deploy.trace.Trace;
import java.io.File;
import java.io.FilenameFilter;
import java.net.URL;

class Cache6Upgrader
extends CacheUpgrader {
    static final String CACHE_6_UPGRADER_NAME = "Cache6Upgrader";
    static final String SYSTEM_CACHE_6_UPGRADER_NAME = "SystemCache6Upgrader";

    private Cache6Upgrader(String string, File file, File file2) {
        super(string, file, file2);
    }

    static Cache6Upgrader createInstance(boolean bl, File file, File file2) {
        String string = CACHE_6_UPGRADER_NAME;
        if (bl) {
            string = SYSTEM_CACHE_6_UPGRADER_NAME;
        }
        return new Cache6Upgrader(string, file, file2);
    }

    protected void upgradeImpl() {
        this.copySplashDir();
        this.copyMuffinDir();
        this.copyCacheEntries();
    }

    protected CacheEntry upgradeItemImpl(URL uRL, String string, int n) {
        CacheEntry cacheEntry = this.getOldCacheEntry(uRL, string, n);
        if (cacheEntry == null) {
            if (Cache6Upgrader.isTracing()) {
                Cache6Upgrader.trace(this + ": found no old cache for: " + uRL.toString() + " version: " + string + " contentType: " + n);
            }
            return null;
        }
        CacheEntry cacheEntry2 = this.copyToNewCache(cacheEntry);
        if (Cache6Upgrader.isTracing()) {
            if (cacheEntry2 != null) {
                Cache6Upgrader.trace(this + " copied " + uRL.toString() + " to: " + cacheEntry2.getDataFile());
            } else {
                Cache6Upgrader.trace(this + " failed to copy: " + uRL.toString());
            }
        }
        return cacheEntry2;
    }

    private void copySplashDir() {
        File file = new File(this.oldCacheDir, "splash");
        File file2 = new File(this.newCacheDir, "splash");
        Cache6Upgrader.copyDirIgnoresErrors(file, file2);
    }

    private void copyMuffinDir() {
        File file = new File(this.oldCacheDir, "muffin");
        File file2 = new File(this.newCacheDir, "muffin");
        Cache6Upgrader.copyDirIgnoresErrors(file, file2, new FilenameFilter(){

            public boolean accept(File file, String string) {
                if (new File(file, string).isDirectory()) {
                    return true;
                }
                return string.toLowerCase().endsWith(".muf");
            }
        });
    }

    private void copyCacheEntries() {
        File[] fileArray = Cache.getIndexFiles(this.oldCacheDir);
        for (int i = 0; i < fileArray.length; ++i) {
            File file = fileArray[i];
            CacheEntry cacheEntry = this.getCacheEntryFromIndexFile(file);
            if (cacheEntry == null) continue;
            try {
                if (this.resourcePresentInNewCache(new URL(cacheEntry.getURL()))) continue;
                this.copyToNewCache(cacheEntry);
                continue;
            }
            catch (Exception exception) {
                Trace.ignoredException(exception);
            }
        }
    }
}

