/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.io.IOException;
import java.io.OutputStream;
import sun.security.ssl.EngineOutputRecord;
import sun.security.ssl.HandshakeHash;
import sun.security.ssl.OutputRecord;
import sun.security.ssl.ProtocolVersion;
import sun.security.ssl.SSLEngineImpl;
import sun.security.ssl.SSLSocketImpl;

public class HandshakeOutStream
extends OutputStream {
    private SSLSocketImpl socket;
    private SSLEngineImpl engine;
    OutputRecord r;

    HandshakeOutStream(ProtocolVersion protocolVersion, ProtocolVersion protocolVersion2, HandshakeHash handshakeHash, SSLSocketImpl sSLSocketImpl) {
        this.socket = sSLSocketImpl;
        this.r = new OutputRecord(22);
        this.init(protocolVersion, protocolVersion2, handshakeHash);
    }

    HandshakeOutStream(ProtocolVersion protocolVersion, ProtocolVersion protocolVersion2, HandshakeHash handshakeHash, SSLEngineImpl sSLEngineImpl) {
        this.engine = sSLEngineImpl;
        this.r = new EngineOutputRecord(22, sSLEngineImpl);
        this.init(protocolVersion, protocolVersion2, handshakeHash);
    }

    private void init(ProtocolVersion protocolVersion, ProtocolVersion protocolVersion2, HandshakeHash handshakeHash) {
        this.r.setVersion(protocolVersion);
        this.r.setHelloVersion(protocolVersion2);
        this.r.setHandshakeHash(handshakeHash);
    }

    void doHashes() {
        this.r.doHashes();
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        while (n2 > 0) {
            int n3 = Math.min(n2, this.r.availableDataBytes());
            if (n3 == 0) {
                this.flush();
                continue;
            }
            this.r.write(byArray, n, n3);
            n += n3;
            n2 -= n3;
        }
    }

    @Override
    public void write(int n) throws IOException {
        if (this.r.availableDataBytes() < 1) {
            this.flush();
        }
        this.r.write(n);
    }

    @Override
    public void flush() throws IOException {
        if (this.socket != null) {
            try {
                this.socket.writeRecord(this.r);
            }
            catch (IOException iOException) {
                this.socket.waitForClose(true);
                throw iOException;
            }
        } else {
            this.engine.writeRecord((EngineOutputRecord)this.r);
        }
    }

    void setFinishedMsg() {
        assert (this.socket == null);
        ((EngineOutputRecord)this.r).setFinishedMsg();
    }

    void putInt8(int n) throws IOException {
        this.r.write(n);
    }

    void putInt16(int n) throws IOException {
        if (this.r.availableDataBytes() < 2) {
            this.flush();
        }
        this.r.write(n >> 8);
        this.r.write(n);
    }

    void putInt24(int n) throws IOException {
        if (this.r.availableDataBytes() < 3) {
            this.flush();
        }
        this.r.write(n >> 16);
        this.r.write(n >> 8);
        this.r.write(n);
    }

    void putInt32(int n) throws IOException {
        if (this.r.availableDataBytes() < 4) {
            this.flush();
        }
        this.r.write(n >> 24);
        this.r.write(n >> 16);
        this.r.write(n >> 8);
        this.r.write(n);
    }

    void putBytes8(byte[] byArray) throws IOException {
        if (byArray == null) {
            this.putInt8(0);
            return;
        }
        this.putInt8(byArray.length);
        this.write(byArray, 0, byArray.length);
    }

    public void putBytes16(byte[] byArray) throws IOException {
        if (byArray == null) {
            this.putInt16(0);
            return;
        }
        this.putInt16(byArray.length);
        this.write(byArray, 0, byArray.length);
    }

    void putBytes24(byte[] byArray) throws IOException {
        if (byArray == null) {
            this.putInt24(0);
            return;
        }
        this.putInt24(byArray.length);
        this.write(byArray, 0, byArray.length);
    }
}

