/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.accessibility.util;

import com.sun.java.accessibility.util.AccessibilityListenerList;
import com.sun.java.accessibility.util.EventQueueMonitor;
import com.sun.java.accessibility.util.TopLevelWindowListener;
import com.sun.java.accessibility.util._AccessibleState;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;

public class AccessibilityEventMonitor {
    protected static AccessibilityListenerList listenerList = new AccessibilityListenerList();
    protected static AccessibilityEventListener accessibilityListener = new AccessibilityEventListener();

    public static void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (listenerList.getListenerCount(PropertyChangeListener.class) == 0) {
            accessibilityListener.installListeners();
        }
        listenerList.add(PropertyChangeListener.class, propertyChangeListener);
    }

    public static void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        listenerList.remove(PropertyChangeListener.class, propertyChangeListener);
        if (listenerList.getListenerCount(PropertyChangeListener.class) == 0) {
            accessibilityListener.removeListeners();
        }
    }

    static class AccessibilityEventListener
    implements TopLevelWindowListener,
    PropertyChangeListener {
        public AccessibilityEventListener() {
            EventQueueMonitor.addTopLevelWindowListener(this);
        }

        protected void installListeners() {
            Window[] windowArray = EventQueueMonitor.getTopLevelWindows();
            if (windowArray != null) {
                for (int i = 0; i < windowArray.length; ++i) {
                    if (!(windowArray[i] instanceof Accessible)) continue;
                    this.installListeners(windowArray[i]);
                }
            }
        }

        protected void installListeners(Accessible accessible) {
            this.installListeners(accessible.getAccessibleContext());
        }

        private void installListeners(AccessibleContext accessibleContext) {
            AccessibleStateSet accessibleStateSet;
            if (accessibleContext != null && !(accessibleStateSet = accessibleContext.getAccessibleStateSet()).contains(AccessibleState.TRANSIENT)) {
                AccessibleContext accessibleContext2;
                Accessible accessible;
                accessibleContext.addPropertyChangeListener(this);
                AccessibleStateSet accessibleStateSet2 = accessibleContext.getAccessibleStateSet();
                if (accessibleStateSet2.contains(_AccessibleState.MANAGES_DESCENDANTS)) {
                    return;
                }
                AccessibleRole accessibleRole = accessibleContext.getAccessibleRole();
                if (accessibleRole == AccessibleRole.LIST || accessibleRole == AccessibleRole.TREE) {
                    return;
                }
                if (accessibleRole == AccessibleRole.TABLE && (accessible = accessibleContext.getAccessibleChild(0)) != null && (accessibleContext2 = accessible.getAccessibleContext()) != null && (accessibleRole = accessibleContext2.getAccessibleRole()) != null && accessibleRole != AccessibleRole.TABLE) {
                    return;
                }
                int n = accessibleContext.getAccessibleChildrenCount();
                for (int i = 0; i < n; ++i) {
                    Accessible accessible2 = accessibleContext.getAccessibleChild(i);
                    if (accessible2 == null) continue;
                    this.installListeners(accessible2);
                }
            }
        }

        protected void removeListeners() {
            Window[] windowArray = EventQueueMonitor.getTopLevelWindows();
            if (windowArray != null) {
                for (int i = 0; i < windowArray.length; ++i) {
                    if (!(windowArray[i] instanceof Accessible)) continue;
                    this.removeListeners(windowArray[i]);
                }
            }
        }

        protected void removeListeners(Accessible accessible) {
            this.removeListeners(accessible.getAccessibleContext());
        }

        private void removeListeners(AccessibleContext accessibleContext) {
            AccessibleStateSet accessibleStateSet;
            if (accessibleContext != null && !(accessibleStateSet = accessibleContext.getAccessibleStateSet()).contains(AccessibleState.TRANSIENT)) {
                accessibleContext.removePropertyChangeListener(this);
                if (accessibleStateSet.contains(_AccessibleState.MANAGES_DESCENDANTS)) {
                    return;
                }
                AccessibleRole accessibleRole = accessibleContext.getAccessibleRole();
                if (accessibleRole == AccessibleRole.LIST || accessibleRole == AccessibleRole.TABLE || accessibleRole == AccessibleRole.TREE) {
                    return;
                }
                int n = accessibleContext.getAccessibleChildrenCount();
                for (int i = 0; i < n; ++i) {
                    Accessible accessible = accessibleContext.getAccessibleChild(i);
                    if (accessible == null) continue;
                    this.removeListeners(accessible);
                }
            }
        }

        @Override
        public void topLevelWindowCreated(Window window) {
            if (window instanceof Accessible) {
                this.installListeners(window);
            }
        }

        @Override
        public void topLevelWindowDestroyed(Window window) {
            if (window instanceof Accessible) {
                this.removeListeners(window);
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Object[] objectArray = listenerList.getListenerList();
            for (int i = objectArray.length - 2; i >= 0; i -= 2) {
                if (objectArray[i] != PropertyChangeListener.class) continue;
                ((PropertyChangeListener)objectArray[i + 1]).propertyChange(propertyChangeEvent);
            }
            String string = propertyChangeEvent.getPropertyName();
            if (string.compareTo("AccessibleChild") == 0) {
                Object object;
                Object object2 = propertyChangeEvent.getOldValue();
                if (object2 == null ^ (object = propertyChangeEvent.getNewValue()) == null) {
                    if (object2 != null) {
                        if (object2 instanceof Accessible) {
                            Accessible accessible = (Accessible)object2;
                            this.removeListeners(accessible.getAccessibleContext());
                        } else if (object2 instanceof AccessibleContext) {
                            this.removeListeners((AccessibleContext)object2);
                        }
                    } else if (object != null) {
                        if (object instanceof Accessible) {
                            Accessible accessible = (Accessible)object;
                            this.installListeners(accessible.getAccessibleContext());
                        } else if (object instanceof AccessibleContext) {
                            this.installListeners((AccessibleContext)object);
                        }
                    }
                } else {
                    System.out.println("ERROR in usage of PropertyChangeEvents for: " + propertyChangeEvent.toString());
                }
            }
        }
    }
}

