/*
 * Decompiled with CFR 0.152.
 */
package sun.org.mozilla.javascript.internal.json;

import java.util.ArrayList;
import sun.org.mozilla.javascript.internal.Context;
import sun.org.mozilla.javascript.internal.ScriptRuntime;
import sun.org.mozilla.javascript.internal.Scriptable;

public class JsonParser {
    private Context cx;
    private Scriptable scope;
    private int pos;
    private int length;
    private String src;

    public JsonParser(Context context, Scriptable scriptable) {
        this.cx = context;
        this.scope = scriptable;
    }

    public synchronized Object parseValue(String string) throws ParseException {
        if (string == null) {
            throw new ParseException("Input string may not be null");
        }
        this.pos = 0;
        this.length = string.length();
        this.src = string;
        Object object = this.readValue();
        this.consumeWhitespace();
        if (this.pos < this.length) {
            throw new ParseException("Expected end of stream at char " + this.pos);
        }
        return object;
    }

    private Object readValue() throws ParseException {
        this.consumeWhitespace();
        if (this.pos < this.length) {
            char c = this.src.charAt(this.pos++);
            switch (c) {
                case '{': {
                    return this.readObject();
                }
                case '[': {
                    return this.readArray();
                }
                case 't': {
                    return this.readTrue();
                }
                case 'f': {
                    return this.readFalse();
                }
                case '\"': {
                    return this.readString();
                }
                case 'n': {
                    return this.readNull();
                }
                case '-': 
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    return this.readNumber(c);
                }
            }
            throw new ParseException("Unexpected token: " + c);
        }
        throw new ParseException("Empty JSON string");
    }

    private Object readObject() throws ParseException {
        Scriptable scriptable = this.cx.newObject(this.scope);
        boolean bl = false;
        this.consumeWhitespace();
        while (this.pos < this.length) {
            char c = this.src.charAt(this.pos++);
            switch (c) {
                case '}': {
                    return scriptable;
                }
                case ',': {
                    if (!bl) {
                        throw new ParseException("Unexpected comma in object literal");
                    }
                    bl = false;
                    break;
                }
                case '\"': {
                    if (bl) {
                        throw new ParseException("Missing comma in object literal");
                    }
                    String string = this.readString();
                    this.consume(':');
                    Object object = this.readValue();
                    double d = ScriptRuntime.toNumber(string);
                    int n = (int)d;
                    if (d != (double)n) {
                        scriptable.put(string, scriptable, object);
                    } else {
                        scriptable.put(n, scriptable, object);
                    }
                    bl = true;
                    break;
                }
                default: {
                    throw new ParseException("Unexpected token in object literal");
                }
            }
            this.consumeWhitespace();
        }
        throw new ParseException("Unterminated object literal");
    }

    private Object readArray() throws ParseException {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        boolean bl = false;
        this.consumeWhitespace();
        while (this.pos < this.length) {
            char c = this.src.charAt(this.pos);
            switch (c) {
                case ']': {
                    ++this.pos;
                    return this.cx.newArray(this.scope, arrayList.toArray());
                }
                case ',': {
                    if (!bl) {
                        throw new ParseException("Unexpected comma in array literal");
                    }
                    bl = false;
                    ++this.pos;
                    break;
                }
                default: {
                    if (bl) {
                        throw new ParseException("Missing comma in array literal");
                    }
                    arrayList.add(this.readValue());
                    bl = true;
                }
            }
            this.consumeWhitespace();
        }
        throw new ParseException("Unterminated array literal");
    }

    private String readString() throws ParseException {
        StringBuilder stringBuilder = new StringBuilder();
        block17: while (this.pos < this.length) {
            char c;
            if ((c = this.src.charAt(this.pos++)) <= '\u001f') {
                throw new ParseException("String contains control character");
            }
            switch (c) {
                case '\\': {
                    if (this.pos >= this.length) {
                        throw new ParseException("Unterminated string");
                    }
                    c = this.src.charAt(this.pos++);
                    switch (c) {
                        case '\"': {
                            stringBuilder.append('\"');
                            continue block17;
                        }
                        case '\\': {
                            stringBuilder.append('\\');
                            continue block17;
                        }
                        case '/': {
                            stringBuilder.append('/');
                            continue block17;
                        }
                        case 'b': {
                            stringBuilder.append('\b');
                            continue block17;
                        }
                        case 'f': {
                            stringBuilder.append('\f');
                            continue block17;
                        }
                        case 'n': {
                            stringBuilder.append('\n');
                            continue block17;
                        }
                        case 'r': {
                            stringBuilder.append('\r');
                            continue block17;
                        }
                        case 't': {
                            stringBuilder.append('\t');
                            continue block17;
                        }
                        case 'u': {
                            if (this.length - this.pos < 5) {
                                throw new ParseException("Invalid character code: \\u" + this.src.substring(this.pos));
                            }
                            try {
                                stringBuilder.append((char)Integer.parseInt(this.src.substring(this.pos, this.pos + 4), 16));
                                this.pos += 4;
                                continue block17;
                            }
                            catch (NumberFormatException numberFormatException) {
                                throw new ParseException("Invalid character code: " + this.src.substring(this.pos, this.pos + 4));
                            }
                        }
                    }
                    throw new ParseException("Unexcpected character in string: '\\" + c + "'");
                }
                case '\"': {
                    return stringBuilder.toString();
                }
            }
            stringBuilder.append(c);
        }
        throw new ParseException("Unterminated string literal");
    }

    private Number readNumber(char c) throws ParseException {
        char c2;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(c);
        while (this.pos < this.length && (Character.isDigit(c2 = this.src.charAt(this.pos)) || c2 == '-' || c2 == '+' || c2 == '.' || c2 == 'e' || c2 == 'E')) {
            ++this.pos;
            stringBuilder.append(c2);
        }
        String string = stringBuilder.toString();
        int n = string.length();
        try {
            double d;
            int n2;
            for (int i = 0; i < n; ++i) {
                char c3 = string.charAt(i);
                if (!Character.isDigit(c3)) continue;
                if (c3 != '0' || n <= i + 1 || !Character.isDigit(string.charAt(i + 1))) break;
                throw new ParseException("Unsupported number format: " + string);
            }
            if ((double)(n2 = (int)(d = Double.parseDouble(string))) == d) {
                return n2;
            }
            return d;
        }
        catch (NumberFormatException numberFormatException) {
            throw new ParseException("Unsupported number format: " + string);
        }
    }

    private Boolean readTrue() throws ParseException {
        if (this.length - this.pos < 3 || this.src.charAt(this.pos) != 'r' || this.src.charAt(this.pos + 1) != 'u' || this.src.charAt(this.pos + 2) != 'e') {
            throw new ParseException("Unexpected token: t");
        }
        this.pos += 3;
        return Boolean.TRUE;
    }

    private Boolean readFalse() throws ParseException {
        if (this.length - this.pos < 4 || this.src.charAt(this.pos) != 'a' || this.src.charAt(this.pos + 1) != 'l' || this.src.charAt(this.pos + 2) != 's' || this.src.charAt(this.pos + 3) != 'e') {
            throw new ParseException("Unexpected token: f");
        }
        this.pos += 4;
        return Boolean.FALSE;
    }

    private Object readNull() throws ParseException {
        if (this.length - this.pos < 3 || this.src.charAt(this.pos) != 'u' || this.src.charAt(this.pos + 1) != 'l' || this.src.charAt(this.pos + 2) != 'l') {
            throw new ParseException("Unexpected token: n");
        }
        this.pos += 3;
        return null;
    }

    private void consumeWhitespace() {
        block3: while (this.pos < this.length) {
            char c = this.src.charAt(this.pos);
            switch (c) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    ++this.pos;
                    continue block3;
                }
            }
            return;
        }
    }

    private void consume(char c) throws ParseException {
        char c2;
        this.consumeWhitespace();
        if (this.pos >= this.length) {
            throw new ParseException("Expected " + c + " but reached end of stream");
        }
        if ((c2 = this.src.charAt(this.pos++)) == c) {
            return;
        }
        throw new ParseException("Expected " + c + " found " + c2);
    }

    public static class ParseException
    extends Exception {
        ParseException(String string) {
            super(string);
        }

        ParseException(Exception exception) {
            super(exception);
        }
    }
}

