/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.fs;

import sun.nio.fs.WindowsException;
import sun.nio.fs.WindowsNativeDispatcher;

class WindowsSecurity {
    static final long processTokenWithDuplicateAccess = WindowsSecurity.openProcessToken(2);
    static final long processTokenWithQueryAccess = WindowsSecurity.openProcessToken(8);

    private WindowsSecurity() {
    }

    private static long openProcessToken(int n) {
        try {
            return WindowsNativeDispatcher.OpenProcessToken(WindowsNativeDispatcher.GetCurrentProcess(), n);
        }
        catch (WindowsException windowsException) {
            return 0L;
        }
    }

    static Privilege enablePrivilege(String string) {
        long l;
        try {
            l = WindowsNativeDispatcher.LookupPrivilegeValue(string);
        }
        catch (WindowsException windowsException) {
            throw new AssertionError((Object)windowsException);
        }
        long l2 = 0L;
        boolean bl = false;
        boolean bl2 = false;
        try {
            l2 = WindowsNativeDispatcher.OpenThreadToken(WindowsNativeDispatcher.GetCurrentThread(), 32, false);
            if (l2 == 0L && processTokenWithDuplicateAccess != 0L) {
                l2 = WindowsNativeDispatcher.DuplicateTokenEx(processTokenWithDuplicateAccess, 36);
                WindowsNativeDispatcher.SetThreadToken(0L, l2);
                bl = true;
            }
            if (l2 != 0L) {
                WindowsNativeDispatcher.AdjustTokenPrivileges(l2, l, 2);
                bl2 = true;
            }
        }
        catch (WindowsException windowsException) {
            // empty catch block
        }
        final long l3 = l2;
        final boolean bl3 = bl;
        final boolean bl4 = bl2;
        return new Privilege(){

            @Override
            public void drop() {
                try {
                    if (bl3) {
                        WindowsNativeDispatcher.SetThreadToken(0L, 0L);
                    } else if (bl4) {
                        WindowsNativeDispatcher.AdjustTokenPrivileges(l3, l, 0);
                    }
                }
                catch (WindowsException windowsException) {
                    throw new AssertionError((Object)windowsException);
                }
            }
        };
    }

    static interface Privilege {
        public void drop();
    }
}

