/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.nio.channels.AsynchronousChannel;
import java.nio.channels.CompletionHandler;
import java.nio.channels.ShutdownChannelGroupException;
import java.security.AccessController;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import sun.nio.ch.AsynchronousChannelGroupImpl;
import sun.nio.ch.Groupable;
import sun.nio.ch.PendingFuture;
import sun.security.action.GetIntegerAction;

class Invoker {
    private static final int maxHandlerInvokeCount = AccessController.doPrivileged(new GetIntegerAction("sun.nio.ch.maxCompletionHandlersOnStack", 16));
    private static final ThreadLocal<GroupAndInvokeCount> myGroupAndInvokeCount = new ThreadLocal<GroupAndInvokeCount>(){

        @Override
        protected GroupAndInvokeCount initialValue() {
            return null;
        }
    };

    private Invoker() {
    }

    static void bindToGroup(AsynchronousChannelGroupImpl asynchronousChannelGroupImpl) {
        myGroupAndInvokeCount.set(new GroupAndInvokeCount(asynchronousChannelGroupImpl));
    }

    static GroupAndInvokeCount getGroupAndInvokeCount() {
        return myGroupAndInvokeCount.get();
    }

    static boolean isBoundToAnyGroup() {
        return myGroupAndInvokeCount.get() != null;
    }

    static boolean mayInvokeDirect(GroupAndInvokeCount groupAndInvokeCount, AsynchronousChannelGroupImpl asynchronousChannelGroupImpl) {
        return groupAndInvokeCount != null && groupAndInvokeCount.group() == asynchronousChannelGroupImpl && groupAndInvokeCount.invokeCount() < maxHandlerInvokeCount;
    }

    static <V, A> void invokeUnchecked(CompletionHandler<V, ? super A> completionHandler, A a, V v, Throwable throwable) {
        if (throwable == null) {
            completionHandler.completed(v, a);
        } else {
            completionHandler.failed(throwable, a);
        }
        Thread.interrupted();
    }

    static <V, A> void invokeDirect(GroupAndInvokeCount groupAndInvokeCount, CompletionHandler<V, ? super A> completionHandler, A a, V v, Throwable throwable) {
        groupAndInvokeCount.incrementInvokeCount();
        Invoker.invokeUnchecked(completionHandler, a, v, throwable);
    }

    static <V, A> void invoke(AsynchronousChannel asynchronousChannel, CompletionHandler<V, ? super A> completionHandler, A a, V v, Throwable throwable) {
        boolean bl = false;
        boolean bl2 = false;
        GroupAndInvokeCount groupAndInvokeCount = myGroupAndInvokeCount.get();
        if (groupAndInvokeCount != null) {
            if (groupAndInvokeCount.group() == ((Groupable)((Object)asynchronousChannel)).group()) {
                bl2 = true;
            }
            if (bl2 && groupAndInvokeCount.invokeCount() < maxHandlerInvokeCount) {
                bl = true;
            }
        }
        if (bl) {
            Invoker.invokeDirect(groupAndInvokeCount, completionHandler, a, v, throwable);
        } else {
            try {
                Invoker.invokeIndirectly(asynchronousChannel, completionHandler, a, v, throwable);
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                if (bl2) {
                    Invoker.invokeDirect(groupAndInvokeCount, completionHandler, a, v, throwable);
                }
                throw new ShutdownChannelGroupException();
            }
        }
    }

    static <V, A> void invokeIndirectly(AsynchronousChannel asynchronousChannel, final CompletionHandler<V, ? super A> completionHandler, final A a, final V v, final Throwable throwable) {
        try {
            ((Groupable)((Object)asynchronousChannel)).group().executeOnPooledThread(new Runnable(){

                @Override
                public void run() {
                    GroupAndInvokeCount groupAndInvokeCount = (GroupAndInvokeCount)myGroupAndInvokeCount.get();
                    if (groupAndInvokeCount != null) {
                        groupAndInvokeCount.setInvokeCount(1);
                    }
                    Invoker.invokeUnchecked(completionHandler, a, v, throwable);
                }
            });
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            throw new ShutdownChannelGroupException();
        }
    }

    static <V, A> void invokeIndirectly(final CompletionHandler<V, ? super A> completionHandler, final A a, final V v, final Throwable throwable, Executor executor) {
        try {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    Invoker.invokeUnchecked(completionHandler, a, v, throwable);
                }
            });
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            throw new ShutdownChannelGroupException();
        }
    }

    static void invokeOnThreadInThreadPool(Groupable groupable, Runnable runnable) {
        GroupAndInvokeCount groupAndInvokeCount = myGroupAndInvokeCount.get();
        AsynchronousChannelGroupImpl asynchronousChannelGroupImpl = groupable.group();
        boolean bl = groupAndInvokeCount == null ? false : groupAndInvokeCount.group == asynchronousChannelGroupImpl;
        try {
            if (bl) {
                runnable.run();
            } else {
                asynchronousChannelGroupImpl.executeOnPooledThread(runnable);
            }
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            throw new ShutdownChannelGroupException();
        }
    }

    static <V, A> void invokeUnchecked(PendingFuture<V, A> pendingFuture) {
        assert (pendingFuture.isDone());
        CompletionHandler<V, A> completionHandler = pendingFuture.handler();
        if (completionHandler != null) {
            Invoker.invokeUnchecked(completionHandler, pendingFuture.attachment(), pendingFuture.value(), pendingFuture.exception());
        }
    }

    static <V, A> void invoke(PendingFuture<V, A> pendingFuture) {
        assert (pendingFuture.isDone());
        CompletionHandler<V, A> completionHandler = pendingFuture.handler();
        if (completionHandler != null) {
            Invoker.invoke(pendingFuture.channel(), completionHandler, pendingFuture.attachment(), pendingFuture.value(), pendingFuture.exception());
        }
    }

    static <V, A> void invokeIndirectly(PendingFuture<V, A> pendingFuture) {
        assert (pendingFuture.isDone());
        CompletionHandler<V, A> completionHandler = pendingFuture.handler();
        if (completionHandler != null) {
            Invoker.invokeIndirectly(pendingFuture.channel(), completionHandler, pendingFuture.attachment(), pendingFuture.value(), pendingFuture.exception());
        }
    }

    static class GroupAndInvokeCount {
        private final AsynchronousChannelGroupImpl group;
        private int handlerInvokeCount;

        GroupAndInvokeCount(AsynchronousChannelGroupImpl asynchronousChannelGroupImpl) {
            this.group = asynchronousChannelGroupImpl;
        }

        AsynchronousChannelGroupImpl group() {
            return this.group;
        }

        int invokeCount() {
            return this.handlerInvokeCount;
        }

        void setInvokeCount(int n) {
            this.handlerInvokeCount = n;
        }

        void resetInvokeCount() {
            this.handlerInvokeCount = 0;
        }

        void incrementInvokeCount() {
            ++this.handlerInvokeCount;
        }
    }
}

