/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.im;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.InputMethodEvent;
import java.awt.event.KeyEvent;
import java.awt.font.TextHitInfo;
import java.awt.im.InputMethodRequests;
import java.awt.im.spi.InputMethod;
import java.security.AccessController;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import javax.swing.JFrame;
import sun.awt.InputMethodSupport;
import sun.awt.im.CompositionAreaHandler;
import sun.awt.im.InputContext;
import sun.awt.im.InputMethodJFrame;
import sun.security.action.GetPropertyAction;

public class InputMethodContext
extends InputContext
implements java.awt.im.spi.InputMethodContext {
    private boolean dispatchingCommittedText;
    private CompositionAreaHandler compositionAreaHandler;
    private Object compositionAreaHandlerLock = new Object();
    private static boolean belowTheSpotInputRequested;
    private boolean inputMethodSupportsBelowTheSpot;

    void setInputMethodSupportsBelowTheSpot(boolean bl) {
        this.inputMethodSupportsBelowTheSpot = bl;
    }

    boolean useBelowTheSpotInput() {
        return belowTheSpotInputRequested && this.inputMethodSupportsBelowTheSpot;
    }

    private boolean haveActiveClient() {
        Component component = this.getClientComponent();
        return component != null && component.getInputMethodRequests() != null;
    }

    @Override
    public void dispatchInputMethodEvent(int n, AttributedCharacterIterator attributedCharacterIterator, int n2, TextHitInfo textHitInfo, TextHitInfo textHitInfo2) {
        Component component = this.getClientComponent();
        if (component != null) {
            InputMethodEvent inputMethodEvent = new InputMethodEvent(component, n, attributedCharacterIterator, n2, textHitInfo, textHitInfo2);
            if (this.haveActiveClient() && !this.useBelowTheSpotInput()) {
                component.dispatchEvent(inputMethodEvent);
            } else {
                this.getCompositionAreaHandler(true).processInputMethodEvent(inputMethodEvent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void dispatchCommittedText(Component component, AttributedCharacterIterator attributedCharacterIterator, int n) {
        if (n == 0 || attributedCharacterIterator.getEndIndex() <= attributedCharacterIterator.getBeginIndex()) {
            return;
        }
        long l = System.currentTimeMillis();
        this.dispatchingCommittedText = true;
        try {
            InputMethodRequests inputMethodRequests = component.getInputMethodRequests();
            if (inputMethodRequests != null) {
                int n2 = attributedCharacterIterator.getBeginIndex();
                AttributedCharacterIterator attributedCharacterIterator2 = new AttributedString(attributedCharacterIterator, n2, n2 + n).getIterator();
                InputMethodEvent inputMethodEvent = new InputMethodEvent(component, 1100, attributedCharacterIterator2, n, null, null);
                component.dispatchEvent(inputMethodEvent);
            } else {
                char c = attributedCharacterIterator.first();
                while (n-- > 0 && c != '\uffff') {
                    KeyEvent keyEvent = new KeyEvent(component, 400, l, 0, 0, c);
                    component.dispatchEvent(keyEvent);
                    c = attributedCharacterIterator.next();
                }
            }
        }
        finally {
            this.dispatchingCommittedText = false;
        }
    }

    @Override
    public void dispatchEvent(AWTEvent aWTEvent) {
        if (aWTEvent instanceof InputMethodEvent) {
            if (((Component)aWTEvent.getSource()).getInputMethodRequests() == null || this.useBelowTheSpotInput() && !this.dispatchingCommittedText) {
                this.getCompositionAreaHandler(true).processInputMethodEvent((InputMethodEvent)aWTEvent);
            }
        } else if (!this.dispatchingCommittedText) {
            super.dispatchEvent(aWTEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompositionAreaHandler getCompositionAreaHandler(boolean bl) {
        Object object = this.compositionAreaHandlerLock;
        synchronized (object) {
            if (this.compositionAreaHandler == null) {
                this.compositionAreaHandler = new CompositionAreaHandler(this);
            }
            this.compositionAreaHandler.setClientComponent(this.getClientComponent());
            if (bl) {
                this.compositionAreaHandler.grabCompositionArea(false);
            }
            return this.compositionAreaHandler;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void grabCompositionArea(boolean bl) {
        Object object = this.compositionAreaHandlerLock;
        synchronized (object) {
            if (this.compositionAreaHandler != null) {
                this.compositionAreaHandler.grabCompositionArea(bl);
            } else {
                CompositionAreaHandler.closeCompositionArea();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void releaseCompositionArea() {
        Object object = this.compositionAreaHandlerLock;
        synchronized (object) {
            if (this.compositionAreaHandler != null) {
                this.compositionAreaHandler.releaseCompositionArea();
            }
        }
    }

    boolean isCompositionAreaVisible() {
        if (this.compositionAreaHandler != null) {
            return this.compositionAreaHandler.isCompositionAreaVisible();
        }
        return false;
    }

    void setCompositionAreaVisible(boolean bl) {
        if (this.compositionAreaHandler != null) {
            this.compositionAreaHandler.setCompositionAreaVisible(bl);
        }
    }

    @Override
    public Rectangle getTextLocation(TextHitInfo textHitInfo) {
        return this.getReq().getTextLocation(textHitInfo);
    }

    @Override
    public TextHitInfo getLocationOffset(int n, int n2) {
        return this.getReq().getLocationOffset(n, n2);
    }

    @Override
    public int getInsertPositionOffset() {
        return this.getReq().getInsertPositionOffset();
    }

    @Override
    public AttributedCharacterIterator getCommittedText(int n, int n2, AttributedCharacterIterator.Attribute[] attributeArray) {
        return this.getReq().getCommittedText(n, n2, attributeArray);
    }

    @Override
    public int getCommittedTextLength() {
        return this.getReq().getCommittedTextLength();
    }

    @Override
    public AttributedCharacterIterator cancelLatestCommittedText(AttributedCharacterIterator.Attribute[] attributeArray) {
        return this.getReq().cancelLatestCommittedText(attributeArray);
    }

    @Override
    public AttributedCharacterIterator getSelectedText(AttributedCharacterIterator.Attribute[] attributeArray) {
        return this.getReq().getSelectedText(attributeArray);
    }

    private InputMethodRequests getReq() {
        if (this.haveActiveClient() && !this.useBelowTheSpotInput()) {
            return this.getClientComponent().getInputMethodRequests();
        }
        return this.getCompositionAreaHandler(false);
    }

    @Override
    public Window createInputMethodWindow(String string, boolean bl) {
        InputMethodContext inputMethodContext = bl ? this : null;
        return InputMethodContext.createInputMethodWindow(string, inputMethodContext, false);
    }

    @Override
    public JFrame createInputMethodJFrame(String string, boolean bl) {
        InputMethodContext inputMethodContext = bl ? this : null;
        return (JFrame)InputMethodContext.createInputMethodWindow(string, inputMethodContext, true);
    }

    static Window createInputMethodWindow(String string, InputContext inputContext, boolean bl) {
        if (GraphicsEnvironment.isHeadless()) {
            throw new HeadlessException();
        }
        if (bl) {
            return new InputMethodJFrame(string, inputContext);
        }
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        if (toolkit instanceof InputMethodSupport) {
            return ((InputMethodSupport)((Object)toolkit)).createInputMethodWindow(string, inputContext);
        }
        throw new InternalError("Input methods must be supported");
    }

    @Override
    public void enableClientWindowNotification(InputMethod inputMethod, boolean bl) {
        super.enableClientWindowNotification(inputMethod, bl);
    }

    void setCompositionAreaUndecorated(boolean bl) {
        if (this.compositionAreaHandler != null) {
            this.compositionAreaHandler.setCompositionAreaUndecorated(bl);
        }
    }

    static {
        String string = AccessController.doPrivileged(new GetPropertyAction("java.awt.im.style", null));
        if (string == null) {
            Toolkit.getDefaultToolkit();
            string = Toolkit.getProperty("java.awt.im.style", null);
        }
        belowTheSpotInputRequested = "below-the-spot".equals(string);
    }
}

