/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.synth;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicInternalFrameUI;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthDesktopPaneUI;
import javax.swing.plaf.synth.SynthInternalFrameTitlePane;
import javax.swing.plaf.synth.SynthLookAndFeel;
import javax.swing.plaf.synth.SynthStyle;
import javax.swing.plaf.synth.SynthUI;

public class SynthInternalFrameUI
extends BasicInternalFrameUI
implements SynthUI,
PropertyChangeListener {
    private SynthStyle style;

    public static ComponentUI createUI(JComponent jComponent) {
        return new SynthInternalFrameUI((JInternalFrame)jComponent);
    }

    protected SynthInternalFrameUI(JInternalFrame jInternalFrame) {
        super(jInternalFrame);
    }

    @Override
    public void installDefaults() {
        this.internalFrameLayout = this.createLayoutManager();
        this.frame.setLayout(this.internalFrameLayout);
        this.updateStyle(this.frame);
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.frame.addPropertyChangeListener(this);
    }

    @Override
    protected void uninstallComponents() {
        if (this.frame.getComponentPopupMenu() instanceof UIResource) {
            this.frame.setComponentPopupMenu(null);
        }
        super.uninstallComponents();
    }

    @Override
    protected void uninstallListeners() {
        this.frame.removePropertyChangeListener(this);
        super.uninstallListeners();
    }

    private void updateStyle(JComponent jComponent) {
        SynthContext synthContext = this.getContext(jComponent, 1);
        SynthStyle synthStyle = this.style;
        this.style = SynthLookAndFeel.updateStyle(synthContext, this);
        if (this.style != synthStyle) {
            Icon icon = this.frame.getFrameIcon();
            if (icon == null || icon instanceof UIResource) {
                this.frame.setFrameIcon(synthContext.getStyle().getIcon(synthContext, "InternalFrame.icon"));
            }
            if (synthStyle != null) {
                this.uninstallKeyboardActions();
                this.installKeyboardActions();
            }
        }
        synthContext.dispose();
    }

    @Override
    protected void uninstallDefaults() {
        SynthContext synthContext = this.getContext(this.frame, 1);
        this.style.uninstallDefaults(synthContext);
        synthContext.dispose();
        this.style = null;
        if (this.frame.getLayout() == this.internalFrameLayout) {
            this.frame.setLayout(null);
        }
    }

    @Override
    public SynthContext getContext(JComponent jComponent) {
        return this.getContext(jComponent, this.getComponentState(jComponent));
    }

    private SynthContext getContext(JComponent jComponent, int n) {
        return SynthContext.getContext(SynthContext.class, jComponent, SynthLookAndFeel.getRegion(jComponent), this.style, n);
    }

    private int getComponentState(JComponent jComponent) {
        return SynthLookAndFeel.getComponentState(jComponent);
    }

    @Override
    protected JComponent createNorthPane(JInternalFrame jInternalFrame) {
        this.titlePane = new SynthInternalFrameTitlePane(jInternalFrame);
        this.titlePane.setName("InternalFrame.northPane");
        return this.titlePane;
    }

    @Override
    protected ComponentListener createComponentListener() {
        if (UIManager.getBoolean("InternalFrame.useTaskBar")) {
            return new BasicInternalFrameUI.ComponentHandler(){

                @Override
                public void componentResized(ComponentEvent componentEvent) {
                    JComponent jComponent;
                    if (SynthInternalFrameUI.this.frame != null && SynthInternalFrameUI.this.frame.isMaximum()) {
                        jComponent = (JDesktopPane)componentEvent.getSource();
                        for (Component component : jComponent.getComponents()) {
                            if (!(component instanceof SynthDesktopPaneUI.TaskBar)) continue;
                            SynthInternalFrameUI.this.frame.setBounds(0, 0, jComponent.getWidth(), jComponent.getHeight() - component.getHeight());
                            SynthInternalFrameUI.this.frame.revalidate();
                            break;
                        }
                    }
                    jComponent = SynthInternalFrameUI.this.frame;
                    SynthInternalFrameUI.this.frame = null;
                    super.componentResized(componentEvent);
                    SynthInternalFrameUI.this.frame = (JInternalFrame)jComponent;
                }
            };
        }
        return super.createComponentListener();
    }

    @Override
    public void update(Graphics graphics, JComponent jComponent) {
        SynthContext synthContext = this.getContext(jComponent);
        SynthLookAndFeel.update(synthContext, graphics);
        synthContext.getPainter().paintInternalFrameBackground(synthContext, graphics, 0, 0, jComponent.getWidth(), jComponent.getHeight());
        this.paint(synthContext, graphics);
        synthContext.dispose();
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        SynthContext synthContext = this.getContext(jComponent);
        this.paint(synthContext, graphics);
        synthContext.dispose();
    }

    protected void paint(SynthContext synthContext, Graphics graphics) {
    }

    @Override
    public void paintBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        synthContext.getPainter().paintInternalFrameBorder(synthContext, graphics, n, n2, n3, n4);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        SynthStyle synthStyle = this.style;
        JInternalFrame jInternalFrame = (JInternalFrame)propertyChangeEvent.getSource();
        String string = propertyChangeEvent.getPropertyName();
        if (SynthLookAndFeel.shouldUpdateStyle(propertyChangeEvent)) {
            this.updateStyle(jInternalFrame);
        }
        if (this.style == synthStyle && (string == "maximum" || string == "selected")) {
            SynthContext synthContext = this.getContext(jInternalFrame, 1);
            this.style.uninstallDefaults(synthContext);
            this.style.installDefaults(synthContext, this);
        }
    }
}

