/*
 * Decompiled with CFR 0.152.
 */
package java.nio.file.attribute;

import java.util.Date;
import java.util.Formatter;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;

public final class FileTime
implements Comparable<FileTime> {
    private final long value;
    private final TimeUnit unit;
    private String valueAsString;
    private DaysAndNanos daysAndNanos;

    private DaysAndNanos asDaysAndNanos() {
        if (this.daysAndNanos == null) {
            this.daysAndNanos = new DaysAndNanos(this.value, this.unit);
        }
        return this.daysAndNanos;
    }

    private FileTime(long l, TimeUnit timeUnit) {
        if (timeUnit == null) {
            throw new NullPointerException();
        }
        this.value = l;
        this.unit = timeUnit;
    }

    public static FileTime from(long l, TimeUnit timeUnit) {
        return new FileTime(l, timeUnit);
    }

    public static FileTime fromMillis(long l) {
        return new FileTime(l, TimeUnit.MILLISECONDS);
    }

    public long to(TimeUnit timeUnit) {
        return timeUnit.convert(this.value, this.unit);
    }

    public long toMillis() {
        return this.unit.toMillis(this.value);
    }

    public boolean equals(Object object) {
        return object instanceof FileTime ? this.compareTo((FileTime)object) == 0 : false;
    }

    public int hashCode() {
        return this.asDaysAndNanos().hashCode();
    }

    @Override
    public int compareTo(FileTime fileTime) {
        if (this.unit == fileTime.unit) {
            return this.value < fileTime.value ? -1 : (this.value == fileTime.value ? 0 : 1);
        }
        return this.asDaysAndNanos().compareTo(fileTime.asDaysAndNanos());
    }

    public String toString() {
        String string = this.valueAsString;
        if (string == null) {
            long l;
            long l2 = this.toMillis();
            String string2 = "";
            if (this.unit.compareTo(TimeUnit.SECONDS) < 0 && (l = this.asDaysAndNanos().fractionOfSecondInNanos()) != 0L) {
                if (l < 0L) {
                    l += 1000000000L;
                    if (l2 != Long.MIN_VALUE) {
                        --l2;
                    }
                }
                String string3 = Long.toString(l);
                int n = string3.length();
                int n2 = 9 - n;
                StringBuilder stringBuilder = new StringBuilder(".");
                while (n2-- > 0) {
                    stringBuilder.append('0');
                }
                if (string3.charAt(n - 1) == '0') {
                    --n;
                    while (string3.charAt(n - 1) == '0') {
                        --n;
                    }
                    stringBuilder.append(string3.substring(0, n));
                } else {
                    stringBuilder.append(string3);
                }
                string2 = stringBuilder.toString();
            }
            GregorianCalendar gregorianCalendar = new GregorianCalendar(TimeZone.getTimeZone("UTC"), Locale.ROOT);
            if (this.value < 0L) {
                gregorianCalendar.setGregorianChange(new Date(Long.MIN_VALUE));
            }
            gregorianCalendar.setTimeInMillis(l2);
            String string4 = gregorianCalendar.get(0) == 0 ? "-" : "";
            this.valueAsString = string = new Formatter(Locale.ROOT).format("%s%tFT%tR:%tS%sZ", string4, gregorianCalendar, gregorianCalendar, gregorianCalendar, string2).toString();
        }
        return string;
    }

    private static class DaysAndNanos
    implements Comparable<DaysAndNanos> {
        private static final long C0 = 1L;
        private static final long C1 = 24L;
        private static final long C2 = 1440L;
        private static final long C3 = 86400L;
        private static final long C4 = 86400000L;
        private static final long C5 = 86400000000L;
        private static final long C6 = 86400000000000L;
        private final long days;
        private final long excessNanos;

        DaysAndNanos(long l, TimeUnit timeUnit) {
            long l2;
            switch (timeUnit) {
                case DAYS: {
                    l2 = 1L;
                    break;
                }
                case HOURS: {
                    l2 = 24L;
                    break;
                }
                case MINUTES: {
                    l2 = 1440L;
                    break;
                }
                case SECONDS: {
                    l2 = 86400L;
                    break;
                }
                case MILLISECONDS: {
                    l2 = 86400000L;
                    break;
                }
                case MICROSECONDS: {
                    l2 = 86400000000L;
                    break;
                }
                case NANOSECONDS: {
                    l2 = 86400000000000L;
                    break;
                }
                default: {
                    throw new AssertionError((Object)"Unit not handled");
                }
            }
            this.days = timeUnit.toDays(l);
            this.excessNanos = timeUnit.toNanos(l - this.days * l2);
        }

        long fractionOfSecondInNanos() {
            return this.excessNanos % 1000000000L;
        }

        public boolean equals(Object object) {
            return object instanceof DaysAndNanos ? this.compareTo((DaysAndNanos)object) == 0 : false;
        }

        public int hashCode() {
            return (int)(this.days ^ this.days >>> 32 ^ this.excessNanos ^ this.excessNanos >>> 32);
        }

        @Override
        public int compareTo(DaysAndNanos daysAndNanos) {
            if (this.days != daysAndNanos.days) {
                return this.days < daysAndNanos.days ? -1 : 1;
            }
            return this.excessNanos < daysAndNanos.excessNanos ? -1 : (this.excessNanos == daysAndNanos.excessNanos ? 0 : 1);
        }
    }
}

