/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.FileDescriptor;
import java.io.IOException;
import java.net.AbstractPlainSocketImpl;
import java.net.InetAddress;
import java.net.InetAddressContainer;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.net.SocketImpl;
import sun.misc.JavaIOFileDescriptorAccess;
import sun.misc.SharedSecrets;

class DualStackPlainSocketImpl
extends AbstractPlainSocketImpl {
    static JavaIOFileDescriptorAccess fdAccess = SharedSecrets.getJavaIOFileDescriptorAccess();
    static final int WOULDBLOCK = -2;

    public DualStackPlainSocketImpl() {
    }

    public DualStackPlainSocketImpl(FileDescriptor fileDescriptor) {
        this.fd = fileDescriptor;
    }

    @Override
    void socketCreate(boolean bl) throws IOException {
        if (this.fd == null) {
            throw new SocketException("Socket closed");
        }
        int n = DualStackPlainSocketImpl.socket0(bl, false);
        fdAccess.set(this.fd, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void socketConnect(InetAddress inetAddress, int n, int n2) throws IOException {
        int n3 = this.checkAndReturnNativeFD();
        if (inetAddress == null) {
            throw new NullPointerException("inet address argument is null.");
        }
        if (n2 <= 0) {
            int n4 = DualStackPlainSocketImpl.connect0(n3, inetAddress, n);
        } else {
            DualStackPlainSocketImpl.configureBlocking(n3, false);
            try {
                int n5 = DualStackPlainSocketImpl.connect0(n3, inetAddress, n);
                if (n5 == -2) {
                    DualStackPlainSocketImpl.waitForConnect(n3, n2);
                }
            }
            finally {
                DualStackPlainSocketImpl.configureBlocking(n3, true);
            }
        }
        if (this.localport == 0) {
            this.localport = DualStackPlainSocketImpl.localPort0(n3);
        }
    }

    @Override
    void socketBind(InetAddress inetAddress, int n) throws IOException {
        int n2 = this.checkAndReturnNativeFD();
        if (inetAddress == null) {
            throw new NullPointerException("inet address argument is null.");
        }
        DualStackPlainSocketImpl.bind0(n2, inetAddress, n);
        this.localport = n == 0 ? DualStackPlainSocketImpl.localPort0(n2) : n;
        this.address = inetAddress;
    }

    @Override
    void socketListen(int n) throws IOException {
        int n2 = this.checkAndReturnNativeFD();
        DualStackPlainSocketImpl.listen0(n2, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void socketAccept(SocketImpl socketImpl) throws IOException {
        int n = this.checkAndReturnNativeFD();
        if (socketImpl == null) {
            throw new NullPointerException("socket is null");
        }
        int n2 = -1;
        InetSocketAddress[] inetSocketAddressArray = new InetSocketAddress[1];
        if (this.timeout <= 0) {
            n2 = DualStackPlainSocketImpl.accept0(n, inetSocketAddressArray);
        } else {
            DualStackPlainSocketImpl.configureBlocking(n, false);
            try {
                DualStackPlainSocketImpl.waitForNewConnection(n, this.timeout);
                n2 = DualStackPlainSocketImpl.accept0(n, inetSocketAddressArray);
                if (n2 != -1) {
                    DualStackPlainSocketImpl.configureBlocking(n2, true);
                }
            }
            finally {
                DualStackPlainSocketImpl.configureBlocking(n, true);
            }
        }
        fdAccess.set(socketImpl.fd, n2);
        InetSocketAddress inetSocketAddress = inetSocketAddressArray[0];
        socketImpl.port = inetSocketAddress.getPort();
        socketImpl.address = inetSocketAddress.getAddress();
        socketImpl.localport = this.localport;
    }

    @Override
    int socketAvailable() throws IOException {
        int n = this.checkAndReturnNativeFD();
        return DualStackPlainSocketImpl.available0(n);
    }

    @Override
    void socketClose0(boolean bl) throws IOException {
        if (this.fd == null) {
            throw new SocketException("Socket closed");
        }
        if (!this.fd.valid()) {
            return;
        }
        DualStackPlainSocketImpl.close0(fdAccess.get(this.fd));
        fdAccess.set(this.fd, -1);
    }

    @Override
    void socketShutdown(int n) throws IOException {
        int n2 = this.checkAndReturnNativeFD();
        DualStackPlainSocketImpl.shutdown0(n2, n);
    }

    @Override
    void socketSetOption(int n, boolean bl, Object object) throws SocketException {
        int n2 = this.checkAndReturnNativeFD();
        if (n == 4102) {
            return;
        }
        int n3 = 0;
        switch (n) {
            case 1: 
            case 4: 
            case 8: 
            case 4099: {
                n3 = bl ? 1 : 0;
                break;
            }
            case 3: 
            case 4097: 
            case 4098: {
                n3 = (Integer)object;
                break;
            }
            case 128: {
                if (bl) {
                    n3 = (Integer)object;
                    break;
                }
                n3 = -1;
                break;
            }
            default: {
                throw new SocketException("Option not supported");
            }
        }
        DualStackPlainSocketImpl.setIntOption(n2, n, n3);
    }

    @Override
    int socketGetOption(int n, Object object) throws SocketException {
        int n2 = this.checkAndReturnNativeFD();
        if (n == 15) {
            DualStackPlainSocketImpl.localAddress(n2, (InetAddressContainer)object);
            return 0;
        }
        int n3 = DualStackPlainSocketImpl.getIntOption(n2, n);
        switch (n) {
            case 1: 
            case 4: 
            case 8: 
            case 4099: {
                return n3 == 0 ? -1 : 1;
            }
        }
        return n3;
    }

    @Override
    void socketSendUrgentData(int n) throws IOException {
        int n2 = this.checkAndReturnNativeFD();
        DualStackPlainSocketImpl.sendOOB(n2, n);
    }

    private int checkAndReturnNativeFD() throws SocketException {
        if (this.fd == null || !this.fd.valid()) {
            throw new SocketException("Socket closed");
        }
        return fdAccess.get(this.fd);
    }

    static native void initIDs();

    static native int socket0(boolean var0, boolean var1) throws IOException;

    static native void bind0(int var0, InetAddress var1, int var2) throws IOException;

    static native int connect0(int var0, InetAddress var1, int var2) throws IOException;

    static native void waitForConnect(int var0, int var1) throws IOException;

    static native int localPort0(int var0) throws IOException;

    static native void localAddress(int var0, InetAddressContainer var1) throws SocketException;

    static native void listen0(int var0, int var1) throws IOException;

    static native int accept0(int var0, InetSocketAddress[] var1) throws IOException;

    static native void waitForNewConnection(int var0, int var1) throws IOException;

    static native int available0(int var0) throws IOException;

    static native void close0(int var0) throws IOException;

    static native void shutdown0(int var0, int var1) throws IOException;

    static native void setIntOption(int var0, int var1, int var2) throws SocketException;

    static native int getIntOption(int var0, int var1) throws SocketException;

    static native void sendOOB(int var0, int var1) throws IOException;

    static native void configureBlocking(int var0, boolean var1) throws IOException;

    static {
        DualStackPlainSocketImpl.initIDs();
    }
}

